/*
 * Decompiled with CFR 0.152.
 */
package feign.hystrix;

import com.netflix.hystrix.HystrixCommand;
import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

final class HystrixDelegatingContract
implements Contract {
    private final Contract delegate;

    public HystrixDelegatingContract(Contract delegate) {
        this.delegate = delegate;
    }

    public List<MethodMetadata> parseAndValidatateMetadata(Class<?> targetType) {
        List metadatas = this.delegate.parseAndValidatateMetadata(targetType);
        for (MethodMetadata metadata : metadatas) {
            Type type = metadata.returnType();
            if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(HystrixCommand.class)) continue;
            Type actualType = Util.resolveLastTypeParameter((Type)type, HystrixCommand.class);
            metadata.returnType(actualType);
        }
        return metadatas;
    }
}

