/*
 * Decompiled with CFR 0.152.
 */
package feign.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import rx.Observable;
import rx.Single;

final class HystrixInvocationHandler
implements InvocationHandler {
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;
    private final Object fallback;
    private final Map<Method, Method> fallbackMethodMap;

    HystrixInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, Object fallback) {
        this.target = (Target)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
        this.fallback = fallback;
        this.fallbackMethodMap = this.toFallbackMethod(dispatch);
    }

    private Map<Method, Method> toFallbackMethod(Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        LinkedHashMap<Method, Method> result = new LinkedHashMap<Method, Method>();
        for (Method method : dispatch.keySet()) {
            method.setAccessible(true);
            result.put(method, method);
        }
        return result;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if ("equals".equals(method.getName())) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        String groupKey = this.target.name();
        String commandKey = method.getName();
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
        HystrixCommand<Object> hystrixCommand = new HystrixCommand<Object>(setter){

            protected Object run() throws Exception {
                try {
                    return ((InvocationHandlerFactory.MethodHandler)HystrixInvocationHandler.this.dispatch.get(method)).invoke(args);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw (Error)t;
                }
            }

            protected Object getFallback() {
                if (HystrixInvocationHandler.this.fallback == null) {
                    return super.getFallback();
                }
                try {
                    Object result = ((Method)HystrixInvocationHandler.this.fallbackMethodMap.get(method)).invoke(HystrixInvocationHandler.this.fallback, args);
                    if (HystrixInvocationHandler.this.isReturnsHystrixCommand(method)) {
                        return ((HystrixCommand)result).execute();
                    }
                    if (HystrixInvocationHandler.this.isReturnsObservable(method)) {
                        return ((Observable)result).toBlocking().first();
                    }
                    if (HystrixInvocationHandler.this.isReturnsSingle(method)) {
                        return ((Single)result).toObservable().toBlocking().first();
                    }
                    return result;
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    throw new AssertionError((Object)e.getCause());
                }
            }
        };
        if (this.isReturnsHystrixCommand(method)) {
            return hystrixCommand;
        }
        if (this.isReturnsObservable(method)) {
            return hystrixCommand.toObservable();
        }
        if (this.isReturnsSingle(method)) {
            return hystrixCommand.toObservable().toSingle();
        }
        return hystrixCommand.execute();
    }

    private boolean isReturnsHystrixCommand(Method method) {
        return HystrixCommand.class.isAssignableFrom(method.getReturnType());
    }

    private boolean isReturnsObservable(Method method) {
        return Observable.class.isAssignableFrom(method.getReturnType());
    }

    private boolean isReturnsSingle(Method method) {
        return Single.class.isAssignableFrom(method.getReturnType());
    }

    public boolean equals(Object obj) {
        if (obj instanceof HystrixInvocationHandler) {
            HystrixInvocationHandler other = (HystrixInvocationHandler)obj;
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    static final class Factory
    implements InvocationHandlerFactory {
        Factory() {
        }

        public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            return new HystrixInvocationHandler(target, dispatch, null);
        }
    }
}

