/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxb;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public final class JAXBContextFactory {
    private final ConcurrentHashMap<Class, JAXBContext> jaxbContexts = new ConcurrentHashMap(64);
    private final Map<String, Object> properties;

    private JAXBContextFactory(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Unmarshaller createUnmarshaller(Class<?> clazz) throws JAXBException {
        JAXBContext ctx = this.getContext(clazz);
        return ctx.createUnmarshaller();
    }

    public Marshaller createMarshaller(Class<?> clazz) throws JAXBException {
        JAXBContext ctx = this.getContext(clazz);
        Marshaller marshaller = ctx.createMarshaller();
        this.setMarshallerProperties(marshaller);
        return marshaller;
    }

    private void setMarshallerProperties(Marshaller marshaller) throws PropertyException {
        for (String key : this.properties.keySet()) {
            marshaller.setProperty(key, this.properties.get(key));
        }
    }

    private JAXBContext getContext(Class<?> clazz) throws JAXBException {
        JAXBContext jaxbContext = this.jaxbContexts.get(clazz);
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.jaxbContexts.putIfAbsent(clazz, jaxbContext);
        }
        return jaxbContext;
    }

    public static class Builder {
        private final Map<String, Object> properties = new HashMap<String, Object>(5);

        public Builder withMarshallerJAXBEncoding(String value) {
            this.properties.put("jaxb.encoding", value);
            return this;
        }

        public Builder withMarshallerSchemaLocation(String value) {
            this.properties.put("jaxb.schemaLocation", value);
            return this;
        }

        public Builder withMarshallerNoNamespaceSchemaLocation(String value) {
            this.properties.put("jaxb.noNamespaceSchemaLocation", value);
            return this;
        }

        public Builder withMarshallerFormattedOutput(Boolean value) {
            this.properties.put("jaxb.formatted.output", value);
            return this;
        }

        public Builder withMarshallerFragment(Boolean value) {
            this.properties.put("jaxb.fragment", value);
            return this;
        }

        public JAXBContextFactory build() {
            return new JAXBContextFactory(this.properties);
        }
    }
}

