/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxb;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.jaxb.JAXBContextFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class JAXBDecoder
implements Decoder {
    private final JAXBContextFactory jaxbContextFactory;

    public JAXBDecoder(JAXBContextFactory jaxbContextFactory) {
        this.jaxbContextFactory = jaxbContextFactory;
    }

    public Object decode(Response response, Type type) throws IOException {
        if (response.status() == 404) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("JAXB only supports decoding raw types. Found " + type);
        }
        try {
            Unmarshaller unmarshaller = this.jaxbContextFactory.createUnmarshaller((Class)type);
            Object object = unmarshaller.unmarshal(response.body().asInputStream());
            return object;
        }
        catch (JAXBException e) {
            throw new DecodeException(e.toString(), (Throwable)e);
        }
        finally {
            if (response.body() != null) {
                response.body().close();
            }
        }
    }
}

