/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxrs;

import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

public final class JAXRSContract
extends Contract.BaseContract {
    static final String ACCEPT = "Accept";
    static final String CONTENT_TYPE = "Content-Type";

    public MethodMetadata parseAndValidatateMetadata(Method method) {
        MethodMetadata md = super.parseAndValidatateMetadata(method);
        Path path = method.getDeclaringClass().getAnnotation(Path.class);
        if (path != null) {
            String pathValue = Util.emptyToNull((String)path.value());
            Util.checkState((pathValue != null ? 1 : 0) != 0, (String)"Path.value() was empty on type %s", (Object[])new Object[]{method.getDeclaringClass().getName()});
            if (!pathValue.startsWith("/")) {
                pathValue = "/" + pathValue;
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            md.template().insert(0, (CharSequence)pathValue);
        }
        return md;
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
        HttpMethod http = annotationType.getAnnotation(HttpMethod.class);
        if (http != null) {
            Util.checkState((data.template().method() == null ? 1 : 0) != 0, (String)"Method %s contains multiple HTTP methods. Found: %s and %s", (Object[])new Object[]{method.getName(), data.template().method(), http.value()});
            data.template().method(http.value());
        } else if (annotationType == Path.class) {
            String pathValue = Util.emptyToNull((String)((Path)Path.class.cast(methodAnnotation)).value());
            Util.checkState((pathValue != null ? 1 : 0) != 0, (String)"Path.value() was empty on method %s", (Object[])new Object[]{method.getName()});
            String methodAnnotationValue = ((Path)Path.class.cast(methodAnnotation)).value();
            if (!methodAnnotationValue.startsWith("/") && !data.template().toString().endsWith("/")) {
                methodAnnotationValue = "/" + methodAnnotationValue;
            }
            methodAnnotationValue = methodAnnotationValue.replaceAll("\\{\\s*(.+?)\\s*(:.+?)?\\}", "\\{$1\\}");
            data.template().append((CharSequence)methodAnnotationValue);
        } else if (annotationType == Produces.class) {
            String[] serverProduces = ((Produces)methodAnnotation).value();
            String clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
            Util.checkState((clientAccepts != null ? 1 : 0) != 0, (String)"Produces.value() was empty on method %s", (Object[])new Object[]{method.getName()});
            data.template().header(ACCEPT, new String[]{clientAccepts});
        } else if (annotationType == Consumes.class) {
            String[] serverConsumes = ((Consumes)methodAnnotation).value();
            String clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
            Util.checkState((clientProduces != null ? 1 : 0) != 0, (String)"Consumes.value() was empty on method %s", (Object[])new Object[]{method.getName()});
            data.template().header(CONTENT_TYPE, new String[]{clientProduces});
        }
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        boolean isHttpParam = false;
        for (Annotation parameterAnnotation : annotations) {
            String name;
            Class<? extends Annotation> annotationType = parameterAnnotation.annotationType();
            if (annotationType == PathParam.class) {
                name = ((PathParam)PathParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                this.nameParam(data, name, paramIndex);
                isHttpParam = true;
                continue;
            }
            if (annotationType == QueryParam.class) {
                name = ((QueryParam)QueryParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"QueryParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                Collection query = this.addTemplatedParam((Collection)data.template().queries().get(name), name);
                data.template().query(name, (Iterable)query);
                this.nameParam(data, name, paramIndex);
                isHttpParam = true;
                continue;
            }
            if (annotationType == HeaderParam.class) {
                name = ((HeaderParam)HeaderParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"HeaderParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                Collection header = this.addTemplatedParam((Collection)data.template().headers().get(name), name);
                data.template().header(name, (Iterable)header);
                this.nameParam(data, name, paramIndex);
                isHttpParam = true;
                continue;
            }
            if (annotationType != FormParam.class) continue;
            name = ((FormParam)FormParam.class.cast(parameterAnnotation)).value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"FormParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            data.formParams().add(name);
            this.nameParam(data, name, paramIndex);
            isHttpParam = true;
        }
        return isHttpParam;
    }
}

