/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.Request;
import com.netflix.graphql.dgs.client.WebClientGraphQLClient;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J<\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "webclient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Lorg/springframework/web/reactive/function/client/WebClient;)V", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "(Lorg/springframework/web/reactive/function/client/WebClient;Ljava/util/function/Consumer;)V", "handleResponse", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "", "reactiveExecuteQuery", "Lreactor/core/publisher/Mono;", "query", "requestBodyUriCustomizer", "Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$RequestBodyUriCustomizer;", "variables", "", "", "operationName", "Companion", "RequestBodyUriCustomizer", "graphql-dgs-client"})
public final class WebClientGraphQLClient
implements MonoGraphQLClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebClient webclient;
    @NotNull
    private final Consumer<HttpHeaders> headersConsumer;
    @NotNull
    private static final RequestBodyUriCustomizer REQUEST_BODY_URI_CUSTOMIZER_IDENTITY = WebClientGraphQLClient::REQUEST_BODY_URI_CUSTOMIZER_IDENTITY$lambda$4;

    public WebClientGraphQLClient(@NotNull WebClient webclient, @NotNull Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        this.webclient = webclient;
        this.headersConsumer = headersConsumer;
    }

    public WebClientGraphQLClient(@NotNull WebClient webclient) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        this(webclient, WebClientGraphQLClient::_init_$lambda$0);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.reactiveExecuteQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, operationName, REQUEST_BODY_URI_CUSTOMIZER_IDENTITY);
    }

    @NotNull
    public final Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull RequestBodyUriCustomizer requestBodyUriCustomizer) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)requestBodyUriCustomizer, (String)"requestBodyUriCustomizer");
        return this.reactiveExecuteQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), null, requestBodyUriCustomizer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Mono<GraphQLResponse> reactiveExecuteQuery(@Language(value="graphql") @NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName, @NotNull RequestBodyUriCustomizer requestBodyUriCustomizer) {
        void $this$toEntity$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestBodyUriCustomizer, (String)"requestBodyUriCustomizer");
        String serializedRequest = GraphQLClients.INSTANCE.getObjectMapper$graphql_dgs_client().writeValueAsString((Object)new Request(query, variables, operationName));
        WebClient.RequestBodyUriSpec requestBodyUriSpec = this.webclient.post();
        Intrinsics.checkNotNullExpressionValue((Object)requestBodyUriSpec, (String)"webclient.post()");
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)requestBodyUriCustomizer.apply(requestBodyUriSpec).headers(WebClientGraphQLClient::reactiveExecuteQuery$lambda$1)).headers(this.headersConsumer)).bodyValue((Object)serializedRequest).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"requestBodyUriCustomizer\u2026)\n            .retrieve()");
        boolean $i$f$toEntity = false;
        Mono mono = $this$toEntity$iv.toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"toEntity(object : Parame\u2026zedTypeReference<T>() {})");
        Mono mono2 = mono.map(arg_0 -> WebClientGraphQLClient.reactiveExecuteQuery$lambda$2(reactiveExecuteQuery.2.INSTANCE, arg_0)).map(arg_0 -> WebClientGraphQLClient.reactiveExecuteQuery$lambda$3((Function1)new Function1<HttpResponse, GraphQLResponse>(this, serializedRequest){
            final /* synthetic */ WebClientGraphQLClient this$0;
            final /* synthetic */ String $serializedRequest;
            {
                this.this$0 = $receiver;
                this.$serializedRequest = $serializedRequest;
                super(1);
            }

            public final GraphQLResponse invoke(HttpResponse httpResponse) {
                Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
                String string = this.$serializedRequest;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializedRequest");
                return WebClientGraphQLClient.access$handleResponse(this.this$0, httpResponse, string);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"fun reactiveExecuteQuery\u2026erializedRequest) }\n    }");
        return mono2;
    }

    private final GraphQLResponse handleResponse(HttpResponse response, String requestBody) {
        int statusCode = response.component1();
        String body = response.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (!HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) {
            String string = this.webclient.toString();
            String string2 = body;
            if (string2 == null) {
                string2 = "";
            }
            throw new GraphQLClientException(statusCode, string, string2, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string, headers);
    }

    private static final void _init_$lambda$0(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void reactiveExecuteQuery$lambda$1(HttpHeaders headers) {
        headers.addAll((MultiValueMap)GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client());
    }

    private static final HttpResponse reactiveExecuteQuery$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HttpResponse)$tmp0.invoke(p0);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GraphQLResponse)$tmp0.invoke(p0);
    }

    private static final WebClient.RequestBodySpec REQUEST_BODY_URI_CUSTOMIZER_IDENTITY$lambda$4(WebClient.RequestBodyUriSpec it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (WebClient.RequestBodySpec)it;
    }

    public static final /* synthetic */ GraphQLResponse access$handleResponse(WebClientGraphQLClient $this, HttpResponse response, String requestBody) {
        return $this.handleResponse(response, requestBody);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$Companion;", "", "()V", "REQUEST_BODY_URI_CUSTOMIZER_IDENTITY", "Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$RequestBodyUriCustomizer;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @FunctionalInterface
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient$RequestBodyUriCustomizer;", "", "apply", "Lorg/springframework/web/reactive/function/client/WebClient$RequestBodySpec;", "spec", "Lorg/springframework/web/reactive/function/client/WebClient$RequestBodyUriSpec;", "graphql-dgs-client"})
    public static interface RequestBodyUriCustomizer {
        @NotNull
        public WebClient.RequestBodySpec apply(@NotNull WebClient.RequestBodyUriSpec var1);
    }
}

