/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer.dataloader;

import com.netflix.graphql.dgs.metrics.DgsMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/dataloader/BatchLoaderWithContextInterceptor;", "Ljava/lang/reflect/InvocationHandler;", "batchLoaderWithContext", "", "name", "", "registry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Ljava/lang/Object;Ljava/lang/String;Lio/micrometer/core/instrument/MeterRegistry;)V", "invoke", "Ljava/util/concurrent/CompletionStage;", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/util/concurrent/CompletionStage;", "Companion", "graphql-dgs-spring-boot-micrometer"})
public final class BatchLoaderWithContextInterceptor
implements InvocationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object batchLoaderWithContext;
    @NotNull
    private final String name;
    @NotNull
    private final MeterRegistry registry;
    @NotNull
    private static final String ID = DgsMetrics.GqlMetric.DATA_LOADER.getKey();
    private static final Logger logger = LoggerFactory.getLogger(BatchLoaderWithContextInterceptor.class);

    public BatchLoaderWithContextInterceptor(@NotNull Object batchLoaderWithContext, @NotNull String name, @NotNull MeterRegistry registry2) {
        Intrinsics.checkNotNullParameter((Object)batchLoaderWithContext, (String)"batchLoaderWithContext");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)registry2, (String)"registry");
        this.batchLoaderWithContext = batchLoaderWithContext;
        this.name = name;
        this.registry = registry2;
    }

    @Override
    @NotNull
    public CompletionStage<?> invoke(@NotNull Object proxy, @NotNull Method method, @NotNull Object[] args) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"load")) {
            CompletionStage completionStage;
            logger.debug("Starting metered timer[{}] for {}.", (Object)ID, (Object)this.getClass().getSimpleName());
            Timer.Sample timerSampler = Timer.start((MeterRegistry)this.registry);
            try {
                Object object = method.invoke(this.batchLoaderWithContext, Arrays.copyOf(args, args.length));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.concurrent.CompletionStage<*>");
                CompletionStage future = (CompletionStage)object;
                completionStage = future.whenComplete((arg_0, arg_1) -> BatchLoaderWithContextInterceptor.invoke$lambda$0((Function2)new Function2<Object, Throwable, Unit>(this, timerSampler){
                    final /* synthetic */ BatchLoaderWithContextInterceptor this$0;
                    final /* synthetic */ Timer.Sample $timerSampler;
                    {
                        this.this$0 = $receiver;
                        this.$timerSampler = $timerSampler;
                        super(2);
                    }

                    public final void invoke(Object result, Throwable throwable) {
                        int n;
                        BatchLoaderWithContextInterceptor.access$getLogger$cp().debug("Stopping timer[{}] for {}", (Object)BatchLoaderWithContextInterceptor.access$getID$cp(), (Object)this.this$0.getClass().getSimpleName());
                        if (result instanceof List) {
                            n = ((List)result).size();
                        } else if (result instanceof Map) {
                            n = ((Map)result).size();
                        } else {
                            throw new IllegalStateException("BatchLoader or MappedBatchLoader should always return a List/Map. A " + result.getClass().getName() + " was found.");
                        }
                        int resultSize = n;
                        Object[] objectArray = new Tag[]{Tag.of((String)DgsMetrics.GqlTag.LOADER_NAME.getKey(), (String)BatchLoaderWithContextInterceptor.access$getName$p(this.this$0)), Tag.of((String)DgsMetrics.GqlTag.LOADER_BATCH_SIZE.getKey(), (String)String.valueOf(resultSize))};
                        this.$timerSampler.stop(Timer.builder((String)BatchLoaderWithContextInterceptor.access$getID$cp()).tags((Iterable)CollectionsKt.listOf((Object[])objectArray)).register(BatchLoaderWithContextInterceptor.access$getRegistry$p(this.this$0)));
                    }
                }, arg_0, arg_1));
                Intrinsics.checkNotNull(completionStage);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{ID, this.getClass().getSimpleName(), exception.getMessage()};
                logger.warn("Error creating timer interceptor '{}' for {} with exception {}", objectArray);
                Object object = method.invoke(this.batchLoaderWithContext, Arrays.copyOf(args, args.length));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.concurrent.CompletionStage<kotlin.collections.List<*>>");
                completionStage = (CompletionStage)object;
            }
            return completionStage;
        }
        throw new UnsupportedOperationException("Unsupported method: " + method.getName());
    }

    private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$getID$cp() {
        return ID;
    }

    public static final /* synthetic */ String access$getName$p(BatchLoaderWithContextInterceptor $this) {
        return $this.name;
    }

    public static final /* synthetic */ MeterRegistry access$getRegistry$p(BatchLoaderWithContextInterceptor $this) {
        return $this.registry;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/dataloader/BatchLoaderWithContextInterceptor$Companion;", "", "()V", "ID", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs-spring-boot-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

