/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.metrics.micrometer.utils;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.netflix.graphql.dgs.Internal;
import com.netflix.graphql.dgs.metrics.micrometer.DgsMeterRegistrySupplier;
import com.netflix.graphql.dgs.metrics.micrometer.utils.CacheableQuerySignatureRepository;
import com.netflix.graphql.dgs.metrics.micrometer.utils.QuerySignatureRepository;
import com.netflix.graphql.dgs.metrics.micrometer.utils.SimpleQuerySignatureRepository;
import graphql.language.Document;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;

@Internal
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/CacheableQuerySignatureRepository;", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/SimpleQuerySignatureRepository;", "autoTimer", "Lorg/springframework/boot/actuate/metrics/AutoTimer;", "meterRegistrySupplier", "Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;", "optionalCacheManager", "Ljava/util/Optional;", "Lorg/springframework/cache/CacheManager;", "(Lorg/springframework/boot/actuate/metrics/AutoTimer;Lcom/netflix/graphql/dgs/metrics/micrometer/DgsMeterRegistrySupplier;Ljava/util/Optional;)V", "cache", "Lorg/springframework/cache/Cache;", "afterPropertiesSet", "", "computeQuerySignature", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/QuerySignatureRepository$QuerySignature;", "queryHash", "", "queryName", "document", "Lgraphql/language/Document;", "fetchRawValueFromCache", "key", "Lcom/netflix/graphql/dgs/metrics/micrometer/utils/CacheableQuerySignatureRepository$CacheKey;", "fetchRawValueFromCache$graphql_dgs_spring_boot_micrometer", "newMonitoredCaffeineCacheManager", "CacheKey", "Companion", "graphql-dgs-spring-boot-micrometer"})
public class CacheableQuerySignatureRepository
extends SimpleQuerySignatureRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Optional<CacheManager> optionalCacheManager;
    private Cache cache;
    @NotNull
    private static final Logger log;
    public static final long DEFAULT_MAX_CACHE_SIZE = 100L;
    @NotNull
    public static final String QUERY_SIG_CACHE = "dgsQuerySignatureCache";

    public CacheableQuerySignatureRepository(@NotNull AutoTimer autoTimer, @NotNull DgsMeterRegistrySupplier meterRegistrySupplier, @NotNull Optional<CacheManager> optionalCacheManager) {
        Intrinsics.checkNotNullParameter((Object)autoTimer, (String)"autoTimer");
        Intrinsics.checkNotNullParameter((Object)meterRegistrySupplier, (String)"meterRegistrySupplier");
        Intrinsics.checkNotNullParameter(optionalCacheManager, (String)"optionalCacheManager");
        super(autoTimer, meterRegistrySupplier);
        this.optionalCacheManager = optionalCacheManager;
    }

    @Override
    @NotNull
    protected QuerySignatureRepository.QuerySignature computeQuerySignature(@NotNull String queryHash, @Nullable String queryName, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)queryHash, (String)"queryHash");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CacheKey key = new CacheKey(queryHash, queryName);
        log.debug("Computing query signature for query with cache key: {}.", (Object)key);
        Cache cache = this.cache;
        if (cache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cache");
            cache = null;
        }
        Object object = cache.get((Object)key, () -> CacheableQuerySignatureRepository.computeQuerySignature$lambda$0(this, queryHash, queryName, document));
        Intrinsics.checkNotNull((Object)object);
        return (QuerySignatureRepository.QuerySignature)object;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Cache cache = Objects.requireNonNull(this.optionalCacheManager.filter(arg_0 -> CacheableQuerySignatureRepository.afterPropertiesSet$lambda$1(afterPropertiesSet.1.INSTANCE, arg_0)).flatMap(arg_0 -> CacheableQuerySignatureRepository.afterPropertiesSet$lambda$2(afterPropertiesSet.2.INSTANCE, arg_0)).orElseGet(() -> CacheableQuerySignatureRepository.afterPropertiesSet$lambda$3(this)), "Expected to resolve named cache[dgsQuerySignatureCache] from either the internal cache manager or the optional!");
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"requireNonNull(...)");
        this.cache = cache;
    }

    private final CacheManager newMonitoredCaffeineCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        com.github.benmanes.caffeine.cache.Cache customCaffeineCache = Caffeine.newBuilder().maximumSize(100L).recordStats().build();
        com.github.benmanes.caffeine.cache.Cache meteredCache = CaffeineCacheMetrics.monitor((MeterRegistry)this.getMeterRegistry(), (com.github.benmanes.caffeine.cache.Cache)customCaffeineCache, (String)QUERY_SIG_CACHE, (String[])new String[0]);
        cacheManager.registerCustomCache(QUERY_SIG_CACHE, meteredCache);
        return (CacheManager)cacheManager;
    }

    @NotNull
    public final Optional<QuerySignatureRepository.QuerySignature> fetchRawValueFromCache$graphql_dgs_spring_boot_micrometer(@NotNull CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cache cache = this.cache;
        if (cache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cache");
            cache = null;
        }
        Optional<QuerySignatureRepository.QuerySignature> optional = Optional.ofNullable(cache.get((Object)key)).map(arg_0 -> CacheableQuerySignatureRepository.fetchRawValueFromCache$lambda$4(fetchRawValueFromCache.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    private static final QuerySignatureRepository.QuerySignature computeQuerySignature$lambda$0(CacheableQuerySignatureRepository this$0, String $queryHash, String $queryName, Document $document) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$queryHash, (String)"$queryHash");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        return super.computeQuerySignature($queryHash, $queryName, $document);
    }

    private static final boolean afterPropertiesSet$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Optional afterPropertiesSet$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Cache afterPropertiesSet$lambda$3(CacheableQuerySignatureRepository this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.newMonitoredCaffeineCacheManager().getCache(QUERY_SIG_CACHE);
    }

    private static final QuerySignatureRepository.QuerySignature fetchRawValueFromCache$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (QuerySignatureRepository.QuerySignature)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(CacheableQuerySignatureRepository.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/CacheableQuerySignatureRepository$CacheKey;", "", "hash", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-spring-boot-micrometer"})
    public static final class CacheKey {
        @NotNull
        private final String hash;
        @Nullable
        private final String name;

        public CacheKey(@NotNull String hash, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.hash = hash;
            this.name = name;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @Nullable
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final CacheKey copy(@NotNull String hash, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new CacheKey(hash, name);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = cacheKey.hash;
            }
            if ((n & 2) != 0) {
                string2 = cacheKey.name;
            }
            return cacheKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CacheKey(hash=" + this.hash + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = this.hash.hashCode();
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)cacheKey.hash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)cacheKey.name);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/metrics/micrometer/utils/CacheableQuerySignatureRepository$Companion;", "", "()V", "DEFAULT_MAX_CACHE_SIZE", "", "QUERY_SIG_CACHE", "", "log", "Lorg/slf4j/Logger;", "graphql-dgs-spring-boot-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

