/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.autoconfig;

import com.netflix.graphql.dgs.internal.DataFetcherReference;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.springgraphql.DgsGraphQLSourceBuilder;
import com.netflix.graphql.dgs.springgraphql.ReloadableGraphQLSource;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsGraphQLConfigurationProperties;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLAutoConfiguration;
import com.netflix.graphql.dgs.springgraphql.autoconfig.ExceptionHandlerResolverAdapter;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;

@AutoConfiguration
@AutoConfigureBefore(name={"org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration"})
@AutoConfigureAfter(name={"com.netflix.graphql.dgs.autoconfig.DgsAutoConfiguration"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0084\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration;", "", "dgsGraphQLConfigProps", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsGraphQLConfigurationProperties;", "(Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsGraphQLConfigurationProperties;)V", "logger", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "graphQlSource", "Lorg/springframework/graphql/execution/GraphQlSource;", "properties", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlProperties;", "dgsSchemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "exceptionResolvers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/graphql/execution/DataFetcherExceptionResolver;", "subscriptionExceptionResolvers", "Lorg/springframework/graphql/execution/SubscriptionExceptionResolver;", "instrumentations", "Lgraphql/execution/instrumentation/Instrumentation;", "wiringConfigurers", "Lorg/springframework/graphql/execution/RuntimeWiringConfigurer;", "sourceCustomizers", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlSourceBuilderCustomizer;", "reloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "defaultExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "reportConsumer", "Ljava/util/Optional;", "Ljava/util/function/Consumer;", "Lorg/springframework/graphql/execution/SchemaReport;", "graphql-dgs-spring-graphql"})
@SourceDebugExtension(value={"SMAP\nDgsSpringGraphQLSourceAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSpringGraphQLSourceAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,134:1\n125#2:135\n152#2,3:136\n*S KotlinDebug\n*F\n+ 1 DgsSpringGraphQLSourceAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration\n*L\n82#1:135\n82#1:136,3\n*E\n"})
public class DgsSpringGraphQLSourceAutoConfiguration {
    @NotNull
    private final DgsGraphQLConfigurationProperties dgsGraphQLConfigProps;
    private final Log logger;

    public DgsSpringGraphQLSourceAutoConfiguration(@NotNull DgsGraphQLConfigurationProperties dgsGraphQLConfigProps) {
        Intrinsics.checkNotNullParameter((Object)dgsGraphQLConfigProps, (String)"dgsGraphQLConfigProps");
        this.dgsGraphQLConfigProps = dgsGraphQLConfigProps;
        this.logger = LogFactory.getLog(DgsSpringGraphQLAutoConfiguration.class);
    }

    @Bean
    @NotNull
    public GraphQlSource graphQlSource(@NotNull GraphQlProperties properties, @NotNull DgsSchemaProvider dgsSchemaProvider, @NotNull ObjectProvider<DataFetcherExceptionResolver> exceptionResolvers, @NotNull ObjectProvider<SubscriptionExceptionResolver> subscriptionExceptionResolvers, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull ObjectProvider<RuntimeWiringConfigurer> wiringConfigurers, @NotNull ObjectProvider<GraphQlSourceBuilderCustomizer> sourceCustomizers, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull DataFetcherExceptionHandler defaultExceptionHandler, @NotNull Optional<Consumer<SchemaReport>> reportConsumer) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        Intrinsics.checkNotNullParameter(exceptionResolvers, (String)"exceptionResolvers");
        Intrinsics.checkNotNullParameter(subscriptionExceptionResolvers, (String)"subscriptionExceptionResolvers");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter(wiringConfigurers, (String)"wiringConfigurers");
        Intrinsics.checkNotNullParameter(sourceCustomizers, (String)"sourceCustomizers");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter((Object)defaultExceptionHandler, (String)"defaultExceptionHandler");
        Intrinsics.checkNotNullParameter(reportConsumer, (String)"reportConsumer");
        List list = exceptionResolvers.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        List dataFetcherExceptionResolvers = CollectionsKt.toMutableList((Collection)list);
        dataFetcherExceptionResolvers.add(new ExceptionHandlerResolverAdapter(defaultExceptionHandler));
        GraphQlSource.SchemaResourceBuilder builder = (GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)new DgsGraphQLSourceBuilder(dgsSchemaProvider, this.dgsGraphQLConfigProps.getIntrospection().getShowSdlComments()).exceptionResolvers(dataFetcherExceptionResolvers)).subscriptionExceptionResolvers(subscriptionExceptionResolvers.orderedStream().toList())).instrumentation(instrumentations.orderedStream().toList());
        if (properties.getSchema().getInspection().isEnabled()) {
            if (reportConsumer.isPresent()) {
                builder.inspectSchemaMappings(reportConsumer.get());
            } else {
                builder.inspectSchemaMappings(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$1(this, arg_0));
            }
        }
        wiringConfigurers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$2((Function1)new Function1<RuntimeWiringConfigurer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull RuntimeWiringConfigurer configurer) {
                Intrinsics.checkNotNullParameter((Object)configurer, (String)"configurer");
                this.$builder.configureRuntimeWiring(configurer);
            }
        }, arg_0));
        sourceCustomizers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$3((Function1)new Function1<GraphQlSourceBuilderCustomizer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull GraphQlSourceBuilderCustomizer customizer) {
                Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
                customizer.customize(this.$builder);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)builder);
        return new ReloadableGraphQLSource((GraphQlSource.Builder)builder, reloadSchemaIndicator);
    }

    /*
     * WARNING - void declaration
     */
    private static final void graphQlSource$lambda$1(DgsSpringGraphQLSourceAutoConfiguration this$0, SchemaReport message) {
        List list;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StringBuilder messageBuilder = new StringBuilder("***Schema Report***\n");
        SchemaReport schemaReport = message;
        if (schemaReport != null && (schemaReport = schemaReport.unmappedArguments()) != null) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = (Map)schemaReport;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (it.getKey() instanceof SelfDescribingDataFetcher) {
                    Object k = it.getKey();
                    Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type com.netflix.graphql.dgs.springgraphql.DgsGraphQLSourceBuilder.DgsSelfDescribingDataFetcher");
                    DataFetcherReference dataFetcher = ((DgsGraphQLSourceBuilder.DgsSelfDescribingDataFetcher)k).getDataFetcher();
                    object = dataFetcher.getMethod().getDeclaringClass().getName() + "." + dataFetcher.getMethod().getName() + " for arguments " + it.getValue();
                } else {
                    object = it.toString();
                }
                collection.add(object);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List arguments = list;
        SchemaReport schemaReport2 = message;
        messageBuilder.append("Unmapped fields: " + (schemaReport2 != null ? schemaReport2.unmappedFields() : null) + "\n");
        SchemaReport schemaReport3 = message;
        messageBuilder.append("Unmapped registrations: " + (schemaReport3 != null ? schemaReport3.unmappedRegistrations() : null) + "\n");
        messageBuilder.append("Unmapped arguments: " + arguments + "\n");
        SchemaReport schemaReport4 = message;
        messageBuilder.append("Skipped types: " + (schemaReport4 != null ? schemaReport4.skippedTypes() : null) + "\n");
        this$0.logger.info((Object)messageBuilder.toString());
    }

    private static final void graphQlSource$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void graphQlSource$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

