/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.autoconfig;

import com.netflix.graphql.dgs.internal.DataFetcherReference;
import com.netflix.graphql.dgs.internal.DefaultDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.springgraphql.DgsGraphQLSourceBuilder;
import com.netflix.graphql.dgs.springgraphql.ReloadableGraphQLSource;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsGraphQLConfigurationProperties;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLAutoConfiguration;
import com.netflix.graphql.dgs.springgraphql.autoconfig.ExceptionHandlerResolverAdapter;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.DataFetcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.util.MultiValueMap;

@AutoConfiguration
@AutoConfigureBefore(name={"org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration"})
@AutoConfigureAfter(name={"com.netflix.graphql.dgs.autoconfig.DgsAutoConfiguration"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J~\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration;", "", "dgsGraphQLConfigProps", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsGraphQLConfigurationProperties;", "(Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsGraphQLConfigurationProperties;)V", "graphQlSource", "Lorg/springframework/graphql/execution/GraphQlSource;", "properties", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlProperties;", "dgsSchemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "exceptionResolvers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/graphql/execution/DataFetcherExceptionResolver;", "subscriptionExceptionResolvers", "Lorg/springframework/graphql/execution/SubscriptionExceptionResolver;", "instrumentations", "Lgraphql/execution/instrumentation/Instrumentation;", "wiringConfigurers", "Lorg/springframework/graphql/execution/RuntimeWiringConfigurer;", "sourceCustomizers", "Lorg/springframework/boot/autoconfigure/graphql/GraphQlSourceBuilderCustomizer;", "reloadSchemaIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "defaultExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "reportConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/graphql/execution/SchemaReport;", "Companion", "graphql-dgs-spring-graphql"})
@SourceDebugExtension(value={"SMAP\nDgsSpringGraphQLSourceAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSpringGraphQLSourceAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,137:1\n125#2:138\n152#2,3:139\n*S KotlinDebug\n*F\n+ 1 DgsSpringGraphQLSourceAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration\n*L\n89#1:138\n89#1:139,3\n*E\n"})
public class DgsSpringGraphQLSourceAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsGraphQLConfigurationProperties dgsGraphQLConfigProps;
    private static final Logger logger = LoggerFactory.getLogger(DgsSpringGraphQLAutoConfiguration.class);

    public DgsSpringGraphQLSourceAutoConfiguration(@NotNull DgsGraphQLConfigurationProperties dgsGraphQLConfigProps) {
        Intrinsics.checkNotNullParameter((Object)dgsGraphQLConfigProps, (String)"dgsGraphQLConfigProps");
        this.dgsGraphQLConfigProps = dgsGraphQLConfigProps;
    }

    @Bean
    @NotNull
    public GraphQlSource graphQlSource(@NotNull GraphQlProperties properties, @NotNull DgsSchemaProvider dgsSchemaProvider, @NotNull ObjectProvider<DataFetcherExceptionResolver> exceptionResolvers, @NotNull ObjectProvider<SubscriptionExceptionResolver> subscriptionExceptionResolvers, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull ObjectProvider<RuntimeWiringConfigurer> wiringConfigurers, @NotNull ObjectProvider<GraphQlSourceBuilderCustomizer> sourceCustomizers, @NotNull DefaultDgsQueryExecutor.ReloadSchemaIndicator reloadSchemaIndicator, @NotNull DataFetcherExceptionHandler defaultExceptionHandler, @Nullable Consumer<SchemaReport> reportConsumer) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        Intrinsics.checkNotNullParameter(exceptionResolvers, (String)"exceptionResolvers");
        Intrinsics.checkNotNullParameter(subscriptionExceptionResolvers, (String)"subscriptionExceptionResolvers");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter(wiringConfigurers, (String)"wiringConfigurers");
        Intrinsics.checkNotNullParameter(sourceCustomizers, (String)"sourceCustomizers");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter((Object)defaultExceptionHandler, (String)"defaultExceptionHandler");
        List list = exceptionResolvers.orderedStream().collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        List dataFetcherExceptionResolvers = list;
        ((Collection)dataFetcherExceptionResolvers).add(new ExceptionHandlerResolverAdapter(defaultExceptionHandler));
        GraphQlSource.SchemaResourceBuilder builder = (GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)new DgsGraphQLSourceBuilder(dgsSchemaProvider, this.dgsGraphQLConfigProps.getIntrospection().getShowSdlComments()).exceptionResolvers(dataFetcherExceptionResolvers)).subscriptionExceptionResolvers(subscriptionExceptionResolvers.orderedStream().toList())).instrumentation(instrumentations.orderedStream().toList());
        if (properties.getSchema().getInspection().isEnabled()) {
            if (reportConsumer != null) {
                builder.inspectSchemaMappings(reportConsumer);
            } else if (logger.isInfoEnabled()) {
                builder.inspectSchemaMappings(DgsSpringGraphQLSourceAutoConfiguration::graphQlSource$lambda$1);
            }
        }
        wiringConfigurers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$2((Function1)new Function1<RuntimeWiringConfigurer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull RuntimeWiringConfigurer configurer) {
                Intrinsics.checkNotNullParameter((Object)configurer, (String)"configurer");
                this.$builder.configureRuntimeWiring(configurer);
            }
        }, arg_0));
        sourceCustomizers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLSourceAutoConfiguration.graphQlSource$lambda$3((Function1)new Function1<GraphQlSourceBuilderCustomizer, Unit>(builder){
            final /* synthetic */ GraphQlSource.SchemaResourceBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull GraphQlSourceBuilderCustomizer customizer) {
                Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
                customizer.customize(this.$builder);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)builder);
        return new ReloadableGraphQLSource((GraphQlSource.Builder)builder, reloadSchemaIndicator);
    }

    /*
     * WARNING - void declaration
     */
    private static final void graphQlSource$lambda$1(SchemaReport schemaReport) {
        void $this$mapTo$iv$iv;
        StringBuilder messageBuilder = new StringBuilder("***Schema Report***\n");
        MultiValueMap multiValueMap = schemaReport.unmappedArguments();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"unmappedArguments(...)");
        Map $this$map$iv = (Map)multiValueMap;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DataFetcher key = (DataFetcher)entry.getKey();
            List value = (List)entry.getValue();
            if (key instanceof SelfDescribingDataFetcher) {
                DataFetcherReference dataFetcher = ((DgsGraphQLSourceBuilder.DgsSelfDescribingDataFetcher)key).getDataFetcher();
                object = dataFetcher.getMethod().getDeclaringClass().getName() + "." + dataFetcher.getMethod().getName() + " for arguments " + value;
            } else {
                object = entry.toString();
            }
            collection.add(object);
        }
        List arguments = (List)destination$iv$iv;
        messageBuilder.append("Unmapped fields: ").append(schemaReport.unmappedFields()).append('\n');
        messageBuilder.append("Unmapped registrations: ").append(schemaReport.unmappedRegistrations()).append('\n');
        messageBuilder.append("Unmapped arguments: ").append(arguments).append('\n');
        messageBuilder.append("Skipped types: ").append(schemaReport.skippedTypes()).append('\n');
        logger.info("{}", (Object)messageBuilder);
    }

    private static final void graphQlSource$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void graphQlSource$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLSourceAutoConfiguration$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

