/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.mvc;

import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.DgsWebMvcRequestData;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.language.OperationDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsGraphQLCSRFInstrumentation;", "Lgraphql/execution/instrumentation/SimplePerformantInstrumentation;", "()V", "beginExecuteOperation", "Lgraphql/execution/instrumentation/InstrumentationContext;", "Lgraphql/ExecutionResult;", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationExecuteOperationParameters;", "state", "Lgraphql/execution/instrumentation/InstrumentationState;", "Companion", "graphql-dgs-spring-webmvc"})
public final class DgsGraphQLCSRFInstrumentation
extends SimplePerformantInstrumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    @Nullable
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(@Nullable InstrumentationExecuteOperationParameters parameters, @Nullable InstrumentationState state) {
        if (parameters != null && parameters.getExecutionContext().getOperationDefinition().getOperation() == OperationDefinition.Operation.MUTATION) {
            GraphQLContext graphQLContext = parameters.getExecutionContext().getGraphQLContext();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLContext, (String)"getGraphQLContext(...)");
            DgsRequestData dgsRequestData = DgsContext.Companion.from(graphQLContext).getRequestData();
            Intrinsics.checkNotNull((Object)dgsRequestData, (String)"null cannot be cast to non-null type com.netflix.graphql.dgs.internal.DgsWebMvcRequestData");
            WebRequest httpRequest = ((DgsWebMvcRequestData)dgsRequestData).getWebRequest();
            if (httpRequest instanceof ServletWebRequest && StringsKt.equals((String)((ServletWebRequest)httpRequest).getHttpMethod().name(), (String)HttpMethod.GET.name(), (boolean)true)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Bad Request");
            }
        }
        return super.beginExecuteOperation(parameters, state);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsGraphQLCSRFInstrumentation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/mvc/DgsGraphQLCSRFInstrumentation$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "graphql-dgs-spring-webmvc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

