/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.types.subscription.websockets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.netflix.graphql.types.subscription.websockets.ExecutionResult;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectionInitMessage.class, name="connection_init"), @JsonSubTypes.Type(value=ConnectionAckMessage.class, name="connection_ack"), @JsonSubTypes.Type(value=PingMessage.class, name="ping"), @JsonSubTypes.Type(value=PongMessage.class, name="pong"), @JsonSubTypes.Type(value=SubscribeMessage.class, name="subscribe"), @JsonSubTypes.Type(value=NextMessage.class, name="next"), @JsonSubTypes.Type(value=ErrorMessage.class, name="error"), @JsonSubTypes.Type(value=CompleteMessage.class, name="complete")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\b\u0007\b\t\n\u000b\f\r\u000eB\u0011\b\u0004\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\b\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message;", "", "type", "", "(Ljava/lang/String;)V", "getType", "()Ljava/lang/String;", "CompleteMessage", "ConnectionAckMessage", "ConnectionInitMessage", "ErrorMessage", "NextMessage", "PingMessage", "PongMessage", "SubscribeMessage", "Lcom/netflix/graphql/types/subscription/websockets/Message$CompleteMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message$ConnectionAckMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message$ConnectionInitMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message$ErrorMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message$NextMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message$PingMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message$PongMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message$SubscribeMessage;", "graphql-dgs-subscription-types"})
public abstract class Message {
    @NotNull
    private final String type;

    private Message(@JsonProperty(value="type") String type) {
        this.type = type;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public /* synthetic */ Message(String type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$CompleteMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
    public static final class CompleteMessage
    extends Message {
        @NotNull
        private final String id;

        public CompleteMessage(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super("complete", null);
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final CompleteMessage copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new CompleteMessage(id);
        }

        public static /* synthetic */ CompleteMessage copy$default(CompleteMessage completeMessage, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = completeMessage.id;
            }
            return completeMessage.copy(string);
        }

        @NotNull
        public String toString() {
            return "CompleteMessage(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompleteMessage)) {
                return false;
            }
            CompleteMessage completeMessage = (CompleteMessage)other;
            return Intrinsics.areEqual((Object)this.id, (Object)completeMessage.id);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0003J!\u0010\n\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$ConnectionAckMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "payload", "", "", "", "(Ljava/util/Map;)V", "getPayload", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
    public static final class ConnectionAckMessage
    extends Message {
        @Nullable
        private final Map<String, Object> payload;

        public ConnectionAckMessage(@Nullable Map<String, ? extends Object> payload) {
            super("connection_ack", null);
            this.payload = payload;
        }

        public /* synthetic */ ConnectionAckMessage(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Nullable
        public final Map<String, Object> getPayload() {
            return this.payload;
        }

        @Nullable
        public final Map<String, Object> component1() {
            return this.payload;
        }

        @NotNull
        public final ConnectionAckMessage copy(@Nullable Map<String, ? extends Object> payload) {
            return new ConnectionAckMessage(payload);
        }

        public static /* synthetic */ ConnectionAckMessage copy$default(ConnectionAckMessage connectionAckMessage, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = connectionAckMessage.payload;
            }
            return connectionAckMessage.copy(map);
        }

        @NotNull
        public String toString() {
            return "ConnectionAckMessage(payload=" + this.payload + ")";
        }

        public int hashCode() {
            return this.payload == null ? 0 : ((Object)this.payload).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionAckMessage)) {
                return false;
            }
            ConnectionAckMessage connectionAckMessage = (ConnectionAckMessage)other;
            return Intrinsics.areEqual(this.payload, connectionAckMessage.payload);
        }

        public ConnectionAckMessage() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0003J!\u0010\n\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$ConnectionInitMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "payload", "", "", "", "(Ljava/util/Map;)V", "getPayload", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
    public static final class ConnectionInitMessage
    extends Message {
        @Nullable
        private final Map<String, Object> payload;

        public ConnectionInitMessage(@Nullable Map<String, ? extends Object> payload) {
            super("connection_init", null);
            this.payload = payload;
        }

        public /* synthetic */ ConnectionInitMessage(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Nullable
        public final Map<String, Object> getPayload() {
            return this.payload;
        }

        @Nullable
        public final Map<String, Object> component1() {
            return this.payload;
        }

        @NotNull
        public final ConnectionInitMessage copy(@Nullable Map<String, ? extends Object> payload) {
            return new ConnectionInitMessage(payload);
        }

        public static /* synthetic */ ConnectionInitMessage copy$default(ConnectionInitMessage connectionInitMessage, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = connectionInitMessage.payload;
            }
            return connectionInitMessage.copy(map);
        }

        @NotNull
        public String toString() {
            return "ConnectionInitMessage(payload=" + this.payload + ")";
        }

        public int hashCode() {
            return this.payload == null ? 0 : ((Object)this.payload).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionInitMessage)) {
                return false;
            }
            ConnectionInitMessage connectionInitMessage = (ConnectionInitMessage)other;
            return Intrinsics.areEqual(this.payload, connectionInitMessage.payload);
        }

        public ConnectionInitMessage() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$ErrorMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "id", "", "payload", "", "", "(Ljava/lang/String;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "getPayload", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
    public static final class ErrorMessage
    extends Message {
        @NotNull
        private final String id;
        @NotNull
        private final List<Object> payload;

        public ErrorMessage(@NotNull String id, @NotNull List<? extends Object> payload) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(payload, (String)"payload");
            super("error", null);
            this.id = id;
            this.payload = payload;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final List<Object> getPayload() {
            return this.payload;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final List<Object> component2() {
            return this.payload;
        }

        @NotNull
        public final ErrorMessage copy(@NotNull String id, @NotNull List<? extends Object> payload) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(payload, (String)"payload");
            return new ErrorMessage(id, payload);
        }

        public static /* synthetic */ ErrorMessage copy$default(ErrorMessage errorMessage, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = errorMessage.id;
            }
            if ((n & 2) != 0) {
                list = errorMessage.payload;
            }
            return errorMessage.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "ErrorMessage(id=" + this.id + ", payload=" + this.payload + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + ((Object)this.payload).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorMessage)) {
                return false;
            }
            ErrorMessage errorMessage = (ErrorMessage)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)errorMessage.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.payload, errorMessage.payload);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$NextMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "id", "", "payload", "Lcom/netflix/graphql/types/subscription/websockets/ExecutionResult;", "(Ljava/lang/String;Lcom/netflix/graphql/types/subscription/websockets/ExecutionResult;)V", "getId", "()Ljava/lang/String;", "getPayload", "()Lcom/netflix/graphql/types/subscription/websockets/ExecutionResult;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
    public static final class NextMessage
    extends Message {
        @NotNull
        private final String id;
        @NotNull
        private final ExecutionResult payload;

        public NextMessage(@NotNull String id, @NotNull ExecutionResult payload) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            super("next", null);
            this.id = id;
            this.payload = payload;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final ExecutionResult getPayload() {
            return this.payload;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final ExecutionResult component2() {
            return this.payload;
        }

        @NotNull
        public final NextMessage copy(@NotNull String id, @NotNull ExecutionResult payload) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            return new NextMessage(id, payload);
        }

        public static /* synthetic */ NextMessage copy$default(NextMessage nextMessage, String string, ExecutionResult executionResult, int n, Object object) {
            if ((n & 1) != 0) {
                string = nextMessage.id;
            }
            if ((n & 2) != 0) {
                executionResult = nextMessage.payload;
            }
            return nextMessage.copy(string, executionResult);
        }

        @NotNull
        public String toString() {
            return "NextMessage(id=" + this.id + ", payload=" + this.payload + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.payload.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NextMessage)) {
                return false;
            }
            NextMessage nextMessage = (NextMessage)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)nextMessage.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.payload, (Object)nextMessage.payload);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0003J!\u0010\n\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$PingMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "payload", "", "", "", "(Ljava/util/Map;)V", "getPayload", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
    public static final class PingMessage
    extends Message {
        @Nullable
        private final Map<String, Object> payload;

        public PingMessage(@Nullable Map<String, ? extends Object> payload) {
            super("ping", null);
            this.payload = payload;
        }

        public /* synthetic */ PingMessage(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Nullable
        public final Map<String, Object> getPayload() {
            return this.payload;
        }

        @Nullable
        public final Map<String, Object> component1() {
            return this.payload;
        }

        @NotNull
        public final PingMessage copy(@Nullable Map<String, ? extends Object> payload) {
            return new PingMessage(payload);
        }

        public static /* synthetic */ PingMessage copy$default(PingMessage pingMessage, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = pingMessage.payload;
            }
            return pingMessage.copy(map);
        }

        @NotNull
        public String toString() {
            return "PingMessage(payload=" + this.payload + ")";
        }

        public int hashCode() {
            return this.payload == null ? 0 : ((Object)this.payload).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PingMessage)) {
                return false;
            }
            PingMessage pingMessage = (PingMessage)other;
            return Intrinsics.areEqual(this.payload, pingMessage.payload);
        }

        public PingMessage() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0003J!\u0010\n\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$PongMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "payload", "", "", "", "(Ljava/util/Map;)V", "getPayload", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
    public static final class PongMessage
    extends Message {
        @Nullable
        private final Map<String, Object> payload;

        public PongMessage(@Nullable Map<String, ? extends Object> payload) {
            super("pong", null);
            this.payload = payload;
        }

        public /* synthetic */ PongMessage(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Nullable
        public final Map<String, Object> getPayload() {
            return this.payload;
        }

        @Nullable
        public final Map<String, Object> component1() {
            return this.payload;
        }

        @NotNull
        public final PongMessage copy(@Nullable Map<String, ? extends Object> payload) {
            return new PongMessage(payload);
        }

        public static /* synthetic */ PongMessage copy$default(PongMessage pongMessage, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = pongMessage.payload;
            }
            return pongMessage.copy(map);
        }

        @NotNull
        public String toString() {
            return "PongMessage(payload=" + this.payload + ")";
        }

        public int hashCode() {
            return this.payload == null ? 0 : ((Object)this.payload).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PongMessage)) {
                return false;
            }
            PongMessage pongMessage = (PongMessage)other;
            return Intrinsics.areEqual(this.payload, pongMessage.payload);
        }

        public PongMessage() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$SubscribeMessage;", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "id", "", "payload", "Lcom/netflix/graphql/types/subscription/websockets/Message$SubscribeMessage$Payload;", "(Ljava/lang/String;Lcom/netflix/graphql/types/subscription/websockets/Message$SubscribeMessage$Payload;)V", "getId", "()Ljava/lang/String;", "getPayload", "()Lcom/netflix/graphql/types/subscription/websockets/Message$SubscribeMessage$Payload;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Payload", "graphql-dgs-subscription-types"})
    public static final class SubscribeMessage
    extends Message {
        @NotNull
        private final String id;
        @NotNull
        private final Payload payload;

        public SubscribeMessage(@NotNull String id, @NotNull Payload payload) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            super("subscribe", null);
            this.id = id;
            this.payload = payload;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Payload getPayload() {
            return this.payload;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final Payload component2() {
            return this.payload;
        }

        @NotNull
        public final SubscribeMessage copy(@NotNull String id, @NotNull Payload payload) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            return new SubscribeMessage(id, payload);
        }

        public static /* synthetic */ SubscribeMessage copy$default(SubscribeMessage subscribeMessage, String string, Payload payload, int n, Object object) {
            if ((n & 1) != 0) {
                string = subscribeMessage.id;
            }
            if ((n & 2) != 0) {
                payload = subscribeMessage.payload;
            }
            return subscribeMessage.copy(string, payload);
        }

        @NotNull
        public String toString() {
            return "SubscribeMessage(id=" + this.id + ", payload=" + this.payload + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.payload.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubscribeMessage)) {
                return false;
            }
            SubscribeMessage subscribeMessage = (SubscribeMessage)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)subscribeMessage.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.payload, (Object)subscribeMessage.payload);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u00c6\u0003J\u0017\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u00c6\u0003JO\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00062\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/netflix/graphql/types/subscription/websockets/Message$SubscribeMessage$Payload;", "", "operationName", "", "query", "variables", "", "extensions", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "getExtensions", "()Ljava/util/Map;", "getOperationName", "()Ljava/lang/String;", "getQuery", "getVariables", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-subscription-types"})
        public static final class Payload {
            @Nullable
            private final String operationName;
            @NotNull
            private final String query;
            @Nullable
            private final Map<String, Object> variables;
            @Nullable
            private final Map<String, Object> extensions;

            public Payload(@Nullable String operationName, @Language(value="graphql") @NotNull String query, @Nullable Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                this.operationName = operationName;
                this.query = query;
                this.variables = variables;
                this.extensions = extensions;
            }

            public /* synthetic */ Payload(String string, String string2, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 4) != 0) {
                    map = null;
                }
                if ((n & 8) != 0) {
                    map2 = null;
                }
                this(string, string2, map, map2);
            }

            @Nullable
            public final String getOperationName() {
                return this.operationName;
            }

            @NotNull
            public final String getQuery() {
                return this.query;
            }

            @Nullable
            public final Map<String, Object> getVariables() {
                return this.variables;
            }

            @Nullable
            public final Map<String, Object> getExtensions() {
                return this.extensions;
            }

            @Nullable
            public final String component1() {
                return this.operationName;
            }

            @NotNull
            public final String component2() {
                return this.query;
            }

            @Nullable
            public final Map<String, Object> component3() {
                return this.variables;
            }

            @Nullable
            public final Map<String, Object> component4() {
                return this.extensions;
            }

            @NotNull
            public final Payload copy(@Nullable String operationName, @Language(value="graphql") @NotNull String query, @Nullable Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                return new Payload(operationName, query, variables, extensions);
            }

            public static /* synthetic */ Payload copy$default(Payload payload, String string, String string2, Map map, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = payload.operationName;
                }
                if ((n & 2) != 0) {
                    string2 = payload.query;
                }
                if ((n & 4) != 0) {
                    map = payload.variables;
                }
                if ((n & 8) != 0) {
                    map2 = payload.extensions;
                }
                return payload.copy(string, string2, map, map2);
            }

            @NotNull
            public String toString() {
                return "Payload(operationName=" + this.operationName + ", query=" + this.query + ", variables=" + this.variables + ", extensions=" + this.extensions + ")";
            }

            public int hashCode() {
                int result = this.operationName == null ? 0 : this.operationName.hashCode();
                result = result * 31 + this.query.hashCode();
                result = result * 31 + (this.variables == null ? 0 : ((Object)this.variables).hashCode());
                result = result * 31 + (this.extensions == null ? 0 : ((Object)this.extensions).hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Payload)) {
                    return false;
                }
                Payload payload = (Payload)other;
                if (!Intrinsics.areEqual((Object)this.operationName, (Object)payload.operationName)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.query, (Object)payload.query)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.variables, payload.variables)) {
                    return false;
                }
                return Intrinsics.areEqual(this.extensions, payload.extensions);
            }
        }
    }
}

