/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifierDefault;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.junit.Assert;
import org.junit.Test;

public interface HystrixCircuitBreaker {
    public boolean allowRequest();

    public boolean isOpen();

    public void markSuccess();

    public static class UnitTest {
        private HystrixCommandKey key = CommandKeyForUnitTest.KEY_ONE;

        @Test
        public void testTripCircuit() {
            try {
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                metrics.markSuccess(1000L);
                metrics.markSuccess(1000L);
                metrics.markSuccess(1000L);
                metrics.markSuccess(1000L);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testTripCircuitOnFailuresAboveThreshold() {
            try {
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
                metrics.markSuccess(400L);
                metrics.markSuccess(400L);
                metrics.markFailure(10L);
                metrics.markSuccess(400L);
                metrics.markFailure(10L);
                metrics.markFailure(10L);
                metrics.markSuccess(400L);
                metrics.markFailure(10L);
                metrics.markFailure(10L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testCircuitDoesNotTripOnFailuresBelowThreshold() {
            try {
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
                metrics.markSuccess(400L);
                metrics.markSuccess(400L);
                metrics.markFailure(10L);
                metrics.markSuccess(400L);
                metrics.markSuccess(40L);
                metrics.markSuccess(400L);
                metrics.markFailure(10L);
                metrics.markFailure(10L);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testTripCircuitOnTimeouts() {
            try {
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
                metrics.markTimeout(2000L);
                metrics.markTimeout(2000L);
                metrics.markTimeout(2000L);
                metrics.markTimeout(2000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testTripCircuitOnTimeoutsAboveThreshold() {
            try {
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
                metrics.markSuccess(400L);
                metrics.markSuccess(400L);
                metrics.markTimeout(10L);
                metrics.markSuccess(400L);
                metrics.markTimeout(10L);
                metrics.markTimeout(10L);
                metrics.markSuccess(400L);
                metrics.markTimeout(10L);
                metrics.markTimeout(10L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testSingleTestOnOpenCircuitAfterTimeWindow() {
            try {
                int sleepWindow = 200;
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerSleepWindowInMilliseconds(sleepWindow);
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Thread.sleep(sleepWindow + 50);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Assert.assertFalse((boolean)cb.allowRequest());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testCircuitClosedAfterSuccess() {
            try {
                int sleepWindow = 200;
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerSleepWindowInMilliseconds(sleepWindow);
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markTimeout(1000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Thread.sleep(sleepWindow + 50);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Assert.assertFalse((boolean)cb.allowRequest());
                metrics.markSuccess(500L);
                cb.markSuccess();
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testCircuitClosedAfterSuccessAndClearsStatisticalWindow() {
            try {
                int statisticalWindow = 200;
                int sleepWindow = 10;
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerSleepWindowInMilliseconds(sleepWindow).withMetricsRollingStatisticalWindowInMilliseconds(statisticalWindow);
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Thread.sleep(sleepWindow + 50);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Assert.assertFalse((boolean)cb.allowRequest());
                metrics.markSuccess(500L);
                cb.markSuccess();
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testMultipleTimeWindowRetriesBeforeClosingCircuit() {
            try {
                int sleepWindow = 200;
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerSleepWindowInMilliseconds(sleepWindow);
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Thread.sleep(sleepWindow + 50);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Assert.assertFalse((boolean)cb.allowRequest());
                metrics.markFailure(1000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.allowRequest());
                Thread.sleep(sleepWindow + 50);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Assert.assertFalse((boolean)cb.allowRequest());
                metrics.markFailure(1000L);
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.allowRequest());
                Thread.sleep(sleepWindow + 50);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.isOpen());
                Assert.assertFalse((boolean)cb.allowRequest());
                metrics.markSuccess(200L);
                cb.markSuccess();
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        @Test
        public void testLowVolumeDoesNotTripCircuit() {
            try {
                int sleepWindow = 200;
                int lowVolume = 5;
                HystrixCommandProperties.Setter properties = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerSleepWindowInMilliseconds(sleepWindow).withCircuitBreakerRequestVolumeThreshold(lowVolume);
                HystrixCommandMetrics metrics = UnitTest.getMetrics(properties);
                HystrixCircuitBreaker cb = UnitTest.getCircuitBreaker(this.key, CommandOwnerForUnitTest.OWNER_TWO, metrics, properties);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                metrics.markFailure(1000L);
                Assert.assertTrue((boolean)cb.allowRequest());
                Assert.assertFalse((boolean)cb.isOpen());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Error occurred: " + e.getMessage()));
            }
        }

        private static HystrixCommandMetrics getMetrics(HystrixCommandProperties.Setter properties) {
            return new HystrixCommandMetrics(CommandKeyForUnitTest.KEY_ONE, CommandOwnerForUnitTest.OWNER_ONE, ThreadPoolKeyForUnitTest.THREAD_POOL_ONE, HystrixCommandProperties.Setter.asMock(properties), HystrixEventNotifierDefault.getInstance());
        }

        private static HystrixCircuitBreaker getCircuitBreaker(HystrixCommandKey key, HystrixCommandGroupKey commandGroup, HystrixCommandMetrics metrics, HystrixCommandProperties.Setter properties) {
            return new HystrixCircuitBreakerImpl(key, commandGroup, HystrixCommandProperties.Setter.asMock(properties), metrics);
        }

        static /* synthetic */ HystrixCommandMetrics access$000(HystrixCommandProperties.Setter x0) {
            return UnitTest.getMetrics(x0);
        }

        private static enum CommandKeyForUnitTest implements HystrixCommandKey
        {
            KEY_ONE,
            KEY_TWO;

        }

        private static enum ThreadPoolKeyForUnitTest implements HystrixThreadPoolKey
        {
            THREAD_POOL_ONE,
            THREAD_POOL_TWO;

        }

        private static enum CommandOwnerForUnitTest implements HystrixCommandGroupKey
        {
            OWNER_ONE,
            OWNER_TWO;

        }
    }

    public static class TestCircuitBreaker
    implements HystrixCircuitBreaker {
        final HystrixCommandMetrics metrics = UnitTest.access$000(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter());
        private boolean forceShortCircuit = false;

        public TestCircuitBreaker setForceShortCircuit(boolean value) {
            this.forceShortCircuit = value;
            return this;
        }

        @Override
        public boolean isOpen() {
            if (this.forceShortCircuit) {
                return true;
            }
            return this.metrics.getCumulativeCount(HystrixRollingNumberEvent.FAILURE) >= 3L;
        }

        @Override
        public void markSuccess() {
        }

        @Override
        public boolean allowRequest() {
            return !this.isOpen();
        }
    }

    public static class NoOpCircuitBreaker
    implements HystrixCircuitBreaker {
        @Override
        public boolean allowRequest() {
            return true;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void markSuccess() {
        }
    }

    @ThreadSafe
    public static class HystrixCircuitBreakerImpl
    implements HystrixCircuitBreaker {
        private final HystrixCommandProperties properties;
        private final HystrixCommandMetrics metrics;
        private AtomicBoolean circuitOpen = new AtomicBoolean(false);
        private AtomicLong circuitOpenedOrLastTestedTime = new AtomicLong();

        protected HystrixCircuitBreakerImpl(HystrixCommandKey key, HystrixCommandGroupKey commandGroup, HystrixCommandProperties properties, HystrixCommandMetrics metrics) {
            this.properties = properties;
            this.metrics = metrics;
        }

        @Override
        public void markSuccess() {
            if (this.circuitOpen.get()) {
                this.circuitOpen.set(false);
                this.metrics.resetCounter();
            }
        }

        @Override
        public boolean allowRequest() {
            if (this.properties.circuitBreakerForceOpen().get().booleanValue()) {
                return false;
            }
            if (this.properties.circuitBreakerForceClosed().get().booleanValue()) {
                this.isOpen();
                return true;
            }
            return !this.isOpen() || this.allowSingleTest();
        }

        public boolean allowSingleTest() {
            long timeCircuitOpenedOrWasLastTested = this.circuitOpenedOrLastTestedTime.get();
            return this.circuitOpen.get() && System.currentTimeMillis() > timeCircuitOpenedOrWasLastTested + (long)this.properties.circuitBreakerSleepWindowInMilliseconds().get().intValue() && this.circuitOpenedOrLastTestedTime.compareAndSet(timeCircuitOpenedOrWasLastTested, System.currentTimeMillis());
        }

        @Override
        public boolean isOpen() {
            if (this.circuitOpen.get()) {
                return true;
            }
            if (this.metrics.getHealthCounts().getTotalRequests() < (long)this.properties.circuitBreakerRequestVolumeThreshold().get().intValue()) {
                return false;
            }
            if (this.metrics.getHealthCounts().getErrorPercentage() < this.properties.circuitBreakerErrorThresholdPercentage().get()) {
                return false;
            }
            if (this.circuitOpen.compareAndSet(false, true)) {
                this.circuitOpenedOrLastTestedTime.set(System.currentTimeMillis());
            }
            return true;
        }
    }

    @ThreadSafe
    public static class Factory {
        private static ConcurrentHashMap<String, HystrixCircuitBreaker> circuitBreakersByCommand = new ConcurrentHashMap();

        public static HystrixCircuitBreaker getInstance(HystrixCommandKey key, HystrixCommandGroupKey group, HystrixCommandProperties properties, HystrixCommandMetrics metrics) {
            HystrixCircuitBreaker previouslyCached = circuitBreakersByCommand.get(key.name());
            if (previouslyCached != null) {
                return previouslyCached;
            }
            HystrixCircuitBreaker cbForCommand = circuitBreakersByCommand.putIfAbsent(key.name(), new HystrixCircuitBreakerImpl(key, group, properties, metrics));
            if (cbForCommand == null) {
                return circuitBreakersByCommand.get(key.name());
            }
            return cbForCommand;
        }
    }
}

