/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextCallable;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType>
implements HystrixExecutable<ResponseType> {
    private static final Logger logger = LoggerFactory.getLogger(HystrixCollapser.class);
    private final CollapserTimer timer;
    private final HystrixCollapserKey collapserKey;
    private final HystrixCollapserProperties properties;
    private final Scope scope;
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private final HystrixRequestCache requestCache;
    private static ConcurrentHashMap<String, RequestCollapser<?, ?, ?>> globalScopedCollapsers = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>>> requestScopedCollapsers = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<? extends HystrixCollapser>, String> defaultNameCache = new ConcurrentHashMap();

    protected HystrixCollapser() {
        this(Setter.withCollapserKey(null).andScope(Scope.REQUEST));
    }

    protected HystrixCollapser(HystrixCollapserKey collapserKey) {
        this(Setter.withCollapserKey(collapserKey).andScope(Scope.REQUEST));
    }

    protected HystrixCollapser(Setter setter) {
        this(setter.collapserKey, setter.scope, new RealCollapserTimer(), setter.propertiesStrategy, setter.propertiesSetter, setter.concurrencyStrategy);
    }

    private HystrixCollapser(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixPropertiesStrategy propertiesFactory, HystrixCollapserProperties.Setter propertiesBuilder, HystrixConcurrencyStrategy concurrencyStrategy) {
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy(concurrencyStrategy);
        this.timer = timer;
        this.scope = scope;
        if (collapserKey == null || collapserKey.name().trim().equals("")) {
            String defaultKeyName = HystrixCollapser.getDefaultNameFromClass(this.getClass());
            this.collapserKey = HystrixCollapserKey.Factory.asKey(defaultKeyName);
        } else {
            this.collapserKey = collapserKey;
        }
        this.requestCache = HystrixRequestCache.getInstance(this.collapserKey, this.concurrencyStrategy);
        this.properties = HystrixPropertiesFactory.getCollapserProperties(propertiesFactory, this.collapserKey, propertiesBuilder);
    }

    public final HystrixCollapserKey getCollapserKey() {
        return this.collapserKey;
    }

    public final Scope getScope() {
        return this.scope;
    }

    public abstract RequestArgumentType getRequestArgument();

    protected abstract HystrixCommand<BatchReturnType> createCommand(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> var1);

    protected Collection<Collection<CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
        return Collections.singletonList(requests);
    }

    protected abstract void mapResponseToRequests(BatchReturnType var1, Collection<CollapsedRequest<ResponseType, RequestArgumentType>> var2);

    @Override
    public ResponseType execute() {
        try {
            return this.queue().get();
        }
        catch (Throwable e) {
            if (e instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e;
            }
            if (e.getCause() instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e.getCause();
            }
            String message = this.getClass().getSimpleName() + " HystrixCollapser failed while executing.";
            logger.debug(message, e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public Future<ResponseType> queue() {
        Future fromCache;
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> collapser = null;
        if (Scope.REQUEST == this.getScope()) {
            collapser = this.getCollapserForUserRequest();
        } else if (Scope.GLOBAL == this.getScope()) {
            collapser = this.getCollapserForGlobalScope();
        } else {
            logger.warn("Invalid Scope: " + (Object)((Object)this.getScope()) + "  Defaulting to REQUEST scope.");
            collapser = this.getCollapserForUserRequest();
        }
        if (this.properties.requestCachingEnabled().get().booleanValue() && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
            return fromCache;
        }
        Future<ResponseType> response = collapser.submitRequest(this.getRequestArgument());
        if (this.properties.requestCachingEnabled().get().booleanValue()) {
            this.requestCache.putIfAbsent(this.getCacheKey(), response);
        }
        return response;
    }

    private RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getCollapserForGlobalScope() {
        RequestCollapser<?, ?, ?> collapser = globalScopedCollapsers.get(this.getCollapserKey().name());
        if (collapser != null) {
            return collapser;
        }
        RequestCollapser newCollapser = new RequestCollapser(this, this.timer, this.concurrencyStrategy);
        RequestCollapser existing = globalScopedCollapsers.putIfAbsent(this.getCollapserKey().name(), newCollapser);
        if (existing == null) {
            return newCollapser;
        }
        newCollapser.shutdown();
        return existing;
    }

    private RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getCollapserForUserRequest() {
        return this.getRequestVariableForCommand(this.getCollapserKey()).get(this.concurrencyStrategy);
    }

    private HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>> getRequestVariableForCommand(HystrixCollapserKey key) {
        HystrixRequestVariableHolder requestVariable = requestScopedCollapsers.get(key.name());
        if (requestVariable == null) {
            RequestCollapserRequestVariable newCollapser = new RequestCollapserRequestVariable(this, this.timer, this.concurrencyStrategy);
            HystrixRequestVariableHolder existing = requestScopedCollapsers.putIfAbsent(key.name(), newCollapser);
            requestVariable = existing == null ? newCollapser : existing;
        }
        return requestVariable;
    }

    protected String getCacheKey() {
        return null;
    }

    private static String getDefaultNameFromClass(Class<? extends HystrixCollapser> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    public static class UnitTests {
        static AtomicInteger counter = new AtomicInteger();

        @Before
        public void init() {
            counter.set(0);
            requestScopedCollapsers.clear();
            globalScopedCollapsers.clear();
            HystrixRequestContext.initializeContext();
        }

        @After
        public void cleanup() {
            if (HystrixRequestContext.getContextForCurrentThread() != null) {
                HystrixRequestContext.getContextForCurrentThread().shutdown();
            }
        }

        @Test
        public void testTwoRequests() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testMultipleBatches() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testMaxRequestsInBatch() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1, 2, 10).queue();
            Future response2 = new TestRequestCollapser(timer, counter, 2, 2, 10).queue();
            Future response3 = new TestRequestCollapser(timer, counter, 3, 2, 10).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestsOverTime() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            timer.incrementTime(5);
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(8);
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(6);
            Future response4 = new TestRequestCollapser(timer, counter, 4).queue();
            timer.incrementTime(8);
            Future response5 = new TestRequestCollapser(timer, counter, 5).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((Object)"5", response5.get());
            System.out.println("number of executions: " + counter.get());
            Assert.assertEquals((long)3L, (long)counter.get());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testShardedRequests() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestShardedRequestCollapser(timer, counter, "1a").queue();
            Future response2 = new TestShardedRequestCollapser(timer, counter, "2b").queue();
            Future response3 = new TestShardedRequestCollapser(timer, counter, "3b").queue();
            Future response4 = new TestShardedRequestCollapser(timer, counter, "4a").queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1a", response1.get());
            Assert.assertEquals((Object)"2b", response2.get());
            Assert.assertEquals((Object)"3b", response3.get());
            Assert.assertEquals((Object)"4a", response4.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestScope() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, "1").queue();
            Future response2 = new TestRequestCollapser(timer, counter, "2").queue();
            requestScopedCollapsers.clear();
            Future response3 = new TestRequestCollapser(timer, counter, "3").queue();
            Future response4 = new TestRequestCollapser(timer, counter, "4").queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testGlobalScope() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestGloballyScopedRequestCollapser(timer, counter, "1").queue();
            Future response2 = new TestGloballyScopedRequestCollapser(timer, counter, "2").queue();
            requestScopedCollapsers.clear();
            Future response3 = new TestGloballyScopedRequestCollapser(timer, counter, "3").queue();
            Future response4 = new TestGloballyScopedRequestCollapser(timer, counter, "4").queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testErrorHandlingViaFutureException() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapserWithFaultyCreateCommand(timer, counter, "1").queue();
            Future response2 = new TestRequestCollapserWithFaultyCreateCommand(timer, counter, "2").queue();
            timer.incrementTime(10);
            try {
                response1.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            try {
                response2.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)0L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testErrorHandlingWhenMapToResponseFails() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapserWithFaultyMapToResponse(timer, counter, "1").queue();
            Future response2 = new TestRequestCollapserWithFaultyMapToResponse(timer, counter, "2").queue();
            timer.incrementTime(10);
            try {
                response1.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            try {
                response2.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestVariableLifecycle1() throws Exception {
            HystrixRequestContext requestContext = HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            timer.incrementTime(5);
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(8);
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(6);
            Future response4 = new TestRequestCollapser(timer, counter, 4).queue();
            timer.incrementTime(8);
            Future response5 = new TestRequestCollapser(timer, counter, 5).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((Object)"5", response5.get());
            for (TestCollapserTimer.ATask t : timer.tasks) {
                Assert.assertEquals((long)3L, (long)t.task.count.get());
            }
            System.out.println("timer.tasks.size() A: " + timer.tasks.size());
            System.out.println("tasks in test: " + timer.tasks);
            requestContext.shutdown();
            System.out.println("timer.tasks.size() B: " + timer.tasks.size());
            HystrixRequestVariableHolder rv = (HystrixRequestVariableHolder)requestScopedCollapsers.get(new TestRequestCollapser(timer, counter, 1).getCollapserKey().name());
            Assert.assertNotNull((Object)rv);
            Assert.assertEquals((long)0L, (long)timer.tasks.size());
        }

        @Test
        public void testRequestVariableLifecycle2() throws Exception {
            HystrixRequestContext requestContext = HystrixRequestContext.initializeContext();
            final TestCollapserTimer timer = new TestCollapserTimer();
            final ConcurrentLinkedQueue responses = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue<Thread> threads = new ConcurrentLinkedQueue<Thread>();
            for (int t = 0; t < 5; ++t) {
                Thread th = new Thread(new HystrixContextRunnable(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 100; ++i) {
                            responses.add(new TestRequestCollapser(timer, counter, 1).queue());
                        }
                    }
                }));
                threads.add(th);
                th.start();
            }
            for (Thread th : threads) {
                th.join();
            }
            Assert.assertEquals((long)500L, (long)responses.size());
            for (Future f : responses) {
                Assert.assertFalse((boolean)f.isDone());
            }
            timer.incrementTime(5);
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(8);
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(6);
            Future response4 = new TestRequestCollapser(timer, counter, 4).queue();
            timer.incrementTime(8);
            Future response5 = new TestRequestCollapser(timer, counter, 5).queue();
            timer.incrementTime(10);
            for (Future f : responses) {
                Assert.assertEquals((Object)"1", f.get());
            }
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((Object)"5", response5.get());
            for (TestCollapserTimer.ATask t : timer.tasks) {
                Assert.assertEquals((long)3L, (long)t.task.count.get());
            }
            requestContext.shutdown();
            HystrixRequestVariableHolder rv = (HystrixRequestVariableHolder)requestScopedCollapsers.get(new TestRequestCollapser(timer, counter, 1).getCollapserKey().name());
            Assert.assertNotNull((Object)rv);
            Assert.assertEquals((long)0L, (long)timer.tasks.size());
        }

        @Test
        public void testRequestCache1() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f3 = command1.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCache2() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", true);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f3 = command1.queue();
            Future f4 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
                Assert.assertEquals((Object)"B", f4.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCache3() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", true);
            SuccessfulCacheableCollapsedCommand command3 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", true);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"B", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f4 = command1.queue();
            Future f5 = command2.queue();
            Future f6 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f4.get());
                Assert.assertEquals((Object)"B", f5.get());
                Assert.assertEquals((Object)"B", f6.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testNoRequestCache3() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", false);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", false);
            SuccessfulCacheableCollapsedCommand command3 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", false);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"B", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f4 = command1.queue();
            Future f5 = command2.queue();
            Future f6 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f4.get());
                Assert.assertEquals((Object)"B", f5.get());
                Assert.assertEquals((Object)"B", f6.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand commandA = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[2])[0];
            Assert.assertEquals((long)2L, (long)commandA.getExecutionEvents().size());
            Assert.assertTrue((boolean)commandA.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)commandA.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
            HystrixCommand commandB = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[2])[1];
            Assert.assertEquals((long)2L, (long)commandB.getExecutionEvents().size());
            Assert.assertTrue((boolean)commandB.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)commandB.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCacheWithException() {
            HystrixRequestContext.initializeContext();
            ConcurrentLinkedQueue<HystrixCommand<List<String>>> commands = new ConcurrentLinkedQueue<HystrixCommand<List<String>>>();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, null, true, commands);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, null, true, commands);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.FAILURE));
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
            SuccessfulCacheableCollapsedCommand command3 = new SuccessfulCacheableCollapsedCommand(timer, counter, null, true, commands);
            Future f3 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.FAILURE));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCacheWithTimeout() {
            HystrixRequestContext.initializeContext();
            ConcurrentLinkedQueue<HystrixCommand<List<String>>> commands = new ConcurrentLinkedQueue<HystrixCommand<List<String>>>();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "TIMEOUT", true, commands);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "TIMEOUT", true, commands);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.TIMEOUT));
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
            Future f3 = command1.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        private static HystrixCollapserKey collapserKeyFromString(final Object o) {
            return new HystrixCollapserKey(){

                @Override
                public String name() {
                    return String.valueOf(o);
                }
            };
        }

        private static class TestTimerListener
        implements HystrixTimer.TimerListener {
            private final HystrixTimer.TimerListener actualListener;
            private final AtomicInteger count = new AtomicInteger();

            public TestTimerListener(HystrixTimer.TimerListener actual) {
                this.actualListener = actual;
            }

            @Override
            public void tick() {
                this.count.incrementAndGet();
                this.actualListener.tick();
            }

            @Override
            public int getIntervalTimeInMilliseconds() {
                return 10;
            }
        }

        private static class TestCollapserTimer
        implements CollapserTimer {
            private final ConcurrentLinkedQueue<ATask> tasks = new ConcurrentLinkedQueue();

            private TestCollapserTimer() {
            }

            @Override
            public Reference<HystrixTimer.TimerListener> addListener(final HystrixTimer.TimerListener collapseTask) {
                System.out.println("add listener: " + collapseTask);
                this.tasks.add(new ATask(new TestTimerListener(collapseTask)));
                return new SoftReference<HystrixTimer.TimerListener>(collapseTask){

                    @Override
                    public void clear() {
                        System.out.println("tasks: " + TestCollapserTimer.this.tasks);
                        System.out.println("**** clear TimerListener: tasks.size => " + TestCollapserTimer.this.tasks.size());
                        for (ATask t : TestCollapserTimer.this.tasks) {
                            if (!t.task.actualListener.equals(collapseTask)) continue;
                            TestCollapserTimer.this.tasks.remove(t);
                        }
                    }
                };
            }

            public synchronized void incrementTime(int timeInMilliseconds) {
                for (ATask t : this.tasks) {
                    t.incrementTime(timeInMilliseconds);
                }
            }

            private static class ATask {
                final TestTimerListener task;
                final int delay = 10;
                volatile int time = 0;
                volatile int executionCount = 0;

                private ATask(TestTimerListener task) {
                    this.task = task;
                }

                public synchronized void incrementTime(int timeInMilliseconds) {
                    this.time += timeInMilliseconds;
                    if (this.task != null) {
                        if (this.executionCount == 0) {
                            System.out.println("ExecutionCount 0 => Time: " + this.time + " Delay: " + 10);
                            if (this.time >= 10) {
                                this.executeTask();
                            }
                        } else {
                            System.out.println("ExecutionCount 1+ => Time: " + this.time + " Delay: " + 10);
                            if (this.time >= 10) {
                                this.executeTask();
                            }
                        }
                    }
                }

                private synchronized void executeTask() {
                    System.out.println("Executing task ...");
                    this.task.tick();
                    this.time = 0;
                    ++this.executionCount;
                    System.out.println("executionCount: " + this.executionCount);
                }
            }
        }

        private static class SuccessfulCacheableCollapsedCommand
        extends TestRequestCollapser {
            private final boolean cacheEnabled;

            public SuccessfulCacheableCollapsedCommand(TestCollapserTimer timer, AtomicInteger counter, String value, boolean cacheEnabled) {
                super(timer, counter, value);
                this.cacheEnabled = cacheEnabled;
            }

            public SuccessfulCacheableCollapsedCommand(TestCollapserTimer timer, AtomicInteger counter, String value, boolean cacheEnabled, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                super(timer, counter, value, executionLog);
                this.cacheEnabled = cacheEnabled;
            }

            @Override
            public String getCacheKey() {
                if (this.cacheEnabled) {
                    return "aCacheKey_" + ((TestRequestCollapser)this).value;
                }
                return null;
            }
        }

        private static class TestCollapserCommand
        extends HystrixCommand.UnitTest.TestHystrixCommand<List<String>> {
            private final Collection<CollapsedRequest<String, String>> requests;

            TestCollapserCommand(Collection<CollapsedRequest<String, String>> requests) {
                super(TestCollapserCommand.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(50)));
                this.requests = requests;
            }

            @Override
            protected List<String> run() {
                ArrayList<String> response = new ArrayList<String>();
                for (CollapsedRequest<String, String> request : this.requests) {
                    if (request.getArgument() == null) {
                        throw new NullPointerException("Simulated Error");
                    }
                    if (request.getArgument() == "TIMEOUT") {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    response.add(request.getArgument());
                }
                return response;
            }
        }

        private static class TestRequestCollapserWithFaultyMapToResponse
        extends TestRequestCollapser {
            public TestRequestCollapserWithFaultyMapToResponse(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(timer, counter, value);
            }

            @Override
            public void mapResponseToRequests(List<String> batchResponse, Collection<CollapsedRequest<String, String>> requests) {
                throw new NullPointerException("batchResponse was null and we blew up");
            }
        }

        private static class TestRequestCollapserWithFaultyCreateCommand
        extends TestRequestCollapser {
            public TestRequestCollapserWithFaultyCreateCommand(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(timer, counter, value);
            }

            @Override
            public HystrixCommand<List<String>> createCommand(Collection<CollapsedRequest<String, String>> requests) {
                throw new RuntimeException("some failure");
            }
        }

        private static class TestGloballyScopedRequestCollapser
        extends TestRequestCollapser {
            public TestGloballyScopedRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(Scope.GLOBAL, timer, counter, value);
            }
        }

        private static class TestShardedRequestCollapser
        extends TestRequestCollapser {
            public TestShardedRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(timer, counter, value);
            }

            @Override
            protected Collection<Collection<CollapsedRequest<String, String>>> shardRequests(Collection<CollapsedRequest<String, String>> requests) {
                ArrayList<CollapsedRequest<String, String>> typeA = new ArrayList<CollapsedRequest<String, String>>();
                ArrayList<CollapsedRequest<String, String>> typeB = new ArrayList<CollapsedRequest<String, String>>();
                for (CollapsedRequest<String, String> request : requests) {
                    if (request.getArgument().endsWith("a")) {
                        typeA.add(request);
                        continue;
                    }
                    if (!request.getArgument().endsWith("b")) continue;
                    typeB.add(request);
                }
                ArrayList<Collection<CollapsedRequest<String, String>>> shards = new ArrayList<Collection<CollapsedRequest<String, String>>>();
                shards.add(typeA);
                shards.add(typeB);
                return shards;
            }
        }

        private static class TestRequestCollapser
        extends HystrixCollapser<List<String>, String, String> {
            private final AtomicInteger count;
            private final String value;
            private ConcurrentLinkedQueue<HystrixCommand<List<String>>> commandsExecuted;

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, int value) {
                this(timer, counter, String.valueOf(value));
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value) {
                this(timer, counter, value, 10000, 10);
            }

            public TestRequestCollapser(Scope scope, TestCollapserTimer timer, AtomicInteger counter, String value) {
                this(scope, timer, counter, value, 10000, 10);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                this(timer, counter, value, 10000, 10, executionLog);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, int value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds) {
                this(timer, counter, String.valueOf(value), defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds) {
                this(timer, counter, value, defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds, null);
            }

            public TestRequestCollapser(Scope scope, TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds) {
                this(scope, timer, counter, value, defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds, null);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                this(Scope.REQUEST, timer, counter, value, defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds, executionLog);
            }

            public TestRequestCollapser(Scope scope, TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                super(UnitTests.collapserKeyFromString(timer), scope, timer, null, HystrixCollapserProperties.Setter().withMaxRequestsInBatch(defaultMaxRequestsInBatch).withTimerDelayInMilliseconds(defaultTimerDelayInMilliseconds), null);
                this.count = counter;
                this.value = value;
                this.commandsExecuted = executionLog;
            }

            @Override
            public String getRequestArgument() {
                return this.value;
            }

            @Override
            public HystrixCommand<List<String>> createCommand(Collection<CollapsedRequest<String, String>> requests) {
                TestCollapserCommand command = new TestCollapserCommand(requests);
                if (this.commandsExecuted != null) {
                    this.commandsExecuted.add(command);
                }
                return command;
            }

            @Override
            public void mapResponseToRequests(List<String> batchResponse, Collection<CollapsedRequest<String, String>> requests) {
                System.out.println("increment count: " + this.count.incrementAndGet());
                if (batchResponse.size() != requests.size()) {
                    throw new RuntimeException("lists don't match in size");
                }
                int i = 0;
                for (CollapsedRequest<String, String> request : requests) {
                    request.setResponse(batchResponse.get(i++));
                }
            }
        }
    }

    @NotThreadSafe
    public static class Setter {
        private final HystrixCollapserKey collapserKey;
        private Scope scope;
        private HystrixPropertiesStrategy propertiesStrategy;
        private HystrixCollapserProperties.Setter propertiesSetter;
        private HystrixConcurrencyStrategy concurrencyStrategy;

        private Setter(HystrixCollapserKey collapserKey) {
            this.collapserKey = collapserKey;
        }

        public static Setter withCollapserKey(HystrixCollapserKey collapserKey) {
            return new Setter(collapserKey);
        }

        public Setter andScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Setter andPropertiesStrategy(HystrixPropertiesStrategy propertiesStrategy) {
            this.propertiesStrategy = propertiesStrategy;
            return this;
        }

        public Setter andCollapserPropertiesDefaults(HystrixCollapserProperties.Setter propertiesSetter) {
            this.propertiesSetter = propertiesSetter;
            return this;
        }

        public Setter andConcurrencyStrategy(HystrixConcurrencyStrategy concurrencyStrategy) {
            this.concurrencyStrategy = concurrencyStrategy;
            return this;
        }
    }

    private static class CollapsedRequestFutureImpl<T, R>
    implements CollapsedRequest<T, R>,
    Future<T> {
        private final R argument;
        private AtomicReference<ResponseHolder<T>> responseReference = new AtomicReference();
        private final CountDownLatch batchReceived = new CountDownLatch(1);
        private final CountDownLatch responseReceived = new CountDownLatch(1);
        private volatile Future<?> batchFuture;

        public CollapsedRequestFutureImpl(R arg) {
            this.argument = arg;
        }

        private void setBatchFuture(Future<?> batchFuture) {
            this.batchFuture = batchFuture;
            this.batchReceived.countDown();
        }

        @Override
        public R getArgument() {
            return this.argument;
        }

        @Override
        public void setResponse(T response) {
            boolean didSet = this.responseReference.compareAndSet(null, new ResponseHolder<T>(response, null));
            if (!didSet || this.responseReference.get().getException() != null) {
                throw new IllegalStateException("Response or Exception has already been set.");
            }
            this.responseReceived.countDown();
        }

        @Override
        public void setException(Exception e) {
            boolean didSet = this.responseReference.compareAndSet(null, new ResponseHolder<Object>(null, e));
            if (!didSet || this.responseReference.get().getResponse() != null) {
                throw new IllegalStateException("Response or Exception has already been set.");
            }
            this.responseReceived.countDown();
            this.batchReceived.countDown();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new IllegalStateException("We don't support cancelling tasks submitted for batch execution.");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.responseReference.get() != null;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.get(15L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new ExecutionException("Timeout while waiting.", e);
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.batchReceived.await(timeout, unit);
            if (this.batchFuture != null) {
                this.batchFuture.get();
            }
            this.responseReceived.await(timeout, unit);
            if (this.responseReference.get() == null) {
                logger.error("TimedOut waiting on responseReceived: " + this.responseReceived.getCount() + " batchReceived: " + this.batchReceived.getCount() + " batchFuture: " + this.batchFuture);
                throw new ExecutionException("No response or exception set before returning from Future.get", new NullPointerException());
            }
            if (this.responseReference.get().getException() != null) {
                throw new ExecutionException(this.responseReference.get().getException());
            }
            return this.responseReference.get().getResponse();
        }

        private static class ResponseHolder<T> {
            private final T response;
            private final Exception e;

            public ResponseHolder(T response, Exception e) {
                this.response = response;
                this.e = e;
            }

            public T getResponse() {
                return this.response;
            }

            public Exception getException() {
                return this.e;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.e == null ? 0 : this.e.hashCode());
                result = 31 * result + (this.response == null ? 0 : this.response.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ResponseHolder other = (ResponseHolder)obj;
                if (this.e == null ? other.e != null : !this.e.equals(other.e)) {
                    return false;
                }
                return !(this.response == null ? other.response != null : !this.response.equals(other.response));
            }
        }
    }

    public static interface CollapsedRequest<ResponseType, RequestArgumentType> {
        public RequestArgumentType getArgument();

        public void setResponse(ResponseType var1);

        public void setException(Exception var1);
    }

    private static class RealCollapserTimer
    implements CollapserTimer {
        private static final HystrixTimer timer = HystrixTimer.getInstance();

        private RealCollapserTimer() {
        }

        @Override
        public Reference<HystrixTimer.TimerListener> addListener(HystrixTimer.TimerListener collapseTask) {
            return timer.addTimerListener(collapseTask);
        }
    }

    private static interface CollapserTimer {
        public Reference<HystrixTimer.TimerListener> addListener(HystrixTimer.TimerListener var1);
    }

    @ThreadSafe
    private static class RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> {
        private final HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser;
        private final LinkedBlockingQueue<CollapsedRequest<ResponseType, RequestArgumentType>> requests;
        private final Reference<HystrixTimer.TimerListener> timerListenerReference;
        private final HystrixCollapserProperties properties;
        private final HystrixConcurrencyStrategy concurrencyStrategy;

        public RequestCollapser(HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser, CollapserTimer timer, HystrixConcurrencyStrategy concurrencyStrategy) {
            this.concurrencyStrategy = concurrencyStrategy;
            this.commandCollapser = commandCollapser;
            this.properties = ((HystrixCollapser)commandCollapser).properties;
            this.requests = new LinkedBlockingQueue(this.properties.maxRequestsInBatch().get());
            this.timerListenerReference = timer.addListener(new CollapsedTask());
        }

        private void executeBatch(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> batch) {
            try {
                Collection<Collection<CollapsedRequest<ResponseType, RequestArgumentType>>> shards = this.commandCollapser.shardRequests(batch);
                for (Collection<CollapsedRequest<ResponseType, RequestArgumentType>> shardRequests : shards) {
                    try {
                        HystrixCommand<BatchReturnType> command = this.commandCollapser.createCommand(shardRequests);
                        command.markAsCollapsedCommand(shardRequests.size());
                        BatchFutureWrapper batchFuture = new BatchFutureWrapper(command.queue(), this.commandCollapser, shardRequests);
                        for (CollapsedRequest<ResponseType, RequestArgumentType> request : shardRequests) {
                            ((CollapsedRequestFutureImpl)request).setBatchFuture(batchFuture);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception while creating and queueing command with batch.", (Throwable)e);
                        for (CollapsedRequest<ResponseType, RequestArgumentType> request : shardRequests) {
                            ((CollapsedRequestFutureImpl)request).setException(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception while sharding requests.", (Throwable)e);
                for (CollapsedRequest<ResponseType, RequestArgumentType> request : batch) {
                    ((CollapsedRequestFutureImpl)request).setException(e);
                }
            }
        }

        public Future<ResponseType> submitRequest(RequestArgumentType arg) {
            CollapsedRequestFutureImpl request = new CollapsedRequestFutureImpl(arg);
            while (!this.requests.offer(request)) {
                this.executeRequestsFromQueue();
            }
            return request;
        }

        private void executeRequestsFromQueue() {
            ArrayList requestsForExecution = new ArrayList(this.requests.size());
            this.requests.drainTo(requestsForExecution);
            if (requestsForExecution.size() > 0) {
                this.executeBatch(Collections.unmodifiableList(requestsForExecution));
            }
        }

        public void shutdown() {
            if (this.requests.size() > 0) {
                try {
                    logger.warn("Requests still exist in queue but will not be executed due to RequestCollapser shutdown: " + this.requests.size(), (Throwable)new IllegalStateException());
                    for (CollapsedRequest<ResponseType, RequestArgumentType> request : this.requests) {
                        ((CollapsedRequestFutureImpl)request).setException(new IllegalStateException("Requests not executed before shutdown."));
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to setException on CollapsedRequestFutureImpl instances.", (Throwable)e);
                }
            }
            this.timerListenerReference.clear();
        }

        private class BatchFutureWrapper
        implements Future<BatchReturnType> {
            private final Future<BatchReturnType> actualFuture;
            private final HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType> command;
            private final Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests;
            private Lock mapResponseToRequestsLock = new ReentrantLock();
            @GuardedBy(value="mapResponseToRequestsLock")
            private volatile boolean mapResponseToRequestsPerformed = false;

            private BatchFutureWrapper(Future<BatchReturnType> actualFuture, HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType> command, Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                this.actualFuture = actualFuture;
                this.command = command;
                this.requests = requests;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return this.actualFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return this.actualFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return this.actualFuture.isDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BatchReturnType get() throws InterruptedException, ExecutionException {
                block7: {
                    if (!this.mapResponseToRequestsPerformed && this.mapResponseToRequestsLock.tryLock()) {
                        try {
                            if (this.mapResponseToRequestsPerformed) break block7;
                            try {
                                this.command.mapResponseToRequests(this.actualFuture.get(), this.requests);
                            }
                            catch (Exception e) {
                                logger.error("Exception mapping responses to requests.", (Throwable)e);
                                for (CollapsedRequest request : this.requests) {
                                    ((CollapsedRequestFutureImpl)request).setException(e);
                                }
                            }
                            this.mapResponseToRequestsPerformed = true;
                        }
                        finally {
                            this.mapResponseToRequestsLock.unlock();
                        }
                    }
                }
                return this.actualFuture.get();
            }

            @Override
            public BatchReturnType get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                throw new RuntimeException("This is an internal class that should ONLY have the 'get' method accessed from CollapsedRequestFutureImpl in order to block and 'push' work onto the calling thread.");
            }
        }

        private class CollapsedTask
        implements HystrixTimer.TimerListener {
            final Callable<Void> callableWithContextOfParent;

            CollapsedTask() {
                this.callableWithContextOfParent = RequestCollapser.this.concurrencyStrategy.wrapCallable(new HystrixContextCallable<Void>(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            RequestCollapser.this.executeRequestsFromQueue();
                        }
                        catch (Throwable t) {
                            logger.error("Error occurred trying to executeRequestsFromQueue.", t);
                        }
                        return null;
                    }
                }));
            }

            @Override
            public void tick() {
                if (RequestCollapser.this.requests.size() > 0) {
                    try {
                        this.callableWithContextOfParent.call();
                    }
                    catch (Exception e) {
                        logger.error("Error occurred trying to execute callable inside CollapsedTask from Timer.", (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public int getIntervalTimeInMilliseconds() {
                return RequestCollapser.this.properties.timerDelayInMilliseconds().get();
            }
        }
    }

    private static final class RequestCollapserRequestVariable<BatchReturnType, ResponseType, RequestArgumentType>
    extends HystrixRequestVariableHolder<RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>> {
        private RequestCollapserRequestVariable(HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser, final CollapserTimer timer, final HystrixConcurrencyStrategy concurrencyStrategy) {
            super(new HystrixRequestVariableLifecycle<RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>>(){

                @Override
                public RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> initialValue() {
                    return new RequestCollapser(HystrixCollapser.this, timer, concurrencyStrategy);
                }

                @Override
                public void shutdown(RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> currentCollapser) {
                    if (currentCollapser != null) {
                        currentCollapser.shutdown();
                    }
                }
            });
        }
    }

    public static enum Scope {
        REQUEST,
        GLOBAL;

    }
}

