/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedArchaiusProperty;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HystrixCommandProperties {
    private static final Logger logger = LoggerFactory.getLogger(HystrixCommandProperties.class);
    private static final Integer default_metricsRollingStatisticalWindow = 10000;
    private static final Integer default_metricsRollingStatisticalWindowBuckets = 10;
    private static final Integer default_circuitBreakerRequestVolumeThreshold = 20;
    private static final Integer default_circuitBreakerSleepWindowInMilliseconds = 5000;
    private static final Integer default_circuitBreakerErrorThresholdPercentage = 50;
    private static final Boolean default_circuitBreakerForceOpen = false;
    private static final Boolean default_circuitBreakerForceClosed = false;
    private static final Integer default_executionIsolationThreadTimeoutInMilliseconds = 1000;
    private static final ExecutionIsolationStrategy default_executionIsolationStrategy = ExecutionIsolationStrategy.THREAD;
    private static final Boolean default_executionIsolationThreadInterruptOnTimeout = true;
    private static final Boolean default_metricsRollingPercentileEnabled = true;
    private static final Boolean default_requestCacheEnabled = true;
    private static final Integer default_fallbackIsolationSemaphoreMaxConcurrentRequests = 10;
    private static final Integer default_executionIsolationSemaphoreMaxConcurrentRequests = 10;
    private static final Boolean default_requestLogEnabled = true;
    private static final Boolean default_circuitBreakerEnabled = true;
    private static final Integer default_metricsRollingPercentileWindow = 60000;
    private static final Integer default_metricsRollingPercentileWindowBuckets = 6;
    private static final Integer default_metricsRollingPercentileBucketSize = 100;
    private static final Integer default_metricsHealthSnapshotIntervalInMilliseconds = 500;
    private final HystrixCommandKey key;
    private final HystrixProperty<Integer> circuitBreakerRequestVolumeThreshold;
    private final HystrixProperty<Integer> circuitBreakerSleepWindowInMilliseconds;
    private final HystrixProperty<Boolean> circuitBreakerEnabled;
    private final HystrixProperty<Integer> circuitBreakerErrorThresholdPercentage;
    private final HystrixProperty<Boolean> circuitBreakerForceOpen;
    private final HystrixProperty<Boolean> circuitBreakerForceClosed;
    private final HystrixProperty<ExecutionIsolationStrategy> executionIsolationStrategy;
    private final HystrixProperty<Integer> executionIsolationThreadTimeoutInMilliseconds;
    private final HystrixProperty<String> executionIsolationThreadPoolKeyOverride;
    private final HystrixProperty<Integer> executionIsolationSemaphoreMaxConcurrentRequests;
    private final HystrixProperty<Integer> fallbackIsolationSemaphoreMaxConcurrentRequests;
    private final HystrixProperty<Boolean> executionIsolationThreadInterruptOnTimeout;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets;
    private final HystrixProperty<Boolean> metricsRollingPercentileEnabled;
    private final HystrixProperty<Integer> metricsRollingPercentileWindow;
    private final HystrixProperty<Integer> metricsRollingPercentileWindowBuckets;
    private final HystrixProperty<Integer> metricsRollingPercentileBucketSize;
    private final HystrixProperty<Integer> metricsHealthSnapshotIntervalInMilliseconds;
    private final HystrixProperty<Boolean> requestLogEnabled;
    private final HystrixProperty<Boolean> requestCacheEnabled;

    protected HystrixCommandProperties(HystrixCommandKey key) {
        this(key, new Setter(), "hystrix");
    }

    protected HystrixCommandProperties(HystrixCommandKey key, Setter builder) {
        this(key, builder, "hystrix");
    }

    protected HystrixCommandProperties(HystrixCommandKey key, Setter builder, String propertyPrefix) {
        this.key = key;
        this.circuitBreakerEnabled = HystrixCommandProperties.getProperty(propertyPrefix, key, "circuitBreaker.enabled", builder.getCircuitBreakerEnabled(), default_circuitBreakerEnabled);
        this.circuitBreakerRequestVolumeThreshold = HystrixCommandProperties.getProperty(propertyPrefix, key, "circuitBreaker.requestVolumeThreshold", builder.getCircuitBreakerRequestVolumeThreshold(), default_circuitBreakerRequestVolumeThreshold);
        this.circuitBreakerSleepWindowInMilliseconds = HystrixCommandProperties.getProperty(propertyPrefix, key, "circuitBreaker.sleepWindowInMilliseconds", builder.getCircuitBreakerSleepWindowInMilliseconds(), default_circuitBreakerSleepWindowInMilliseconds);
        this.circuitBreakerErrorThresholdPercentage = HystrixCommandProperties.getProperty(propertyPrefix, key, "circuitBreaker.errorThresholdPercentage", builder.getCircuitBreakerErrorThresholdPercentage(), default_circuitBreakerErrorThresholdPercentage);
        this.circuitBreakerForceOpen = HystrixCommandProperties.getProperty(propertyPrefix, key, "circuitBreaker.forceOpen", builder.getCircuitBreakerForceOpen(), default_circuitBreakerForceOpen);
        this.circuitBreakerForceClosed = HystrixCommandProperties.getProperty(propertyPrefix, key, "circuitBreaker.forceClosed", builder.getCircuitBreakerForceClosed(), default_circuitBreakerForceClosed);
        this.executionIsolationStrategy = HystrixCommandProperties.getProperty(propertyPrefix, key, "execution.isolation.strategy", builder.getExecutionIsolationStrategy(), default_executionIsolationStrategy);
        this.executionIsolationThreadTimeoutInMilliseconds = HystrixCommandProperties.getProperty(propertyPrefix, key, "execution.isolation.thread.timeoutInMilliseconds", builder.getExecutionIsolationThreadTimeoutInMilliseconds(), default_executionIsolationThreadTimeoutInMilliseconds);
        this.executionIsolationThreadInterruptOnTimeout = HystrixCommandProperties.getProperty(propertyPrefix, key, "execution.isolation.thread.interruptOnTimeout", builder.getExecutionIsolationThreadInterruptOnTimeout(), default_executionIsolationThreadInterruptOnTimeout);
        this.executionIsolationSemaphoreMaxConcurrentRequests = HystrixCommandProperties.getProperty(propertyPrefix, key, "execution.isolation.semaphore.maxConcurrentRequests", builder.getExecutionIsolationSemaphoreMaxConcurrentRequests(), default_executionIsolationSemaphoreMaxConcurrentRequests);
        this.fallbackIsolationSemaphoreMaxConcurrentRequests = HystrixCommandProperties.getProperty(propertyPrefix, key, "fallback.isolation.semaphore.maxConcurrentRequests", builder.getFallbackIsolationSemaphoreMaxConcurrentRequests(), default_fallbackIsolationSemaphoreMaxConcurrentRequests);
        this.metricsRollingStatisticalWindowInMilliseconds = HystrixCommandProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.timeInMilliseconds", builder.getMetricsRollingStatisticalWindowInMilliseconds(), default_metricsRollingStatisticalWindow);
        this.metricsRollingStatisticalWindowBuckets = HystrixCommandProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.numBuckets", builder.getMetricsRollingStatisticalWindowBuckets(), default_metricsRollingStatisticalWindowBuckets);
        this.metricsRollingPercentileEnabled = HystrixCommandProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.enabled", builder.getMetricsRollingPercentileEnabled(), default_metricsRollingPercentileEnabled);
        this.metricsRollingPercentileWindow = HystrixCommandProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.timeInMilliseconds", builder.getMetricsRollingPercentileWindowInMilliseconds(), default_metricsRollingPercentileWindow);
        this.metricsRollingPercentileWindowBuckets = HystrixCommandProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.numBuckets", builder.getMetricsRollingPercentileWindowBuckets(), default_metricsRollingPercentileWindowBuckets);
        this.metricsRollingPercentileBucketSize = HystrixCommandProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.bucketSize", builder.getMetricsRollingPercentileBucketSize(), default_metricsRollingPercentileBucketSize);
        this.metricsHealthSnapshotIntervalInMilliseconds = HystrixCommandProperties.getProperty(propertyPrefix, key, "metrics.healthSnapshot.intervalInMilliseconds", builder.getMetricsHealthSnapshotIntervalInMilliseconds(), default_metricsHealthSnapshotIntervalInMilliseconds);
        this.requestCacheEnabled = HystrixCommandProperties.getProperty(propertyPrefix, key, "requestCache.enabled", builder.getRequestCacheEnabled(), default_requestCacheEnabled);
        this.requestLogEnabled = HystrixCommandProperties.getProperty(propertyPrefix, key, "requestLog.enabled", builder.getRequestLogEnabled(), default_requestLogEnabled);
        this.executionIsolationThreadPoolKeyOverride = HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty(propertyPrefix + ".command." + key.name() + ".threadPoolKeyOverride", null));
    }

    public HystrixProperty<Boolean> circuitBreakerEnabled() {
        return this.circuitBreakerEnabled;
    }

    public HystrixProperty<Integer> circuitBreakerErrorThresholdPercentage() {
        return this.circuitBreakerErrorThresholdPercentage;
    }

    public HystrixProperty<Boolean> circuitBreakerForceClosed() {
        return this.circuitBreakerForceClosed;
    }

    public HystrixProperty<Boolean> circuitBreakerForceOpen() {
        return this.circuitBreakerForceOpen;
    }

    public HystrixProperty<Integer> circuitBreakerRequestVolumeThreshold() {
        return this.circuitBreakerRequestVolumeThreshold;
    }

    public HystrixProperty<Integer> circuitBreakerSleepWindowInMilliseconds() {
        return this.circuitBreakerSleepWindowInMilliseconds;
    }

    public HystrixProperty<Integer> executionIsolationSemaphoreMaxConcurrentRequests() {
        return this.executionIsolationSemaphoreMaxConcurrentRequests;
    }

    public HystrixProperty<ExecutionIsolationStrategy> executionIsolationStrategy() {
        return this.executionIsolationStrategy;
    }

    public HystrixProperty<Boolean> executionIsolationThreadInterruptOnTimeout() {
        return this.executionIsolationThreadInterruptOnTimeout;
    }

    public HystrixProperty<String> executionIsolationThreadPoolKeyOverride() {
        return this.executionIsolationThreadPoolKeyOverride;
    }

    public HystrixProperty<Integer> executionIsolationThreadTimeoutInMilliseconds() {
        return this.executionIsolationThreadTimeoutInMilliseconds;
    }

    public HystrixProperty<Integer> fallbackIsolationSemaphoreMaxConcurrentRequests() {
        return this.fallbackIsolationSemaphoreMaxConcurrentRequests;
    }

    public HystrixProperty<Integer> metricsHealthSnapshotIntervalInMilliseconds() {
        return this.metricsHealthSnapshotIntervalInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingPercentileBucketSize() {
        return this.metricsRollingPercentileBucketSize;
    }

    public HystrixProperty<Boolean> metricsRollingPercentileEnabled() {
        return this.metricsRollingPercentileEnabled;
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindow() {
        return this.metricsRollingPercentileWindow;
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindowBuckets() {
        return this.metricsRollingPercentileWindowBuckets;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
        return this.metricsRollingStatisticalWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
        return this.metricsRollingStatisticalWindowBuckets;
    }

    public HystrixProperty<Boolean> requestCacheEnabled() {
        return this.requestCacheEnabled;
    }

    public HystrixProperty<Boolean> requestLogEnabled() {
        return this.requestLogEnabled;
    }

    private static HystrixProperty<Boolean> getProperty(String propertyPrefix, HystrixCommandKey key, String instanceProperty, Boolean builderOverrideValue, Boolean defaultValue) {
        return HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.BooleanProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicBooleanProperty(propertyPrefix + ".command." + key.name() + "." + instanceProperty, builderOverrideValue), new HystrixPropertiesChainedArchaiusProperty.DynamicBooleanProperty(propertyPrefix + ".command.default." + instanceProperty, defaultValue)));
    }

    private static HystrixProperty<Integer> getProperty(String propertyPrefix, HystrixCommandKey key, String instanceProperty, Integer builderOverrideValue, Integer defaultValue) {
        return HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.IntegerProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicIntegerProperty(propertyPrefix + ".command." + key.name() + "." + instanceProperty, builderOverrideValue), new HystrixPropertiesChainedArchaiusProperty.DynamicIntegerProperty(propertyPrefix + ".command.default." + instanceProperty, defaultValue)));
    }

    private static HystrixProperty<String> getProperty(String propertyPrefix, HystrixCommandKey key, String instanceProperty, String builderOverrideValue, String defaultValue) {
        return HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.StringProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty(propertyPrefix + ".command." + key.name() + "." + instanceProperty, builderOverrideValue), new HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty(propertyPrefix + ".command.default." + instanceProperty, defaultValue)));
    }

    private static HystrixProperty<ExecutionIsolationStrategy> getProperty(String propertyPrefix, HystrixCommandKey key, String instanceProperty, ExecutionIsolationStrategy builderOverrideValue, ExecutionIsolationStrategy defaultValue) {
        return new ExecutionIsolationStrategyHystrixProperty(builderOverrideValue, key, propertyPrefix, defaultValue, instanceProperty);
    }

    public static Setter Setter() {
        return new Setter();
    }

    public static class UnitTest {
        @After
        public void cleanup() {
            ConfigurationManager.getConfigInstance().clear();
        }

        @Test
        public void testBooleanBuilderOverride1() {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withCircuitBreakerForceClosed(true), "unitTestPrefix");
            Assert.assertEquals((Object)true, (Object)properties.circuitBreakerForceClosed().get());
        }

        @Test
        public void testBooleanBuilderOverride2() {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withCircuitBreakerForceClosed(false), "unitTestPrefix");
            Assert.assertEquals((Object)false, (Object)properties.circuitBreakerForceClosed().get());
        }

        @Test
        public void testBooleanCodeDefault() {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter(), "unitTestPrefix");
            Assert.assertEquals((Object)default_circuitBreakerForceClosed, (Object)properties.circuitBreakerForceClosed().get());
        }

        @Test
        public void testBooleanGlobalDynamicOverrideOfCodeDefault() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter(), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed", (Object)true);
            Assert.assertEquals((Object)true, (Object)properties.circuitBreakerForceClosed().get());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed");
        }

        @Test
        public void testBooleanInstanceBuilderOverrideOfGlobalDynamicOverride1() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withCircuitBreakerForceClosed(true), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed", (Object)false);
            Assert.assertEquals((Object)true, (Object)properties.circuitBreakerForceClosed().get());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed");
        }

        @Test
        public void testBooleanInstanceBuilderOverrideOfGlobalDynamicOverride2() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withCircuitBreakerForceClosed(false), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed", (Object)true);
            Assert.assertEquals((Object)false, (Object)properties.circuitBreakerForceClosed().get());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed");
        }

        @Test
        public void testBooleanInstanceDynamicOverrideOfEverything() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withCircuitBreakerForceClosed(false), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed", (Object)false);
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.TEST.circuitBreaker.forceClosed", (Object)true);
            Assert.assertEquals((Object)true, (Object)properties.circuitBreakerForceClosed().get());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.circuitBreaker.forceClosed");
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.TEST.circuitBreaker.forceClosed");
        }

        @Test
        public void testIntegerBuilderOverride() {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withMetricsRollingStatisticalWindowInMilliseconds(5000), "unitTestPrefix");
            Assert.assertEquals((long)5000L, (long)properties.metricsRollingStatisticalWindowInMilliseconds().get().intValue());
        }

        @Test
        public void testIntegerCodeDefault() {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter(), "unitTestPrefix");
            Assert.assertEquals((Object)default_metricsRollingStatisticalWindow, (Object)properties.metricsRollingStatisticalWindowInMilliseconds().get());
        }

        @Test
        public void testIntegerGlobalDynamicOverrideOfCodeDefault() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter(), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.metrics.rollingStats.timeInMilliseconds", (Object)1234);
            Assert.assertEquals((long)1234L, (long)properties.metricsRollingStatisticalWindowInMilliseconds().get().intValue());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.metrics.rollingStats.timeInMilliseconds");
        }

        @Test
        public void testIntegerInstanceBuilderOverrideOfGlobalDynamicOverride() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withMetricsRollingStatisticalWindowInMilliseconds(5000), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.rollingStats.timeInMilliseconds", (Object)3456);
            Assert.assertEquals((long)5000L, (long)properties.metricsRollingStatisticalWindowInMilliseconds().get().intValue());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.rollingStats.timeInMilliseconds");
        }

        @Test
        public void testIntegerInstanceDynamicOverrideOfEverything() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter().withMetricsRollingStatisticalWindowInMilliseconds(5000), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.metrics.rollingStats.timeInMilliseconds", (Object)1234);
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.TEST.metrics.rollingStats.timeInMilliseconds", (Object)3456);
            Assert.assertEquals((long)3456L, (long)properties.metricsRollingStatisticalWindowInMilliseconds().get().intValue());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.metrics.rollingStats.timeInMilliseconds");
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.TEST.metrics.rollingStats.timeInMilliseconds");
        }

        @Test
        public void testThreadPoolOnlyHasInstanceOverride() throws Exception {
            TestPropertiesCommand properties = new TestPropertiesCommand(TestKey.TEST, new Setter(), "unitTestPrefix");
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.default.threadPoolKeyOverride", (Object)1234);
            Assert.assertEquals(null, (Object)properties.executionIsolationThreadPoolKeyOverride().get());
            ConfigurationManager.getConfigInstance().setProperty("unitTestPrefix.command.TEST.threadPoolKeyOverride", (Object)"testPool");
            Assert.assertEquals((Object)"testPool", (Object)properties.executionIsolationThreadPoolKeyOverride().get());
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.default.threadPoolKeyOverride");
            ConfigurationManager.getConfigInstance().clearProperty("unitTestPrefix.command.TEST.threadPoolKeyOverride");
        }

        private static class TestPropertiesCommand
        extends HystrixCommandProperties {
            protected TestPropertiesCommand(HystrixCommandKey key, Setter builder, String propertyPrefix) {
                super(key, builder, propertyPrefix);
            }
        }

        public static enum TestKey implements HystrixCommandKey
        {
            TEST;

        }
    }

    @NotThreadSafe
    public static class Setter {
        private Boolean circuitBreakerEnabled = null;
        private Integer circuitBreakerErrorThresholdPercentage = null;
        private Boolean circuitBreakerForceClosed = null;
        private Boolean circuitBreakerForceOpen = null;
        private Integer circuitBreakerRequestVolumeThreshold = null;
        private Integer circuitBreakerSleepWindowInMilliseconds = null;
        private Integer executionIsolationSemaphoreMaxConcurrentRequests = null;
        private ExecutionIsolationStrategy executionIsolationStrategy = null;
        private Boolean executionIsolationThreadInterruptOnTimeout = null;
        private Integer executionIsolationThreadTimeoutInMilliseconds = null;
        private Integer fallbackIsolationSemaphoreMaxConcurrentRequests = null;
        private Integer metricsHealthSnapshotIntervalInMilliseconds = null;
        private Integer metricsRollingPercentileBucketSize = null;
        private Boolean metricsRollingPercentileEnabled = null;
        private Integer metricsRollingPercentileWindowInMilliseconds = null;
        private Integer metricsRollingPercentileWindowBuckets = null;
        private Integer metricsRollingStatisticalWindowInMilliseconds = null;
        private Integer metricsRollingStatisticalWindowBuckets = null;
        private Boolean requestCacheEnabled = null;
        private Boolean requestLogEnabled = null;

        private Setter() {
        }

        public Boolean getCircuitBreakerEnabled() {
            return this.circuitBreakerEnabled;
        }

        public Integer getCircuitBreakerErrorThresholdPercentage() {
            return this.circuitBreakerErrorThresholdPercentage;
        }

        public Boolean getCircuitBreakerForceClosed() {
            return this.circuitBreakerForceClosed;
        }

        public Boolean getCircuitBreakerForceOpen() {
            return this.circuitBreakerForceOpen;
        }

        public Integer getCircuitBreakerRequestVolumeThreshold() {
            return this.circuitBreakerRequestVolumeThreshold;
        }

        public Integer getCircuitBreakerSleepWindowInMilliseconds() {
            return this.circuitBreakerSleepWindowInMilliseconds;
        }

        public Integer getExecutionIsolationSemaphoreMaxConcurrentRequests() {
            return this.executionIsolationSemaphoreMaxConcurrentRequests;
        }

        public ExecutionIsolationStrategy getExecutionIsolationStrategy() {
            return this.executionIsolationStrategy;
        }

        public Boolean getExecutionIsolationThreadInterruptOnTimeout() {
            return this.executionIsolationThreadInterruptOnTimeout;
        }

        public Integer getExecutionIsolationThreadTimeoutInMilliseconds() {
            return this.executionIsolationThreadTimeoutInMilliseconds;
        }

        public Integer getFallbackIsolationSemaphoreMaxConcurrentRequests() {
            return this.fallbackIsolationSemaphoreMaxConcurrentRequests;
        }

        public Integer getMetricsHealthSnapshotIntervalInMilliseconds() {
            return this.metricsHealthSnapshotIntervalInMilliseconds;
        }

        public Integer getMetricsRollingPercentileBucketSize() {
            return this.metricsRollingPercentileBucketSize;
        }

        public Boolean getMetricsRollingPercentileEnabled() {
            return this.metricsRollingPercentileEnabled;
        }

        public Integer getMetricsRollingPercentileWindowInMilliseconds() {
            return this.metricsRollingPercentileWindowInMilliseconds;
        }

        public Integer getMetricsRollingPercentileWindowBuckets() {
            return this.metricsRollingPercentileWindowBuckets;
        }

        public Integer getMetricsRollingStatisticalWindowInMilliseconds() {
            return this.metricsRollingStatisticalWindowInMilliseconds;
        }

        public Integer getMetricsRollingStatisticalWindowBuckets() {
            return this.metricsRollingStatisticalWindowBuckets;
        }

        public Boolean getRequestCacheEnabled() {
            return this.requestCacheEnabled;
        }

        public Boolean getRequestLogEnabled() {
            return this.requestLogEnabled;
        }

        public Setter withCircuitBreakerEnabled(boolean value) {
            this.circuitBreakerEnabled = value;
            return this;
        }

        public Setter withCircuitBreakerErrorThresholdPercentage(int value) {
            this.circuitBreakerErrorThresholdPercentage = value;
            return this;
        }

        public Setter withCircuitBreakerForceClosed(boolean value) {
            this.circuitBreakerForceClosed = value;
            return this;
        }

        public Setter withCircuitBreakerForceOpen(boolean value) {
            this.circuitBreakerForceOpen = value;
            return this;
        }

        public Setter withCircuitBreakerRequestVolumeThreshold(int value) {
            this.circuitBreakerRequestVolumeThreshold = value;
            return this;
        }

        public Setter withCircuitBreakerSleepWindowInMilliseconds(int value) {
            this.circuitBreakerSleepWindowInMilliseconds = value;
            return this;
        }

        public Setter withExecutionIsolationSemaphoreMaxConcurrentRequests(int value) {
            this.executionIsolationSemaphoreMaxConcurrentRequests = value;
            return this;
        }

        public Setter withExecutionIsolationStrategy(ExecutionIsolationStrategy value) {
            this.executionIsolationStrategy = value;
            return this;
        }

        public Setter withExecutionIsolationThreadInterruptOnTimeout(boolean value) {
            this.executionIsolationThreadInterruptOnTimeout = value;
            return this;
        }

        public Setter withExecutionIsolationThreadTimeoutInMilliseconds(int value) {
            this.executionIsolationThreadTimeoutInMilliseconds = value;
            return this;
        }

        public Setter withFallbackIsolationSemaphoreMaxConcurrentRequests(int value) {
            this.fallbackIsolationSemaphoreMaxConcurrentRequests = value;
            return this;
        }

        public Setter withMetricsHealthSnapshotIntervalInMilliseconds(int value) {
            this.metricsHealthSnapshotIntervalInMilliseconds = value;
            return this;
        }

        public Setter withMetricsRollingPercentileBucketSize(int value) {
            this.metricsRollingPercentileBucketSize = value;
            return this;
        }

        public Setter withMetricsRollingPercentileEnabled(boolean value) {
            this.metricsRollingPercentileEnabled = value;
            return this;
        }

        public Setter withMetricsRollingPercentileWindowInMilliseconds(int value) {
            this.metricsRollingPercentileWindowInMilliseconds = value;
            return this;
        }

        public Setter withMetricsRollingPercentileWindowBuckets(int value) {
            this.metricsRollingPercentileWindowBuckets = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowInMilliseconds(int value) {
            this.metricsRollingStatisticalWindowInMilliseconds = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowBuckets(int value) {
            this.metricsRollingStatisticalWindowBuckets = value;
            return this;
        }

        public Setter withRequestCacheEnabled(boolean value) {
            this.requestCacheEnabled = value;
            return this;
        }

        public Setter withRequestLogEnabled(boolean value) {
            this.requestLogEnabled = value;
            return this;
        }

        static Setter getUnitTestPropertiesSetter() {
            return new Setter().withExecutionIsolationThreadTimeoutInMilliseconds(1000).withExecutionIsolationStrategy(ExecutionIsolationStrategy.THREAD).withExecutionIsolationThreadInterruptOnTimeout(true).withCircuitBreakerForceOpen(false).withCircuitBreakerErrorThresholdPercentage(40).withMetricsRollingStatisticalWindowInMilliseconds(5000).withMetricsRollingStatisticalWindowBuckets(5).withCircuitBreakerRequestVolumeThreshold(0).withCircuitBreakerSleepWindowInMilliseconds(5000000).withCircuitBreakerEnabled(true).withRequestLogEnabled(true).withExecutionIsolationSemaphoreMaxConcurrentRequests(20).withFallbackIsolationSemaphoreMaxConcurrentRequests(10).withCircuitBreakerForceClosed(false).withMetricsRollingPercentileEnabled(true).withRequestCacheEnabled(true).withMetricsRollingPercentileWindowInMilliseconds(60000).withMetricsRollingPercentileWindowBuckets(12).withMetricsRollingPercentileBucketSize(1000).withMetricsHealthSnapshotIntervalInMilliseconds(0);
        }

        static HystrixCommandProperties asMock(final Setter builder) {
            return new HystrixCommandProperties(UnitTest.TestKey.TEST){

                @Override
                public HystrixProperty<Boolean> circuitBreakerEnabled() {
                    return HystrixProperty.Factory.asProperty(builder.circuitBreakerEnabled);
                }

                @Override
                public HystrixProperty<Integer> circuitBreakerErrorThresholdPercentage() {
                    return HystrixProperty.Factory.asProperty(builder.circuitBreakerErrorThresholdPercentage);
                }

                @Override
                public HystrixProperty<Boolean> circuitBreakerForceClosed() {
                    return HystrixProperty.Factory.asProperty(builder.circuitBreakerForceClosed);
                }

                @Override
                public HystrixProperty<Boolean> circuitBreakerForceOpen() {
                    return HystrixProperty.Factory.asProperty(builder.circuitBreakerForceOpen);
                }

                @Override
                public HystrixProperty<Integer> circuitBreakerRequestVolumeThreshold() {
                    return HystrixProperty.Factory.asProperty(builder.circuitBreakerRequestVolumeThreshold);
                }

                @Override
                public HystrixProperty<Integer> circuitBreakerSleepWindowInMilliseconds() {
                    return HystrixProperty.Factory.asProperty(builder.circuitBreakerSleepWindowInMilliseconds);
                }

                @Override
                public HystrixProperty<Integer> executionIsolationSemaphoreMaxConcurrentRequests() {
                    return HystrixProperty.Factory.asProperty(builder.executionIsolationSemaphoreMaxConcurrentRequests);
                }

                @Override
                public HystrixProperty<ExecutionIsolationStrategy> executionIsolationStrategy() {
                    return HystrixProperty.Factory.asProperty(builder.executionIsolationStrategy);
                }

                @Override
                public HystrixProperty<Boolean> executionIsolationThreadInterruptOnTimeout() {
                    return HystrixProperty.Factory.asProperty(builder.executionIsolationThreadInterruptOnTimeout);
                }

                @Override
                public HystrixProperty<String> executionIsolationThreadPoolKeyOverride() {
                    return HystrixProperty.Factory.nullProperty();
                }

                @Override
                public HystrixProperty<Integer> executionIsolationThreadTimeoutInMilliseconds() {
                    return HystrixProperty.Factory.asProperty(builder.executionIsolationThreadTimeoutInMilliseconds);
                }

                @Override
                public HystrixProperty<Integer> fallbackIsolationSemaphoreMaxConcurrentRequests() {
                    return HystrixProperty.Factory.asProperty(builder.fallbackIsolationSemaphoreMaxConcurrentRequests);
                }

                @Override
                public HystrixProperty<Integer> metricsHealthSnapshotIntervalInMilliseconds() {
                    return HystrixProperty.Factory.asProperty(builder.metricsHealthSnapshotIntervalInMilliseconds);
                }

                @Override
                public HystrixProperty<Integer> metricsRollingPercentileBucketSize() {
                    return HystrixProperty.Factory.asProperty(builder.metricsRollingPercentileBucketSize);
                }

                @Override
                public HystrixProperty<Boolean> metricsRollingPercentileEnabled() {
                    return HystrixProperty.Factory.asProperty(builder.metricsRollingPercentileEnabled);
                }

                @Override
                public HystrixProperty<Integer> metricsRollingPercentileWindow() {
                    return HystrixProperty.Factory.asProperty(builder.metricsRollingPercentileWindowInMilliseconds);
                }

                @Override
                public HystrixProperty<Integer> metricsRollingPercentileWindowBuckets() {
                    return HystrixProperty.Factory.asProperty(builder.metricsRollingPercentileWindowBuckets);
                }

                @Override
                public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
                    return HystrixProperty.Factory.asProperty(builder.metricsRollingStatisticalWindowInMilliseconds);
                }

                @Override
                public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
                    return HystrixProperty.Factory.asProperty(builder.metricsRollingStatisticalWindowBuckets);
                }

                @Override
                public HystrixProperty<Boolean> requestCacheEnabled() {
                    return HystrixProperty.Factory.asProperty(builder.requestCacheEnabled);
                }

                @Override
                public HystrixProperty<Boolean> requestLogEnabled() {
                    return HystrixProperty.Factory.asProperty(builder.requestLogEnabled);
                }
            };
        }
    }

    private static final class ExecutionIsolationStrategyHystrixProperty
    implements HystrixProperty<ExecutionIsolationStrategy> {
        private final HystrixPropertiesChainedArchaiusProperty.StringProperty property;
        private volatile ExecutionIsolationStrategy value;
        private final ExecutionIsolationStrategy defaultValue;

        private ExecutionIsolationStrategyHystrixProperty(ExecutionIsolationStrategy builderOverrideValue, HystrixCommandKey key, String propertyPrefix, ExecutionIsolationStrategy defaultValue, String instanceProperty) {
            this.defaultValue = defaultValue;
            String overrideValue = null;
            if (builderOverrideValue != null) {
                overrideValue = builderOverrideValue.name();
            }
            this.property = new HystrixPropertiesChainedArchaiusProperty.StringProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty(propertyPrefix + ".command." + key.name() + "." + instanceProperty, overrideValue), new HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty(propertyPrefix + ".command.default." + instanceProperty, defaultValue.name()));
            this.parseProperty();
            this.property.addCallback(new Runnable(){

                @Override
                public void run() {
                    ExecutionIsolationStrategyHystrixProperty.this.parseProperty();
                }
            });
        }

        @Override
        public ExecutionIsolationStrategy get() {
            return this.value;
        }

        private void parseProperty() {
            try {
                this.value = ExecutionIsolationStrategy.valueOf((String)this.property.get());
            }
            catch (Exception e) {
                logger.error("Unable to derive ExecutionIsolationStrategy from property value: " + (String)this.property.get(), (Throwable)e);
                this.value = this.defaultValue;
            }
        }
    }

    public static enum ExecutionIsolationStrategy {
        THREAD,
        SEMAPHORE;

    }
}

