/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.metrics;

import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;

abstract class HystrixMetricsServoPublisherAbstract {
    HystrixMetricsServoPublisherAbstract() {
    }

    protected abstract Tag getServoTypeTag();

    protected abstract Tag getServoInstanceTag();

    protected Monitor<?> getCumulativeCountForEvent(String name, final HystrixCommandMetrics metrics, final HystrixRollingNumberEvent event) {
        return new CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            public Long getValue() {
                return metrics.getCumulativeCount(event);
            }
        };
    }

    protected Monitor<?> getRollingCountForEvent(String name, final HystrixCommandMetrics metrics, final HystrixRollingNumberEvent event) {
        return new GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            public Number getValue() {
                return metrics.getRollingCount(event);
            }
        };
    }

    protected abstract class GaugeMetric
    extends AbstractMonitor<Number>
    implements Gauge<Number> {
        public GaugeMetric(MonitorConfig config) {
            super(config.withAdditionalTag((Tag)DataSourceType.GAUGE).withAdditionalTag(HystrixMetricsServoPublisherAbstract.this.getServoTypeTag()).withAdditionalTag(HystrixMetricsServoPublisherAbstract.this.getServoInstanceTag()));
        }
    }

    protected abstract class CounterMetric
    extends AbstractMonitor<Long>
    implements Counter {
        public CounterMetric(MonitorConfig config) {
            super(config.withAdditionalTag((Tag)DataSourceType.COUNTER).withAdditionalTag(HystrixMetricsServoPublisherAbstract.this.getServoTypeTag()).withAdditionalTag(HystrixMetricsServoPublisherAbstract.this.getServoInstanceTag()));
        }

        public void increment() {
            throw new IllegalStateException("We are wrapping a value instead.");
        }

        public void increment(long arg0) {
            throw new IllegalStateException("We are wrapping a value instead.");
        }
    }

    protected abstract class InformationalMetric<K>
    extends AbstractMonitor<K> {
        public InformationalMetric(MonitorConfig config) {
            super(config.withAdditionalTag((Tag)DataSourceType.INFORMATIONAL).withAdditionalTag(HystrixMetricsServoPublisherAbstract.this.getServoTypeTag()).withAdditionalTag(HystrixMetricsServoPublisherAbstract.this.getServoInstanceTag()));
        }
    }
}

