/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.properties;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategyDefault;
import java.util.concurrent.ConcurrentHashMap;

public class HystrixPropertiesFactory {
    private static final ConcurrentHashMap<String, HystrixCommandProperties> commandProperties = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, HystrixThreadPoolProperties> threadPoolProperties = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, HystrixCollapserProperties> collapserProperties = new ConcurrentHashMap();

    public static HystrixCommandProperties getCommandProperties(HystrixPropertiesStrategy hystrixPropertiesStrategy, HystrixCommandKey key, HystrixCommandProperties.Setter builder) {
        String cacheKey;
        if (hystrixPropertiesStrategy == null) {
            hystrixPropertiesStrategy = HystrixPropertiesStrategyDefault.getInstance();
        }
        if ((cacheKey = hystrixPropertiesStrategy.getCommandPropertiesCacheKey(key, builder)) != null) {
            HystrixCommandProperties existing;
            HystrixCommandProperties properties = commandProperties.get(cacheKey);
            if (properties != null) {
                return properties;
            }
            if (builder == null) {
                builder = HystrixCommandProperties.Setter();
            }
            if ((existing = commandProperties.putIfAbsent(cacheKey, properties = hystrixPropertiesStrategy.getCommandProperties(key, builder))) == null) {
                return properties;
            }
            return existing;
        }
        return hystrixPropertiesStrategy.getCommandProperties(key, builder);
    }

    public static HystrixThreadPoolProperties getThreadPoolProperties(HystrixPropertiesStrategy hystrixPropertiesStrategy, HystrixThreadPoolKey key, HystrixThreadPoolProperties.Setter builder) {
        String cacheKey;
        if (hystrixPropertiesStrategy == null) {
            hystrixPropertiesStrategy = HystrixPropertiesStrategyDefault.getInstance();
        }
        if ((cacheKey = hystrixPropertiesStrategy.getThreadPoolPropertiesCacheKey(key, builder)) != null) {
            HystrixThreadPoolProperties existing;
            HystrixThreadPoolProperties properties = threadPoolProperties.get(cacheKey);
            if (properties != null) {
                return properties;
            }
            if (builder == null) {
                builder = HystrixThreadPoolProperties.Setter();
            }
            if ((existing = threadPoolProperties.putIfAbsent(cacheKey, properties = hystrixPropertiesStrategy.getThreadPoolProperties(key, builder))) == null) {
                return properties;
            }
            return existing;
        }
        return hystrixPropertiesStrategy.getThreadPoolProperties(key, builder);
    }

    public static HystrixCollapserProperties getCollapserProperties(HystrixPropertiesStrategy hystrixPropertiesStrategy, HystrixCollapserKey key, HystrixCollapserProperties.Setter builder) {
        String cacheKey;
        if (hystrixPropertiesStrategy == null) {
            hystrixPropertiesStrategy = HystrixPropertiesStrategyDefault.getInstance();
        }
        if ((cacheKey = hystrixPropertiesStrategy.getCollapserPropertiesCacheKey(key, builder)) != null) {
            HystrixCollapserProperties existing;
            HystrixCollapserProperties properties = collapserProperties.get(cacheKey);
            if (properties != null) {
                return properties;
            }
            if (builder == null) {
                builder = HystrixCollapserProperties.Setter();
            }
            if ((existing = collapserProperties.putIfAbsent(cacheKey, properties = hystrixPropertiesStrategy.getCollapserProperties(key, builder))) == null) {
                return properties;
            }
            return existing;
        }
        return hystrixPropertiesStrategy.getCollapserProperties(key, builder);
    }
}

