/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixContextCallable;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.netflix.hystrix.util.ExceptionThreadingUtility;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class HystrixCommand<R>
implements HystrixExecutable<R> {
    private static final Logger logger = LoggerFactory.getLogger(HystrixCommand.class);
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixThreadPool threadPool;
    private final HystrixThreadPoolKey threadPoolKey;
    private final HystrixCommandProperties properties;
    private final HystrixCommandMetrics metrics;
    private volatile ExecutionResult executionResult = ExecutionResult.access$000();
    private final AtomicBoolean isCommandTimedOut = new AtomicBoolean(false);
    private final AtomicBoolean isExecutionComplete = new AtomicBoolean(false);
    private final AtomicBoolean isExecutedInThread = new AtomicBoolean(false);
    private final HystrixCommandKey commandKey;
    private final HystrixCommandGroupKey commandGroup;
    private final TryableSemaphore fallbackSemaphoreOverride;
    private static final ConcurrentHashMap<String, TryableSemaphore> fallbackSemaphorePerCircuit = new ConcurrentHashMap();
    private final TryableSemaphore executionSemaphoreOverride;
    private static final ConcurrentHashMap<String, TryableSemaphore> executionSemaphorePerCircuit = new ConcurrentHashMap();
    private AtomicLong invocationStartTime = new AtomicLong(-1L);
    private final HystrixRequestCache requestCache;
    private final HystrixEventNotifier eventNotifier;
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private static ConcurrentHashMap<Class<? extends HystrixCommand>, String> defaultNameCache = new ConcurrentHashMap();

    protected HystrixCommand(HystrixCommandGroupKey group) {
        this(new Setter(group));
    }

    protected HystrixCommand(Setter setter) {
        this(setter.groupKey, setter.commandKey, setter.threadPoolKey, null, null, setter.commandPropertiesDefaults, setter.threadPoolPropertiesDefaults, null, null, null);
    }

    private HystrixCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, TryableSemaphore fallbackSemaphore, TryableSemaphore executionSemaphore) {
        if (group == null) {
            throw new IllegalStateException("HystrixCommandGroup can not be NULL");
        }
        this.commandGroup = group;
        if (key == null || key.name().trim().equals("")) {
            String keyName = HystrixCommand.getDefaultNameFromClass(this.getClass());
            this.commandKey = HystrixCommandKey.Factory.asKey(keyName);
        } else {
            this.commandKey = key;
        }
        this.properties = HystrixPropertiesFactory.getCommandProperties(this.commandKey, commandPropertiesDefaults);
        this.threadPoolKey = this.properties.executionIsolationThreadPoolKeyOverride().get() == null ? (threadPoolKey == null ? HystrixThreadPoolKey.Factory.asKey(this.commandGroup.name()) : threadPoolKey) : HystrixThreadPoolKey.Factory.asKey(this.properties.executionIsolationThreadPoolKeyOverride().get());
        this.eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        this.metrics = metrics == null ? HystrixCommandMetrics.getInstance(this.commandKey, this.commandGroup, this.properties) : metrics;
        this.circuitBreaker = this.properties.circuitBreakerEnabled().get().booleanValue() ? (circuitBreaker == null ? HystrixCircuitBreaker.Factory.getInstance(this.commandKey, this.commandGroup, this.properties, this.metrics) : circuitBreaker) : new HystrixCircuitBreaker.NoOpCircuitBreaker();
        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCommand(this.commandKey, this.commandGroup, this.metrics, this.circuitBreaker, this.properties);
        this.threadPool = threadPool == null ? HystrixThreadPool.Factory.getInstance(this.threadPoolKey, threadPoolPropertiesDefaults) : threadPool;
        this.fallbackSemaphoreOverride = fallbackSemaphore;
        this.executionSemaphoreOverride = executionSemaphore;
        this.requestCache = HystrixRequestCache.getInstance(this.commandKey, this.concurrencyStrategy);
    }

    private static String getDefaultNameFromClass(Class<? extends HystrixCommand> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    protected abstract R run();

    protected R getFallback() {
        throw new UnsupportedOperationException("No fallback available.");
    }

    public final HystrixCommandGroupKey getCommandGroup() {
        return this.commandGroup;
    }

    public final HystrixCommandKey getCommandKey() {
        return this.commandKey;
    }

    public final HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    final HystrixCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public final HystrixCommandMetrics getMetrics() {
        return this.metrics;
    }

    public final HystrixCommandProperties getProperties() {
        return this.properties;
    }

    void markAsCollapsedCommand(int sizeOfBatch) {
        this.getMetrics().markCollapsed(sizeOfBatch);
        this.executionResult = this.executionResult.addEvents(HystrixEventType.COLLAPSED);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final R execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R executeWithSemaphore() {
        TryableSemaphore executionSemaphore = this.getExecutionSemaphore();
        if (executionSemaphore.tryAcquire()) {
            try {
                this.metrics.markExecutionSemaphoreUsedPermitsCount(executionSemaphore.getNumberOfPermitsUsed());
                R response = this.executeCommand();
                if (this.isRequestCachingEnabled()) {
                    this.requestCache.putIfAbsent(this.getCacheKey(), this.asFutureForCache(response));
                }
                R r = response;
                return r;
            }
            finally {
                executionSemaphore.release();
            }
        }
        this.metrics.markSemaphoreRejection();
        logger.debug("HystrixCommand Execution Rejection by Semaphore");
        return this.getFallbackOrThrowException(HystrixEventType.SEMAPHORE_REJECTED, HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION, "could not acquire a semaphore for execution");
    }

    @Override
    public final Future<R> queue() {
        try {
            Future<Object> fromCache;
            if (!this.invocationStartTime.compareAndSet(-1L, System.currentTimeMillis())) {
                throw new IllegalStateException("This instance can only be executed once. Please instantiate a new instance.");
            }
            if (this.isRequestCachingEnabled() && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
                this.metrics.markResponseFromCache();
                Future future = this.asCachedFuture(fromCache);
                return future;
            }
            if (!this.circuitBreaker.allowRequest()) {
                this.metrics.markShortCircuited();
                fromCache = this.asFuture(this.getFallbackOrThrowException(HystrixEventType.SHORT_CIRCUITED, HystrixRuntimeException.FailureType.SHORTCIRCUIT, "short-circuited"));
                return fromCache;
            }
            if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
                fromCache = this.queueInThread();
                return fromCache;
            }
            fromCache = this.queueInSemaphore();
            return fromCache;
        }
        finally {
            if (this.properties.requestLogEnabled().get().booleanValue()) {
                if (this.concurrencyStrategy instanceof HystrixConcurrencyStrategyDefault) {
                    if (HystrixRequestContext.isCurrentThreadInitialized()) {
                        HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy).addExecutedCommand(this);
                    }
                } else if (HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) != null) {
                    HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy).addExecutedCommand(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<R> queueInSemaphore() {
        TryableSemaphore executionSemaphore = this.getExecutionSemaphore();
        if (executionSemaphore.tryAcquire()) {
            this.metrics.markExecutionSemaphoreUsedPermitsCount(executionSemaphore.getNumberOfPermitsUsed());
            final CountDownLatch executionCompleted = new CountDownLatch(1);
            try {
                Future fromCache;
                final AtomicReference<R> value = new AtomicReference<R>();
                CommandFuture responseFuture = new CommandFuture<R>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }

                    @Override
                    public boolean isDone() {
                        return true;
                    }

                    @Override
                    public R get() throws InterruptedException, ExecutionException {
                        executionCompleted.await();
                        return value.get();
                    }

                    @Override
                    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return this.get();
                    }

                    @Override
                    public ExecutionResult getExecutionResult() {
                        return HystrixCommand.this.executionResult;
                    }
                };
                if (this.isRequestCachingEnabled() && (fromCache = this.requestCache.putIfAbsent(this.getCacheKey(), responseFuture)) != null) {
                    this.metrics.markResponseFromCache();
                    Future future = this.asCachedFuture(fromCache);
                    return future;
                }
                R r = this.executeCommand();
                value.set(r);
                CommandFuture commandFuture = responseFuture;
                return commandFuture;
            }
            finally {
                executionCompleted.countDown();
                executionSemaphore.release();
            }
        }
        this.metrics.markSemaphoreRejection();
        logger.debug("HystrixCommand Execution Rejection by Semaphore.");
        return this.asFuture(this.getFallbackOrThrowException(HystrixEventType.SEMAPHORE_REJECTED, HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION, "could not acquire a semaphore for execution"));
    }

    private Future<R> queueInThread() {
        Future fromCache;
        long startTime = System.currentTimeMillis();
        this.isExecutedInThread.set(true);
        final Thread callingThread = Thread.currentThread();
        final long timeBeforeExecution = System.currentTimeMillis();
        QueuedExecutionFuture future = new QueuedExecutionFuture(this, startTime, this.threadPool.getExecutor(), new HystrixContextCallable(new Callable<R>(){

            @Override
            public R call() throws Exception {
                try {
                    Object r;
                    ExceptionThreadingUtility.assignCallingThread(callingThread);
                    HystrixCommand.this.threadPool.markThreadExecution();
                    long timeQueued = System.currentTimeMillis() - timeBeforeExecution;
                    if (HystrixCommand.this.isCommandTimedOut.get() || timeQueued > (long)HystrixCommand.this.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Callable is being skipped since the user-thread has already timed-out this request after " + timeQueued + "ms.");
                        }
                        if (!HystrixCommand.this.isCommandTimedOut.get() && HystrixCommand.this.isCommandTimedOut.compareAndSet(false, true)) {
                            HystrixCommand.this.metrics.markTimeout(timeQueued);
                        }
                        Object r2 = null;
                        return r2;
                    }
                    Object object = r = HystrixCommand.this.executeCommand();
                    return object;
                }
                catch (Exception e) {
                    if (!HystrixCommand.this.isCommandTimedOut.get()) {
                        HystrixCommand.this.metrics.markExceptionThrown();
                    }
                    throw e;
                }
                finally {
                    HystrixCommand.this.threadPool.markThreadCompletion();
                }
            }
        }));
        if (this.isRequestCachingEnabled() && (fromCache = this.requestCache.putIfAbsent(this.getCacheKey(), future)) != null) {
            this.metrics.markResponseFromCache();
            return this.asCachedFuture(fromCache);
        }
        future.start();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R executeCommand() {
        long startTime = System.currentTimeMillis();
        try {
            R response = this.run();
            long duration = System.currentTimeMillis() - startTime;
            this.metrics.addCommandExecutionTime(duration);
            if (this.isCommandTimedOut.get()) {
                R r = null;
                return r;
            }
            this.executionResult = this.executionResult.addEvents(HystrixEventType.SUCCESS);
            this.metrics.markSuccess(duration);
            this.circuitBreaker.markSuccess();
            this.eventNotifier.markCommandExecution(this.getCommandKey(), this.properties.executionIsolationStrategy().get(), (int)duration, this.executionResult.events);
            R r = response;
            return r;
        }
        catch (HystrixBadRequestException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.isCommandTimedOut.get()) {
                logger.error("Error executing HystrixCommand [TimedOut]", e);
                R r = null;
                return r;
            }
            logger.error("Error executing HystrixCommand", e);
            this.metrics.markFailure(System.currentTimeMillis() - startTime);
            this.executionResult = this.executionResult.setException(e);
            R r = this.getFallbackOrThrowException(HystrixEventType.FAILURE, HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, "failed", e);
            return r;
        }
        finally {
            this.executionResult = this.executionResult.setExecutionTime((int)(System.currentTimeMillis() - startTime));
            this.isExecutionComplete.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R getFallbackWithProtection() {
        TryableSemaphore fallbackSemaphore = this.getFallbackSemaphore();
        if (fallbackSemaphore.tryAcquire()) {
            try {
                R r = this.getFallback();
                return r;
            }
            finally {
                fallbackSemaphore.release();
            }
        }
        this.metrics.markFallbackRejection();
        logger.debug("HystrixCommand Fallback Rejection.");
        throw new HystrixRuntimeException(HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_FALLBACK, this.getClass(), this.getLogMessagePrefix() + " fallback execution rejected.", null, null);
    }

    public final boolean isCircuitBreakerOpen() {
        return this.circuitBreaker.isOpen();
    }

    public final boolean isExecutionComplete() {
        return this.isExecutionComplete.get();
    }

    public final boolean isExecutedInThread() {
        return this.isExecutedInThread.get();
    }

    public final boolean isSuccessfulExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.SUCCESS);
    }

    public final boolean isFailedExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.FAILURE);
    }

    public final Throwable getFailedExecutionException() {
        return this.executionResult.exception;
    }

    public final boolean isResponseFromFallback() {
        return this.executionResult.events.contains((Object)HystrixEventType.FALLBACK_SUCCESS);
    }

    public final boolean isResponseTimedOut() {
        return this.executionResult.events.contains((Object)HystrixEventType.TIMEOUT);
    }

    public final boolean isResponseShortCircuited() {
        return this.executionResult.events.contains((Object)HystrixEventType.SHORT_CIRCUITED);
    }

    public final boolean isResponseFromCache() {
        return this.executionResult.events.contains((Object)HystrixEventType.RESPONSE_FROM_CACHE);
    }

    public final boolean isResponseRejected() {
        return this.executionResult.events.contains((Object)HystrixEventType.THREAD_POOL_REJECTED) || this.executionResult.events.contains((Object)HystrixEventType.SEMAPHORE_REJECTED);
    }

    public final List<HystrixEventType> getExecutionEvents() {
        return this.executionResult.events;
    }

    public final int getExecutionTimeInMilliseconds() {
        return this.executionResult.executionTime;
    }

    private TryableSemaphore getFallbackSemaphore() {
        if (this.fallbackSemaphoreOverride == null) {
            TryableSemaphore _s = fallbackSemaphorePerCircuit.get(this.commandKey.name());
            if (_s == null) {
                fallbackSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphore(this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests()));
                return fallbackSemaphorePerCircuit.get(this.commandKey.name());
            }
            return _s;
        }
        return this.fallbackSemaphoreOverride;
    }

    private TryableSemaphore getExecutionSemaphore() {
        if (this.executionSemaphoreOverride == null) {
            TryableSemaphore _s = executionSemaphorePerCircuit.get(this.commandKey.name());
            if (_s == null) {
                executionSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphore(this.properties.executionIsolationSemaphoreMaxConcurrentRequests()));
                return executionSemaphorePerCircuit.get(this.commandKey.name());
            }
            return _s;
        }
        return this.executionSemaphoreOverride;
    }

    private R getFallbackOrThrowException(HystrixEventType eventType, HystrixRuntimeException.FailureType failureType, String message) {
        return this.getFallbackOrThrowException(eventType, failureType, message, null);
    }

    private R getFallbackOrThrowException(HystrixEventType eventType, HystrixRuntimeException.FailureType failureType, String message, Throwable e) {
        try {
            R fallback = this.getFallbackWithProtection();
            this.metrics.markFallbackSuccess();
            this.executionResult = this.executionResult.addEvents(eventType, HystrixEventType.FALLBACK_SUCCESS);
            R r = fallback;
            return r;
        }
        catch (UnsupportedOperationException fe) {
            logger.debug("No fallback for HystrixCommand. ", (Throwable)fe);
            this.executionResult = this.executionResult.addEvents(eventType);
            throw new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and no fallback available.", e, (Throwable)fe);
        }
        catch (Throwable fe) {
            logger.error("Error retrieving fallback for HystrixCommand. ", fe);
            this.metrics.markFallbackFailure();
            this.executionResult = this.executionResult.addEvents(eventType, HystrixEventType.FALLBACK_FAILURE);
            throw new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and failed retrieving fallback.", e, fe);
        }
        finally {
            this.isExecutionComplete.set(true);
        }
    }

    protected String getCacheKey() {
        return null;
    }

    private Future<R> asFutureForCache(R value) {
        return this.asFuture(value);
    }

    private Future<R> asCachedFuture(Future<R> actualFuture) {
        if (!(actualFuture instanceof CommandFuture)) {
            throw new RuntimeException("This should be a CommandFuture from the asFutureForCache method.");
        }
        final CommandFuture commandFuture = (CommandFuture)actualFuture;
        return new Future<R>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return commandFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return commandFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return commandFuture.isDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R get() throws InterruptedException, ExecutionException {
                Object v;
                try {
                    v = commandFuture.get();
                }
                catch (Throwable throwable) {
                    HystrixCommand.this.executionResult = commandFuture.getExecutionResult();
                    HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.addEvents(HystrixEventType.RESPONSE_FROM_CACHE);
                    HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.setExecutionTime(-1);
                    throw throwable;
                }
                HystrixCommand.this.executionResult = commandFuture.getExecutionResult();
                HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.addEvents(HystrixEventType.RESPONSE_FROM_CACHE);
                HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.setExecutionTime(-1);
                return v;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Object v;
                try {
                    v = commandFuture.get(timeout, unit);
                }
                catch (Throwable throwable) {
                    HystrixCommand.this.executionResult = commandFuture.getExecutionResult();
                    HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.addEvents(HystrixEventType.RESPONSE_FROM_CACHE);
                    HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.setExecutionTime(-1);
                    throw throwable;
                }
                HystrixCommand.this.executionResult = commandFuture.getExecutionResult();
                HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.addEvents(HystrixEventType.RESPONSE_FROM_CACHE);
                HystrixCommand.this.executionResult = HystrixCommand.this.executionResult.setExecutionTime(-1);
                return v;
            }
        };
    }

    private boolean isRequestCachingEnabled() {
        return this.properties.requestCacheEnabled().get();
    }

    private Future<R> asFuture(final R value) {
        return new CommandFuture<R>(){

            @Override
            public boolean cancel(boolean arg0) {
                return false;
            }

            @Override
            public R get() throws InterruptedException, ExecutionException {
                return value;
            }

            @Override
            public R get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public ExecutionResult getExecutionResult() {
                return HystrixCommand.this.executionResult;
            }
        };
    }

    private String getLogMessagePrefix() {
        return this.getCommandKey().name();
    }

    public static class UnitTest {
        private static HystrixPropertiesStrategy TEST_PROPERTIES_FACTORY = new TestPropertiesFactory();

        @Before
        public void prepareForTest() {
            HystrixRequestContext.initializeContext();
            HystrixPlugins.getInstance().registerPropertiesStrategy(TEST_PROPERTIES_FACTORY);
        }

        @After
        public void cleanup() {
            if (HystrixRequestContext.getContextForCurrentThread() != null) {
                HystrixRequestContext.getContextForCurrentThread().shutdown();
            }
            ConfigurationManager.getConfigInstance().clear();
            HystrixPlugins.getInstance().registerPropertiesStrategy(null);
        }

        @Test
        public void testExecutionSuccess() {
            try {
                SuccessfulTestCommand command = new SuccessfulTestCommand();
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((Object)true, command.execute());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals(null, (Object)command.getFailedExecutionException());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
                Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testExecutionMultipleTimes() {
            SuccessfulTestCommand command = new SuccessfulTestCommand();
            Assert.assertFalse((boolean)command.isExecutionComplete());
            Assert.assertEquals((Object)true, command.execute());
            Assert.assertTrue((boolean)command.isExecutionComplete());
            Assert.assertTrue((boolean)command.isExecutedInThread());
            try {
                command.execute();
                Assert.fail((String)"we should not allow this ... it breaks the state of request logs");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                command.queue();
                Assert.fail((String)"we should not allow this ... it breaks the state of request logs");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testExecutionKnownFailureWithNoFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithoutFallback command = new KnownFailureTestCommandWithoutFallback(circuitBreaker);
            try {
                command.execute();
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.fail((String)"we shouldn't get here");
            }
            catch (HystrixRuntimeException e) {
                e.printStackTrace();
                Assert.assertNotNull((Object)e.getFallbackException());
                Assert.assertNotNull(e.getImplementingClass());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should always get an HystrixRuntimeException when an error occurs.");
            }
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionUnknownFailureWithNoFallback() {
            UnknownFailureTestCommandWithoutFallback command = new UnknownFailureTestCommandWithoutFallback();
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (HystrixRuntimeException e) {
                e.printStackTrace();
                Assert.assertNotNull((Object)e.getFallbackException());
                Assert.assertNotNull(e.getImplementingClass());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should always get an HystrixRuntimeException when an error occurs.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionFailureWithFallback() {
            KnownFailureTestCommandWithFallback command = new KnownFailureTestCommandWithFallback(new HystrixCircuitBreaker.TestCircuitBreaker());
            try {
                Assert.assertEquals((Object)false, command.execute());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((Object)"we failed with a simulated issue", (Object)command.getFailedExecutionException().getMessage());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionFailureWithFallbackFailure() {
            KnownFailureTestCommandWithFallbackFailure command = new KnownFailureTestCommandWithFallbackFailure();
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (HystrixRuntimeException e) {
                System.out.println("------------------------------------------------");
                e.printStackTrace();
                System.out.println("------------------------------------------------");
                Assert.assertNotNull((Object)e.getFallbackException());
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueSuccess() {
            SuccessfulTestCommand command = new SuccessfulTestCommand();
            try {
                Future future = command.queue();
                Assert.assertEquals((Object)true, future.get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueKnownFailureWithNoFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithoutFallback command = new KnownFailureTestCommandWithoutFallback(circuitBreaker);
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertNotNull(de.getImplementingClass());
                }
                Assert.fail((String)"the cause should be HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueUnknownFailureWithNoFallback() {
            UnknownFailureTestCommandWithoutFallback command = new UnknownFailureTestCommandWithoutFallback();
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertNotNull(de.getImplementingClass());
                }
                Assert.fail((String)"the cause should be HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueFailureWithFallback() {
            KnownFailureTestCommandWithFallback command = new KnownFailureTestCommandWithFallback(new HystrixCircuitBreaker.TestCircuitBreaker());
            try {
                Future future = command.queue();
                Assert.assertEquals((Object)false, future.get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueFailureWithFallbackFailure() {
            KnownFailureTestCommandWithFallbackFailure command = new KnownFailureTestCommandWithFallbackFailure();
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    e.printStackTrace();
                    Assert.assertNotNull((Object)de.getFallbackException());
                }
                Assert.fail((String)"the cause should be HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCircuitBreakerTripsAfterFailures() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt1.execute();
            Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt2 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt2.execute();
            Assert.assertTrue((boolean)attempt2.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt3.execute();
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
            KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt4.execute();
            Assert.assertTrue((boolean)attempt4.isResponseFromFallback());
            Assert.assertTrue((boolean)attempt4.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt4.isCircuitBreakerOpen());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCircuitBreakerTripsAfterFailuresViaQueue() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt1.queue().get();
                Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
                Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
                KnownFailureTestCommandWithFallback attempt2 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt2.queue().get();
                Assert.assertTrue((boolean)attempt2.isResponseFromFallback());
                Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
                KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt3.queue().get();
                Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
                Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
                Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
                KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt4.queue().get();
                Assert.assertTrue((boolean)attempt4.isResponseFromFallback());
                Assert.assertTrue((boolean)attempt4.isResponseShortCircuited());
                Assert.assertTrue((boolean)attempt4.isCircuitBreakerOpen());
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
                Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received fallbacks.");
            }
        }

        @Test
        public void testCircuitBreakerAcrossMultipleCommandsButSameCircuitBreaker() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt1.execute();
            Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
            KnownFailureTestCommandWithoutFallback attempt2 = new KnownFailureTestCommandWithoutFallback(circuitBreaker);
            try {
                attempt2.execute();
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertTrue((boolean)attempt2.isFailedExecution());
            Assert.assertFalse((boolean)attempt2.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt3.execute();
            Assert.assertTrue((boolean)attempt2.isFailedExecution());
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
            KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt4.execute();
            Assert.assertTrue((boolean)attempt4.isResponseFromFallback());
            Assert.assertTrue((boolean)attempt4.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt4.isCircuitBreakerOpen());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCircuitBreakerAcrossMultipleCommandsAndDifferentDependency() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker_one = new HystrixCircuitBreaker.TestCircuitBreaker();
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker_two = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker_one);
            attempt1.execute();
            Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt2 = new KnownFailureTestCommandWithFallback(circuitBreaker_two);
            attempt2.execute();
            Assert.assertTrue((boolean)attempt2.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker_one);
            attempt3.execute();
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertFalse((boolean)attempt3.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker_one);
            attempt4.execute();
            Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)3L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker_one.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker_two.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionSuccessWithCircuitBreakerDisabled() {
            TestCommandWithoutCircuitBreaker command = new TestCommandWithoutCircuitBreaker();
            try {
                Assert.assertEquals((Object)true, command.execute());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionTimeoutWithNoFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 1);
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException");
            }
            Assert.assertTrue((boolean)command.isResponseTimedOut());
            Assert.assertFalse((boolean)command.isResponseFromFallback());
            Assert.assertFalse((boolean)command.isResponseRejected());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionTimeoutWithFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                Assert.assertEquals((Object)false, command.execute());
                Assert.assertTrue((boolean)command.isResponseTimedOut());
                Assert.assertTrue((boolean)command.isResponseFromFallback());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionTimeoutFallbackFailure() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 3);
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertFalse((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCircuitBreakerOnExecutionTimeout() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                command.execute();
                Assert.assertTrue((boolean)command.isResponseFromFallback());
                Assert.assertFalse((boolean)command.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)command.isResponseShortCircuited());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCountersOnExecutionTimeout() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                command.execute();
                Thread.sleep(200L);
                Assert.assertTrue((boolean)command.isResponseFromFallback());
                Assert.assertFalse((boolean)command.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)command.isResponseShortCircuited());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueuedExecutionTimeoutWithNoFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 1);
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof ExecutionException && e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be ExecutionException with cause as HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueuedExecutionTimeoutWithFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                Assert.assertEquals((Object)false, command.queue().get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueuedExecutionTimeoutFallbackFailure() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 3);
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e instanceof ExecutionException && e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertFalse((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be ExecutionException with cause as HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testShortCircuitFallbackCounter() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
            try {
                new KnownFailureTestCommandWithFallback(circuitBreaker).execute();
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                new KnownFailureTestCommandWithFallback(circuitBreaker).execute();
                Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadWithNoFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPool pool = new SingleThreadedPool(1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            Future f = null;
            try {
                f = new TestCommandRejection(circuitBreaker, pool, 500, 600, 1).queue();
                new TestCommandRejection(circuitBreaker, pool, 500, 600, 1).queue();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                if (e instanceof HystrixRuntimeException && e.getCause() instanceof RejectedExecutionException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof RejectedExecutionException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException with cause as RejectedExecutionException");
            }
            try {
                f.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"The first one should succeed.");
            }
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)50L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadWithFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPool pool = new SingleThreadedPool(1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                TestCommandRejection command1 = new TestCommandRejection(circuitBreaker, pool, 500, 600, 2);
                command1.queue();
                TestCommandRejection command2 = new TestCommandRejection(circuitBreaker, pool, 500, 600, 2);
                Assert.assertEquals((Object)false, command2.queue().get());
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertFalse((boolean)command1.isResponseRejected());
                Assert.assertFalse((boolean)command1.isResponseFromFallback());
                Assert.assertTrue((boolean)command2.isResponseRejected());
                Assert.assertTrue((boolean)command2.isResponseFromFallback());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadWithFallbackFailure() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPool pool = new SingleThreadedPool(1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                new TestCommandRejection(circuitBreaker, pool, 500, 600, 3).queue();
                Assert.assertEquals((Object)false, new TestCommandRejection(circuitBreaker, pool, 500, 600, 3).queue().get());
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                if (e instanceof HystrixRuntimeException && e.getCause() instanceof RejectedExecutionException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertFalse((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof RejectedExecutionException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException with cause as RejectedExecutionException");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadUsingQueueSize() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPool pool = new SingleThreadedPool(10, 1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                new TestCommandRejection(circuitBreaker, pool, 500, 600, 1).queue();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                if (e instanceof HystrixRuntimeException && e.getCause() instanceof RejectedExecutionException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof RejectedExecutionException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException with cause as RejectedExecutionException");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testTimedOutCommandDoesNotExecute() {
            SingleThreadedPool pool = new SingleThreadedPool(5);
            HystrixCircuitBreaker.TestCircuitBreaker s1 = new HystrixCircuitBreaker.TestCircuitBreaker();
            HystrixCircuitBreaker.TestCircuitBreaker s2 = new HystrixCircuitBreaker.TestCircuitBreaker();
            CommandWithCustomThreadPool c1 = new CommandWithCustomThreadPool(s1, pool, 100, HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(600));
            CommandWithCustomThreadPool c2 = new CommandWithCustomThreadPool(s2, pool, 200, HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(20));
            Future c1f = c1.queue();
            boolean receivedException = false;
            try {
                c2.queue().get();
            }
            catch (Exception e) {
                receivedException = true;
            }
            if (!receivedException) {
                Assert.fail((String)"We expect to receive an exception for c2 as it's supposed to timeout.");
            }
            try {
                c1f.get();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                Assert.fail((String)"we should not have failed while getting c1");
            }
            Assert.assertTrue((String)"c1 is expected to executed but didn't", (boolean)c1.didExecute);
            try {
                Thread.sleep(400L);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to sleep");
            }
            Assert.assertFalse((String)"c2 is not expected to execute, but did", (boolean)c2.didExecute);
            Assert.assertEquals((long)1L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)s1.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)s2.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testFallbackSemaphore() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                boolean result = (Boolean)new TestSemaphoreCommandWithSlowFallback(circuitBreaker, 1, 200L).queue().get();
                Assert.assertTrue((boolean)result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            boolean exceptionReceived = false;
            Future result = null;
            try {
                result = new TestSemaphoreCommandWithSlowFallback(circuitBreaker, 1, 400L).queue();
                Thread.sleep(50L);
                Future result2 = new TestSemaphoreCommandWithSlowFallback(circuitBreaker, 1, 200L).queue();
                result2.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                exceptionReceived = true;
            }
            try {
                Assert.assertTrue((boolean)((Boolean)result.get()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!exceptionReceived) {
                Assert.fail((String)"We expected an exception on the 2nd get");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionSemaphoreWithQueue() {
            final HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                boolean result = (Boolean)new TestSemaphoreCommand(circuitBreaker, 1, 200L).queue().get();
                Assert.assertTrue((boolean)result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final AtomicBoolean exceptionReceived = new AtomicBoolean();
            HystrixContextRunnable r = new HystrixContextRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        new TestSemaphoreCommand(circuitBreaker, 1, 200L).queue().get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptionReceived.set(true);
                    }
                }
            });
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"failed waiting on threads");
            }
            if (!exceptionReceived.get()) {
                Assert.fail((String)"We expected an exception on the 2nd get");
            }
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionSemaphoreWithExecution() {
            final HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                TestSemaphoreCommand command = new TestSemaphoreCommand(circuitBreaker, 1, 200L);
                boolean result = (Boolean)command.execute();
                Assert.assertFalse((boolean)command.isExecutedInThread());
                Assert.assertTrue((boolean)result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final ArrayBlockingQueue results = new ArrayBlockingQueue(2);
            final AtomicBoolean exceptionReceived = new AtomicBoolean();
            HystrixContextRunnable r = new HystrixContextRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        results.add(new TestSemaphoreCommand(circuitBreaker, 1, 200L).execute());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptionReceived.set(true);
                    }
                }
            });
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"failed waiting on threads");
            }
            if (!exceptionReceived.get()) {
                Assert.fail((String)"We expected an exception on the 2nd get");
            }
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(Boolean.TRUE));
            Assert.assertFalse((boolean)results.contains(Boolean.FALSE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedExecutionSemaphoreWithFallback() {
            final HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            final ArrayBlockingQueue results = new ArrayBlockingQueue(2);
            final AtomicBoolean exceptionReceived = new AtomicBoolean();
            HystrixContextRunnable r = new HystrixContextRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        results.add(new TestSemaphoreCommandWithFallback(circuitBreaker, 1, 200L, false).execute());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptionReceived.set(true);
                    }
                }
            });
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"failed waiting on threads");
            }
            if (exceptionReceived.get()) {
                Assert.fail((String)"We should have received a fallback response");
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(Boolean.TRUE));
            Assert.assertTrue((boolean)results.contains(Boolean.FALSE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            System.out.println("**** DONE");
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testDynamicOwner() {
            try {
                DynamicOwnerTestCommand command = new DynamicOwnerTestCommand(CommandGroupForUnitTest.OWNER_ONE);
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((Object)true, command.execute());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testDynamicOwnerFails() {
            try {
                DynamicOwnerTestCommand command = new DynamicOwnerTestCommand(null);
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((Object)true, command.execute());
                Assert.fail((String)"we should have thrown an exception as we need an owner");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Test
        public void testDynamicKey() {
            try {
                DynamicOwnerAndKeyTestCommand command1 = new DynamicOwnerAndKeyTestCommand(CommandGroupForUnitTest.OWNER_ONE, CommandKeyForUnitTest.KEY_ONE);
                Assert.assertEquals((Object)true, command1.execute());
                DynamicOwnerAndKeyTestCommand command2 = new DynamicOwnerAndKeyTestCommand(CommandGroupForUnitTest.OWNER_ONE, CommandKeyForUnitTest.KEY_TWO);
                Assert.assertEquals((Object)true, command2.execute());
                Assert.assertNotSame((Object)command1.getCircuitBreaker(), (Object)command2.getCircuitBreaker());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testRequestCache1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertFalse((boolean)command2.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((command1.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)command1.isResponseFromCache());
            Assert.assertEquals((long)2L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((command2.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command2.isResponseFromCache());
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCache2() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "B");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((command2.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)command2.isResponseFromCache());
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCache3() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "B");
            SuccessfulCacheableCommand command3 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertFalse((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)2L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((command3.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command3.isResponseFromCache());
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testNoRequestCache3() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, false, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, false, "B");
            SuccessfulCacheableCommand command3 = new SuccessfulCacheableCommand(circuitBreaker, false, "A");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertTrue((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheViaQueueSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertFalse((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)2L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testNoRequestCacheViaQueueSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertTrue((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheViaExecuteSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            String f1 = (String)command1.execute();
            String f2 = (String)command2.execute();
            String f3 = (String)command3.execute();
            Assert.assertEquals((Object)"A", (Object)f1);
            Assert.assertEquals((Object)"B", (Object)f2);
            Assert.assertEquals((Object)"A", (Object)f3);
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertFalse((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)2L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testNoRequestCacheViaExecuteSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            String f1 = (String)command1.execute();
            String f2 = (String)command2.execute();
            String f3 = (String)command3.execute();
            Assert.assertEquals((Object)"A", (Object)f1);
            Assert.assertEquals((Object)"B", (Object)f2);
            Assert.assertEquals((Object)"A", (Object)f3);
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertTrue((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheOnTimeoutCausesNullPointerException() throws Exception {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            Assert.assertFalse((boolean)((Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute()));
            Assert.assertFalse((boolean)((Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute()));
            Assert.assertFalse((boolean)((Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute()));
            Thread.sleep(500L);
            Boolean value = (Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute();
            Assert.assertFalse((boolean)value);
            RequestCacheNullPointerExceptionCase c = new RequestCacheNullPointerExceptionCase(circuitBreaker);
            Future f = c.queue();
            Assert.assertNotNull(f);
            Assert.assertFalse((boolean)((Boolean)f.get()));
            Assert.assertTrue((boolean)c.isResponseFromFallback());
            Assert.assertTrue((boolean)c.isResponseTimedOut());
            Assert.assertFalse((boolean)c.isFailedExecution());
            Assert.assertFalse((boolean)c.isResponseShortCircuited());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)5L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand[] executeCommands = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[0]);
            System.out.println(":executeCommands[0].getExecutionEvents()" + executeCommands[0].getExecutionEvents());
            Assert.assertEquals((long)2L, (long)executeCommands[0].getExecutionEvents().size());
            Assert.assertTrue((boolean)executeCommands[0].getExecutionEvents().contains((Object)HystrixEventType.FALLBACK_SUCCESS));
            Assert.assertTrue((boolean)executeCommands[0].getExecutionEvents().contains((Object)HystrixEventType.TIMEOUT));
            Assert.assertTrue((executeCommands[0].getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)executeCommands[0].isResponseTimedOut());
            Assert.assertTrue((boolean)executeCommands[0].isResponseFromFallback());
            Assert.assertFalse((boolean)executeCommands[0].isResponseFromCache());
            Assert.assertEquals((long)3L, (long)executeCommands[1].getExecutionEvents().size());
            Assert.assertTrue((boolean)executeCommands[1].getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((executeCommands[1].getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)executeCommands[1].isResponseFromCache());
            Assert.assertTrue((boolean)executeCommands[1].isResponseTimedOut());
            Assert.assertTrue((boolean)executeCommands[1].isResponseFromFallback());
        }

        @Test
        public void testRequestCacheOnTimeoutThrowsException() throws Exception {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            RequestCacheTimeoutWithoutFallback r1 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                r1.execute();
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r1.isResponseTimedOut());
            }
            RequestCacheTimeoutWithoutFallback r2 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                r2.execute();
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r2.isResponseTimedOut());
            }
            RequestCacheTimeoutWithoutFallback r3 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            Future f3 = r3.queue();
            try {
                f3.get();
                Assert.fail((String)"expected a timeout");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)r3.isResponseTimedOut());
            }
            Thread.sleep(500L);
            RequestCacheTimeoutWithoutFallback r4 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                r4.execute();
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r4.isResponseTimedOut());
                Assert.assertFalse((boolean)r4.isResponseFromFallback());
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testBasicExecutionWorksWithoutRequestVariable() {
            try {
                HystrixRequestContext.setContextOnCurrentThread(null);
                SuccessfulTestCommand command = new SuccessfulTestCommand();
                Assert.assertEquals((Object)true, command.execute());
                SuccessfulTestCommand command2 = new SuccessfulTestCommand();
                Assert.assertEquals((Object)true, command2.queue().get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testCacheKeyExecutionRequiresRequestVariable() {
            try {
                HystrixRequestContext.setContextOnCurrentThread(null);
                HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                SuccessfulCacheableCommand command = new SuccessfulCacheableCommand(circuitBreaker, true, "one");
                Assert.assertEquals((Object)true, command.execute());
                SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "two");
                Assert.assertEquals((Object)true, command2.queue().get());
                Assert.fail((String)"We expect an exception because cacheKey requires RequestVariable.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testBadRequestExceptionViaExecuteInThread() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).execute();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (HystrixBadRequestException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testBadRequestExceptionViaQueueInThread() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).queue().get();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                if (!(e.getCause() instanceof HystrixBadRequestException)) {
                    Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testBadRequestExceptionViaExecuteInSemaphore() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).execute();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (HystrixBadRequestException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testBadRequestExceptionViaQueueInSemaphore() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).queue().get();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (HystrixBadRequestException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        private static class TestPropertiesFactory
        extends HystrixPropertiesStrategy {
            private TestPropertiesFactory() {
            }

            @Override
            public HystrixCommandProperties getCommandProperties(HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
                if (builder == null) {
                    builder = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                }
                return HystrixCommandProperties.Setter.asMock(builder);
            }

            @Override
            public HystrixThreadPoolProperties getThreadPoolProperties(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter builder) {
                if (builder == null) {
                    builder = HystrixThreadPoolProperties.Setter.getUnitTestPropertiesBuilder();
                }
                return HystrixThreadPoolProperties.Setter.asMock(builder);
            }

            @Override
            public HystrixCollapserProperties getCollapserProperties(HystrixCollapserKey collapserKey, HystrixCollapserProperties.Setter builder) {
                throw new IllegalStateException("not expecting collapser properties");
            }

            @Override
            public String getCommandPropertiesCacheKey(HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
                return null;
            }

            @Override
            public String getThreadPoolPropertiesCacheKey(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter builder) {
                return null;
            }

            @Override
            public String getCollapserPropertiesCacheKey(HystrixCollapserKey collapserKey, HystrixCollapserProperties.Setter builder) {
                return null;
            }
        }

        static enum ThreadPoolKeyForUnitTest implements HystrixThreadPoolKey
        {
            THREAD_POOL_ONE,
            THREAD_POOL_TWO;

        }

        static enum CommandGroupForUnitTest implements HystrixCommandGroupKey
        {
            OWNER_ONE,
            OWNER_TWO;

        }

        static enum CommandKeyForUnitTest implements HystrixCommandKey
        {
            KEY_ONE,
            KEY_TWO;

        }

        private static class BadRequestCommand
        extends TestHystrixCommand<Boolean> {
            public BadRequestCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy isolationType) {
                super(BadRequestCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(isolationType)));
            }

            @Override
            protected Boolean run() {
                throw new HystrixBadRequestException("Message to developer that they passed in bad data or something like that.");
            }

            @Override
            protected Boolean getFallback() {
                return false;
            }
        }

        private static class RequestCacheTimeoutWithoutFallback
        extends TestHystrixCommand<Boolean> {
            public RequestCacheTimeoutWithoutFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(RequestCacheTimeoutWithoutFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(200)));
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            public String getCacheKey() {
                return "A";
            }
        }

        private static class RequestCacheNullPointerExceptionCase
        extends TestHystrixCommand<Boolean> {
            public RequestCacheNullPointerExceptionCase(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(RequestCacheNullPointerExceptionCase.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(200)));
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected Boolean getFallback() {
                return false;
            }

            @Override
            public String getCacheKey() {
                return "A";
            }
        }

        private static class TestSemaphoreCommandWithFallback
        extends TestHystrixCommand<Boolean> {
            private final long executionSleep;
            private final Boolean fallback;

            private TestSemaphoreCommandWithFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, int executionSemaphoreCount, long executionSleep, Boolean fallback) {
                super(TestSemaphoreCommandWithFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(executionSemaphoreCount)));
                this.executionSleep = executionSleep;
                this.fallback = fallback;
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(this.executionSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected Boolean getFallback() {
                return this.fallback;
            }
        }

        private static class TestSemaphoreCommand
        extends TestHystrixCommand<Boolean> {
            private final long executionSleep;

            private TestSemaphoreCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, int executionSemaphoreCount, long executionSleep) {
                super(TestSemaphoreCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(executionSemaphoreCount)));
                this.executionSleep = executionSleep;
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(this.executionSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }

        private static class TestSemaphoreCommandWithSlowFallback
        extends TestHystrixCommand<Boolean> {
            private final long fallbackSleep;

            private TestSemaphoreCommandWithSlowFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, int fallbackSemaphoreExecutionCount, long fallbackSleep) {
                super(TestSemaphoreCommandWithSlowFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withFallbackIsolationSemaphoreMaxConcurrentRequests(fallbackSemaphoreExecutionCount)));
                this.fallbackSleep = fallbackSleep;
            }

            @Override
            protected Boolean run() {
                throw new RuntimeException("run fails");
            }

            @Override
            protected Boolean getFallback() {
                try {
                    Thread.sleep(this.fallbackSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }

        private static class CommandWithCustomThreadPool
        extends TestHystrixCommand<Boolean> {
            public boolean didExecute = false;
            private final int sleepTime;

            private CommandWithCustomThreadPool(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, int sleepTime, HystrixCommandProperties.Setter properties) {
                super(CommandWithCustomThreadPool.testPropsBuilder().setThreadPool(threadPool).setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(properties));
                this.sleepTime = sleepTime;
            }

            @Override
            protected Boolean run() {
                System.out.println("**** Executing CommandWithCustomThreadPool. Execution => " + this.sleepTime);
                this.didExecute = true;
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }

        private static class TestCommandRejection
        extends TestHystrixCommand<Boolean> {
            private static final int FALLBACK_NOT_IMPLEMENTED = 1;
            private static final int FALLBACK_SUCCESS = 2;
            private static final int FALLBACK_FAILURE = 3;
            private final int fallbackBehavior;
            private final int sleepTime;

            private TestCommandRejection(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, int sleepTime, int timeout, int fallbackBehavior) {
                super(TestCommandRejection.testPropsBuilder().setThreadPool(threadPool).setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(timeout)));
                this.fallbackBehavior = fallbackBehavior;
                this.sleepTime = sleepTime;
            }

            @Override
            protected Boolean run() {
                System.out.println(">>> TestCommandRejection running");
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected Boolean getFallback() {
                if (this.fallbackBehavior == 2) {
                    return false;
                }
                if (this.fallbackBehavior == 3) {
                    throw new RuntimeException("failed on fallback");
                }
                return (Boolean)super.getFallback();
            }
        }

        private static class SingleThreadedPool
        implements HystrixThreadPool {
            final LinkedBlockingQueue<Runnable> queue;
            final ThreadPoolExecutor pool;
            private final int rejectionQueueSizeThreshold;

            public SingleThreadedPool(int queueSize) {
                this(queueSize, 100);
            }

            public SingleThreadedPool(int queueSize, int rejectionQueueSizeThreshold) {
                this.queue = new LinkedBlockingQueue(queueSize);
                this.pool = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, this.queue);
                this.rejectionQueueSizeThreshold = rejectionQueueSizeThreshold;
            }

            @Override
            public ThreadPoolExecutor getExecutor() {
                return this.pool;
            }

            @Override
            public void markThreadExecution() {
            }

            @Override
            public void markThreadCompletion() {
            }

            @Override
            public boolean isQueueSpaceAvailable() {
                return this.queue.size() < this.rejectionQueueSizeThreshold;
            }
        }

        private static class TestCommandWithTimeout
        extends TestHystrixCommand<Boolean> {
            private final long timeout;
            private static final int FALLBACK_NOT_IMPLEMENTED = 1;
            private static final int FALLBACK_SUCCESS = 2;
            private static final int FALLBACK_FAILURE = 3;
            private final int fallbackBehavior;

            private TestCommandWithTimeout(long timeout, int fallbackBehavior) {
                super(TestCommandWithTimeout.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds((int)timeout)));
                this.timeout = timeout;
                this.fallbackBehavior = fallbackBehavior;
            }

            @Override
            protected Boolean run() {
                System.out.println("***** running");
                try {
                    Thread.sleep(this.timeout * 2L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected Boolean getFallback() {
                if (this.fallbackBehavior == 2) {
                    return false;
                }
                if (this.fallbackBehavior == 3) {
                    throw new RuntimeException("failed on fallback");
                }
                return (Boolean)super.getFallback();
            }
        }

        private static class TestCommandWithoutCircuitBreaker
        extends TestHystrixCommand<Boolean> {
            private TestCommandWithoutCircuitBreaker() {
                super(TestCommandWithoutCircuitBreaker.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerEnabled(false)));
            }

            @Override
            protected Boolean run() {
                System.out.println("successfully executed");
                return true;
            }
        }

        private static class SuccessfulCacheableCommandViaSemaphore
        extends TestHystrixCommand<String> {
            private final boolean cacheEnabled;
            private volatile boolean executed = false;
            private final String value;

            public SuccessfulCacheableCommandViaSemaphore(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, boolean cacheEnabled, String value) {
                super(SuccessfulCacheableCommandViaSemaphore.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)));
                this.value = value;
                this.cacheEnabled = cacheEnabled;
            }

            @Override
            protected String run() {
                this.executed = true;
                System.out.println("successfully executed");
                return this.value;
            }

            public boolean isCommandRunningInThread() {
                return super.getProperties().executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
            }

            @Override
            public String getCacheKey() {
                if (this.cacheEnabled) {
                    return this.value;
                }
                return null;
            }
        }

        private static class SuccessfulCacheableCommand
        extends TestHystrixCommand<String> {
            private final boolean cacheEnabled;
            private volatile boolean executed = false;
            private final String value;

            public SuccessfulCacheableCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, boolean cacheEnabled, String value) {
                super(SuccessfulCacheableCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
                this.value = value;
                this.cacheEnabled = cacheEnabled;
            }

            @Override
            protected String run() {
                this.executed = true;
                System.out.println("successfully executed");
                return this.value;
            }

            public boolean isCommandRunningInThread() {
                return super.getProperties().executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
            }

            @Override
            public String getCacheKey() {
                if (this.cacheEnabled) {
                    return this.value;
                }
                return null;
            }
        }

        private static class KnownFailureTestCommandWithFallbackFailure
        extends TestHystrixCommand<Boolean> {
            private KnownFailureTestCommandWithFallbackFailure() {
                super(KnownFailureTestCommandWithFallbackFailure.testPropsBuilder());
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with a simulated issue");
            }

            @Override
            protected Boolean getFallback() {
                throw new RuntimeException("failed while getting fallback");
            }
        }

        private static class KnownFailureTestCommandWithFallback
        extends TestHystrixCommand<Boolean> {
            public KnownFailureTestCommandWithFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(KnownFailureTestCommandWithFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with a simulated issue");
            }

            @Override
            protected Boolean getFallback() {
                return false;
            }
        }

        private static class KnownFailureTestCommandWithoutFallback
        extends TestHystrixCommand<Boolean> {
            private KnownFailureTestCommandWithoutFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(KnownFailureTestCommandWithoutFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with a simulated issue");
            }
        }

        private static class UnknownFailureTestCommandWithoutFallback
        extends TestHystrixCommand<Boolean> {
            private UnknownFailureTestCommandWithoutFallback() {
                super(UnknownFailureTestCommandWithoutFallback.testPropsBuilder());
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with an unknown issue");
            }
        }

        private static class DynamicOwnerAndKeyTestCommand
        extends TestHystrixCommand<Boolean> {
            public DynamicOwnerAndKeyTestCommand(HystrixCommandGroupKey owner, HystrixCommandKey key) {
                super(DynamicOwnerAndKeyTestCommand.testPropsBuilder().setOwner(owner).setCommandKey(key).setCircuitBreaker(null).setMetrics(null));
            }

            @Override
            protected Boolean run() {
                System.out.println("successfully executed");
                return true;
            }
        }

        private static class DynamicOwnerTestCommand
        extends TestHystrixCommand<Boolean> {
            public DynamicOwnerTestCommand(HystrixCommandGroupKey owner) {
                super(DynamicOwnerTestCommand.testPropsBuilder().setOwner(owner));
            }

            @Override
            protected Boolean run() {
                System.out.println("successfully executed");
                return true;
            }
        }

        private static class SuccessfulTestCommand
        extends TestHystrixCommand<Boolean> {
            public SuccessfulTestCommand() {
                this(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter());
            }

            public SuccessfulTestCommand(HystrixCommandProperties.Setter properties) {
                super(SuccessfulTestCommand.testPropsBuilder().setCommandPropertiesDefaults(properties));
            }

            @Override
            protected Boolean run() {
                return true;
            }
        }

        static abstract class TestHystrixCommand<K>
        extends HystrixCommand<K> {
            final TestCommandBuilder builder;

            TestHystrixCommand(TestCommandBuilder builder) {
                super(builder.owner, builder.dependencyKey, builder.threadPoolKey, builder.circuitBreaker, builder.threadPool, builder.commandPropertiesDefaults, builder.threadPoolPropertiesDefaults, builder.metrics, builder.fallbackSemaphore, builder.executionSemaphore);
                this.builder = builder;
            }

            static TestCommandBuilder testPropsBuilder() {
                return new TestCommandBuilder();
            }

            static class TestCommandBuilder {
                HystrixCircuitBreaker.TestCircuitBreaker _cb = new HystrixCircuitBreaker.TestCircuitBreaker();
                HystrixCommandGroupKey owner = CommandGroupForUnitTest.OWNER_ONE;
                HystrixCommandKey dependencyKey = null;
                HystrixThreadPoolKey threadPoolKey = null;
                HystrixCircuitBreaker circuitBreaker = this._cb;
                HystrixThreadPool threadPool = null;
                HystrixCommandProperties.Setter commandPropertiesDefaults = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults = HystrixThreadPoolProperties.Setter.getUnitTestPropertiesBuilder();
                HystrixCommandMetrics metrics;
                TryableSemaphore fallbackSemaphore;
                TryableSemaphore executionSemaphore;

                TestCommandBuilder() {
                    this.metrics = this._cb.metrics;
                    this.fallbackSemaphore = null;
                    this.executionSemaphore = null;
                }

                TestCommandBuilder setOwner(HystrixCommandGroupKey owner) {
                    this.owner = owner;
                    return this;
                }

                TestCommandBuilder setCommandKey(HystrixCommandKey dependencyKey) {
                    this.dependencyKey = dependencyKey;
                    return this;
                }

                TestCommandBuilder setThreadPoolKey(HystrixThreadPoolKey threadPoolKey) {
                    this.threadPoolKey = threadPoolKey;
                    return this;
                }

                TestCommandBuilder setCircuitBreaker(HystrixCircuitBreaker circuitBreaker) {
                    this.circuitBreaker = circuitBreaker;
                    return this;
                }

                TestCommandBuilder setThreadPool(HystrixThreadPool threadPool) {
                    this.threadPool = threadPool;
                    return this;
                }

                TestCommandBuilder setCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
                    this.commandPropertiesDefaults = commandPropertiesDefaults;
                    return this;
                }

                TestCommandBuilder setThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
                    this.threadPoolPropertiesDefaults = threadPoolPropertiesDefaults;
                    return this;
                }

                TestCommandBuilder setMetrics(HystrixCommandMetrics metrics) {
                    this.metrics = metrics;
                    return this;
                }

                TestCommandBuilder setFallbackSemaphore(TryableSemaphore fallbackSemaphore) {
                    this.fallbackSemaphore = fallbackSemaphore;
                    return this;
                }

                TestCommandBuilder setExecutionSemaphore(TryableSemaphore executionSemaphore) {
                    this.executionSemaphore = executionSemaphore;
                    return this;
                }
            }
        }
    }

    @NotThreadSafe
    public static class Setter {
        private final HystrixCommandGroupKey groupKey;
        private HystrixCommandKey commandKey;
        private HystrixThreadPoolKey threadPoolKey;
        private HystrixCommandProperties.Setter commandPropertiesDefaults;
        private HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults;

        private Setter(HystrixCommandGroupKey groupKey) {
            this.groupKey = groupKey;
        }

        public static Setter withGroupKey(HystrixCommandGroupKey groupKey) {
            return new Setter(groupKey);
        }

        public Setter andCommandKey(HystrixCommandKey commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        public Setter andThreadPoolKey(HystrixThreadPoolKey threadPoolKey) {
            this.threadPoolKey = threadPoolKey;
            return this;
        }

        public Setter andCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
            this.commandPropertiesDefaults = commandPropertiesDefaults;
            return this;
        }

        public Setter andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
            this.threadPoolPropertiesDefaults = threadPoolPropertiesDefaults;
            return this;
        }
    }

    private static class TryableSemaphore {
        private final HystrixProperty<Integer> numberOfPermits;
        private static AtomicInteger count = new AtomicInteger(0);

        public TryableSemaphore(HystrixProperty<Integer> numberOfPermits) {
            this.numberOfPermits = numberOfPermits;
        }

        public boolean tryAcquire() {
            int currentCount = count.incrementAndGet();
            if (currentCount > this.numberOfPermits.get()) {
                count.decrementAndGet();
                return false;
            }
            return true;
        }

        public void release() {
            count.decrementAndGet();
        }

        public int getNumberOfPermitsUsed() {
            return count.get();
        }

        public int getNumberOfPermits() {
            return this.numberOfPermits.get();
        }
    }

    private static interface CommandFuture<K>
    extends Future<K> {
        public ExecutionResult getExecutionResult();
    }

    private class QueuedExecutionFuture
    implements CommandFuture<R> {
        private final ThreadPoolExecutor executor;
        private final Callable<R> callable;
        private final HystrixCommand<R> command;
        private final long startTime;
        private final CountDownLatch actualResponseReceived = new CountDownLatch(1);
        private final AtomicBoolean actualFutureExecuted = new AtomicBoolean(false);
        private volatile R result;
        private volatile ExecutionException executionException;
        private volatile Future<R> actualFuture = null;
        private final CountDownLatch futureStarted = new CountDownLatch(1);
        private final AtomicBoolean started = new AtomicBoolean(false);

        public QueuedExecutionFuture(HystrixCommand<R> command, long startTime, ThreadPoolExecutor executor, Callable<R> callable) {
            this.command = command;
            this.startTime = startTime;
            this.executor = executor;
            this.callable = callable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start() {
            if (this.started.compareAndSet(false, true)) {
                try {
                    if (!HystrixCommand.this.threadPool.isQueueSpaceAvailable()) {
                        throw new RejectedExecutionException("Rejected command because thread-pool queueSize is at rejection threshold.");
                    }
                    this.actualFuture = this.executor.submit(HystrixCommand.this.concurrencyStrategy.wrapCallable(this.callable));
                }
                catch (RejectedExecutionException e) {
                    HystrixCommand.this.metrics.markThreadPoolRejection();
                    this.actualFuture = HystrixCommand.this.asFuture(HystrixCommand.this.getFallbackOrThrowException(HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "could not be queued for execution", e));
                }
                catch (Exception e) {
                    logger.error(HystrixCommand.this.getLogMessagePrefix() + ": Unexpected exception while submitting to queue.", (Throwable)e);
                    this.actualFuture = HystrixCommand.this.asFuture(HystrixCommand.this.getFallbackOrThrowException(HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "had unexpected exception while attempting to queue for execution.", e));
                }
                finally {
                    this.futureStarted.countDown();
                }
            } else {
                try {
                    this.futureStarted.await();
                }
                catch (InterruptedException e) {
                    logger.error(HystrixCommand.this.getLogMessagePrefix() + ": Unexpected interruption while waiting on other thread submitting to queue.", (Throwable)e);
                    this.actualFuture = HystrixCommand.this.asFuture(HystrixCommand.this.getFallbackOrThrowException(HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "Unexpected interruption while waiting on other thread submitting to queue.", e));
                }
            }
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws CancellationException, InterruptedException, ExecutionException {
            this.start();
            if (this.actualFutureExecuted.compareAndSet(false, true)) {
                this.performActualGet();
            } else {
                this.actualResponseReceived.await();
            }
            if (this.executionException != null) {
                throw this.executionException;
            }
            return this.result;
        }

        @Override
        public R get() throws CancellationException, InterruptedException, ExecutionException {
            return this.get(HystrixCommand.this.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue(), TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performActualGet() throws CancellationException, InterruptedException, ExecutionException {
            try {
                if (!this.started.get() || this.actualFuture == null) {
                    throw new IllegalStateException("Future was not started.");
                }
                this.result = this.actualFuture.get(HystrixCommand.this.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.actualFuture.cancel(HystrixCommand.this.properties.executionIsolationThreadInterruptOnTimeout().get());
                if (HystrixCommand.this.isCommandTimedOut.compareAndSet(false, true)) {
                    HystrixCommand.this.metrics.markTimeout(System.currentTimeMillis() - this.startTime);
                }
                try {
                    this.result = HystrixCommand.this.getFallbackOrThrowException(HystrixEventType.TIMEOUT, HystrixRuntimeException.FailureType.TIMEOUT, "timed-out", e);
                }
                catch (HystrixRuntimeException re) {
                    this.executionException = new ExecutionException(re);
                    HystrixCommand.this.metrics.markExceptionThrown();
                }
            }
            finally {
                this.actualResponseReceived.countDown();
            }
        }

        @Override
        public ExecutionResult getExecutionResult() {
            return HystrixCommand.this.executionResult;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.actualFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.actualFuture.isDone();
        }
    }

    private static class ExecutionResult {
        private final List<HystrixEventType> events;
        private final int executionTime;
        private final Throwable exception;
        private static ExecutionResult EMPTY = new ExecutionResult(new HystrixEventType[0]);

        private ExecutionResult(HystrixEventType ... events) {
            this(Arrays.asList(events), -1, null);
        }

        public ExecutionResult setExecutionTime(int executionTime) {
            return new ExecutionResult(this.events, executionTime, this.exception);
        }

        public ExecutionResult setException(Throwable e) {
            return new ExecutionResult(this.events, this.executionTime, e);
        }

        private ExecutionResult(List<HystrixEventType> events, int executionTime, Throwable e) {
            this.events = events;
            this.executionTime = executionTime;
            this.exception = e;
        }

        public ExecutionResult addEvents(HystrixEventType ... events) {
            ArrayList<HystrixEventType> newEvents = new ArrayList<HystrixEventType>();
            newEvents.addAll(this.events);
            for (HystrixEventType e : events) {
                newEvents.add(e);
            }
            return new ExecutionResult(Collections.unmodifiableList(newEvents), this.executionTime, this.exception);
        }

        static /* synthetic */ ExecutionResult access$000() {
            return EMPTY;
        }
    }
}

