/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifierDefault;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherDefault;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategyDefault;

public class HystrixPlugins {
    private static final HystrixPlugins INSTANCE = new HystrixPlugins();
    private volatile HystrixEventNotifier notifier = null;
    private volatile HystrixConcurrencyStrategy concurrencyStrategy = null;
    private volatile HystrixMetricsPublisher metricsPublisher = null;
    private volatile HystrixPropertiesStrategy propertiesFactory = null;

    private HystrixPlugins() {
    }

    public static HystrixPlugins getInstance() {
        return INSTANCE;
    }

    public HystrixEventNotifier getEventNotifier() {
        if (this.notifier != null) {
            return this.notifier;
        }
        return HystrixEventNotifierDefault.getInstance();
    }

    public void registerEventNotifier(HystrixEventNotifier impl) {
        this.notifier = impl;
    }

    public HystrixConcurrencyStrategy getConcurrencyStrategy() {
        if (this.concurrencyStrategy != null) {
            return this.concurrencyStrategy;
        }
        return HystrixConcurrencyStrategyDefault.getInstance();
    }

    public void registerConcurrencyStrategy(HystrixConcurrencyStrategy impl) {
        this.concurrencyStrategy = impl;
    }

    public HystrixMetricsPublisher getMetricsPublisher() {
        if (this.metricsPublisher != null) {
            return this.metricsPublisher;
        }
        return HystrixMetricsPublisherDefault.getInstance();
    }

    public void registerMetricsPublisher(HystrixMetricsPublisher impl) {
        this.metricsPublisher = impl;
    }

    public HystrixPropertiesStrategy getPropertiesStrategy() {
        if (this.propertiesFactory != null) {
            return this.propertiesFactory;
        }
        return HystrixPropertiesStrategyDefault.getInstance();
    }

    public void registerPropertiesStrategy(HystrixPropertiesStrategy impl) {
        this.propertiesFactory = impl;
    }
}

