/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedArchaiusProperty;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import javax.annotation.concurrent.NotThreadSafe;

public abstract class HystrixCollapserProperties {
    private static final Integer default_maxRequestsInBatch = Integer.MAX_VALUE;
    private static final Integer default_timerDelayInMilliseconds = 10;
    private static final Boolean default_requestCacheEnabled = true;
    private final HystrixProperty<Integer> maxRequestsInBatch;
    private final HystrixProperty<Integer> timerDelayInMilliseconds;
    private final HystrixProperty<Boolean> requestCacheEnabled;

    protected HystrixCollapserProperties(HystrixCollapserKey collapserKey) {
        this(collapserKey, new Setter(), "hystrix");
    }

    protected HystrixCollapserProperties(HystrixCollapserKey collapserKey, Setter builder) {
        this(collapserKey, builder, "hystrix");
    }

    protected HystrixCollapserProperties(HystrixCollapserKey key, Setter builder, String propertyPrefix) {
        this.maxRequestsInBatch = HystrixCollapserProperties.getProperty(propertyPrefix, key, "maxRequestsInBatch", builder.getMaxRequestsInBatch(), default_maxRequestsInBatch);
        this.timerDelayInMilliseconds = HystrixCollapserProperties.getProperty(propertyPrefix, key, "timerDelayInMilliseconds", builder.getTimerDelayInMilliseconds(), default_timerDelayInMilliseconds);
        this.requestCacheEnabled = HystrixCollapserProperties.getProperty(propertyPrefix, key, "requestCache.enabled", builder.getRequestCacheEnabled(), default_requestCacheEnabled);
    }

    private static HystrixProperty<Integer> getProperty(String propertyPrefix, HystrixCollapserKey key, String instanceProperty, Integer builderOverrideValue, Integer defaultValue) {
        return HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.IntegerProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicIntegerProperty(propertyPrefix + ".collapser." + key.name() + "." + instanceProperty, builderOverrideValue), new HystrixPropertiesChainedArchaiusProperty.DynamicIntegerProperty(propertyPrefix + ".collapser.default." + instanceProperty, defaultValue)));
    }

    private static HystrixProperty<Boolean> getProperty(String propertyPrefix, HystrixCollapserKey key, String instanceProperty, Boolean builderOverrideValue, Boolean defaultValue) {
        return HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.BooleanProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicBooleanProperty(propertyPrefix + ".collapser." + key.name() + "." + instanceProperty, builderOverrideValue), new HystrixPropertiesChainedArchaiusProperty.DynamicBooleanProperty(propertyPrefix + ".collapser.default." + instanceProperty, defaultValue)));
    }

    private static HystrixProperty<String> getProperty(String propertyPrefix, HystrixCollapserKey key, String instanceProperty, String builderOverrideValue, String defaultValue) {
        return HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.StringProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty(propertyPrefix + ".collapser." + key.name() + "." + instanceProperty, builderOverrideValue), new HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty(propertyPrefix + ".collapser.default." + instanceProperty, defaultValue)));
    }

    public HystrixProperty<Boolean> requestCachingEnabled() {
        return this.requestCacheEnabled;
    }

    public HystrixProperty<Integer> maxRequestsInBatch() {
        return this.maxRequestsInBatch;
    }

    public HystrixProperty<Integer> timerDelayInMilliseconds() {
        return this.timerDelayInMilliseconds;
    }

    public static Setter Setter() {
        return new Setter();
    }

    @NotThreadSafe
    public static class Setter {
        private Boolean collapsingEnabled = null;
        private Integer maxRequestsInBatch = null;
        private Integer timerDelayInMilliseconds = null;
        private Boolean requestCacheEnabled = null;

        private Setter() {
        }

        public Boolean getCollapsingEnabled() {
            return this.collapsingEnabled;
        }

        public Integer getMaxRequestsInBatch() {
            return this.maxRequestsInBatch;
        }

        public Integer getTimerDelayInMilliseconds() {
            return this.timerDelayInMilliseconds;
        }

        public Boolean getRequestCacheEnabled() {
            return this.requestCacheEnabled;
        }

        public Setter withCollapsingEnabled(boolean value) {
            this.collapsingEnabled = value;
            return this;
        }

        public Setter withMaxRequestsInBatch(int value) {
            this.maxRequestsInBatch = value;
            return this;
        }

        public Setter withTimerDelayInMilliseconds(int value) {
            this.timerDelayInMilliseconds = value;
            return this;
        }

        public Setter withRequestCacheEnabled(boolean value) {
            this.requestCacheEnabled = value;
            return this;
        }

        static Setter getUnitTestPropertiesBuilder() {
            return new Setter().withMaxRequestsInBatch(Integer.MAX_VALUE).withTimerDelayInMilliseconds(10).withRequestCacheEnabled(true);
        }

        static HystrixCollapserProperties asMock(final Setter builder) {
            return new HystrixCollapserProperties(TestHystrixCollapserKey.TEST){

                @Override
                public HystrixProperty<Boolean> requestCachingEnabled() {
                    return HystrixProperty.Factory.asProperty(builder.requestCacheEnabled);
                }

                @Override
                public HystrixProperty<Integer> maxRequestsInBatch() {
                    return HystrixProperty.Factory.asProperty(builder.maxRequestsInBatch);
                }

                @Override
                public HystrixProperty<Integer> timerDelayInMilliseconds() {
                    return HystrixProperty.Factory.asProperty(builder.timerDelayInMilliseconds);
                }
            };
        }

        private static enum TestHystrixCollapserKey implements HystrixCollapserKey
        {
            TEST;

        }
    }
}

