/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.collapser.CollapserTimer;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import com.netflix.hystrix.collapser.RealCollapserTimer;
import com.netflix.hystrix.collapser.RequestCollapser;
import com.netflix.hystrix.collapser.RequestCollapserFactory;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.concurrency.Schedulers;
import rx.subjects.ReplaySubject;

public abstract class HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType>
implements HystrixExecutable<ResponseType> {
    static final Logger logger = LoggerFactory.getLogger(HystrixCollapser.class);
    private final RequestCollapserFactory<BatchReturnType, ResponseType, RequestArgumentType> collapserFactory;
    private final HystrixRequestCache requestCache;
    private final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> collapserInstanceWrapper;
    private static ConcurrentHashMap<Class<? extends HystrixCollapser>, String> defaultNameCache = new ConcurrentHashMap();

    protected HystrixCollapser() {
        this(Setter.withCollapserKey(null).andScope(Scope.REQUEST));
    }

    protected HystrixCollapser(HystrixCollapserKey collapserKey) {
        this(Setter.withCollapserKey(collapserKey).andScope(Scope.REQUEST));
    }

    protected HystrixCollapser(Setter setter) {
        this(setter.collapserKey, setter.scope, new RealCollapserTimer(), setter.propertiesSetter);
    }

    private HystrixCollapser(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixCollapserProperties.Setter propertiesBuilder) {
        if (collapserKey == null || collapserKey.name().trim().equals("")) {
            String defaultKeyName = HystrixCollapser.getDefaultNameFromClass(this.getClass());
            collapserKey = HystrixCollapserKey.Factory.asKey(defaultKeyName);
        }
        this.collapserFactory = new RequestCollapserFactory(collapserKey, scope, timer, propertiesBuilder);
        this.requestCache = HystrixRequestCache.getInstance(collapserKey, HystrixPlugins.getInstance().getConcurrencyStrategy());
        final HystrixCollapser self = this;
        this.collapserInstanceWrapper = new HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType>(){

            @Override
            public Collection<Collection<CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                return self.shardRequests(requests);
            }

            @Override
            public Observable<BatchReturnType> createObservableCommand(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                HystrixCommand command = self.createCommand(requests);
                command.markAsCollapsedCommand(requests.size());
                return command.toObservable();
            }

            @Override
            public void mapResponseToRequests(BatchReturnType batchResponse, Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                self.mapResponseToRequests(batchResponse, requests);
            }

            @Override
            public HystrixCollapserKey getCollapserKey() {
                return self.getCollapserKey();
            }
        };
    }

    private HystrixCollapserProperties getProperties() {
        return this.collapserFactory.getProperties();
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserFactory.getCollapserKey();
    }

    public Scope getScope() {
        return this.collapserFactory.getScope();
    }

    public abstract RequestArgumentType getRequestArgument();

    protected abstract HystrixCommand<BatchReturnType> createCommand(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> var1);

    protected Collection<Collection<CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
        return Collections.singletonList(requests);
    }

    protected abstract void mapResponseToRequests(BatchReturnType var1, Collection<CollapsedRequest<ResponseType, RequestArgumentType>> var2);

    @Override
    public Observable<ResponseType> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.toObservable().subscribe((Observer)subject);
        return subject;
    }

    public Observable<ResponseType> toObservable() {
        return this.toObservable(Schedulers.threadPoolForComputation());
    }

    public Observable<ResponseType> toObservable(Scheduler observeOn) {
        Observable fromCache;
        if (this.getProperties().requestCachingEnabled().get().booleanValue() && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
            return fromCache;
        }
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> requestCollapser = this.collapserFactory.getRequestCollapser(this.collapserInstanceWrapper);
        Observable response = requestCollapser.submitRequest(this.getRequestArgument());
        if (this.getProperties().requestCachingEnabled().get().booleanValue()) {
            Observable o = response.cache();
            Observable fromCache2 = this.requestCache.putIfAbsent(this.getCacheKey(), o);
            response = fromCache2 == null ? o : fromCache2;
        }
        return response;
    }

    @Override
    public ResponseType execute() {
        try {
            return this.queue().get();
        }
        catch (Throwable e) {
            if (e instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e;
            }
            if (e.getCause() instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e.getCause();
            }
            String message = this.getClass().getSimpleName() + " HystrixCollapser failed while executing.";
            logger.debug(message, e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public Future<ResponseType> queue() {
        Observable<ResponseType> o = this.toObservable();
        return o.toBlockingObservable().toFuture();
    }

    protected String getCacheKey() {
        return null;
    }

    static void reset() {
        RequestCollapserFactory.reset();
    }

    private static String getDefaultNameFromClass(Class<? extends HystrixCollapser> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    public static class UnitTests {
        static AtomicInteger counter = new AtomicInteger();

        @Before
        public void init() {
            counter.set(0);
            HystrixCollapser.reset();
            HystrixRequestContext.initializeContext();
        }

        @After
        public void cleanup() {
            if (HystrixRequestContext.getContextForCurrentThread() != null) {
                HystrixRequestContext.getContextForCurrentThread().shutdown();
            }
        }

        @Test
        public void testTwoRequests() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testMultipleBatches() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testMaxRequestsInBatch() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1, 2, 10).queue();
            Future response2 = new TestRequestCollapser(timer, counter, 2, 2, 10).queue();
            Future response3 = new TestRequestCollapser(timer, counter, 3, 2, 10).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestsOverTime() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            timer.incrementTime(5);
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(8);
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(6);
            Future response4 = new TestRequestCollapser(timer, counter, 4).queue();
            timer.incrementTime(8);
            Future response5 = new TestRequestCollapser(timer, counter, 5).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((Object)"5", response5.get());
            System.out.println("number of executions: " + counter.get());
            Assert.assertEquals((long)3L, (long)counter.get());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testUnsubscribeOnOneDoesntKillBatch() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            response1.cancel(true);
            timer.incrementTime(10);
            Assert.assertEquals(null, response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testShardedRequests() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestShardedRequestCollapser(timer, counter, "1a").queue();
            Future response2 = new TestShardedRequestCollapser(timer, counter, "2b").queue();
            Future response3 = new TestShardedRequestCollapser(timer, counter, "3b").queue();
            Future response4 = new TestShardedRequestCollapser(timer, counter, "4a").queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1a", response1.get());
            Assert.assertEquals((Object)"2b", response2.get());
            Assert.assertEquals((Object)"3b", response3.get());
            Assert.assertEquals((Object)"4a", response4.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestScope() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, "1").queue();
            Future response2 = new TestRequestCollapser(timer, counter, "2").queue();
            RequestCollapserFactory.resetRequest();
            Future response3 = new TestRequestCollapser(timer, counter, "3").queue();
            Future response4 = new TestRequestCollapser(timer, counter, "4").queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testGlobalScope() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestGloballyScopedRequestCollapser(timer, counter, "1").queue();
            Future response2 = new TestGloballyScopedRequestCollapser(timer, counter, "2").queue();
            RequestCollapserFactory.resetRequest();
            Future response3 = new TestGloballyScopedRequestCollapser(timer, counter, "3").queue();
            Future response4 = new TestGloballyScopedRequestCollapser(timer, counter, "4").queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testErrorHandlingViaFutureException() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapserWithFaultyCreateCommand(timer, counter, "1").queue();
            Future response2 = new TestRequestCollapserWithFaultyCreateCommand(timer, counter, "2").queue();
            timer.incrementTime(10);
            try {
                response1.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            try {
                response2.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)0L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testErrorHandlingWhenMapToResponseFails() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapserWithFaultyMapToResponse(timer, counter, "1").queue();
            Future response2 = new TestRequestCollapserWithFaultyMapToResponse(timer, counter, "2").queue();
            timer.incrementTime(10);
            try {
                response1.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            try {
                response2.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestVariableLifecycle1() throws Exception {
            HystrixRequestContext requestContext = HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapser(timer, counter, 1).queue();
            timer.incrementTime(5);
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(8);
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(6);
            Future response4 = new TestRequestCollapser(timer, counter, 4).queue();
            timer.incrementTime(8);
            Future response5 = new TestRequestCollapser(timer, counter, 5).queue();
            timer.incrementTime(10);
            Assert.assertEquals((Object)"1", response1.get());
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((Object)"5", response5.get());
            for (TestCollapserTimer.ATask t : timer.tasks) {
                Assert.assertEquals((long)3L, (long)t.task.count.get());
            }
            System.out.println("timer.tasks.size() A: " + timer.tasks.size());
            System.out.println("tasks in test: " + timer.tasks);
            requestContext.shutdown();
            System.out.println("timer.tasks.size() B: " + timer.tasks.size());
            HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>> rv = RequestCollapserFactory.getRequestVariable(new TestRequestCollapser(timer, counter, 1).getCollapserKey().name());
            Assert.assertNotNull(rv);
            Assert.assertEquals((long)0L, (long)timer.tasks.size());
        }

        @Test
        public void testRequestVariableLifecycle2() throws Exception {
            HystrixRequestContext requestContext = HystrixRequestContext.initializeContext();
            final TestCollapserTimer timer = new TestCollapserTimer();
            final ConcurrentLinkedQueue responses = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue<Thread> threads = new ConcurrentLinkedQueue<Thread>();
            for (int t = 0; t < 5; ++t) {
                Thread th = new Thread(new HystrixContextRunnable(HystrixPlugins.getInstance().getConcurrencyStrategy(), new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 100; ++i) {
                            responses.add(new TestRequestCollapser(timer, counter, 1).queue());
                        }
                    }
                }));
                threads.add(th);
                th.start();
            }
            for (Thread th : threads) {
                th.join();
            }
            Assert.assertEquals((long)500L, (long)responses.size());
            for (Future f : responses) {
                Assert.assertFalse((boolean)f.isDone());
            }
            timer.incrementTime(5);
            Future response2 = new TestRequestCollapser(timer, counter, 2).queue();
            timer.incrementTime(8);
            Future response3 = new TestRequestCollapser(timer, counter, 3).queue();
            timer.incrementTime(6);
            Future response4 = new TestRequestCollapser(timer, counter, 4).queue();
            timer.incrementTime(8);
            Future response5 = new TestRequestCollapser(timer, counter, 5).queue();
            timer.incrementTime(10);
            for (Future f : responses) {
                Assert.assertEquals((Object)"1", f.get());
            }
            Assert.assertEquals((Object)"2", response2.get());
            Assert.assertEquals((Object)"3", response3.get());
            Assert.assertEquals((Object)"4", response4.get());
            Assert.assertEquals((Object)"5", response5.get());
            for (TestCollapserTimer.ATask t : timer.tasks) {
                Assert.assertEquals((long)3L, (long)t.task.count.get());
            }
            requestContext.shutdown();
            HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>> rv = RequestCollapserFactory.getRequestVariable(new TestRequestCollapser(timer, counter, 1).getCollapserKey().name());
            Assert.assertNotNull(rv);
            Assert.assertEquals((long)0L, (long)timer.tasks.size());
        }

        @Test
        public void testRequestCache1() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f3 = command1.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCache2() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", true);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f3 = command1.queue();
            Future f4 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
                Assert.assertEquals((Object)"B", f4.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCache3() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", true);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", true);
            SuccessfulCacheableCollapsedCommand command3 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", true);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"B", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f4 = command1.queue();
            Future f5 = command2.queue();
            Future f6 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f4.get());
                Assert.assertEquals((Object)"B", f5.get());
                Assert.assertEquals((Object)"B", f6.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testNoRequestCache3() {
            HystrixRequestContext.initializeContext();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "A", false);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", false);
            SuccessfulCacheableCollapsedCommand command3 = new SuccessfulCacheableCollapsedCommand(timer, counter, "B", false);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"B", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Future f4 = command1.queue();
            Future f5 = command2.queue();
            Future f6 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f4.get());
                Assert.assertEquals((Object)"B", f5.get());
                Assert.assertEquals((Object)"B", f6.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)2L, (long)counter.get());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand commandA = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[2])[0];
            Assert.assertEquals((long)2L, (long)commandA.getExecutionEvents().size());
            Assert.assertTrue((boolean)commandA.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)commandA.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
            HystrixCommand commandB = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[2])[1];
            Assert.assertEquals((long)2L, (long)commandB.getExecutionEvents().size());
            Assert.assertTrue((boolean)commandB.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)commandB.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCacheWithException() {
            HystrixRequestContext.initializeContext();
            ConcurrentLinkedQueue<HystrixCommand<List<String>>> commands = new ConcurrentLinkedQueue<HystrixCommand<List<String>>>();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, null, true, commands);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, null, true, commands);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.FAILURE));
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
            SuccessfulCacheableCollapsedCommand command3 = new SuccessfulCacheableCollapsedCommand(timer, counter, null, true, commands);
            Future f3 = command3.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand command = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[1])[0];
            Assert.assertEquals((long)2L, (long)command.getExecutionEvents().size());
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.FAILURE));
            Assert.assertTrue((boolean)command.getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
        }

        @Test
        public void testRequestCacheWithTimeout() {
            HystrixRequestContext.initializeContext();
            ConcurrentLinkedQueue<HystrixCommand<List<String>>> commands = new ConcurrentLinkedQueue<HystrixCommand<List<String>>>();
            TestCollapserTimer timer = new TestCollapserTimer();
            SuccessfulCacheableCollapsedCommand command1 = new SuccessfulCacheableCollapsedCommand(timer, counter, "TIMEOUT", true, commands);
            SuccessfulCacheableCollapsedCommand command2 = new SuccessfulCacheableCollapsedCommand(timer, counter, "TIMEOUT", true, commands);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.TIMEOUT));
            Assert.assertTrue((boolean)commands.peek().getExecutionEvents().contains((Object)HystrixEventType.COLLAPSED));
            Future f3 = command1.queue();
            timer.incrementTime(15);
            try {
                Assert.assertEquals((Object)"A", f3.get());
                Assert.fail((String)"exception should have been thrown");
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)commands.size());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestWithCommandShortCircuited() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestRequestCollapserWithShortCircuitedCommand(timer, counter, "1").queue();
            Future response2 = new TestRequestCollapserWithShortCircuitedCommand(timer, counter, "2").queue();
            timer.incrementTime(10);
            try {
                response1.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            try {
                response2.get();
                Assert.fail((String)"we should have received an exception");
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testVoidResponseTypeFireAndForgetCollapsing1() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestCollapserWithVoidResponseType(timer, counter, 1).queue();
            Future response2 = new TestCollapserWithVoidResponseType(timer, counter, 2).queue();
            timer.incrementTime(100);
            Assert.assertEquals(null, response1.get());
            Assert.assertEquals(null, response2.get());
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testVoidResponseTypeFireAndForgetCollapsing2() throws Exception {
            TestCollapserTimer timer = new TestCollapserTimer();
            Future response1 = new TestCollapserWithVoidResponseTypeAndMissingMapResponseToRequests(timer, counter, 1).queue();
            Future response2 = new TestCollapserWithVoidResponseTypeAndMissingMapResponseToRequests(timer, counter, 2).queue();
            timer.incrementTime(100);
            try {
                Assert.assertEquals(null, response1.get());
                Assert.fail((String)"expected an error as mapResponseToRequests did not set responses");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
                Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("No response set by"));
            }
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testVoidResponseTypeFireAndForgetCollapsing3() throws Exception {
            RealCollapserTimer timer = new RealCollapserTimer();
            Assert.assertNull(new TestCollapserWithVoidResponseType(timer, counter, 1).execute());
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        private static HystrixCollapserKey collapserKeyFromString(final Object o) {
            return new HystrixCollapserKey(){

                @Override
                public String name() {
                    return String.valueOf(o);
                }
            };
        }

        private static class TestCollapserWithVoidResponseTypeAndMissingMapResponseToRequests
        extends HystrixCollapser<Void, Void, Integer> {
            private final AtomicInteger count;
            private final Integer value;

            public TestCollapserWithVoidResponseTypeAndMissingMapResponseToRequests(CollapserTimer timer, AtomicInteger counter, int value) {
                super(UnitTests.collapserKeyFromString(timer), Scope.REQUEST, timer, HystrixCollapserProperties.Setter().withMaxRequestsInBatch(1000).withTimerDelayInMilliseconds(50));
                this.count = counter;
                this.value = value;
            }

            @Override
            public Integer getRequestArgument() {
                return this.value;
            }

            @Override
            protected HystrixCommand<Void> createCommand(Collection<CollapsedRequest<Void, Integer>> requests) {
                ArrayList<Integer> args = new ArrayList<Integer>();
                for (CollapsedRequest<Void, Integer> request : requests) {
                    args.add(request.getArgument());
                }
                return new FireAndForgetCommand(args);
            }

            @Override
            protected void mapResponseToRequests(Void batchResponse, Collection<CollapsedRequest<Void, Integer>> requests) {
                this.count.incrementAndGet();
            }
        }

        private static class TestCollapserWithVoidResponseType
        extends HystrixCollapser<Void, Void, Integer> {
            private final AtomicInteger count;
            private final Integer value;

            public TestCollapserWithVoidResponseType(CollapserTimer timer, AtomicInteger counter, int value) {
                super(UnitTests.collapserKeyFromString(timer), Scope.REQUEST, timer, HystrixCollapserProperties.Setter().withMaxRequestsInBatch(1000).withTimerDelayInMilliseconds(50));
                this.count = counter;
                this.value = value;
            }

            @Override
            public Integer getRequestArgument() {
                return this.value;
            }

            @Override
            protected HystrixCommand<Void> createCommand(Collection<CollapsedRequest<Void, Integer>> requests) {
                ArrayList<Integer> args = new ArrayList<Integer>();
                for (CollapsedRequest<Void, Integer> request : requests) {
                    args.add(request.getArgument());
                }
                return new FireAndForgetCommand(args);
            }

            @Override
            protected void mapResponseToRequests(Void batchResponse, Collection<CollapsedRequest<Void, Integer>> requests) {
                this.count.incrementAndGet();
                for (CollapsedRequest<Void, Integer> r : requests) {
                    r.setResponse(null);
                }
            }
        }

        private static class TestTimerListener
        implements HystrixTimer.TimerListener {
            private final HystrixTimer.TimerListener actualListener;
            private final AtomicInteger count = new AtomicInteger();

            public TestTimerListener(HystrixTimer.TimerListener actual) {
                this.actualListener = actual;
            }

            @Override
            public void tick() {
                this.count.incrementAndGet();
                this.actualListener.tick();
            }

            @Override
            public int getIntervalTimeInMilliseconds() {
                return 10;
            }
        }

        private static class TestCollapserTimer
        implements CollapserTimer {
            private final ConcurrentLinkedQueue<ATask> tasks = new ConcurrentLinkedQueue();

            private TestCollapserTimer() {
            }

            @Override
            public Reference<HystrixTimer.TimerListener> addListener(final HystrixTimer.TimerListener collapseTask) {
                System.out.println("add listener: " + collapseTask);
                this.tasks.add(new ATask(new TestTimerListener(collapseTask)));
                return new SoftReference<HystrixTimer.TimerListener>(collapseTask){

                    @Override
                    public void clear() {
                        System.out.println("tasks: " + TestCollapserTimer.this.tasks);
                        System.out.println("**** clear TimerListener: tasks.size => " + TestCollapserTimer.this.tasks.size());
                        for (ATask t : TestCollapserTimer.this.tasks) {
                            if (!t.task.actualListener.equals(collapseTask)) continue;
                            TestCollapserTimer.this.tasks.remove(t);
                        }
                    }
                };
            }

            public synchronized void incrementTime(int timeInMilliseconds) {
                for (ATask t : this.tasks) {
                    t.incrementTime(timeInMilliseconds);
                }
            }

            private static class ATask {
                final TestTimerListener task;
                final int delay = 10;
                volatile int time = 0;
                volatile int executionCount = 0;

                private ATask(TestTimerListener task) {
                    this.task = task;
                }

                public synchronized void incrementTime(int timeInMilliseconds) {
                    this.time += timeInMilliseconds;
                    if (this.task != null) {
                        if (this.executionCount == 0) {
                            System.out.println("ExecutionCount 0 => Time: " + this.time + " Delay: " + 10);
                            if (this.time >= 10) {
                                this.executeTask();
                            }
                        } else {
                            System.out.println("ExecutionCount 1+ => Time: " + this.time + " Delay: " + 10);
                            if (this.time >= 10) {
                                this.executeTask();
                            }
                        }
                    }
                }

                private synchronized void executeTask() {
                    System.out.println("Executing task ...");
                    this.task.tick();
                    this.time = 0;
                    ++this.executionCount;
                    System.out.println("executionCount: " + this.executionCount);
                }
            }
        }

        private static class FireAndForgetCommand
        extends HystrixCommand<Void> {
            protected FireAndForgetCommand(List<Integer> values) {
                super(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("fireAndForgetCommand")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter()));
            }

            @Override
            protected Void run() throws Exception {
                System.out.println("*** FireAndForgetCommand execution: " + Thread.currentThread());
                return null;
            }
        }

        private static class ShortCircuitedCommand
        extends HystrixCommand<List<String>> {
            protected ShortCircuitedCommand() {
                super(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("shortCircuitedCommand")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerForceOpen(true)));
            }

            @Override
            protected List<String> run() throws Exception {
                System.out.println("*** execution (this shouldn't happen)");
                ArrayList<String> values = new ArrayList<String>();
                values.add("hello");
                return values;
            }
        }

        private static class SuccessfulCacheableCollapsedCommand
        extends TestRequestCollapser {
            private final boolean cacheEnabled;

            public SuccessfulCacheableCollapsedCommand(TestCollapserTimer timer, AtomicInteger counter, String value, boolean cacheEnabled) {
                super(timer, counter, value);
                this.cacheEnabled = cacheEnabled;
            }

            public SuccessfulCacheableCollapsedCommand(TestCollapserTimer timer, AtomicInteger counter, String value, boolean cacheEnabled, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                super(timer, counter, value, executionLog);
                this.cacheEnabled = cacheEnabled;
            }

            @Override
            public String getCacheKey() {
                if (this.cacheEnabled) {
                    return "aCacheKey_" + ((TestRequestCollapser)this).value;
                }
                return null;
            }
        }

        private static class TestCollapserCommand
        extends HystrixCommand.UnitTest.TestHystrixCommand<List<String>> {
            private final Collection<CollapsedRequest<String, String>> requests;

            TestCollapserCommand(Collection<CollapsedRequest<String, String>> requests) {
                super(TestCollapserCommand.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(50)));
                this.requests = requests;
            }

            @Override
            protected List<String> run() {
                System.out.println(">>> TestCollapserCommand run() ... batch size: " + this.requests.size());
                ArrayList<String> response = new ArrayList<String>();
                for (CollapsedRequest<String, String> request : this.requests) {
                    if (request.getArgument() == null) {
                        throw new NullPointerException("Simulated Error");
                    }
                    if (request.getArgument() == "TIMEOUT") {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    response.add(request.getArgument());
                }
                return response;
            }
        }

        private static class TestRequestCollapserWithFaultyMapToResponse
        extends TestRequestCollapser {
            public TestRequestCollapserWithFaultyMapToResponse(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(timer, counter, value);
            }

            @Override
            public void mapResponseToRequests(List<String> batchResponse, Collection<CollapsedRequest<String, String>> requests) {
                throw new NullPointerException("batchResponse was null and we blew up");
            }
        }

        private static class TestRequestCollapserWithShortCircuitedCommand
        extends TestRequestCollapser {
            public TestRequestCollapserWithShortCircuitedCommand(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(timer, counter, value);
            }

            @Override
            public HystrixCommand<List<String>> createCommand(Collection<CollapsedRequest<String, String>> requests) {
                return new ShortCircuitedCommand();
            }
        }

        private static class TestRequestCollapserWithFaultyCreateCommand
        extends TestRequestCollapser {
            public TestRequestCollapserWithFaultyCreateCommand(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(timer, counter, value);
            }

            @Override
            public HystrixCommand<List<String>> createCommand(Collection<CollapsedRequest<String, String>> requests) {
                throw new RuntimeException("some failure");
            }
        }

        private static class TestGloballyScopedRequestCollapser
        extends TestRequestCollapser {
            public TestGloballyScopedRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(Scope.GLOBAL, timer, counter, value);
            }
        }

        private static class TestShardedRequestCollapser
        extends TestRequestCollapser {
            public TestShardedRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value) {
                super(timer, counter, value);
            }

            @Override
            protected Collection<Collection<CollapsedRequest<String, String>>> shardRequests(Collection<CollapsedRequest<String, String>> requests) {
                ArrayList<CollapsedRequest<String, String>> typeA = new ArrayList<CollapsedRequest<String, String>>();
                ArrayList<CollapsedRequest<String, String>> typeB = new ArrayList<CollapsedRequest<String, String>>();
                for (CollapsedRequest<String, String> request : requests) {
                    if (request.getArgument().endsWith("a")) {
                        typeA.add(request);
                        continue;
                    }
                    if (!request.getArgument().endsWith("b")) continue;
                    typeB.add(request);
                }
                ArrayList<Collection<CollapsedRequest<String, String>>> shards = new ArrayList<Collection<CollapsedRequest<String, String>>>();
                shards.add(typeA);
                shards.add(typeB);
                return shards;
            }
        }

        private static class TestRequestCollapser
        extends HystrixCollapser<List<String>, String, String> {
            private final AtomicInteger count;
            private final String value;
            private ConcurrentLinkedQueue<HystrixCommand<List<String>>> commandsExecuted;

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, int value) {
                this(timer, counter, String.valueOf(value));
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value) {
                this(timer, counter, value, 10000, 10);
            }

            public TestRequestCollapser(Scope scope, TestCollapserTimer timer, AtomicInteger counter, String value) {
                this(scope, timer, counter, value, 10000, 10);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                this(timer, counter, value, 10000, 10, executionLog);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, int value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds) {
                this(timer, counter, String.valueOf(value), defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds) {
                this(timer, counter, value, defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds, null);
            }

            public TestRequestCollapser(Scope scope, TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds) {
                this(scope, timer, counter, value, defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds, null);
            }

            public TestRequestCollapser(TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                this(Scope.REQUEST, timer, counter, value, defaultMaxRequestsInBatch, defaultTimerDelayInMilliseconds, executionLog);
            }

            public TestRequestCollapser(Scope scope, TestCollapserTimer timer, AtomicInteger counter, String value, int defaultMaxRequestsInBatch, int defaultTimerDelayInMilliseconds, ConcurrentLinkedQueue<HystrixCommand<List<String>>> executionLog) {
                super(UnitTests.collapserKeyFromString(timer), scope, timer, HystrixCollapserProperties.Setter().withMaxRequestsInBatch(defaultMaxRequestsInBatch).withTimerDelayInMilliseconds(defaultTimerDelayInMilliseconds));
                this.count = counter;
                this.value = value;
                this.commandsExecuted = executionLog;
            }

            @Override
            public String getRequestArgument() {
                return this.value;
            }

            @Override
            public HystrixCommand<List<String>> createCommand(Collection<CollapsedRequest<String, String>> requests) {
                TestCollapserCommand command = new TestCollapserCommand(requests);
                if (this.commandsExecuted != null) {
                    this.commandsExecuted.add(command);
                }
                return command;
            }

            @Override
            public void mapResponseToRequests(List<String> batchResponse, Collection<CollapsedRequest<String, String>> requests) {
                System.out.println("increment count: " + this.count.incrementAndGet());
                if (batchResponse.size() != requests.size()) {
                    throw new RuntimeException("lists don't match in size => " + batchResponse.size() + " : " + requests.size());
                }
                int i = 0;
                for (CollapsedRequest<String, String> request : requests) {
                    request.setResponse(batchResponse.get(i++));
                }
            }
        }
    }

    @NotThreadSafe
    public static class Setter {
        private final HystrixCollapserKey collapserKey;
        private Scope scope = Scope.REQUEST;
        private HystrixCollapserProperties.Setter propertiesSetter;

        private Setter(HystrixCollapserKey collapserKey) {
            this.collapserKey = collapserKey;
        }

        public static Setter withCollapserKey(HystrixCollapserKey collapserKey) {
            return new Setter(collapserKey);
        }

        public Setter andScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Setter andCollapserPropertiesDefaults(HystrixCollapserProperties.Setter propertiesSetter) {
            this.propertiesSetter = propertiesSetter;
            return this;
        }
    }

    public static interface CollapsedRequest<ResponseType, RequestArgumentType> {
        public RequestArgumentType getArgument();

        public void setResponse(ResponseType var1);

        public void setException(Exception var1);
    }

    public static enum Scope {
        REQUEST,
        GLOBAL;

    }
}

