/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.junit.Assert;
import org.junit.Test;

public interface HystrixThreadPool {
    public ThreadPoolExecutor getExecutor();

    public void markThreadExecution();

    public void markThreadCompletion();

    public boolean isQueueSpaceAvailable();

    public static class UnitTest {
        @Test
        public void testShutdown() {
            int count = Factory.threadPools.size();
            HystrixThreadPool pool = Factory.getInstance(HystrixThreadPoolKey.Factory.asKey("threadPoolFactoryTest"), HystrixThreadPoolProperties.Setter.getUnitTestPropertiesBuilder());
            Assert.assertEquals((long)(count + 1), (long)Factory.threadPools.size());
            Assert.assertFalse((boolean)pool.getExecutor().isShutdown());
            Factory.shutdown();
            Assert.assertEquals((long)0L, (long)Factory.threadPools.size());
            Assert.assertTrue((boolean)pool.getExecutor().isShutdown());
        }

        @Test
        public void testShutdownWithWait() {
            int count = Factory.threadPools.size();
            HystrixThreadPool pool = Factory.getInstance(HystrixThreadPoolKey.Factory.asKey("threadPoolFactoryTest"), HystrixThreadPoolProperties.Setter.getUnitTestPropertiesBuilder());
            Assert.assertEquals((long)(count + 1), (long)Factory.threadPools.size());
            Assert.assertFalse((boolean)pool.getExecutor().isShutdown());
            Factory.shutdown(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)Factory.threadPools.size());
            Assert.assertTrue((boolean)pool.getExecutor().isShutdown());
        }
    }

    @ThreadSafe
    public static class HystrixThreadPoolDefault
    implements HystrixThreadPool {
        private final HystrixThreadPoolProperties properties;
        private final BlockingQueue<Runnable> queue;
        private final ThreadPoolExecutor threadPool;
        private final HystrixThreadPoolMetrics metrics;

        public HystrixThreadPoolDefault(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesDefaults) {
            this.properties = HystrixPropertiesFactory.getThreadPoolProperties(threadPoolKey, propertiesDefaults);
            HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
            this.queue = concurrencyStrategy.getBlockingQueue(this.properties.maxQueueSize().get());
            this.threadPool = concurrencyStrategy.getThreadPool(threadPoolKey, this.properties.coreSize(), this.properties.coreSize(), this.properties.keepAliveTimeMinutes(), TimeUnit.MINUTES, this.queue);
            this.metrics = HystrixThreadPoolMetrics.getInstance(threadPoolKey, this.threadPool, this.properties);
            HystrixMetricsPublisherFactory.createOrRetrievePublisherForThreadPool(threadPoolKey, this.metrics, this.properties);
        }

        @Override
        public ThreadPoolExecutor getExecutor() {
            this.threadPool.setCorePoolSize(this.properties.coreSize().get());
            this.threadPool.setMaximumPoolSize(this.properties.coreSize().get());
            this.threadPool.setKeepAliveTime(this.properties.keepAliveTimeMinutes().get().intValue(), TimeUnit.MINUTES);
            return this.threadPool;
        }

        @Override
        public void markThreadExecution() {
            this.metrics.markThreadExecution();
        }

        @Override
        public void markThreadCompletion() {
            this.metrics.markThreadCompletion();
        }

        @Override
        public boolean isQueueSpaceAvailable() {
            if (this.properties.maxQueueSize().get() < 0) {
                return true;
            }
            return this.threadPool.getQueue().size() < this.properties.queueSizeRejectionThreshold().get();
        }
    }

    public static class Factory {
        private static ConcurrentHashMap<String, HystrixThreadPool> threadPools = new ConcurrentHashMap();

        static HystrixThreadPool getInstance(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesBuilder) {
            String key = threadPoolKey.name();
            HystrixThreadPool previouslyCached = threadPools.get(key);
            if (previouslyCached != null) {
                return previouslyCached;
            }
            HystrixThreadPool poolForKey = threadPools.putIfAbsent(key, new HystrixThreadPoolDefault(threadPoolKey, propertiesBuilder));
            if (poolForKey == null) {
                HystrixThreadPool threadPoolJustCreated = threadPools.get(key);
                return threadPoolJustCreated;
            }
            return poolForKey;
        }

        static synchronized void shutdown() {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            threadPools.clear();
        }

        static synchronized void shutdown(long timeout, TimeUnit unit) {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            for (HystrixThreadPool pool : threadPools.values()) {
                try {
                    pool.getExecutor().awaitTermination(timeout, unit);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for thread-pools to terminate. Pools may not be correctly shutdown or cleared.", e);
                }
            }
            threadPools.clear();
        }
    }
}

