/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextFunc2;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.util.functions.Func2;

public class HystrixContextScheduler
extends Scheduler {
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private final Scheduler actualScheduler;

    public HystrixContextScheduler(Scheduler scheduler) {
        this(HystrixPlugins.getInstance().getConcurrencyStrategy(), scheduler);
    }

    public HystrixContextScheduler(HystrixConcurrencyStrategy concurrencyStrategy, Scheduler scheduler) {
        this.actualScheduler = scheduler;
        this.concurrencyStrategy = concurrencyStrategy;
    }

    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        return this.actualScheduler.schedule(state, new HystrixContextFunc2<T>(this.concurrencyStrategy, action));
    }

    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
        return this.actualScheduler.schedule(state, new HystrixContextFunc2<T>(this.concurrencyStrategy, action), delayTime, unit);
    }
}

