/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.properties;

import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedArchaiusProperty;
import org.junit.Assert;
import org.junit.Test;

public interface HystrixProperty<T> {
    public T get();

    public static class UnitTest {
        @Test
        public void testNested1() {
            HystrixProperty<String> a = Factory.asProperty("a");
            Assert.assertEquals((Object)"a", (Object)a.get());
            HystrixProperty<String> aWithDefault = Factory.asProperty(a, "b");
            Assert.assertEquals((Object)"a", (Object)aWithDefault.get());
        }

        @Test
        public void testNested2() {
            HystrixProperty nullValue = Factory.nullProperty();
            HystrixProperty<String> withDefault = Factory.asProperty(nullValue, "b");
            Assert.assertEquals((Object)"b", (Object)withDefault.get());
        }

        @Test
        public void testNested3() {
            HystrixProperty nullValue = Factory.nullProperty();
            HystrixProperty<String> a = Factory.asProperty(nullValue, "a");
            HystrixProperty<String> withDefault = Factory.asProperty(a, "b");
            Assert.assertEquals((Object)"a", (Object)withDefault.get());
        }

        @Test
        public void testNested4() {
            HystrixProperty nullValue = Factory.nullProperty();
            HystrixProperty<Object> a = Factory.asProperty(nullValue, null);
            HystrixProperty<String> withDefault = Factory.asProperty(a, "b");
            Assert.assertEquals((Object)"b", (Object)withDefault.get());
        }

        @Test
        public void testNested5() {
            HystrixProperty nullValue = Factory.nullProperty();
            HystrixProperty<Object> a = Factory.asProperty(nullValue, null);
            HystrixProperty withDefault = Factory.asProperty(a, Factory.asProperty("b"));
            Assert.assertEquals((Object)"b", withDefault.get());
        }

        @Test
        public void testSeries1() {
            HystrixProperty nullValue = Factory.nullProperty();
            HystrixProperty<Object> a = Factory.asProperty(nullValue, null);
            HystrixProperty withDefault = Factory.asProperty(a, nullValue, nullValue, Factory.asProperty("b"));
            Assert.assertEquals((Object)"b", withDefault.get());
        }

        @Test
        public void testSeries2() {
            HystrixProperty nullValue = Factory.nullProperty();
            HystrixProperty<Object> a = Factory.asProperty(nullValue, null);
            HystrixProperty withDefault = Factory.asProperty(a, nullValue, Factory.asProperty("b"), nullValue, Factory.asProperty("c"));
            Assert.assertEquals((Object)"b", withDefault.get());
        }
    }

    public static class Factory {
        public static <T> HystrixProperty<T> asProperty(final T value) {
            return new HystrixProperty<T>(){

                @Override
                public T get() {
                    return value;
                }
            };
        }

        public static HystrixProperty<Integer> asProperty(final HystrixPropertiesChainedArchaiusProperty.DynamicIntegerProperty value) {
            return new HystrixProperty<Integer>(){

                @Override
                public Integer get() {
                    return value.get();
                }
            };
        }

        public static HystrixProperty<Long> asProperty(final HystrixPropertiesChainedArchaiusProperty.DynamicLongProperty value) {
            return new HystrixProperty<Long>(){

                @Override
                public Long get() {
                    return value.get();
                }
            };
        }

        public static HystrixProperty<String> asProperty(final HystrixPropertiesChainedArchaiusProperty.DynamicStringProperty value) {
            return new HystrixProperty<String>(){

                @Override
                public String get() {
                    return value.get();
                }
            };
        }

        public static HystrixProperty<Boolean> asProperty(final HystrixPropertiesChainedArchaiusProperty.DynamicBooleanProperty value) {
            return new HystrixProperty<Boolean>(){

                @Override
                public Boolean get() {
                    return value.get();
                }
            };
        }

        public static <T> HystrixProperty<T> asProperty(final HystrixProperty<T> value, final T defaultValue) {
            return new HystrixProperty<T>(){

                @Override
                public T get() {
                    Object v = value.get();
                    if (v == null) {
                        return defaultValue;
                    }
                    return v;
                }
            };
        }

        public static <T> HystrixProperty<T> asProperty(final HystrixProperty<T> ... values) {
            return new HystrixProperty<T>(){

                @Override
                public T get() {
                    for (HystrixProperty v : values) {
                        if (v.get() == null) continue;
                        return v.get();
                    }
                    return null;
                }
            };
        }

        public static <T> HystrixProperty<T> asProperty(final HystrixPropertiesChainedArchaiusProperty.ChainLink<T> chainedProperty) {
            return new HystrixProperty<T>(){

                @Override
                public T get() {
                    return chainedProperty.get();
                }
            };
        }

        public static <T> HystrixProperty<T> nullProperty() {
            return new HystrixProperty<T>(){

                @Override
                public T get() {
                    return null;
                }
            };
        }
    }
}

