/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.collapser;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.collapser.CollapserTimer;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import com.netflix.hystrix.collapser.RequestCollapser;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.util.HystrixTimer;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCollapserFactory<BatchReturnType, ResponseType, RequestArgumentType> {
    private static final Logger logger = LoggerFactory.getLogger(RequestCollapserFactory.class);
    private final CollapserTimer timer;
    private final HystrixCollapserKey collapserKey;
    private final HystrixCollapserProperties properties;
    private final HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
    private final HystrixCollapser.Scope scope;
    private static ConcurrentHashMap<String, RequestCollapser<?, ?, ?>> globalScopedCollapsers = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>>> requestScopedCollapsers = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<? extends HystrixCollapser>, String> defaultNameCache = new ConcurrentHashMap();

    public RequestCollapserFactory(HystrixCollapserKey collapserKey, HystrixCollapser.Scope scope, CollapserTimer timer, HystrixCollapserProperties.Setter propertiesBuilder) {
        this.timer = timer;
        this.scope = scope;
        this.collapserKey = collapserKey;
        this.properties = HystrixPropertiesFactory.getCollapserProperties(this.collapserKey, propertiesBuilder);
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserKey;
    }

    public HystrixCollapser.Scope getScope() {
        return this.scope;
    }

    public HystrixCollapserProperties getProperties() {
        return this.properties;
    }

    public RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getRequestCollapser(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        if (HystrixCollapser.Scope.REQUEST == this.getScope()) {
            return this.getCollapserForUserRequest(commandCollapser);
        }
        if (HystrixCollapser.Scope.GLOBAL == this.getScope()) {
            return this.getCollapserForGlobalScope(commandCollapser);
        }
        logger.warn("Invalid Scope: " + (Object)((Object)this.getScope()) + "  Defaulting to REQUEST scope.");
        return this.getCollapserForUserRequest(commandCollapser);
    }

    private RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getCollapserForGlobalScope(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        RequestCollapser<?, ?, ?> collapser = globalScopedCollapsers.get(this.collapserKey.name());
        if (collapser != null) {
            return collapser;
        }
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> newCollapser = new RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>(commandCollapser, this.properties, this.timer, this.concurrencyStrategy);
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> existing = globalScopedCollapsers.putIfAbsent(this.collapserKey.name(), newCollapser);
        if (existing == null) {
            return newCollapser;
        }
        newCollapser.shutdown();
        return existing;
    }

    private RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getCollapserForUserRequest(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        return this.getRequestVariableForCommand(commandCollapser).get(this.concurrencyStrategy);
    }

    private HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>> getRequestVariableForCommand(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        HystrixRequestVariableHolder requestVariable = requestScopedCollapsers.get(commandCollapser.getCollapserKey().name());
        if (requestVariable == null) {
            RequestCollapserRequestVariable newCollapser = new RequestCollapserRequestVariable(commandCollapser, this.properties, this.timer, this.concurrencyStrategy);
            HystrixRequestVariableHolder existing = requestScopedCollapsers.putIfAbsent(commandCollapser.getCollapserKey().name(), newCollapser);
            requestVariable = existing == null ? newCollapser : existing;
        }
        return requestVariable;
    }

    public static void reset() {
        defaultNameCache.clear();
        globalScopedCollapsers.clear();
        requestScopedCollapsers.clear();
        HystrixTimer.reset();
    }

    public static void resetRequest() {
        requestScopedCollapsers.clear();
    }

    public static HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>> getRequestVariable(String key) {
        return requestScopedCollapsers.get(key);
    }

    @NotThreadSafe
    public static class Setter {
        private final HystrixCollapserKey collapserKey;
        private HystrixCollapser.Scope scope = HystrixCollapser.Scope.REQUEST;
        private HystrixCollapserProperties.Setter propertiesSetter;

        private Setter(HystrixCollapserKey collapserKey) {
            this.collapserKey = collapserKey;
        }

        public static Setter withCollapserKey(HystrixCollapserKey collapserKey) {
            return new Setter(collapserKey);
        }

        public Setter andScope(HystrixCollapser.Scope scope) {
            this.scope = scope;
            return this;
        }

        public Setter andCollapserPropertiesDefaults(HystrixCollapserProperties.Setter propertiesSetter) {
            this.propertiesSetter = propertiesSetter;
            return this;
        }
    }

    private final class RequestCollapserRequestVariable
    extends HystrixRequestVariableHolder<RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>> {
        private RequestCollapserRequestVariable(final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser, final HystrixCollapserProperties properties, final CollapserTimer timer, final HystrixConcurrencyStrategy concurrencyStrategy) {
            super(new HystrixRequestVariableLifecycle<RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>>(){

                @Override
                public RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> initialValue() {
                    return new RequestCollapser(commandCollapser, properties, timer, concurrencyStrategy);
                }

                @Override
                public void shutdown(RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> currentCollapser) {
                    if (currentCollapser != null) {
                        currentCollapser.shutdown();
                    }
                }
            });
        }
    }
}

