/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifierDefault;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHookDefault;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherDefault;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategyDefault;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import rx.functions.Action1;

public class HystrixPlugins {
    private static final HystrixPlugins INSTANCE = new HystrixPlugins();
    private final AtomicReference<HystrixEventNotifier> notifier = new AtomicReference();
    private final AtomicReference<HystrixConcurrencyStrategy> concurrencyStrategy = new AtomicReference();
    private final AtomicReference<HystrixMetricsPublisher> metricsPublisher = new AtomicReference();
    private final AtomicReference<HystrixPropertiesStrategy> propertiesFactory = new AtomicReference();
    private final AtomicReference<HystrixCommandExecutionHook> commandExecutionHook = new AtomicReference();

    private HystrixPlugins() {
    }

    public static HystrixPlugins getInstance() {
        return INSTANCE;
    }

    public HystrixEventNotifier getEventNotifier() {
        if (this.notifier.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixEventNotifier.class);
            if (impl == null) {
                this.notifier.compareAndSet(null, HystrixEventNotifierDefault.getInstance());
            } else {
                this.notifier.compareAndSet(null, (HystrixEventNotifier)impl);
            }
        }
        return this.notifier.get();
    }

    public void registerEventNotifier(HystrixEventNotifier impl) {
        if (!this.notifier.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixConcurrencyStrategy getConcurrencyStrategy() {
        if (this.concurrencyStrategy.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixConcurrencyStrategy.class);
            if (impl == null) {
                this.concurrencyStrategy.compareAndSet(null, HystrixConcurrencyStrategyDefault.getInstance());
            } else {
                this.concurrencyStrategy.compareAndSet(null, (HystrixConcurrencyStrategy)impl);
            }
        }
        return this.concurrencyStrategy.get();
    }

    public void registerConcurrencyStrategy(HystrixConcurrencyStrategy impl) {
        if (!this.concurrencyStrategy.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixMetricsPublisher getMetricsPublisher() {
        if (this.metricsPublisher.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixMetricsPublisher.class);
            if (impl == null) {
                this.metricsPublisher.compareAndSet(null, HystrixMetricsPublisherDefault.getInstance());
            } else {
                this.metricsPublisher.compareAndSet(null, (HystrixMetricsPublisher)impl);
            }
        }
        return this.metricsPublisher.get();
    }

    public void registerMetricsPublisher(HystrixMetricsPublisher impl) {
        if (!this.metricsPublisher.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixPropertiesStrategy getPropertiesStrategy() {
        if (this.propertiesFactory.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixPropertiesStrategy.class);
            if (impl == null) {
                this.propertiesFactory.compareAndSet(null, HystrixPropertiesStrategyDefault.getInstance());
            } else {
                this.propertiesFactory.compareAndSet(null, (HystrixPropertiesStrategy)impl);
            }
        }
        return this.propertiesFactory.get();
    }

    public void registerPropertiesStrategy(HystrixPropertiesStrategy impl) {
        if (!this.propertiesFactory.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixCommandExecutionHook getCommandExecutionHook() {
        if (this.commandExecutionHook.get() == null) {
            Object impl = HystrixPlugins.getPluginImplementationViaProperty(HystrixCommandExecutionHook.class);
            if (impl == null) {
                this.commandExecutionHook.compareAndSet(null, HystrixCommandExecutionHookDefault.getInstance());
            } else {
                this.commandExecutionHook.compareAndSet(null, (HystrixCommandExecutionHook)impl);
            }
        }
        return this.commandExecutionHook.get();
    }

    public void registerCommandExecutionHook(HystrixCommandExecutionHook impl) {
        if (!this.commandExecutionHook.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    private static Object getPluginImplementationViaProperty(Class<?> pluginClass) {
        String classSimpleName = pluginClass.getSimpleName();
        String implementingClass = System.getProperty("hystrix.plugin." + classSimpleName + ".implementation");
        if (implementingClass != null) {
            try {
                Class<?> cls = Class.forName(implementingClass);
                cls = cls.asSubclass(pluginClass);
                return cls.newInstance();
            }
            catch (ClassCastException e) {
                throw new RuntimeException(classSimpleName + " implementation is not an instance of " + classSimpleName + ": " + implementingClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(classSimpleName + " implementation class not found: " + implementingClass, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be instantiated: " + implementingClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be accessed: " + implementingClass, e);
            }
        }
        return null;
    }

    public static class UnitTest {
        private static final ThreadLocal<String> testRequestIdThreadLocal = new ThreadLocal();

        @After
        public void reset() {
            HystrixPlugins.getInstance().concurrencyStrategy.set(null);
            HystrixPlugins.getInstance().metricsPublisher.set(null);
            HystrixPlugins.getInstance().notifier.set(null);
            HystrixPlugins.getInstance().propertiesFactory.set(null);
        }

        @Test
        public void testEventNotifierDefaultImpl() {
            HystrixEventNotifier impl = HystrixPlugins.getInstance().getEventNotifier();
            Assert.assertTrue((boolean)(impl instanceof HystrixEventNotifierDefault));
        }

        @Test
        public void testEventNotifierViaRegisterMethod() {
            HystrixPlugins.getInstance().registerEventNotifier(new HystrixEventNotifierTestImpl());
            HystrixEventNotifier impl = HystrixPlugins.getInstance().getEventNotifier();
            Assert.assertTrue((boolean)(impl instanceof HystrixEventNotifierTestImpl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testEventNotifierViaProperty() {
            try {
                String fullClass = UnitTest.getFullClassNameForTestClass(HystrixEventNotifierTestImpl.class);
                System.setProperty("hystrix.plugin.HystrixEventNotifier.implementation", fullClass);
                HystrixEventNotifier impl = HystrixPlugins.getInstance().getEventNotifier();
                Assert.assertTrue((boolean)(impl instanceof HystrixEventNotifierTestImpl));
            }
            finally {
                System.clearProperty("hystrix.plugin.HystrixEventNotifier.implementation");
            }
        }

        @Test
        public void testConcurrencyStrategyDefaultImpl() {
            HystrixConcurrencyStrategy impl = HystrixPlugins.getInstance().getConcurrencyStrategy();
            Assert.assertTrue((boolean)(impl instanceof HystrixConcurrencyStrategyDefault));
        }

        @Test
        public void testConcurrencyStrategyViaRegisterMethod() {
            HystrixPlugins.getInstance().registerConcurrencyStrategy(new HystrixConcurrencyStrategyTestImpl());
            HystrixConcurrencyStrategy impl = HystrixPlugins.getInstance().getConcurrencyStrategy();
            Assert.assertTrue((boolean)(impl instanceof HystrixConcurrencyStrategyTestImpl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testConcurrencyStrategyViaProperty() {
            try {
                String fullClass = UnitTest.getFullClassNameForTestClass(HystrixConcurrencyStrategyTestImpl.class);
                System.setProperty("hystrix.plugin.HystrixConcurrencyStrategy.implementation", fullClass);
                HystrixConcurrencyStrategy impl = HystrixPlugins.getInstance().getConcurrencyStrategy();
                Assert.assertTrue((boolean)(impl instanceof HystrixConcurrencyStrategyTestImpl));
            }
            finally {
                System.clearProperty("hystrix.plugin.HystrixConcurrencyStrategy.implementation");
            }
        }

        @Test
        public void testMetricsPublisherDefaultImpl() {
            HystrixMetricsPublisher impl = HystrixPlugins.getInstance().getMetricsPublisher();
            Assert.assertTrue((boolean)(impl instanceof HystrixMetricsPublisherDefault));
        }

        @Test
        public void testMetricsPublisherViaRegisterMethod() {
            HystrixPlugins.getInstance().registerMetricsPublisher(new HystrixMetricsPublisherTestImpl());
            HystrixMetricsPublisher impl = HystrixPlugins.getInstance().getMetricsPublisher();
            Assert.assertTrue((boolean)(impl instanceof HystrixMetricsPublisherTestImpl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testMetricsPublisherViaProperty() {
            try {
                String fullClass = UnitTest.getFullClassNameForTestClass(HystrixMetricsPublisherTestImpl.class);
                System.setProperty("hystrix.plugin.HystrixMetricsPublisher.implementation", fullClass);
                HystrixMetricsPublisher impl = HystrixPlugins.getInstance().getMetricsPublisher();
                Assert.assertTrue((boolean)(impl instanceof HystrixMetricsPublisherTestImpl));
            }
            finally {
                System.clearProperty("hystrix.plugin.HystrixMetricsPublisher.implementation");
            }
        }

        @Test
        public void testPropertiesStrategyDefaultImpl() {
            HystrixPropertiesStrategy impl = HystrixPlugins.getInstance().getPropertiesStrategy();
            Assert.assertTrue((boolean)(impl instanceof HystrixPropertiesStrategyDefault));
        }

        @Test
        public void testPropertiesStrategyViaRegisterMethod() {
            HystrixPlugins.getInstance().registerPropertiesStrategy(new HystrixPropertiesStrategyTestImpl());
            HystrixPropertiesStrategy impl = HystrixPlugins.getInstance().getPropertiesStrategy();
            Assert.assertTrue((boolean)(impl instanceof HystrixPropertiesStrategyTestImpl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testPropertiesStrategyViaProperty() {
            try {
                String fullClass = UnitTest.getFullClassNameForTestClass(HystrixPropertiesStrategyTestImpl.class);
                System.setProperty("hystrix.plugin.HystrixPropertiesStrategy.implementation", fullClass);
                HystrixPropertiesStrategy impl = HystrixPlugins.getInstance().getPropertiesStrategy();
                Assert.assertTrue((boolean)(impl instanceof HystrixPropertiesStrategyTestImpl));
            }
            finally {
                System.clearProperty("hystrix.plugin.HystrixPropertiesStrategy.implementation");
            }
        }

        private static String getFullClassNameForTestClass(Class<?> cls) {
            return HystrixPlugins.class.getPackage().getName() + "." + HystrixPlugins.class.getSimpleName() + "$UnitTest$" + cls.getSimpleName();
        }

        @Test
        public void testRequestContextViaPluginInTimeout() {
            HystrixPlugins.getInstance().registerConcurrencyStrategy(new HystrixConcurrencyStrategy(){

                @Override
                public <T> Callable<T> wrapCallable(Callable<T> callable) {
                    return new RequestIdCallable<T>(callable);
                }
            });
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            testRequestIdThreadLocal.set("foobar");
            final AtomicReference valueInTimeout = new AtomicReference();
            new DummyCommand().toObservable().doOnError((Action1)new Action1<Throwable>(){

                public void call(Throwable throwable) {
                    System.out.println("initialized = " + HystrixRequestContext.isCurrentThreadInitialized());
                    System.out.println("requestId (timeout) = " + (String)testRequestIdThreadLocal.get());
                    valueInTimeout.set(testRequestIdThreadLocal.get());
                }
            }).materialize().toBlockingObservable().single();
            context.shutdown();
            Hystrix.reset();
            Assert.assertEquals((Object)"foobar", valueInTimeout.get());
        }

        private static class RequestIdCallable<T>
        implements Callable<T> {
            private final Callable<T> callable;
            private final String requestId;

            public RequestIdCallable(Callable<T> callable) {
                this.callable = callable;
                this.requestId = (String)testRequestIdThreadLocal.get();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                String original = (String)testRequestIdThreadLocal.get();
                testRequestIdThreadLocal.set(this.requestId);
                try {
                    T t = this.callable.call();
                    return t;
                }
                finally {
                    testRequestIdThreadLocal.set(original);
                }
            }
        }

        public static class DummyCommand
        extends HystrixCommand<Void> {
            public DummyCommand() {
                super(HystrixCommandGroupKey.Factory.asKey("Dummy"));
            }

            @Override
            protected Void run() throws Exception {
                System.out.println("requestId (run) = " + (String)testRequestIdThreadLocal.get());
                Thread.sleep(2000L);
                return null;
            }
        }

        public static class HystrixPropertiesStrategyTestImpl
        extends HystrixPropertiesStrategy {
        }

        public static class HystrixMetricsPublisherTestImpl
        extends HystrixMetricsPublisher {
        }

        public static class HystrixConcurrencyStrategyTestImpl
        extends HystrixConcurrencyStrategy {
        }

        public static class HystrixEventNotifierTestImpl
        extends HystrixEventNotifier {
        }
    }
}

