/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.properties;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.PropertyWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HystrixPropertiesChainedArchaiusProperty {
    private static final Logger logger = LoggerFactory.getLogger(HystrixPropertiesChainedArchaiusProperty.class);

    public static class UnitTest {
        @After
        public void cleanUp() {
            ConfigurationManager.getConfigInstance().clear();
        }

        @Test
        public void testString() throws Exception {
            DynamicStringProperty pString = new DynamicStringProperty("defaultString", "default-default");
            StringProperty fString = new StringProperty("overrideString", pString);
            Assert.assertTrue((boolean)"default-default".equals(fString.get()));
            ConfigurationManager.getConfigInstance().setProperty("defaultString", (Object)"default");
            Assert.assertTrue((boolean)"default".equals(fString.get()));
            ConfigurationManager.getConfigInstance().setProperty("overrideString", (Object)"override");
            Assert.assertTrue((boolean)"override".equals(fString.get()));
            ConfigurationManager.getConfigInstance().clearProperty("overrideString");
            Assert.assertTrue((boolean)"default".equals(fString.get()));
            ConfigurationManager.getConfigInstance().clearProperty("defaultString");
            Assert.assertTrue((boolean)"default-default".equals(fString.get()));
        }

        @Test
        public void testInteger() throws Exception {
            DynamicIntegerProperty pInt = new DynamicIntegerProperty("defaultInt", -1);
            IntegerProperty fInt = new IntegerProperty("overrideInt", pInt);
            Assert.assertTrue((-1 == (Integer)fInt.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("defaultInt", (Object)10);
            Assert.assertTrue((10 == (Integer)fInt.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("overrideInt", (Object)11);
            Assert.assertTrue((11 == (Integer)fInt.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("overrideInt");
            Assert.assertTrue((10 == (Integer)fInt.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("defaultInt");
            Assert.assertTrue((-1 == (Integer)fInt.get() ? 1 : 0) != 0);
        }

        @Test
        public void testBoolean() throws Exception {
            DynamicBooleanProperty pBoolean = new DynamicBooleanProperty("defaultBoolean", true);
            BooleanProperty fBoolean = new BooleanProperty("overrideBoolean", pBoolean);
            System.out.println("pBoolean: " + pBoolean.get());
            System.out.println("fBoolean: " + fBoolean.get());
            Assert.assertTrue((boolean)((Boolean)fBoolean.get()));
            ConfigurationManager.getConfigInstance().setProperty("defaultBoolean", (Object)Boolean.FALSE);
            System.out.println("pBoolean: " + pBoolean.get());
            System.out.println("fBoolean: " + fBoolean.get());
            Assert.assertFalse((boolean)((Boolean)fBoolean.get()));
            ConfigurationManager.getConfigInstance().setProperty("overrideBoolean", (Object)Boolean.TRUE);
            Assert.assertTrue((boolean)((Boolean)fBoolean.get()));
            ConfigurationManager.getConfigInstance().clearProperty("overrideBoolean");
            Assert.assertFalse((boolean)((Boolean)fBoolean.get()));
            ConfigurationManager.getConfigInstance().clearProperty("defaultBoolean");
            Assert.assertTrue((boolean)((Boolean)fBoolean.get()));
        }

        @Test
        public void testChainingString() throws Exception {
            DynamicStringProperty node1 = new DynamicStringProperty("node1", "v1");
            StringProperty node2 = new StringProperty("node2", node1);
            StringProperty node3 = new StringProperty("node3", node2);
            Assert.assertTrue((String)("" + (String)node3.get()), (boolean)"v1".equals(node3.get()));
            ConfigurationManager.getConfigInstance().setProperty("node1", (Object)"v11");
            Assert.assertTrue((boolean)"v11".equals(node3.get()));
            ConfigurationManager.getConfigInstance().setProperty("node2", (Object)"v22");
            Assert.assertTrue((boolean)"v22".equals(node3.get()));
            ConfigurationManager.getConfigInstance().clearProperty("node1");
            Assert.assertTrue((boolean)"v22".equals(node3.get()));
            ConfigurationManager.getConfigInstance().setProperty("node3", (Object)"v33");
            Assert.assertTrue((boolean)"v33".equals(node3.get()));
            ConfigurationManager.getConfigInstance().clearProperty("node2");
            Assert.assertTrue((boolean)"v33".equals(node3.get()));
            ConfigurationManager.getConfigInstance().setProperty("node2", (Object)"v222");
            Assert.assertTrue((boolean)"v33".equals(node3.get()));
            ConfigurationManager.getConfigInstance().clearProperty("node3");
            Assert.assertTrue((boolean)"v222".equals(node3.get()));
            ConfigurationManager.getConfigInstance().clearProperty("node2");
            Assert.assertTrue((boolean)"v1".equals(node3.get()));
            ConfigurationManager.getConfigInstance().setProperty("node2", (Object)"v2222");
            Assert.assertTrue((boolean)"v2222".equals(node3.get()));
        }

        @Test
        public void testChainingInteger() throws Exception {
            DynamicIntegerProperty node1 = new DynamicIntegerProperty("node1", 1);
            IntegerProperty node2 = new IntegerProperty("node2", node1);
            IntegerProperty node3 = new IntegerProperty("node3", node2);
            Assert.assertTrue((String)("" + node3.get()), (1 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("node1", (Object)11);
            Assert.assertTrue((11 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("node2", (Object)22);
            Assert.assertTrue((22 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("node1");
            Assert.assertTrue((22 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("node3", (Object)33);
            Assert.assertTrue((33 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("node2");
            Assert.assertTrue((33 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("node2", (Object)222);
            Assert.assertTrue((33 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("node3");
            Assert.assertTrue((222 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("node2");
            Assert.assertTrue((1 == (Integer)node3.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("node2", (Object)2222);
            Assert.assertTrue((2222 == (Integer)node3.get() ? 1 : 0) != 0);
        }

        @Test
        public void testAddCallback() throws Exception {
            DynamicStringProperty node1 = new DynamicStringProperty("n1", "n1");
            StringProperty node2 = new StringProperty("n2", node1);
            final AtomicInteger callbackCount = new AtomicInteger(0);
            node2.addCallback(new Runnable(){

                @Override
                public void run() {
                    callbackCount.incrementAndGet();
                }
            });
            Assert.assertTrue((0 == callbackCount.get() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)"n1".equals(node2.get()));
            Assert.assertTrue((0 == callbackCount.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("n1", (Object)"n11");
            Assert.assertTrue((boolean)"n11".equals(node2.get()));
            Assert.assertTrue((0 == callbackCount.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("n2", (Object)"n22");
            Assert.assertTrue((boolean)"n22".equals(node2.get()));
            Assert.assertTrue((1 == callbackCount.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("n1");
            Assert.assertTrue((boolean)"n22".equals(node2.get()));
            Assert.assertTrue((1 == callbackCount.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().setProperty("n2", (Object)"n222");
            Assert.assertTrue((boolean)"n222".equals(node2.get()));
            Assert.assertTrue((2 == callbackCount.get() ? 1 : 0) != 0);
            ConfigurationManager.getConfigInstance().clearProperty("n2");
            Assert.assertTrue((boolean)"n1".equals(node2.get()));
            Assert.assertTrue((3 == callbackCount.get() ? 1 : 0) != 0);
        }
    }

    public static class DynamicStringProperty
    extends PropertyWrapper<String> {
        public DynamicStringProperty(String propName, String defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public String get() {
            return this.prop.getString((String)this.defaultValue);
        }

        public String getValue() {
            return this.get();
        }
    }

    public static class DynamicLongProperty
    extends PropertyWrapper<Long> {
        public DynamicLongProperty(String propName, Long defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Long get() {
            return this.prop.getLong((Long)this.defaultValue);
        }

        public Long getValue() {
            return this.get();
        }
    }

    public static class DynamicIntegerProperty
    extends PropertyWrapper<Integer> {
        public DynamicIntegerProperty(String propName, Integer defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Integer get() {
            return this.prop.getInteger((Integer)this.defaultValue);
        }

        public Integer getValue() {
            return this.get();
        }
    }

    public static class DynamicBooleanProperty
    extends PropertyWrapper<Boolean> {
        public DynamicBooleanProperty(String propName, Boolean defaultValue) {
            super(propName, (Object)defaultValue);
        }

        public Boolean get() {
            return this.prop.getBoolean((Boolean)this.defaultValue);
        }

        public Boolean getValue() {
            return this.get();
        }
    }

    public static class BooleanProperty
    extends ChainLink<Boolean> {
        private final DynamicBooleanProperty sProp;

        public BooleanProperty(DynamicBooleanProperty sProperty) {
            this.sProp = sProperty;
        }

        public BooleanProperty(String name, DynamicBooleanProperty sProperty) {
            this(name, new BooleanProperty(sProperty));
        }

        public BooleanProperty(String name, BooleanProperty next) {
            this(new DynamicBooleanProperty(name, null), next);
        }

        public BooleanProperty(DynamicBooleanProperty sProperty, DynamicBooleanProperty next) {
            this(sProperty, new BooleanProperty(next));
        }

        public BooleanProperty(DynamicBooleanProperty sProperty, BooleanProperty next) {
            super(next);
            this.sProp = sProperty;
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Property changed: '" + BooleanProperty.this.getName() + " = " + BooleanProperty.this.getValue() + "'");
                    BooleanProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.getValue() != null;
        }

        @Override
        public Boolean getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static class IntegerProperty
    extends ChainLink<Integer> {
        private final DynamicIntegerProperty sProp;

        public IntegerProperty(DynamicIntegerProperty sProperty) {
            this.sProp = sProperty;
        }

        public IntegerProperty(String name, DynamicIntegerProperty sProperty) {
            this(name, new IntegerProperty(sProperty));
        }

        public IntegerProperty(String name, IntegerProperty next) {
            this(new DynamicIntegerProperty(name, null), next);
        }

        public IntegerProperty(DynamicIntegerProperty sProperty, DynamicIntegerProperty next) {
            this(sProperty, new IntegerProperty(next));
        }

        public IntegerProperty(DynamicIntegerProperty sProperty, IntegerProperty next) {
            super(next);
            this.sProp = sProperty;
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Property changed: '" + IntegerProperty.this.getName() + " = " + IntegerProperty.this.getValue() + "'");
                    IntegerProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != null;
        }

        @Override
        public Integer getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static class StringProperty
    extends ChainLink<String> {
        private final DynamicStringProperty sProp;

        public StringProperty(DynamicStringProperty sProperty) {
            this.sProp = sProperty;
        }

        public StringProperty(String name, DynamicStringProperty sProperty) {
            this(name, new StringProperty(sProperty));
        }

        public StringProperty(String name, StringProperty next) {
            this(new DynamicStringProperty(name, null), next);
        }

        public StringProperty(DynamicStringProperty sProperty, DynamicStringProperty next) {
            this(sProperty, new StringProperty(next));
        }

        public StringProperty(DynamicStringProperty sProperty, StringProperty next) {
            super(next);
            this.sProp = sProperty;
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Property changed: '" + StringProperty.this.getName() + " = " + StringProperty.this.getValue() + "'");
                    StringProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != null;
        }

        @Override
        protected String getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static abstract class ChainLink<T> {
        private final AtomicReference<ChainLink<T>> pReference;
        private final ChainLink<T> next;
        private final List<Runnable> callbacks;

        public abstract String getName();

        protected abstract T getValue();

        public abstract boolean isValueAcceptable();

        public ChainLink() {
            this.next = null;
            this.pReference = new AtomicReference<ChainLink>(this);
            this.callbacks = new ArrayList<Runnable>();
        }

        public ChainLink(ChainLink<T> nextProperty) {
            this.next = nextProperty;
            this.pReference = new AtomicReference<ChainLink<T>>(this.next);
            this.callbacks = new ArrayList<Runnable>();
        }

        protected void checkAndFlip() {
            if (this.next == null) {
                this.pReference.set(this);
                return;
            }
            if (this.isValueAcceptable()) {
                logger.debug("Flipping property: " + this.getName() + " to use it's current value:" + this.getValue());
                this.pReference.set(this);
            } else {
                logger.debug("Flipping property: " + this.getName() + " to use NEXT property: " + this.next);
                this.pReference.set(this.next);
            }
            for (Runnable r : this.callbacks) {
                r.run();
            }
        }

        public T get() {
            if (this.pReference.get() == this) {
                return this.getValue();
            }
            return this.pReference.get().get();
        }

        public void addCallback(Runnable r) {
            this.callbacks.add(r);
        }

        public String toString() {
            return this.getName() + " = " + this.get();
        }
    }
}

