/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionThreadingUtility {
    private static final String messageForCause = "Calling Thread included as the last 'caused by' on the chain.";
    private static ThreadLocal<Thread> callingThreadCache = new ThreadLocal();

    private static void attachCallingThreadStack(Throwable e, StackTraceElement[] stack) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        Throwable callingThrowable = new Throwable(messageForCause);
        if (stack[0].toString().startsWith("java.lang.Thread.getStackTrace")) {
            StackTraceElement[] newStack = Arrays.copyOfRange(stack, 1, stack.length);
            stack = newStack;
        }
        callingThrowable.setStackTrace(stack);
        while (e.getCause() != null && !seenCauses.contains(e = e.getCause())) {
            seenCauses.add(e);
        }
        if (!messageForCause.equals(e.getMessage())) {
            try {
                e.initCause(callingThrowable);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private static String getStackTraceAsString(StackTraceElement[] stack) {
        StringBuilder s = new StringBuilder();
        boolean firstLine = true;
        for (StackTraceElement e : stack) {
            if (e.toString().startsWith("java.lang.Thread.getStackTrace")) continue;
            if (!firstLine) {
                s.append("\n\t");
            }
            s.append(e.toString());
            firstLine = false;
        }
        return s.toString();
    }

    public static void attachCallingThreadStack(Throwable e) {
        try {
            if (callingThreadCache.get() != null) {
                ExceptionThreadingUtility.attachCallingThreadStack(e, callingThreadCache.get().getStackTrace());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void assignCallingThread(Thread callingThread) {
        callingThreadCache.set(callingThread);
    }

    public static class UnitTest {
        private final Throwable ex1 = new Throwable("Ex1");
        private final Throwable ex2 = new Throwable("Ex2", this.ex1);

        public UnitTest() {
            this.ex1.initCause(this.ex2);
        }

        @Test
        public void testAttachCallingThreadStackParentThenChild() {
            ExceptionThreadingUtility.attachCallingThreadStack(this.ex1, this.ex2.getStackTrace());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex1.getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex1.getCause().getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex2.getMessage());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex2.getCause().getMessage());
        }

        @Test
        public void testAttachCallingThreadStackChildThenParent() {
            ExceptionThreadingUtility.attachCallingThreadStack(this.ex2, this.ex1.getStackTrace());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex1.getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex1.getCause().getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex2.getMessage());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex2.getCause().getMessage());
        }

        @Test
        public void testAttachCallingThreadStackAddExceptionsToEachOther() {
            ExceptionThreadingUtility.attachCallingThreadStack(this.ex1, this.ex2.getStackTrace());
            ExceptionThreadingUtility.attachCallingThreadStack(this.ex2, this.ex1.getStackTrace());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex1.getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex2.getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex1.getCause().getMessage());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex2.getCause().getMessage());
        }

        @Test
        public void testAttachCallingThreadStackAddExceptionToItself() {
            ExceptionThreadingUtility.attachCallingThreadStack(this.ex2, this.ex2.getStackTrace());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex1.getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex1.getCause().getMessage());
            Assert.assertEquals((Object)"Ex2", (Object)this.ex2.getMessage());
            Assert.assertEquals((Object)"Ex1", (Object)this.ex2.getCause().getMessage());
        }
    }
}

