/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRequestLog {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestLog.class);
    private static final int MAX_STORAGE = 1000;
    private static final HystrixRequestVariableHolder<HystrixRequestLog> currentRequestLog = new HystrixRequestVariableHolder<HystrixRequestLog>(new HystrixRequestVariableLifecycle<HystrixRequestLog>(){

        @Override
        public HystrixRequestLog initialValue() {
            return new HystrixRequestLog();
        }

        @Override
        public void shutdown(HystrixRequestLog value) {
        }
    });
    private LinkedBlockingQueue<HystrixCommand<?>> executedCommands = new LinkedBlockingQueue(1000);

    private HystrixRequestLog() {
    }

    public static HystrixRequestLog getCurrentRequest(HystrixConcurrencyStrategy concurrencyStrategy) {
        return currentRequestLog.get(concurrencyStrategy);
    }

    public static HystrixRequestLog getCurrentRequest() {
        return currentRequestLog.get(HystrixPlugins.getInstance().getConcurrencyStrategy());
    }

    public Collection<HystrixCommand<?>> getExecutedCommands() {
        return Collections.unmodifiableCollection(this.executedCommands);
    }

    void addExecutedCommand(HystrixCommand<?> command) {
        if (!this.executedCommands.offer(command)) {
            logger.warn("RequestLog ignoring command after reaching limit of 1000. See https://github.com/Netflix/Hystrix/issues/53 for more information.");
        }
    }

    public String getExecutedCommandsAsString() {
        try {
            LinkedHashMap<String, Integer> aggregatedCommandsExecuted = new LinkedHashMap<String, Integer>();
            HashMap<String, Integer> aggregatedCommandExecutionTime = new HashMap<String, Integer>();
            StringBuilder builder = new StringBuilder();
            int estimatedLength = 0;
            for (HystrixCommand<?> command : this.executedCommands) {
                builder.setLength(0);
                builder.append(command.getCommandKey().name());
                ArrayList<HystrixEventType> events = new ArrayList<HystrixEventType>(command.getExecutionEvents());
                if (events.size() > 0) {
                    Collections.sort(events);
                    builder.append("[");
                    for (HystrixEventType event : events) {
                        builder.append((Object)event).append(", ");
                    }
                    builder.setCharAt(builder.length() - 2, ']');
                    builder.setLength(builder.length() - 1);
                } else {
                    builder.append("[Executed]");
                }
                String display = builder.toString();
                estimatedLength += display.length() + 12;
                Integer counter = (Integer)aggregatedCommandsExecuted.get(display);
                if (counter != null) {
                    aggregatedCommandsExecuted.put(display, counter + 1);
                } else {
                    aggregatedCommandsExecuted.put(display, 1);
                }
                int executionTime = command.getExecutionTimeInMilliseconds();
                if (executionTime < 0) {
                    executionTime = 0;
                }
                if ((counter = (Integer)aggregatedCommandExecutionTime.get(display)) != null && executionTime > 0) {
                    aggregatedCommandExecutionTime.put(display, (Integer)aggregatedCommandExecutionTime.get(display) + executionTime);
                    continue;
                }
                aggregatedCommandExecutionTime.put(display, executionTime);
            }
            builder.setLength(0);
            builder.ensureCapacity(estimatedLength);
            for (String displayString : aggregatedCommandsExecuted.keySet()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(displayString);
                int totalExecutionTime = (Integer)aggregatedCommandExecutionTime.get(displayString);
                builder.append("[").append(totalExecutionTime).append("ms]");
                int count = (Integer)aggregatedCommandsExecuted.get(displayString);
                if (count <= 1) continue;
                builder.append("x").append(count);
            }
            return builder.toString();
        }
        catch (Exception e) {
            logger.error("Failed to create HystrixRequestLog response header string.", (Throwable)e);
            return "Unknown";
        }
    }

    private static class TestCommand
    extends HystrixCommand<String> {
        private final String value;
        private final boolean fail;
        private final boolean failOnFallback;

        public TestCommand(String commandName, String value, boolean fail, boolean failOnFallback) {
            super(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("RequestLogTestCommand")).andCommandKey(HystrixCommandKey.Factory.asKey(commandName)));
            this.value = value;
            this.fail = fail;
            this.failOnFallback = failOnFallback;
        }

        public TestCommand(String value, boolean fail, boolean failOnFallback) {
            super(HystrixCommandGroupKey.Factory.asKey("RequestLogTestCommand"));
            this.value = value;
            this.fail = fail;
            this.failOnFallback = failOnFallback;
        }

        @Override
        protected String run() {
            if (this.fail) {
                throw new RuntimeException("forced failure");
            }
            return this.value;
        }

        @Override
        protected String getFallback() {
            if (this.failOnFallback) {
                throw new RuntimeException("forced fallback failure");
            }
            return this.value + "-fallback";
        }

        @Override
        protected String getCacheKey() {
            return this.value;
        }
    }

    public static class UnitTest {
        private static final String DIGITS_REGEX = "\\[\\d+";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testSuccess() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                new TestCommand("A", false, true).execute();
                String log = HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString();
                log = log.replaceAll(DIGITS_REGEX, "[");
                Assert.assertEquals((Object)"TestCommand[SUCCESS][ms]", (Object)log);
            }
            finally {
                context.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testSuccessFromCache() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                new TestCommand("A", false, true).execute();
                new TestCommand("A", false, true).execute();
                new TestCommand("A", false, true).execute();
                new TestCommand("A", false, true).execute();
                new TestCommand("A", false, true).execute();
                String log = HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString();
                log = log.replaceAll(DIGITS_REGEX, "[");
                Assert.assertEquals((Object)"TestCommand[SUCCESS][ms], TestCommand[SUCCESS, RESPONSE_FROM_CACHE][ms]x4", (Object)log);
            }
            finally {
                context.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testFailWithFallbackSuccess() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                new TestCommand("A", true, false).execute();
                new TestCommand("A", true, false).execute();
                new TestCommand("A", true, false).execute();
                new TestCommand("A", true, false).execute();
                new TestCommand("A", true, false).execute();
                String log = HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString();
                log = log.replaceAll(DIGITS_REGEX, "[");
                Assert.assertEquals((Object)"TestCommand[FAILURE, FALLBACK_SUCCESS][ms], TestCommand[FAILURE, FALLBACK_SUCCESS, RESPONSE_FROM_CACHE][ms]x4", (Object)log);
            }
            finally {
                context.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testFailWithFallbackFailure() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                try {
                    new TestCommand("A", true, true).execute();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    new TestCommand("A", true, true).execute();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String log = HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString();
                log = log.replaceAll(DIGITS_REGEX, "[");
                Assert.assertEquals((Object)"TestCommand[FAILURE, FALLBACK_FAILURE][ms], TestCommand[FAILURE, FALLBACK_FAILURE, RESPONSE_FROM_CACHE][ms]", (Object)log);
            }
            finally {
                context.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testMultipleCommands() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                new TestCommand("GetData", "A", false, false).execute();
                new TestCommand("PutData", "B", false, false).execute();
                new TestCommand("GetValues", "C", false, false).execute();
                new TestCommand("GetValues", "C", false, false).execute();
                try {
                    new TestCommand("A", true, true).execute();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    new TestCommand("A", true, true).execute();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String log = HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString();
                log = log.replaceAll(DIGITS_REGEX, "[");
                Assert.assertEquals((Object)"GetData[SUCCESS][ms], PutData[SUCCESS][ms], GetValues[SUCCESS][ms], GetValues[SUCCESS, RESPONSE_FROM_CACHE][ms], TestCommand[FAILURE, FALLBACK_FAILURE][ms], TestCommand[FAILURE, FALLBACK_FAILURE, RESPONSE_FROM_CACHE][ms]", (Object)log);
            }
            finally {
                context.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testMaxLimit() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                int i;
                for (i = 0; i < 1000; ++i) {
                    new TestCommand("A", false, true).execute();
                }
                for (i = 0; i < 10; ++i) {
                    new TestCommand("A", false, true).execute();
                }
                Assert.assertEquals((long)1000L, (long)HystrixRequestLog.getCurrentRequest().executedCommands.size());
            }
            finally {
                context.shutdown();
            }
        }
    }
}

