/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextScheduler;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Func2;

public class HystrixContextFunc2<T>
implements Func2<Scheduler, T, Subscription> {
    private final Func2<? super Scheduler, ? super T, ? extends Subscription> actual;
    private final HystrixRequestContext parentThreadState;
    private final Callable<Subscription> c;
    private final AtomicReference<Scheduler> t1Holder = new AtomicReference();
    private final AtomicReference<T> t2Holder = new AtomicReference();

    public HystrixContextFunc2(Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        this(HystrixPlugins.getInstance().getConcurrencyStrategy(), action);
    }

    public HystrixContextFunc2(final HystrixConcurrencyStrategy concurrencyStrategy, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        this.actual = action;
        this.parentThreadState = HystrixRequestContext.getContextForCurrentThread();
        this.c = concurrencyStrategy.wrapCallable(new Callable<Subscription>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Subscription call() throws Exception {
                HystrixRequestContext existingState = HystrixRequestContext.getContextForCurrentThread();
                try {
                    HystrixRequestContext.setContextOnCurrentThread(HystrixContextFunc2.this.parentThreadState);
                    Subscription subscription = (Subscription)HystrixContextFunc2.this.actual.call((Object)new HystrixContextScheduler(concurrencyStrategy, (Scheduler)HystrixContextFunc2.this.t1Holder.get()), HystrixContextFunc2.this.t2Holder.get());
                    return subscription;
                }
                finally {
                    HystrixRequestContext.setContextOnCurrentThread(existingState);
                }
            }
        });
    }

    public Subscription call(Scheduler t1, T t2) {
        try {
            this.t1Holder.set(t1);
            this.t2Holder.set(t2);
            return this.c.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed executing wrapped Func2", e);
        }
    }
}

