/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.util.HystrixRollingNumber;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixThreadPoolMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HystrixThreadPoolMetrics.class);
    private static final ConcurrentHashMap<String, HystrixThreadPoolMetrics> metrics = new ConcurrentHashMap();
    private final HystrixThreadPoolKey threadPoolKey;
    private final HystrixRollingNumber counter;
    private final ThreadPoolExecutor threadPool;
    private final HystrixThreadPoolProperties properties;

    public static HystrixThreadPoolMetrics getInstance(HystrixThreadPoolKey key, ThreadPoolExecutor threadPool, HystrixThreadPoolProperties properties) {
        HystrixThreadPoolMetrics threadPoolMetrics = metrics.get(key.name());
        if (threadPoolMetrics != null) {
            return threadPoolMetrics;
        }
        threadPoolMetrics = new HystrixThreadPoolMetrics(key, threadPool, properties);
        HystrixThreadPoolMetrics existing = metrics.putIfAbsent(key.name(), threadPoolMetrics);
        if (existing == null) {
            return threadPoolMetrics;
        }
        return existing;
    }

    public static HystrixThreadPoolMetrics getInstance(HystrixThreadPoolKey key) {
        return metrics.get(key.name());
    }

    public static Collection<HystrixThreadPoolMetrics> getInstances() {
        return Collections.unmodifiableCollection(metrics.values());
    }

    private HystrixThreadPoolMetrics(HystrixThreadPoolKey threadPoolKey, ThreadPoolExecutor threadPool, HystrixThreadPoolProperties properties) {
        this.threadPoolKey = threadPoolKey;
        this.threadPool = threadPool;
        this.properties = properties;
        this.counter = new HystrixRollingNumber(properties.metricsRollingStatisticalWindowInMilliseconds(), properties.metricsRollingStatisticalWindowBuckets());
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    public HystrixThreadPoolProperties getProperties() {
        return this.properties;
    }

    public Number getCurrentActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public Number getCurrentCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    public Number getCurrentCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public Number getCurrentLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    public Number getCurrentMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public Number getCurrentPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public Number getCurrentTaskCount() {
        return this.threadPool.getTaskCount();
    }

    public Number getCurrentQueueSize() {
        return this.threadPool.getQueue().size();
    }

    public void markThreadExecution() {
        this.counter.increment(HystrixRollingNumberEvent.THREAD_EXECUTION);
        this.setMaxActiveThreads();
    }

    public long getRollingCountThreadsExecuted() {
        return this.counter.getRollingSum(HystrixRollingNumberEvent.THREAD_EXECUTION);
    }

    public long getCumulativeCountThreadsExecuted() {
        return this.counter.getCumulativeSum(HystrixRollingNumberEvent.THREAD_EXECUTION);
    }

    public void markThreadCompletion() {
        this.setMaxActiveThreads();
    }

    public long getRollingMaxActiveThreads() {
        return this.counter.getRollingMaxValue(HystrixRollingNumberEvent.THREAD_MAX_ACTIVE);
    }

    private void setMaxActiveThreads() {
        this.counter.updateRollingMax(HystrixRollingNumberEvent.THREAD_MAX_ACTIVE, this.threadPool.getActiveCount());
    }
}

