/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixContextCallable;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixContextScheduler;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.netflix.hystrix.util.ExceptionThreadingUtility;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.hystrix.util.HystrixTimer;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx.subjects.ReplaySubject;
import rx.subscriptions.Subscriptions;

@ThreadSafe
public abstract class HystrixCommand<R>
implements HystrixExecutable<R> {
    private static final Logger logger = LoggerFactory.getLogger(HystrixCommand.class);
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixThreadPool threadPool;
    private final HystrixThreadPoolKey threadPoolKey;
    private final HystrixCommandProperties properties;
    private final HystrixCommandMetrics metrics;
    private volatile ExecutionResult executionResult = ExecutionResult.access$000();
    private final AtomicReference<TimedOutStatus> isCommandTimedOut = new AtomicReference<TimedOutStatus>(TimedOutStatus.NOT_EXECUTED);
    private final AtomicBoolean isExecutionComplete = new AtomicBoolean(false);
    private final AtomicBoolean isExecutedInThread = new AtomicBoolean(false);
    private final HystrixCommandKey commandKey;
    private final HystrixCommandGroupKey commandGroup;
    private final TryableSemaphore fallbackSemaphoreOverride;
    private static final ConcurrentHashMap<String, TryableSemaphore> fallbackSemaphorePerCircuit = new ConcurrentHashMap();
    private final TryableSemaphore executionSemaphoreOverride;
    private static final ConcurrentHashMap<String, TryableSemaphore> executionSemaphorePerCircuit = new ConcurrentHashMap();
    private final AtomicReference<Reference<HystrixTimer.TimerListener>> timeoutTimer = new AtomicReference();
    private AtomicBoolean started = new AtomicBoolean();
    private volatile long invocationStartTime = -1L;
    private final HystrixRequestCache requestCache;
    private final HystrixEventNotifier eventNotifier;
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private final HystrixCommandExecutionHook executionHook;
    private static ConcurrentHashMap<Class<? extends HystrixCommand>, String> defaultNameCache = new ConcurrentHashMap();

    protected HystrixCommand(HystrixCommandGroupKey group) {
        this(new Setter(group));
    }

    protected HystrixCommand(Setter setter) {
        this(setter.groupKey, setter.commandKey, setter.threadPoolKey, null, null, setter.commandPropertiesDefaults, setter.threadPoolPropertiesDefaults, null, null, null, null, null);
    }

    private HystrixCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, TryableSemaphore fallbackSemaphore, TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        if (group == null) {
            throw new IllegalStateException("HystrixCommandGroup can not be NULL");
        }
        this.commandGroup = group;
        if (key == null || key.name().trim().equals("")) {
            String keyName = HystrixCommand.getDefaultNameFromClass(this.getClass());
            this.commandKey = HystrixCommandKey.Factory.asKey(keyName);
        } else {
            this.commandKey = key;
        }
        this.properties = propertiesStrategy == null ? HystrixPropertiesFactory.getCommandProperties(this.commandKey, commandPropertiesDefaults) : propertiesStrategy.getCommandProperties(this.commandKey, commandPropertiesDefaults);
        this.threadPoolKey = this.properties.executionIsolationThreadPoolKeyOverride().get() == null ? (threadPoolKey == null ? HystrixThreadPoolKey.Factory.asKey(this.commandGroup.name()) : threadPoolKey) : HystrixThreadPoolKey.Factory.asKey(this.properties.executionIsolationThreadPoolKeyOverride().get());
        this.eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        this.metrics = metrics == null ? HystrixCommandMetrics.getInstance(this.commandKey, this.commandGroup, this.properties) : metrics;
        this.circuitBreaker = this.properties.circuitBreakerEnabled().get().booleanValue() ? (circuitBreaker == null ? HystrixCircuitBreaker.Factory.getInstance(this.commandKey, this.commandGroup, this.properties, this.metrics) : circuitBreaker) : new HystrixCircuitBreaker.NoOpCircuitBreaker();
        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCommand(this.commandKey, this.commandGroup, this.metrics, this.circuitBreaker, this.properties);
        this.executionHook = executionHook == null ? HystrixPlugins.getInstance().getCommandExecutionHook() : executionHook;
        this.threadPool = threadPool == null ? HystrixThreadPool.Factory.getInstance(this.threadPoolKey, threadPoolPropertiesDefaults) : threadPool;
        this.fallbackSemaphoreOverride = fallbackSemaphore;
        this.executionSemaphoreOverride = executionSemaphore;
        this.requestCache = HystrixRequestCache.getInstance(this.commandKey, this.concurrencyStrategy);
    }

    private static String getDefaultNameFromClass(Class<? extends HystrixCommand> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    protected abstract R run() throws Exception;

    protected R getFallback() {
        throw new UnsupportedOperationException("No fallback available.");
    }

    public HystrixCommandGroupKey getCommandGroup() {
        return this.commandGroup;
    }

    public HystrixCommandKey getCommandKey() {
        return this.commandKey;
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    HystrixCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public HystrixCommandMetrics getMetrics() {
        return this.metrics;
    }

    public HystrixCommandProperties getProperties() {
        return this.properties;
    }

    void markAsCollapsedCommand(int sizeOfBatch) {
        this.getMetrics().markCollapsed(sizeOfBatch);
        this.executionResult = this.executionResult.addEvents(HystrixEventType.COLLAPSED);
    }

    @Override
    public R execute() {
        try {
            return this.queue().get();
        }
        catch (Exception e) {
            throw this.decomposeException(e);
        }
    }

    @Override
    public Future<R> queue() {
        final ObservableCommand<R> o = this.toObservable(Schedulers.immediate(), false);
        final Future f = o.toBlocking().toFuture();
        if (f.isDone()) {
            try {
                f.get();
                return f;
            }
            catch (Exception e) {
                RuntimeException re = this.decomposeException(e);
                if (re instanceof HystrixBadRequestException) {
                    return f;
                }
                if (re instanceof HystrixRuntimeException) {
                    HystrixRuntimeException hre = (HystrixRuntimeException)re;
                    if (hre.getFailureType() == HystrixRuntimeException.FailureType.COMMAND_EXCEPTION || hre.getFailureType() == HystrixRuntimeException.FailureType.TIMEOUT) {
                        return f;
                    }
                    throw hre;
                }
                throw re;
            }
        }
        return new Future<R>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }

            @Override
            public R get() throws InterruptedException, ExecutionException {
                return this.performBlockingGetWithTimeout(o, f);
            }

            protected R performBlockingGetWithTimeout(ObservableCommand<R> o2, Future<R> f2) throws InterruptedException, ExecutionException {
                Reference timer;
                if (f2.isDone()) {
                    return f2.get();
                }
                HystrixCommand originalCommand = o2.getCommand();
                if (originalCommand != null && (timer = (Reference)originalCommand.timeoutTimer.getAndSet(null)) != null) {
                    long timeout;
                    HystrixTimer.TimerListener l = (HystrixTimer.TimerListener)timer.get();
                    timer.clear();
                    long timeRemaining = timeout = (long)originalCommand.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue();
                    long currTime = System.currentTimeMillis();
                    if (originalCommand.invocationStartTime != -1L) {
                        timeRemaining = originalCommand.invocationStartTime + (long)originalCommand.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue() - currTime;
                    }
                    if (timeRemaining > 0L) {
                        try {
                            return f2.get(timeRemaining, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            if (l != null) {
                                l.tick();
                            }
                        }
                    } else if (!f2.isDone() && l != null) {
                        l.tick();
                    }
                }
                return f2.get();
            }

            @Override
            public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }
        };
    }

    protected RuntimeException decomposeException(Exception e) {
        if (e instanceof IllegalStateException) {
            return (IllegalStateException)e;
        }
        if (e instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e;
        }
        if (e.getCause() instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e.getCause();
        }
        if (e instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e;
        }
        if (e.getCause() instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e.getCause();
        }
        String message = this.getLogMessagePrefix() + " failed while executing.";
        logger.debug(message, (Throwable)e);
        return new HystrixRuntimeException(HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, this.getClass(), message, e, null);
    }

    @Override
    public Observable<R> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.toObservable().subscribe((Observer)subject);
        return subject;
    }

    public Observable<R> toObservable() {
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
            return this.toObservable(Schedulers.computation());
        }
        return this.toObservable(Schedulers.immediate());
    }

    public Observable<R> toObservable(Scheduler observeOn) {
        return this.toObservable(observeOn, true);
    }

    private ObservableCommand<R> toObservable(Scheduler observeOn, boolean performAsyncTimeout) {
        Observable fromCache;
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("This instance can only be executed once. Please instantiate a new instance.");
        }
        String _cacheKey = this.getCacheKey();
        if (this.isRequestCachingEnabled() && _cacheKey != null && (fromCache = this.requestCache.get(_cacheKey)) != null) {
            this.metrics.markResponseFromCache();
            return new CachedObservableResponse((CachedObservableOriginal)fromCache, this);
        }
        final HystrixCommand _this = this;
        ObservableCommand o = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super R> observer) {
                block9: {
                    try {
                        HystrixCommand.this.invocationStartTime = System.currentTimeMillis();
                        HystrixCommand.this.executionHook.onStart(_this);
                        if (!HystrixCommand.this.circuitBreaker.allowRequest()) {
                            HystrixCommand.this.metrics.markShortCircuited();
                            try {
                                observer.onNext(HystrixCommand.this.getFallbackOrThrowException(HystrixEventType.SHORT_CIRCUITED, HystrixRuntimeException.FailureType.SHORTCIRCUIT, "short-circuited", new RuntimeException("Hystrix circuit short-circuited and is OPEN")));
                                observer.onCompleted();
                            }
                            catch (Exception e) {
                                observer.onError((Throwable)e);
                            }
                            break block9;
                        }
                        try {
                            if (HystrixCommand.this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
                                HystrixCommand.this.subscribeWithThreadIsolation(observer);
                                break block9;
                            }
                            HystrixCommand.this.subscribeWithSemaphoreIsolation(observer);
                        }
                        catch (RuntimeException e) {
                            observer.onError((Throwable)e);
                        }
                    }
                    finally {
                        HystrixCommand.this.recordExecutedCommand();
                    }
                }
            }
        });
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
            o = new CachedObservableOriginal(o, _this, performAsyncTimeout);
        }
        o = o.onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

            public Observable<R> call(Throwable e) {
                HystrixCommand.this.metrics.markExceptionThrown();
                return Observable.error((Throwable)e);
            }
        });
        if (!Schedulers.immediate().equals(observeOn)) {
            o = o.observeOn(new HystrixContextScheduler(this.concurrencyStrategy, observeOn));
        }
        o = o.finallyDo(new Action0(){

            public void call() {
                Reference tl = (Reference)HystrixCommand.this.timeoutTimer.get();
                if (tl != null) {
                    tl.clear();
                }
            }
        });
        if (this.isRequestCachingEnabled() && _cacheKey != null) {
            Observable fromCache2 = this.requestCache.putIfAbsent(_cacheKey, o = new CachedObservableOriginal(o.cache(), this));
            if (fromCache2 != null) {
                o = new CachedObservableResponse((CachedObservableOriginal)fromCache2, this);
            }
            return o;
        }
        return new ObservableCommand(o, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subscription subscribeWithSemaphoreIsolation(Observer<? super R> observer) {
        TryableSemaphore executionSemaphore = this.getExecutionSemaphore();
        if (executionSemaphore.tryAcquire()) {
            try {
                Subscription subscription;
                try {
                    Hystrix.startCurrentThreadExecutingCommand(this.getCommandKey());
                    R r = this.executeCommand();
                    observer.onNext(r);
                    this.recordTotalExecutionTime(this.invocationStartTime);
                    observer.onCompleted();
                    subscription = Subscriptions.empty();
                }
                catch (Exception e) {
                    Subscription subscription2;
                    try {
                        this.recordTotalExecutionTime(this.invocationStartTime);
                        observer.onError((Throwable)e);
                        subscription2 = Subscriptions.empty();
                    }
                    catch (Throwable throwable) {
                        Hystrix.endCurrentThreadExecutingCommand();
                        throw throwable;
                    }
                    Hystrix.endCurrentThreadExecutingCommand();
                    executionSemaphore.release();
                    return subscription2;
                }
                Hystrix.endCurrentThreadExecutingCommand();
                return subscription;
            }
            finally {
                executionSemaphore.release();
            }
        }
        this.metrics.markSemaphoreRejection();
        logger.debug("HystrixCommand Execution Rejection by Semaphore.");
        observer.onNext(this.getFallbackOrThrowException(HystrixEventType.SEMAPHORE_REJECTED, HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION, "could not acquire a semaphore for execution", new RuntimeException("could not acquire a semaphore for execution")));
        observer.onCompleted();
        return Subscriptions.empty();
    }

    private void subscribeWithThreadIsolation(final Subscriber<? super R> observer) {
        this.isExecutedInThread.set(true);
        final Thread callingThread = Thread.currentThread();
        final HystrixCommand _this = this;
        try {
            if (!this.threadPool.isQueueSpaceAvailable()) {
                throw new RejectedExecutionException("Rejected command because thread-pool queueSize is at rejection threshold.");
            }
            final Future f = this.threadPool.getExecutor().submit(new HystrixContextCallable(this.concurrencyStrategy, new Callable<R>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public R call() throws Exception {
                    boolean recordDuration = true;
                    try {
                        ExceptionThreadingUtility.assignCallingThread(callingThread);
                        HystrixCommand.this.executionHook.onThreadStart(_this);
                        HystrixCommand.this.threadPool.markThreadExecution();
                        try {
                            Hystrix.startCurrentThreadExecutingCommand(HystrixCommand.this.getCommandKey());
                            Object r = HystrixCommand.this.executeCommand();
                            if (HystrixCommand.this.isCommandTimedOut.compareAndSet(TimedOutStatus.NOT_EXECUTED, TimedOutStatus.COMPLETED)) {
                                observer.onNext(r);
                                this.preTerminationWork(recordDuration);
                                observer.onCompleted();
                                Object object = r;
                                return object;
                            }
                            recordDuration = false;
                            this.preTerminationWork(recordDuration);
                            Object r2 = null;
                            return r2;
                        }
                        finally {
                            Hystrix.endCurrentThreadExecutingCommand();
                        }
                    }
                    catch (Exception e) {
                        this.preTerminationWork(recordDuration);
                        if (!HystrixCommand.this.isCommandTimedOut.compareAndSet(TimedOutStatus.NOT_EXECUTED, TimedOutStatus.COMPLETED)) throw e;
                        observer.onError((Throwable)e);
                        throw e;
                    }
                }

                private void preTerminationWork(boolean recordDuration) {
                    if (recordDuration) {
                        HystrixCommand.this.recordTotalExecutionTime(HystrixCommand.this.invocationStartTime);
                    }
                    HystrixCommand.this.threadPool.markThreadCompletion();
                    try {
                        HystrixCommand.this.executionHook.onThreadComplete(_this);
                    }
                    catch (Exception e) {
                        logger.warn("ExecutionHook.onThreadComplete threw an exception that will be ignored.", (Throwable)e);
                    }
                }
            }));
            observer.add(Subscriptions.create((Action0)new Action0(){

                public void call() {
                    f.cancel(HystrixCommand.this.properties.executionIsolationThreadInterruptOnTimeout().get());
                }
            }));
        }
        catch (RejectedExecutionException e) {
            this.metrics.markThreadPoolRejection();
            observer.onNext(this.getFallbackOrThrowException(HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "could not be queued for execution", e));
            observer.onCompleted();
        }
        catch (Exception e) {
            logger.error(this.getLogMessagePrefix() + ": Unexpected exception while submitting to queue.", (Throwable)e);
            observer.onNext(this.getFallbackOrThrowException(HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "had unexpected exception while attempting to queue for execution.", e));
            observer.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R executeCommand() {
        long startTime = System.currentTimeMillis();
        this.metrics.incrementConcurrentExecutionCount();
        try {
            this.executionHook.onRunStart(this);
            R response = this.executionHook.onRunSuccess(this, this.run());
            long duration = System.currentTimeMillis() - startTime;
            this.metrics.addCommandExecutionTime(duration);
            if (this.isCommandTimedOut.get() == TimedOutStatus.TIMED_OUT) {
                R r = null;
                return r;
            }
            this.executionResult = this.executionResult.addEvents(HystrixEventType.SUCCESS);
            this.metrics.markSuccess(duration);
            this.circuitBreaker.markSuccess();
            this.eventNotifier.markCommandExecution(this.getCommandKey(), this.properties.executionIsolationStrategy().get(), (int)duration, this.executionResult.events);
            R r = this.executionHook.onComplete(this, response);
            return r;
        }
        catch (HystrixBadRequestException e) {
            Exception decorated;
            try {
                decorated = this.executionHook.onRunError(this, e);
                if (decorated instanceof HystrixBadRequestException) {
                    e = (HystrixBadRequestException)decorated;
                } else {
                    logger.warn("ExecutionHook.onRunError returned an exception that was not an instance of HystrixBadRequestException so will be ignored.", (Throwable)decorated);
                }
            }
            catch (Exception hookException) {
                logger.warn("Error calling ExecutionHook.onRunError", (Throwable)hookException);
            }
            try {
                decorated = this.executionHook.onError(this, HystrixRuntimeException.FailureType.BAD_REQUEST_EXCEPTION, e);
                if (decorated instanceof HystrixBadRequestException) {
                    e = (HystrixBadRequestException)decorated;
                } else {
                    logger.warn("ExecutionHook.onError returned an exception that was not an instance of HystrixBadRequestException so will be ignored.", (Throwable)decorated);
                }
            }
            catch (Exception hookException) {
                logger.warn("Error calling ExecutionHook.onError", (Throwable)hookException);
            }
            throw e;
        }
        catch (Throwable t) {
            Exception e = null;
            e = t instanceof Exception ? (Exception)t : new Exception("Throwable caught while executing.", t);
            try {
                e = this.executionHook.onRunError(this, e);
            }
            catch (Exception hookException) {
                logger.warn("Error calling ExecutionHook.endRunFailure", (Throwable)hookException);
            }
            if (this.isCommandTimedOut.get() == TimedOutStatus.TIMED_OUT) {
                logger.debug("Error executing HystrixCommand.run() [TimedOut]. Proceeding to fallback logic ...", (Throwable)e);
                R r = null;
                return r;
            }
            logger.debug("Error executing HystrixCommand.run(). Proceeding to fallback logic ...", (Throwable)e);
            this.metrics.markFailure(System.currentTimeMillis() - startTime);
            this.executionResult = this.executionResult.setException(e);
            R r = this.getFallbackOrThrowException(HystrixEventType.FAILURE, HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, "failed", e);
            return r;
        }
        finally {
            this.metrics.decrementConcurrentExecutionCount();
            this.isExecutionComplete.set(true);
        }
    }

    private R getFallbackWithProtection() {
        TryableSemaphore fallbackSemaphore = this.getFallbackSemaphore();
        if (fallbackSemaphore.tryAcquire()) {
            try {
                this.executionHook.onFallbackStart(this);
                R r = this.executionHook.onFallbackSuccess(this, this.getFallback());
                return r;
            }
            catch (RuntimeException e) {
                Exception decorated = this.executionHook.onFallbackError(this, e);
                if (decorated instanceof RuntimeException) {
                    e = (RuntimeException)decorated;
                } else {
                    logger.warn("ExecutionHook.onFallbackError returned an exception that was not an instance of RuntimeException so will be ignored.", (Throwable)decorated);
                }
                throw e;
            }
            finally {
                fallbackSemaphore.release();
            }
        }
        this.metrics.markFallbackRejection();
        logger.debug("HystrixCommand Fallback Rejection.");
        throw new HystrixRuntimeException(HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_FALLBACK, this.getClass(), this.getLogMessagePrefix() + " fallback execution rejected.", null, null);
    }

    private void recordTotalExecutionTime(long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        this.metrics.addUserThreadExecutionTime(duration);
        this.executionResult = this.executionResult.setExecutionTime((int)duration);
    }

    private void recordExecutedCommand() {
        if (this.properties.requestLogEnabled().get().booleanValue()) {
            if (this.concurrencyStrategy instanceof HystrixConcurrencyStrategyDefault) {
                if (HystrixRequestContext.isCurrentThreadInitialized()) {
                    HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy).addExecutedCommand(this);
                }
            } else if (HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) != null) {
                HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy).addExecutedCommand(this);
            }
        }
    }

    public boolean isCircuitBreakerOpen() {
        return this.circuitBreaker.isOpen();
    }

    public boolean isExecutionComplete() {
        return this.isExecutionComplete.get();
    }

    public boolean isExecutedInThread() {
        return this.isExecutedInThread.get();
    }

    public boolean isSuccessfulExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.SUCCESS);
    }

    public boolean isFailedExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.FAILURE);
    }

    public Throwable getFailedExecutionException() {
        return this.executionResult.exception;
    }

    public boolean isResponseFromFallback() {
        return this.executionResult.events.contains((Object)HystrixEventType.FALLBACK_SUCCESS);
    }

    public boolean isResponseTimedOut() {
        return this.executionResult.events.contains((Object)HystrixEventType.TIMEOUT);
    }

    public boolean isResponseShortCircuited() {
        return this.executionResult.events.contains((Object)HystrixEventType.SHORT_CIRCUITED);
    }

    public boolean isResponseFromCache() {
        return this.executionResult.events.contains((Object)HystrixEventType.RESPONSE_FROM_CACHE);
    }

    public boolean isResponseRejected() {
        return this.executionResult.events.contains((Object)HystrixEventType.THREAD_POOL_REJECTED) || this.executionResult.events.contains((Object)HystrixEventType.SEMAPHORE_REJECTED);
    }

    public List<HystrixEventType> getExecutionEvents() {
        return this.executionResult.events;
    }

    public int getExecutionTimeInMilliseconds() {
        return this.executionResult.executionTime;
    }

    private TryableSemaphore getFallbackSemaphore() {
        if (this.fallbackSemaphoreOverride == null) {
            TryableSemaphore _s = fallbackSemaphorePerCircuit.get(this.commandKey.name());
            if (_s == null) {
                fallbackSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphore(this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests()));
                return fallbackSemaphorePerCircuit.get(this.commandKey.name());
            }
            return _s;
        }
        return this.fallbackSemaphoreOverride;
    }

    private TryableSemaphore getExecutionSemaphore() {
        if (this.executionSemaphoreOverride == null) {
            TryableSemaphore _s = executionSemaphorePerCircuit.get(this.commandKey.name());
            if (_s == null) {
                executionSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphore(this.properties.executionIsolationSemaphoreMaxConcurrentRequests()));
                return executionSemaphorePerCircuit.get(this.commandKey.name());
            }
            return _s;
        }
        return this.executionSemaphoreOverride;
    }

    private R getFallbackOrThrowException(HystrixEventType eventType, HystrixRuntimeException.FailureType failureType, String message, Exception e) {
        if (this.properties.fallbackEnabled().get().booleanValue()) {
            R r;
            try {
                this.executionResult = this.executionResult.addEvents(eventType);
                R fallback = this.getFallbackWithProtection();
                this.metrics.markFallbackSuccess();
                this.executionResult = this.executionResult.addEvents(HystrixEventType.FALLBACK_SUCCESS);
                r = this.executionHook.onComplete(this, fallback);
            }
            catch (UnsupportedOperationException fe) {
                logger.debug("No fallback for HystrixCommand. ", (Throwable)fe);
                try {
                    e = this.executionHook.onError(this, failureType, e);
                }
                catch (Exception hookException) {
                    logger.warn("Error calling ExecutionHook.onError", (Throwable)hookException);
                }
                throw new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and no fallback available.", e, (Throwable)fe);
            }
            catch (Exception fe) {
                logger.debug("HystrixCommand execution " + failureType.name() + " and fallback retrieval failed.", (Throwable)fe);
                this.metrics.markFallbackFailure();
                this.executionResult = this.executionResult.addEvents(HystrixEventType.FALLBACK_FAILURE);
                try {
                    e = this.executionHook.onError(this, failureType, e);
                }
                catch (Exception hookException) {
                    logger.warn("Error calling ExecutionHook.onError", (Throwable)hookException);
                }
                throw new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and failed retrieving fallback.", e, (Throwable)fe);
            }
            return r;
        }
        logger.debug("Fallback disabled for HystrixCommand so will throw HystrixRuntimeException. ", (Throwable)e);
        this.executionResult = this.executionResult.addEvents(eventType);
        try {
            e = this.executionHook.onError(this, failureType, e);
        }
        catch (Exception hookException) {
            logger.warn("Error calling ExecutionHook.onError", (Throwable)hookException);
        }
        throw new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and fallback disabled.", e, null);
        finally {
            this.isExecutionComplete.set(true);
        }
    }

    protected String getCacheKey() {
        return null;
    }

    private boolean isRequestCachingEnabled() {
        return this.properties.requestCacheEnabled().get();
    }

    private String getLogMessagePrefix() {
        return this.getCommandKey().name();
    }

    public static class UnitTest {
        private static HystrixPropertiesStrategy TEST_PROPERTIES_FACTORY = new TestPropertiesFactory();

        @Before
        public void prepareForTest() {
            HystrixRequestContext.initializeContext();
        }

        @After
        public void cleanup() {
            if (HystrixRequestContext.getContextForCurrentThread() != null) {
                HystrixRequestContext.getContextForCurrentThread().shutdown();
            }
            ConfigurationManager.getConfigInstance().clear();
        }

        private static void recordHookCall(StringBuilder sequenceRecorder, String methodName) {
            sequenceRecorder.append(methodName).append(" - ");
        }

        @Test
        public void testExecutionSuccess() {
            try {
                SuccessfulTestCommand command = new SuccessfulTestCommand();
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((Object)true, command.execute());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals(null, (Object)command.getFailedExecutionException());
                Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isSuccessfulExecution());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
                Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testExecutionMultipleTimes() {
            SuccessfulTestCommand command = new SuccessfulTestCommand();
            Assert.assertFalse((boolean)command.isExecutionComplete());
            Assert.assertEquals((Object)true, command.execute());
            Assert.assertTrue((boolean)command.isExecutionComplete());
            Assert.assertTrue((boolean)command.isExecutedInThread());
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isSuccessfulExecution());
            try {
                command.execute();
                Assert.fail((String)"we should not allow this ... it breaks the state of request logs");
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            try {
                command.queue();
                Assert.fail((String)"we should not allow this ... it breaks the state of request logs");
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testExecutionKnownFailureWithNoFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithoutFallback command = new KnownFailureTestCommandWithoutFallback(circuitBreaker);
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (HystrixRuntimeException e) {
                e.printStackTrace();
                Assert.assertNotNull((Object)e.getFallbackException());
                Assert.assertNotNull(e.getImplementingClass());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should always get an HystrixRuntimeException when an error occurs.");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionUnknownFailureWithNoFallback() {
            UnknownFailureTestCommandWithoutFallback command = new UnknownFailureTestCommandWithoutFallback();
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (HystrixRuntimeException e) {
                e.printStackTrace();
                Assert.assertNotNull((Object)e.getFallbackException());
                Assert.assertNotNull(e.getImplementingClass());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should always get an HystrixRuntimeException when an error occurs.");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionFailureWithFallback() {
            KnownFailureTestCommandWithFallback command = new KnownFailureTestCommandWithFallback(new HystrixCircuitBreaker.TestCircuitBreaker());
            try {
                Assert.assertEquals((Object)false, command.execute());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((Object)"we failed with a simulated issue", (Object)command.getFailedExecutionException().getMessage());
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionFailureWithFallbackFailure() {
            KnownFailureTestCommandWithFallbackFailure command = new KnownFailureTestCommandWithFallbackFailure();
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (HystrixRuntimeException e) {
                System.out.println("------------------------------------------------");
                e.printStackTrace();
                System.out.println("------------------------------------------------");
                Assert.assertNotNull((Object)e.getFallbackException());
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueSuccess() {
            SuccessfulTestCommand command = new SuccessfulTestCommand();
            try {
                Future future = command.queue();
                Assert.assertEquals((Object)true, future.get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isSuccessfulExecution());
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueKnownFailureWithNoFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithoutFallback command = new KnownFailureTestCommandWithoutFallback(circuitBreaker);
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertNotNull(de.getImplementingClass());
                }
                Assert.fail((String)"the cause should be HystrixRuntimeException");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueUnknownFailureWithNoFallback() {
            UnknownFailureTestCommandWithoutFallback command = new UnknownFailureTestCommandWithoutFallback();
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertNotNull(de.getImplementingClass());
                }
                Assert.fail((String)"the cause should be HystrixRuntimeException");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueFailureWithFallback() {
            KnownFailureTestCommandWithFallback command = new KnownFailureTestCommandWithFallback(new HystrixCircuitBreaker.TestCircuitBreaker());
            try {
                Future future = command.queue();
                Assert.assertEquals((Object)false, future.get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueueFailureWithFallbackFailure() {
            KnownFailureTestCommandWithFallbackFailure command = new KnownFailureTestCommandWithFallbackFailure();
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    e.printStackTrace();
                    Assert.assertNotNull((Object)de.getFallbackException());
                }
                Assert.fail((String)"the cause should be HystrixRuntimeException");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testObserveSuccess() {
            try {
                SuccessfulTestCommand command = new SuccessfulTestCommand();
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((Object)true, (Object)command.observe().toBlocking().single());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals(null, (Object)command.getFailedExecutionException());
                Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isSuccessfulExecution());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
                Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testObserveOnScheduler() throws Exception {
            for (int i = 0; i < 5; ++i) {
                final AtomicReference commandThread = new AtomicReference();
                final AtomicReference subscribeThread = new AtomicReference();
                TestHystrixCommand<Boolean> command = new TestHystrixCommand<Boolean>(TestHystrixCommand.testPropsBuilder()){

                    @Override
                    protected Boolean run() {
                        commandThread.set(Thread.currentThread());
                        return true;
                    }
                };
                final CountDownLatch latch = new CountDownLatch(1);
                command.toObservable(Schedulers.newThread()).subscribe((Observer)new Observer<Boolean>(){

                    public void onCompleted() {
                        latch.countDown();
                    }

                    public void onError(Throwable e) {
                        latch.countDown();
                        e.printStackTrace();
                    }

                    public void onNext(Boolean args) {
                        subscribeThread.set(Thread.currentThread());
                    }
                });
                if (!latch.await(2000L, TimeUnit.MILLISECONDS)) {
                    Assert.fail((String)"timed out");
                }
                Assert.assertNotNull(commandThread.get());
                Assert.assertNotNull(subscribeThread.get());
                System.out.println("Command Thread: " + commandThread.get());
                System.out.println("Subscribe Thread: " + subscribeThread.get());
                Assert.assertTrue((boolean)((Thread)commandThread.get()).getName().startsWith("hystrix-"));
                Assert.assertFalse((boolean)((Thread)subscribeThread.get()).getName().startsWith("hystrix-"));
                Assert.assertTrue((boolean)((Thread)subscribeThread.get()).getName().startsWith("Rx"));
            }
        }

        @Test
        public void testObserveOnComputationSchedulerByDefaultForThreadIsolation() throws Exception {
            final AtomicReference commandThread = new AtomicReference();
            final AtomicReference subscribeThread = new AtomicReference();
            TestHystrixCommand<Boolean> command = new TestHystrixCommand<Boolean>(TestHystrixCommand.testPropsBuilder()){

                @Override
                protected Boolean run() {
                    commandThread.set(Thread.currentThread());
                    return true;
                }
            };
            final CountDownLatch latch = new CountDownLatch(1);
            command.toObservable().subscribe((Observer)new Observer<Boolean>(){

                public void onCompleted() {
                    latch.countDown();
                }

                public void onError(Throwable e) {
                    latch.countDown();
                    e.printStackTrace();
                }

                public void onNext(Boolean args) {
                    subscribeThread.set(Thread.currentThread());
                }
            });
            if (!latch.await(2000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"timed out");
            }
            Assert.assertNotNull(commandThread.get());
            Assert.assertNotNull(subscribeThread.get());
            System.out.println("Command Thread: " + commandThread.get());
            System.out.println("Subscribe Thread: " + subscribeThread.get());
            Assert.assertTrue((boolean)((Thread)commandThread.get()).getName().startsWith("hystrix-"));
            Assert.assertTrue((boolean)((Thread)subscribeThread.get()).getName().startsWith("RxComputationThreadPool"));
        }

        @Test
        public void testObserveOnImmediateSchedulerByDefaultForSemaphoreIsolation() throws Exception {
            final AtomicReference commandThread = new AtomicReference();
            final AtomicReference subscribeThread = new AtomicReference();
            TestHystrixCommand<Boolean> command = new TestHystrixCommand<Boolean>(TestHystrixCommand.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE))){

                @Override
                protected Boolean run() {
                    commandThread.set(Thread.currentThread());
                    return true;
                }
            };
            final CountDownLatch latch = new CountDownLatch(1);
            command.toObservable().subscribe((Observer)new Observer<Boolean>(){

                public void onCompleted() {
                    latch.countDown();
                }

                public void onError(Throwable e) {
                    latch.countDown();
                    e.printStackTrace();
                }

                public void onNext(Boolean args) {
                    subscribeThread.set(Thread.currentThread());
                }
            });
            if (!latch.await(2000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"timed out");
            }
            Assert.assertNotNull(commandThread.get());
            Assert.assertNotNull(subscribeThread.get());
            System.out.println("Command Thread: " + commandThread.get());
            System.out.println("Subscribe Thread: " + subscribeThread.get());
            String mainThreadName = Thread.currentThread().getName();
            Assert.assertTrue((boolean)((Thread)commandThread.get()).getName().equals(mainThreadName));
            Assert.assertTrue((boolean)((Thread)subscribeThread.get()).getName().equals(mainThreadName));
        }

        @Test
        public void testCircuitBreakerTripsAfterFailures() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt1.execute();
            Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt2 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt2.execute();
            Assert.assertTrue((boolean)attempt2.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt3.execute();
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
            KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt4.execute();
            Assert.assertTrue((boolean)attempt4.isResponseFromFallback());
            Assert.assertTrue((boolean)attempt4.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt4.isCircuitBreakerOpen());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCircuitBreakerTripsAfterFailuresViaQueue() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt1.queue().get();
                Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
                Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
                KnownFailureTestCommandWithFallback attempt2 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt2.queue().get();
                Assert.assertTrue((boolean)attempt2.isResponseFromFallback());
                Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
                KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt3.queue().get();
                Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
                Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
                Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
                KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker);
                attempt4.queue().get();
                Assert.assertTrue((boolean)attempt4.isResponseFromFallback());
                Assert.assertTrue((boolean)attempt4.isResponseShortCircuited());
                Assert.assertTrue((boolean)attempt4.isCircuitBreakerOpen());
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
                Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received fallbacks.");
            }
        }

        @Test
        public void testCircuitBreakerAcrossMultipleCommandsButSameCircuitBreaker() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt1.execute();
            Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
            KnownFailureTestCommandWithoutFallback attempt2 = new KnownFailureTestCommandWithoutFallback(circuitBreaker);
            try {
                attempt2.execute();
            }
            catch (Exception e) {
                // empty catch block
            }
            Assert.assertTrue((boolean)attempt2.isFailedExecution());
            Assert.assertFalse((boolean)attempt2.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt3.execute();
            Assert.assertTrue((boolean)attempt2.isFailedExecution());
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
            KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker);
            attempt4.execute();
            Assert.assertTrue((boolean)attempt4.isResponseFromFallback());
            Assert.assertTrue((boolean)attempt4.isResponseShortCircuited());
            Assert.assertTrue((boolean)attempt4.isCircuitBreakerOpen());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCircuitBreakerAcrossMultipleCommandsAndDifferentDependency() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker_one = new HystrixCircuitBreaker.TestCircuitBreaker();
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker_two = new HystrixCircuitBreaker.TestCircuitBreaker();
            KnownFailureTestCommandWithFallback attempt1 = new KnownFailureTestCommandWithFallback(circuitBreaker_one);
            attempt1.execute();
            Assert.assertTrue((boolean)attempt1.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt1.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt1.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt2 = new KnownFailureTestCommandWithFallback(circuitBreaker_two);
            attempt2.execute();
            Assert.assertTrue((boolean)attempt2.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isResponseShortCircuited());
            KnownFailureTestCommandWithFallback attempt3 = new KnownFailureTestCommandWithFallback(circuitBreaker_one);
            attempt3.execute();
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertFalse((boolean)attempt3.isCircuitBreakerOpen());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            KnownFailureTestCommandWithFallback attempt4 = new KnownFailureTestCommandWithFallback(circuitBreaker_one);
            attempt4.execute();
            Assert.assertTrue((boolean)attempt3.isCircuitBreakerOpen());
            Assert.assertTrue((boolean)attempt3.isResponseFromFallback());
            Assert.assertFalse((boolean)attempt3.isResponseShortCircuited());
            Assert.assertFalse((boolean)attempt2.isCircuitBreakerOpen());
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)3L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker_one.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker_one.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker_two.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker_two.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionSuccessWithCircuitBreakerDisabled() {
            TestCommandWithoutCircuitBreaker command = new TestCommandWithoutCircuitBreaker();
            try {
                Assert.assertEquals((Object)true, command.execute());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionTimeoutWithNoFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 1);
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException");
            }
            Assert.assertTrue((String)("Execution Time is: " + command.getExecutionTimeInMilliseconds()), (command.getExecutionTimeInMilliseconds() >= 50 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isResponseTimedOut());
            Assert.assertFalse((boolean)command.isResponseFromFallback());
            Assert.assertFalse((boolean)command.isResponseRejected());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionTimeoutWithFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                Assert.assertEquals((Object)false, command.execute());
                Assert.assertTrue((String)("Execution Time is: " + command.getExecutionTimeInMilliseconds()), (command.getExecutionTimeInMilliseconds() >= 50 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isResponseTimedOut());
                Assert.assertTrue((boolean)command.isResponseFromFallback());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionTimeoutFallbackFailure() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 3);
            try {
                command.execute();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertFalse((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException");
            }
            Assert.assertTrue((String)("Execution Time is: " + command.getExecutionTimeInMilliseconds()), (command.getExecutionTimeInMilliseconds() >= 50 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCircuitBreakerOnExecutionTimeout() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                command.execute();
                Assert.assertTrue((boolean)command.isResponseFromFallback());
                Assert.assertFalse((boolean)command.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)command.isResponseShortCircuited());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isResponseTimedOut());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testCountersOnExecutionTimeout() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                command.execute();
                Thread.sleep(200L);
                Assert.assertTrue((boolean)command.isResponseFromFallback());
                Assert.assertFalse((boolean)command.isCircuitBreakerOpen());
                Assert.assertFalse((boolean)command.isResponseShortCircuited());
                Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isResponseTimedOut());
                Assert.assertFalse((boolean)command.isSuccessfulExecution());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueuedExecutionTimeoutWithNoFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 1);
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof ExecutionException && e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be ExecutionException with cause as HystrixRuntimeException");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isResponseTimedOut());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueuedExecutionTimeoutWithFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                Assert.assertEquals((Object)false, command.queue().get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testQueuedExecutionTimeoutFallbackFailure() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 3);
            try {
                command.queue().get();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e instanceof ExecutionException && e.getCause() instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e.getCause();
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertFalse((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be ExecutionException with cause as HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testObservedExecutionTimeoutWithNoFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 1);
            try {
                command.observe().toBlocking().single();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be ExecutionException with cause as HystrixRuntimeException");
            }
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isResponseTimedOut());
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testObservedExecutionTimeoutWithFallback() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 2);
            try {
                Assert.assertEquals((Object)false, (Object)command.observe().toBlocking().single());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testObservedExecutionTimeoutFallbackFailure() {
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 3);
            try {
                command.observe().toBlocking().single();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                if (e instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertFalse((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                }
                Assert.fail((String)"the exception should be ExecutionException with cause as HystrixRuntimeException");
            }
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testShortCircuitFallbackCounter() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
            try {
                new KnownFailureTestCommandWithFallback(circuitBreaker).execute();
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                KnownFailureTestCommandWithFallback command = new KnownFailureTestCommandWithFallback(circuitBreaker);
                command.execute();
                Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertTrue((command.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isResponseShortCircuited());
                Assert.assertFalse((boolean)command.isResponseTimedOut());
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadWithNoFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            Future f = null;
            HystrixCommand command = null;
            try {
                f = new TestCommandRejection(circuitBreaker, pool, 500, 600, 1).queue();
                command = new TestCommandRejection(circuitBreaker, pool, 500, 600, 1);
                command.queue();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((command.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isResponseRejected());
                Assert.assertFalse((boolean)command.isResponseShortCircuited());
                Assert.assertFalse((boolean)command.isResponseTimedOut());
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                if (e instanceof HystrixRuntimeException && e.getCause() instanceof RejectedExecutionException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof RejectedExecutionException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException with cause as RejectedExecutionException");
            }
            try {
                f.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"The first one should succeed.");
            }
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)50L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadWithFallback() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                TestCommandRejection command1 = new TestCommandRejection(circuitBreaker, pool, 500, 600, 2);
                command1.queue();
                TestCommandRejection command2 = new TestCommandRejection(circuitBreaker, pool, 500, 600, 2);
                Assert.assertEquals((Object)false, command2.queue().get());
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertFalse((boolean)command1.isResponseRejected());
                Assert.assertFalse((boolean)command1.isResponseFromFallback());
                Assert.assertTrue((boolean)command2.isResponseRejected());
                Assert.assertTrue((boolean)command2.isResponseFromFallback());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadWithFallbackFailure() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                new TestCommandRejection(circuitBreaker, pool, 500, 600, 3).queue();
                Assert.assertEquals((Object)false, new TestCommandRejection(circuitBreaker, pool, 500, 600, 3).queue().get());
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                if (e instanceof HystrixRuntimeException && e.getCause() instanceof RejectedExecutionException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertFalse((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof RejectedExecutionException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException with cause as RejectedExecutionException");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedThreadUsingQueueSize() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(10, 1);
            pool.queue.add(new Runnable(){

                @Override
                public void run() {
                    System.out.println("**** queue filler1 ****");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            HystrixCommand command = null;
            try {
                command = new TestCommandRejection(circuitBreaker, pool, 500, 600, 1);
                command.queue();
                Assert.fail((String)"we shouldn't get here");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((command.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isResponseRejected());
                Assert.assertFalse((boolean)command.isResponseShortCircuited());
                Assert.assertFalse((boolean)command.isResponseTimedOut());
                Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                if (e instanceof HystrixRuntimeException && e.getCause() instanceof RejectedExecutionException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof RejectedExecutionException));
                }
                Assert.fail((String)"the exception should be HystrixRuntimeException with cause as RejectedExecutionException");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testTimedOutCommandDoesNotExecute() {
            SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(5);
            HystrixCircuitBreaker.TestCircuitBreaker s1 = new HystrixCircuitBreaker.TestCircuitBreaker();
            HystrixCircuitBreaker.TestCircuitBreaker s2 = new HystrixCircuitBreaker.TestCircuitBreaker();
            CommandWithCustomThreadPool c1 = new CommandWithCustomThreadPool(s1, pool, 100, HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(600));
            CommandWithCustomThreadPool c2 = new CommandWithCustomThreadPool(s2, pool, 200, HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(20));
            Future c1f = c1.queue();
            boolean receivedException = false;
            try {
                c2.queue().get();
            }
            catch (Exception e) {
                receivedException = true;
            }
            if (!receivedException) {
                Assert.fail((String)"We expect to receive an exception for c2 as it's supposed to timeout.");
            }
            try {
                c1f.get();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                Assert.fail((String)"we should not have failed while getting c1");
            }
            Assert.assertTrue((String)"c1 is expected to executed but didn't", (boolean)c1.didExecute);
            try {
                Thread.sleep(400L);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to sleep");
            }
            Assert.assertFalse((String)"c2 is not expected to execute, but did", (boolean)c2.didExecute);
            Assert.assertEquals((long)1L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)s1.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)s1.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)s2.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)s2.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testFallbackSemaphore() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                boolean result = (Boolean)new TestSemaphoreCommandWithSlowFallback(circuitBreaker, 1, 200L).queue().get();
                Assert.assertTrue((boolean)result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            boolean exceptionReceived = false;
            Future result = null;
            try {
                result = new TestSemaphoreCommandWithSlowFallback(circuitBreaker, 1, 400L).queue();
                Thread.sleep(50L);
                Future result2 = new TestSemaphoreCommandWithSlowFallback(circuitBreaker, 1, 200L).queue();
                result2.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                exceptionReceived = true;
            }
            try {
                Assert.assertTrue((boolean)((Boolean)result.get()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!exceptionReceived) {
                Assert.fail((String)"We expected an exception on the 2nd get");
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionSemaphoreWithQueue() {
            final HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                boolean result = (Boolean)new TestSemaphoreCommand(circuitBreaker, 1, 200L, 1, 11).queue().get();
                Assert.assertTrue((boolean)result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final AtomicBoolean exceptionReceived = new AtomicBoolean();
            final TryableSemaphore semaphore = new TryableSemaphore(HystrixProperty.Factory.asProperty(1));
            HystrixContextRunnable r = new HystrixContextRunnable(HystrixPlugins.getInstance().getConcurrencyStrategy(), new Runnable(){

                @Override
                public void run() {
                    try {
                        new TestSemaphoreCommand(circuitBreaker, semaphore, 200L, 1, 11).queue().get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptionReceived.set(true);
                    }
                }
            });
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"failed waiting on threads");
            }
            if (!exceptionReceived.get()) {
                Assert.fail((String)"We expected an exception on the 2nd get");
            }
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionSemaphoreWithExecution() {
            final HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                TestSemaphoreCommand command = new TestSemaphoreCommand(circuitBreaker, 1, 200L, 1, 11);
                boolean result = (Boolean)command.execute();
                Assert.assertFalse((boolean)command.isExecutedInThread());
                Assert.assertTrue((boolean)result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final ArrayBlockingQueue results = new ArrayBlockingQueue(2);
            final AtomicBoolean exceptionReceived = new AtomicBoolean();
            final TryableSemaphore semaphore = new TryableSemaphore(HystrixProperty.Factory.asProperty(1));
            HystrixContextRunnable r = new HystrixContextRunnable(HystrixPlugins.getInstance().getConcurrencyStrategy(), new Runnable(){

                @Override
                public void run() {
                    try {
                        results.add(new TestSemaphoreCommand(circuitBreaker, semaphore, 200L, 1, 11).execute());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptionReceived.set(true);
                    }
                }
            });
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"failed waiting on threads");
            }
            if (!exceptionReceived.get()) {
                Assert.fail((String)"We expected an exception on the 2nd get");
            }
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(Boolean.TRUE));
            Assert.assertFalse((boolean)results.contains(Boolean.FALSE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRejectedExecutionSemaphoreWithFallback() {
            final HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            final ArrayBlockingQueue results = new ArrayBlockingQueue(2);
            final AtomicBoolean exceptionReceived = new AtomicBoolean();
            HystrixContextRunnable r = new HystrixContextRunnable(HystrixPlugins.getInstance().getConcurrencyStrategy(), new Runnable(){

                @Override
                public void run() {
                    try {
                        results.add(new TestSemaphoreCommand(circuitBreaker, 1, 200L, 1, 10).execute());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptionReceived.set(true);
                    }
                }
            });
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"failed waiting on threads");
            }
            if (exceptionReceived.get()) {
                Assert.fail((String)"We should have received a fallback response");
            }
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(Boolean.TRUE));
            Assert.assertTrue((boolean)results.contains(Boolean.FALSE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            System.out.println("**** DONE");
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testSemaphorePermitsInUse() {
            int i;
            final HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            final TryableSemaphore sharedSemaphore = new TryableSemaphore(HystrixProperty.Factory.asProperty(3));
            final CountDownLatch startLatch = new CountDownLatch((Integer)sharedSemaphore.numberOfPermits.get() + 1);
            final CountDownLatch sharedLatch = new CountDownLatch(1);
            HystrixContextRunnable sharedSemaphoreRunnable = new HystrixContextRunnable(HystrixPlugins.getInstance().getConcurrencyStrategy(), new Runnable(){

                @Override
                public void run() {
                    try {
                        new LatchedSemaphoreCommand(circuitBreaker, sharedSemaphore, startLatch, sharedLatch).execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            int sharedThreadCount = (Integer)sharedSemaphore.numberOfPermits.get() * 2;
            Thread[] sharedSemaphoreThreads = new Thread[sharedThreadCount];
            for (int i2 = 0; i2 < sharedThreadCount; ++i2) {
                sharedSemaphoreThreads[i2] = new Thread(sharedSemaphoreRunnable);
            }
            final TryableSemaphore isolatedSemaphore = new TryableSemaphore(HystrixProperty.Factory.asProperty(1));
            final CountDownLatch isolatedLatch = new CountDownLatch(1);
            final AtomicInteger failureCount = new AtomicInteger();
            Thread isolatedThread = new Thread(new HystrixContextRunnable(HystrixPlugins.getInstance().getConcurrencyStrategy(), new Runnable(){

                @Override
                public void run() {
                    try {
                        new LatchedSemaphoreCommand(circuitBreaker, isolatedSemaphore, startLatch, isolatedLatch).execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        failureCount.incrementAndGet();
                    }
                }
            }));
            Assert.assertEquals((String)"wrong number of permits for shared semaphore", (long)0L, (long)sharedSemaphore.getNumberOfPermitsUsed());
            Assert.assertEquals((String)"wrong number of permits for isolated semaphore", (long)0L, (long)isolatedSemaphore.getNumberOfPermitsUsed());
            for (i = 0; i < sharedThreadCount; ++i) {
                sharedSemaphoreThreads[i].start();
            }
            isolatedThread.start();
            try {
                startLatch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((String)"wrong number of permits for shared semaphore", (long)((Integer)sharedSemaphore.numberOfPermits.get()).longValue(), (long)sharedSemaphore.getNumberOfPermitsUsed());
            Assert.assertEquals((String)"wrong number of permits for isolated semaphore", (long)((Integer)isolatedSemaphore.numberOfPermits.get()).longValue(), (long)isolatedSemaphore.getNumberOfPermitsUsed());
            sharedLatch.countDown();
            isolatedLatch.countDown();
            try {
                for (i = 0; i < sharedThreadCount; ++i) {
                    sharedSemaphoreThreads[i].join();
                }
                isolatedThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"failed waiting on threads");
            }
            Assert.assertEquals((String)"wrong number of permits for shared semaphore", (long)0L, (long)sharedSemaphore.getNumberOfPermitsUsed());
            Assert.assertEquals((String)"wrong number of permits for isolated semaphore", (long)0L, (long)isolatedSemaphore.getNumberOfPermitsUsed());
            int expectedFailures = sharedSemaphore.getNumberOfPermitsUsed();
            Assert.assertEquals((String)"failures expected but did not happen", (long)expectedFailures, (long)failureCount.get());
        }

        @Test
        public void testDynamicOwner() {
            try {
                DynamicOwnerTestCommand command = new DynamicOwnerTestCommand(CommandGroupForUnitTest.OWNER_ONE);
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((Object)true, command.execute());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testDynamicOwnerFails() {
            try {
                DynamicOwnerTestCommand command = new DynamicOwnerTestCommand(null);
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((Object)true, command.execute());
                Assert.fail((String)"we should have thrown an exception as we need an owner");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Test
        public void testDynamicKey() {
            try {
                DynamicOwnerAndKeyTestCommand command1 = new DynamicOwnerAndKeyTestCommand(CommandGroupForUnitTest.OWNER_ONE, CommandKeyForUnitTest.KEY_ONE);
                Assert.assertEquals((Object)true, command1.execute());
                DynamicOwnerAndKeyTestCommand command2 = new DynamicOwnerAndKeyTestCommand(CommandGroupForUnitTest.OWNER_ONE, CommandKeyForUnitTest.KEY_TWO);
                Assert.assertEquals((Object)true, command2.execute());
                Assert.assertNotSame((Object)command1.getCircuitBreaker(), (Object)command2.getCircuitBreaker());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We received an exception.");
            }
        }

        @Test
        public void testRequestCache1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"A", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertFalse((boolean)command2.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((command1.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)command1.isResponseFromCache());
            Assert.assertEquals((long)2L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((command2.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command2.isResponseFromCache());
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCache2() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "B");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((command2.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)command2.isResponseFromCache());
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCache3() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "B");
            SuccessfulCacheableCommand command3 = new SuccessfulCacheableCommand(circuitBreaker, true, "A");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertFalse((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)2L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((command3.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command3.isResponseFromCache());
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheWithSlowExecution() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SlowCacheableCommand command1 = new SlowCacheableCommand(circuitBreaker, "A", 200);
            SlowCacheableCommand command2 = new SlowCacheableCommand(circuitBreaker, "A", 100);
            SlowCacheableCommand command3 = new SlowCacheableCommand(circuitBreaker, "A", 100);
            SlowCacheableCommand command4 = new SlowCacheableCommand(circuitBreaker, "A", 100);
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            Future f4 = command4.queue();
            try {
                Assert.assertEquals((Object)"A", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
                Assert.assertEquals((Object)"A", f4.get());
                Assert.assertEquals((Object)"A", f1.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertFalse((boolean)command2.executed);
            Assert.assertFalse((boolean)command3.executed);
            Assert.assertFalse((boolean)command4.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((command1.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)command1.isResponseFromCache());
            Assert.assertEquals((long)2L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((command2.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command2.isResponseFromCache());
            Assert.assertTrue((boolean)command3.isResponseFromCache());
            Assert.assertTrue((command3.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command4.isResponseFromCache());
            Assert.assertTrue((command4.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            System.out.println("HystrixRequestLog: " + HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString());
        }

        @Test
        public void testNoRequestCache3() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommand command1 = new SuccessfulCacheableCommand(circuitBreaker, false, "A");
            SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, false, "B");
            SuccessfulCacheableCommand command3 = new SuccessfulCacheableCommand(circuitBreaker, false, "A");
            Assert.assertTrue((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertTrue((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheViaQueueSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertFalse((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)2L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((boolean)command3.isResponseFromCache());
            Assert.assertTrue((command3.getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testNoRequestCacheViaQueueSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            Future f1 = command1.queue();
            Future f2 = command2.queue();
            Future f3 = command3.queue();
            try {
                Assert.assertEquals((Object)"A", f1.get());
                Assert.assertEquals((Object)"B", f2.get());
                Assert.assertEquals((Object)"A", f3.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertTrue((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheViaExecuteSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, true, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            String f1 = (String)command1.execute();
            String f2 = (String)command2.execute();
            String f3 = (String)command3.execute();
            Assert.assertEquals((Object)"A", (Object)f1);
            Assert.assertEquals((Object)"B", (Object)f2);
            Assert.assertEquals((Object)"A", (Object)f3);
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertFalse((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)2L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)2L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testNoRequestCacheViaExecuteSemaphore1() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            SuccessfulCacheableCommandViaSemaphore command1 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            SuccessfulCacheableCommandViaSemaphore command2 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "B");
            SuccessfulCacheableCommandViaSemaphore command3 = new SuccessfulCacheableCommandViaSemaphore(circuitBreaker, false, "A");
            Assert.assertFalse((boolean)command1.isCommandRunningInThread());
            String f1 = (String)command1.execute();
            String f2 = (String)command2.execute();
            String f3 = (String)command3.execute();
            Assert.assertEquals((Object)"A", (Object)f1);
            Assert.assertEquals((Object)"B", (Object)f2);
            Assert.assertEquals((Object)"A", (Object)f3);
            Assert.assertTrue((boolean)command1.executed);
            Assert.assertTrue((boolean)command2.executed);
            Assert.assertTrue((boolean)command3.executed);
            Assert.assertEquals((long)1L, (long)command1.getExecutionEvents().size());
            Assert.assertTrue((boolean)command1.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command2.getExecutionEvents().size());
            Assert.assertTrue((boolean)command2.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)1L, (long)command3.getExecutionEvents().size());
            Assert.assertTrue((boolean)command3.getExecutionEvents().contains((Object)HystrixEventType.SUCCESS));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)3L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testNoRequestCacheOnTimeoutThrowsException() throws Exception {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            NoRequestCacheTimeoutWithoutFallback r1 = new NoRequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                System.out.println("r1 value: " + r1.execute());
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r1.isResponseTimedOut());
            }
            NoRequestCacheTimeoutWithoutFallback r2 = new NoRequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                r2.execute();
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r2.isResponseTimedOut());
            }
            NoRequestCacheTimeoutWithoutFallback r3 = new NoRequestCacheTimeoutWithoutFallback(circuitBreaker);
            Future f3 = r3.queue();
            try {
                f3.get();
                Assert.fail((String)"expected a timeout");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)r3.isResponseTimedOut());
            }
            Thread.sleep(500L);
            NoRequestCacheTimeoutWithoutFallback r4 = new NoRequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                r4.execute();
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r4.isResponseTimedOut());
                Assert.assertFalse((boolean)r4.isResponseFromFallback());
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheOnTimeoutCausesNullPointerException() throws Exception {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            Assert.assertFalse((boolean)((Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute()));
            Assert.assertFalse((boolean)((Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute()));
            Assert.assertFalse((boolean)((Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute()));
            Thread.sleep(500L);
            Boolean value = (Boolean)new RequestCacheNullPointerExceptionCase(circuitBreaker).execute();
            Assert.assertFalse((boolean)value);
            RequestCacheNullPointerExceptionCase c = new RequestCacheNullPointerExceptionCase(circuitBreaker);
            Future f = c.queue();
            Assert.assertNotNull(f);
            Assert.assertFalse((boolean)((Boolean)f.get()));
            Assert.assertTrue((boolean)c.isResponseFromFallback());
            Assert.assertTrue((boolean)c.isResponseTimedOut());
            Assert.assertFalse((boolean)c.isFailedExecution());
            Assert.assertFalse((boolean)c.isResponseShortCircuited());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)4L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)5L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
            HystrixCommand[] executeCommands = HystrixRequestLog.getCurrentRequest().getExecutedCommands().toArray(new HystrixCommand[0]);
            System.out.println(":executeCommands[0].getExecutionEvents()" + executeCommands[0].getExecutionEvents());
            Assert.assertEquals((long)2L, (long)executeCommands[0].getExecutionEvents().size());
            Assert.assertTrue((boolean)executeCommands[0].getExecutionEvents().contains((Object)HystrixEventType.FALLBACK_SUCCESS));
            Assert.assertTrue((boolean)executeCommands[0].getExecutionEvents().contains((Object)HystrixEventType.TIMEOUT));
            Assert.assertTrue((executeCommands[0].getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)executeCommands[0].isResponseTimedOut());
            Assert.assertTrue((boolean)executeCommands[0].isResponseFromFallback());
            Assert.assertFalse((boolean)executeCommands[0].isResponseFromCache());
            Assert.assertEquals((long)3L, (long)executeCommands[1].getExecutionEvents().size());
            Assert.assertTrue((boolean)executeCommands[1].getExecutionEvents().contains((Object)HystrixEventType.RESPONSE_FROM_CACHE));
            Assert.assertTrue((executeCommands[1].getExecutionTimeInMilliseconds() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)executeCommands[1].isResponseFromCache());
            Assert.assertTrue((boolean)executeCommands[1].isResponseTimedOut());
            Assert.assertTrue((boolean)executeCommands[1].isResponseFromFallback());
        }

        @Test
        public void testRequestCacheOnTimeoutThrowsException() throws Exception {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            RequestCacheTimeoutWithoutFallback r1 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                System.out.println("r1 value: " + r1.execute());
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r1.isResponseTimedOut());
            }
            RequestCacheTimeoutWithoutFallback r2 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                r2.execute();
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r2.isResponseTimedOut());
            }
            RequestCacheTimeoutWithoutFallback r3 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            Future f3 = r3.queue();
            try {
                f3.get();
                Assert.fail((String)"expected a timeout");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)r3.isResponseTimedOut());
            }
            Thread.sleep(500L);
            RequestCacheTimeoutWithoutFallback r4 = new RequestCacheTimeoutWithoutFallback(circuitBreaker);
            try {
                r4.execute();
                Assert.fail((String)"expected a timeout");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r4.isResponseTimedOut());
                Assert.assertFalse((boolean)r4.isResponseFromFallback());
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testRequestCacheOnThreadRejectionThrowsException() throws Exception {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            CountDownLatch completionLatch = new CountDownLatch(1);
            RequestCacheThreadRejectionWithoutFallback r1 = new RequestCacheThreadRejectionWithoutFallback(circuitBreaker, completionLatch);
            try {
                System.out.println("r1: " + r1.execute());
                Assert.fail((String)"expected a rejection");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r1.isResponseRejected());
            }
            RequestCacheThreadRejectionWithoutFallback r2 = new RequestCacheThreadRejectionWithoutFallback(circuitBreaker, completionLatch);
            try {
                System.out.println("r2: " + r2.execute());
                Assert.fail((String)"expected a rejection");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r2.isResponseRejected());
            }
            RequestCacheThreadRejectionWithoutFallback r3 = new RequestCacheThreadRejectionWithoutFallback(circuitBreaker, completionLatch);
            try {
                System.out.println("f3: " + r3.queue().get());
                Assert.fail((String)"expected a rejection");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r3.isResponseRejected());
            }
            completionLatch.countDown();
            RequestCacheThreadRejectionWithoutFallback r4 = new RequestCacheThreadRejectionWithoutFallback(circuitBreaker, completionLatch);
            try {
                System.out.println("r4: " + r4.execute());
                Assert.fail((String)"expected a rejection");
            }
            catch (HystrixRuntimeException e) {
                Assert.assertTrue((boolean)r4.isResponseRejected());
                Assert.assertFalse((boolean)r4.isResponseFromFallback());
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)3L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)circuitBreaker.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)4L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testBasicExecutionWorksWithoutRequestVariable() {
            try {
                HystrixRequestContext.setContextOnCurrentThread(null);
                SuccessfulTestCommand command = new SuccessfulTestCommand();
                Assert.assertEquals((Object)true, command.execute());
                SuccessfulTestCommand command2 = new SuccessfulTestCommand();
                Assert.assertEquals((Object)true, command2.queue().get());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("We received an exception => " + e.getMessage()));
            }
        }

        @Test
        public void testCacheKeyExecutionRequiresRequestVariable() {
            try {
                HystrixRequestContext.setContextOnCurrentThread(null);
                HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                SuccessfulCacheableCommand command = new SuccessfulCacheableCommand(circuitBreaker, true, "one");
                Assert.assertEquals((Object)true, command.execute());
                SuccessfulCacheableCommand command2 = new SuccessfulCacheableCommand(circuitBreaker, true, "two");
                Assert.assertEquals((Object)true, command2.queue().get());
                Assert.fail((String)"We expect an exception because cacheKey requires RequestVariable.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testBadRequestExceptionViaExecuteInThread() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).execute();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (HystrixBadRequestException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testBadRequestExceptionViaQueueInThread() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).queue().get();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                if (!(e.getCause() instanceof HystrixBadRequestException)) {
                    Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testBadRequestExceptionViaQueueInThreadOnResponseFromCache() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).execute();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).queue().get();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                if (!(e.getCause() instanceof HystrixBadRequestException)) {
                    Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testBadRequestExceptionViaExecuteInSemaphore() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).execute();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (HystrixBadRequestException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testBadRequestExceptionViaQueueInSemaphore() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            try {
                new BadRequestCommand(circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).queue().get();
                Assert.fail((String)("we expect to receive a " + HystrixBadRequestException.class.getSimpleName()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                if (!(e.getCause() instanceof HystrixBadRequestException)) {
                    Assert.fail((String)("We expect a " + HystrixBadRequestException.class.getSimpleName() + " but got a " + e.getClass().getSimpleName()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
        }

        @Test
        public void testCheckedExceptionViaExecute() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            CommandWithCheckedException command = new CommandWithCheckedException(circuitBreaker);
            try {
                command.execute();
                Assert.fail((String)("we expect to receive a " + Exception.class.getSimpleName()));
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"simulated checked exception message", (Object)e.getCause().getMessage());
            }
            Assert.assertEquals((Object)"simulated checked exception message", (Object)command.getFailedExecutionException().getMessage());
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
        }

        @Test
        public void testCheckedExceptionViaObserve() throws InterruptedException {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            CommandWithCheckedException command = new CommandWithCheckedException(circuitBreaker);
            final AtomicReference t = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                command.observe().subscribe((Observer)new Observer<Boolean>(){

                    public void onCompleted() {
                        latch.countDown();
                    }

                    public void onError(Throwable e) {
                        t.set(e);
                        latch.countDown();
                    }

                    public void onNext(Boolean args) {
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"we should not get anything thrown, it should be emitted via the Observer#onError method");
            }
            latch.await(1L, TimeUnit.SECONDS);
            Assert.assertNotNull(t.get());
            ((Throwable)t.get()).printStackTrace();
            Assert.assertTrue((boolean)(t.get() instanceof HystrixRuntimeException));
            Assert.assertEquals((Object)"simulated checked exception message", (Object)((Throwable)t.get()).getCause().getMessage());
            Assert.assertEquals((Object)"simulated checked exception message", (Object)command.getFailedExecutionException().getMessage());
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
        }

        @Test
        public void testErrorThrownViaExecute() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            CommandWithErrorThrown command = new CommandWithErrorThrown(circuitBreaker);
            try {
                command.execute();
                Assert.fail((String)("we expect to receive a " + Error.class.getSimpleName()));
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"simulated java.lang.Error message", (Object)e.getCause().getCause().getMessage());
            }
            Assert.assertEquals((Object)"simulated java.lang.Error message", (Object)command.getFailedExecutionException().getCause().getMessage());
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
        }

        @Test
        public void testErrorThrownViaQueue() {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            CommandWithErrorThrown command = new CommandWithErrorThrown(circuitBreaker);
            try {
                command.queue().get();
                Assert.fail((String)"we expect to receive an Exception");
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"simulated java.lang.Error message", (Object)e.getCause().getCause().getCause().getMessage());
            }
            Assert.assertEquals((Object)"simulated java.lang.Error message", (Object)command.getFailedExecutionException().getCause().getMessage());
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
        }

        @Test
        public void testErrorThrownViaObserve() throws InterruptedException {
            HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
            CommandWithErrorThrown command = new CommandWithErrorThrown(circuitBreaker);
            final AtomicReference t = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                command.observe().subscribe((Observer)new Observer<Boolean>(){

                    public void onCompleted() {
                        latch.countDown();
                    }

                    public void onError(Throwable e) {
                        t.set(e);
                        latch.countDown();
                    }

                    public void onNext(Boolean args) {
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"we should not get anything thrown, it should be emitted via the Observer#onError method");
            }
            latch.await(1L, TimeUnit.SECONDS);
            Assert.assertNotNull(t.get());
            ((Throwable)t.get()).printStackTrace();
            Assert.assertTrue((boolean)(t.get() instanceof HystrixRuntimeException));
            Assert.assertEquals((Object)"simulated java.lang.Error message", (Object)((Throwable)t.get()).getCause().getCause().getMessage());
            Assert.assertEquals((Object)"simulated java.lang.Error message", (Object)command.getFailedExecutionException().getCause().getMessage());
            Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)command.isFailedExecution());
            Assert.assertEquals((long)0L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)1L, (long)circuitBreaker.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
        }

        private <T> void assertHooksOnSuccess(Func0<TestHystrixCommand<T>> ctor, Action1<TestHystrixCommand<T>> assertion) {
            this.assertExecute((TestHystrixCommand)ctor.call(), assertion, true);
            this.assertBlockingQueue((TestHystrixCommand)ctor.call(), assertion, true);
            this.assertBlockingObserve((TestHystrixCommand)ctor.call(), assertion, true);
            this.assertNonBlockingObserve((TestHystrixCommand)ctor.call(), assertion, true);
        }

        private <T> void assertHooksOnFailure(Func0<TestHystrixCommand<T>> ctor, Action1<TestHystrixCommand<T>> assertion) {
            this.assertExecute((TestHystrixCommand)ctor.call(), assertion, false);
            this.assertBlockingQueue((TestHystrixCommand)ctor.call(), assertion, false);
            this.assertBlockingObserve((TestHystrixCommand)ctor.call(), assertion, false);
            this.assertNonBlockingObserve((TestHystrixCommand)ctor.call(), assertion, false);
        }

        private <T> void assertExecute(TestHystrixCommand<T> command, Action1<TestHystrixCommand<T>> assertion, boolean isSuccess) {
            System.out.println("Running command.execute() and then assertions...");
            if (isSuccess) {
                command.execute();
            } else {
                try {
                    command.execute();
                    Assert.fail((String)"Expected a command failure!");
                }
                catch (Exception ex) {
                    System.out.println("Received expected ex : " + ex);
                    ex.printStackTrace();
                }
            }
            assertion.call(command);
        }

        private <T> void assertBlockingQueue(TestHystrixCommand<T> command, Action1<TestHystrixCommand<T>> assertion, boolean isSuccess) {
            System.out.println("Running command.queue(), immediately blocking and then running assertions...");
            if (isSuccess) {
                try {
                    command.queue().get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                command.queue().get();
                Assert.fail((String)"Expected a command failure!");
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                System.out.println("Received expected ex : " + ee.getCause());
                ee.getCause().printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Received expected ex : " + e);
                e.printStackTrace();
            }
            assertion.call(command);
        }

        private <T> void assertNonBlockingQueue(TestHystrixCommand<T> command, Action1<TestHystrixCommand<T>> assertion, boolean isSuccess) {
            System.out.println("Running command.queue(), sleeping the test thread until command is complete, and then running assertions...");
            Future f = command.queue();
            this.awaitCommandCompletion(command);
            assertion.call(command);
            if (isSuccess) {
                try {
                    f.get();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                f.get();
                Assert.fail((String)"Expected a command failure!");
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                System.out.println("Received expected ex : " + ee.getCause());
                ee.getCause().printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Received expected ex : " + e);
                e.printStackTrace();
            }
        }

        private <T> void assertBlockingObserve(TestHystrixCommand<T> command, Action1<TestHystrixCommand<T>> assertion, boolean isSuccess) {
            System.out.println("Running command.observe(), immediately blocking and then running assertions...");
            if (isSuccess) {
                try {
                    command.observe().toBlocking().single();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                command.observe().toBlocking().single();
                Assert.fail((String)"Expected a command failure!");
            }
            catch (Exception ex) {
                System.out.println("Received expected ex : " + ex);
                ex.printStackTrace();
            }
            assertion.call(command);
        }

        private <T> void assertNonBlockingObserve(TestHystrixCommand<T> command, Action1<TestHystrixCommand<T>> assertion, boolean isSuccess) {
            System.out.println("Running command.observe(), awaiting terminal state of Observable, then running assertions...");
            final CountDownLatch latch = new CountDownLatch(1);
            Observable o = command.observe();
            o.subscribe(new Subscriber<T>(){

                public void onCompleted() {
                    latch.countDown();
                }

                public void onError(Throwable e) {
                    latch.countDown();
                }

                public void onNext(T t) {
                }
            });
            try {
                latch.await(3L, TimeUnit.SECONDS);
                assertion.call(command);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (isSuccess) {
                try {
                    o.toBlocking().single();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                o.toBlocking().single();
                Assert.fail((String)"Expected a command failure!");
            }
            catch (Exception ex) {
                System.out.println("Received expected ex : " + ex);
                ex.printStackTrace();
            }
        }

        private <T> void awaitCommandCompletion(TestHystrixCommand<T> command) {
            while (!command.isExecutionComplete()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("interrupted");
                }
            }
        }

        @Test
        public void testExecutionHookThreadSuccess() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new SuccessfulTestCommand();
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onRunSuccess - onComplete - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadBadRequestException() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new KnownHystrixBadRequestFailureTestCommand(new HystrixCircuitBreaker.TestCircuitBreaker());
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(HystrixBadRequestException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.BAD_REQUEST_EXCEPTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onRunError - onError - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadExceptionNoFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new KnownFailureTestCommandWithoutFallback(new HystrixCircuitBreaker.TestCircuitBreaker());
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.COMMAND_EXCEPTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onRunError - onFallbackStart - onFallbackError - onError - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadExceptionSuccessfulFallback() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new KnownFailureTestCommandWithFallback(new HystrixCircuitBreaker.TestCircuitBreaker());
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.runFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onRunError - onFallbackStart - onFallbackSuccess - onComplete - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadExceptionUnsuccessfulFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new KnownFailureTestCommandWithFallbackFailure();
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.COMMAND_EXCEPTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.runFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onRunError - onFallbackStart - onFallbackError - onError - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadTimeoutNoFallbackRunSuccess() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestCommandWithTimeout(50L, 1);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(TimeoutException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.TIMEOUT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    Assert.assertNotNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - onRunSuccess - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadTimeoutSuccessfulFallbackRunSuccess() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestCommandWithTimeout(50L, 2);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    Assert.assertNotNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackSuccess - onComplete - onRunSuccess - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadTimeoutUnsuccessfulFallbackRunSuccess() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestCommandWithTimeout(50L, 3);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(TimeoutException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.TIMEOUT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    Assert.assertNotNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - onRunSuccess - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadTimeoutNoFallbackRunFailure() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestCommandWithTimeout(50L, 1, 11);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(TimeoutException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.TIMEOUT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.runFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - onRunError - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadTimeoutSuccessfulFallbackRunFailure() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestCommandWithTimeout(50L, 2, 11);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackSuccess - onComplete - onRunError - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadTimeoutUnsuccessfulFallbackRunFailure() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestCommandWithTimeout(50L, 3, 11);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(TimeoutException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.TIMEOUT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onThreadStart - onRunStart - onFallbackStart - onFallbackError - onError - onRunError - onThreadComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadPoolQueueFullNoFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                    SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(1);
                    try {
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 1).queue();
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 1).queue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new TestCommandRejection(circuitBreaker, pool, 500, 600, 1);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RejectedExecutionException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadPoolQueueFullSuccessfulFallback() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                    SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(1);
                    try {
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 2).queue();
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 2).queue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new TestCommandRejection(circuitBreaker, pool, 500, 600, 2);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadPoolQueueFullUnsuccessfulFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                    SingleThreadedPoolWithQueue pool = new SingleThreadedPoolWithQueue(1);
                    try {
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 3).queue();
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 3).queue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new TestCommandRejection(circuitBreaker, pool, 500, 600, 3);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RejectedExecutionException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadPoolFullNoFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                    SingleThreadedPoolWithNoQueue pool = new SingleThreadedPoolWithNoQueue();
                    try {
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 1).queue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new TestCommandRejection(circuitBreaker, pool, 500, 600, 1);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RejectedExecutionException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadPoolFullSuccessfulFallback() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                    SingleThreadedPoolWithNoQueue pool = new SingleThreadedPoolWithNoQueue();
                    try {
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 2).queue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new TestCommandRejection(circuitBreaker, pool, 500, 600, 2);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadPoolFullUnsuccessfulFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker();
                    SingleThreadedPoolWithNoQueue pool = new SingleThreadedPoolWithNoQueue();
                    try {
                        new TestCommandRejection(circuitBreaker, pool, 500, 600, 3).queue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return new TestCommandRejection(circuitBreaker, pool, 500, 600, 3);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RejectedExecutionException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadShortCircuitNoFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
                    return new KnownFailureTestCommandWithoutFallback(circuitBreaker);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.SHORTCIRCUIT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadShortCircuitSuccessfulFallback() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
                    return new KnownFailureTestCommandWithFallback(circuitBreaker);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookThreadShortCircuitUnsuccessfulFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
                    return new KnownFailureTestCommandWithFallbackFailure(circuitBreaker);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.SHORTCIRCUIT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreSuccess() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), 10, 10L, 1, 10);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onRunStart - onRunSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreBadRequestException() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), 10, 10L, 3, 10);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(HystrixBadRequestException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.BAD_REQUEST_EXCEPTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onRunStart - onRunError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreExceptionNoFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), 10, 10L, 2, 11);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.COMMAND_EXCEPTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onRunStart - onRunError - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSempahoreExceptionSuccessfulFallback() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), 10, 10L, 2, 10);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onRunStart - onRunError - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreExceptionUnsuccessfulFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), 10, 10L, 2, 12);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.COMMAND_EXCEPTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNotNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onRunStart - onRunError - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreRejectedNoFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    TryableSemaphore semaphore = new TryableSemaphore(HystrixProperty.Factory.asProperty(2));
                    final TestSemaphoreCommand cmd1 = new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 11);
                    final TestSemaphoreCommand cmd2 = new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 11);
                    new Thread(){

                        @Override
                        public void run() {
                            cmd1.queue();
                        }
                    }.start();
                    new Thread(){

                        @Override
                        public void run() {
                            cmd2.queue();
                        }
                    }.start();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 11);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSempahoreRejectedSuccessfulFallback() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    TryableSemaphore semaphore = new TryableSemaphore(HystrixProperty.Factory.asProperty(2));
                    final TestSemaphoreCommand cmd1 = new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 10);
                    final TestSemaphoreCommand cmd2 = new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 10);
                    new Thread(){

                        @Override
                        public void run() {
                            cmd1.queue();
                        }
                    }.start();
                    new Thread(){

                        @Override
                        public void run() {
                            cmd2.queue();
                        }
                    }.start();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 10);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreRejectedUnsuccessfulFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    TryableSemaphore semaphore = new TryableSemaphore(HystrixProperty.Factory.asProperty(2));
                    final TestSemaphoreCommand cmd1 = new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 12);
                    final TestSemaphoreCommand cmd2 = new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 12);
                    new Thread(){

                        @Override
                        public void run() {
                            cmd1.queue();
                        }
                    }.start();
                    new Thread(){

                        @Override
                        public void run() {
                            cmd2.queue();
                        }
                    }.start();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    return new TestSemaphoreCommand(new HystrixCircuitBreaker.TestCircuitBreaker(), semaphore, 500L, 1, 12);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreShortCircuitNoFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
                    return new TestSemaphoreCommand(circuitBreaker, 10, 10L, 1, 11);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.SHORTCIRCUIT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(UnsupportedOperationException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreShortCircuitSuccessfulFallback() {
            this.assertHooksOnSuccess(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
                    return new TestSemaphoreCommand(circuitBreaker, 10, 10L, 1, 10);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteFailureException);
                    Assert.assertNull((Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNotNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.fallbackFailureException);
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackSuccess - onComplete - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionHookSemaphoreShortCircuitUnsuccessfulFallback() {
            this.assertHooksOnFailure(new Func0<TestHystrixCommand<Boolean>>(){

                public TestHystrixCommand<Boolean> call() {
                    HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker = new HystrixCircuitBreaker.TestCircuitBreaker().setForceShortCircuit(true);
                    return new TestSemaphoreCommand(circuitBreaker, 10, 10L, 1, 12);
                }
            }, new Action1<TestHystrixCommand<Boolean>>(){

                public void call(TestHystrixCommand<Boolean> command) {
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startExecute.get());
                    Assert.assertNull((Object)command.builder.executionHook.endExecuteSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.endExecuteFailureException.getClass());
                    Assert.assertEquals((Object)((Object)HystrixRuntimeException.FailureType.SHORTCIRCUIT), (Object)((Object)command.builder.executionHook.endExecuteFailureType));
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.startRun.get());
                    Assert.assertNull((Object)command.builder.executionHook.runSuccessResponse);
                    Assert.assertNull((Object)command.builder.executionHook.runFailureException);
                    Assert.assertEquals((long)1L, (long)command.builder.executionHook.startFallback.get());
                    Assert.assertNull((Object)command.builder.executionHook.fallbackSuccessResponse);
                    Assert.assertEquals(RuntimeException.class, command.builder.executionHook.fallbackFailureException.getClass());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadStart.get());
                    Assert.assertEquals((long)0L, (long)command.builder.executionHook.threadComplete.get());
                    Assert.assertEquals((Object)"onStart - onFallbackStart - onFallbackError - onError - ", (Object)command.builder.executionHook.executionSequence.toString());
                }
            });
        }

        @Test
        public void testExecutionFailureWithFallbackImplementedButDisabled() {
            KnownFailureTestCommandWithFallback commandEnabled = new KnownFailureTestCommandWithFallback(new HystrixCircuitBreaker.TestCircuitBreaker(), true);
            try {
                Assert.assertEquals((Object)false, commandEnabled.execute());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"We should have received a response from the fallback.");
            }
            KnownFailureTestCommandWithFallback commandDisabled = new KnownFailureTestCommandWithFallback(new HystrixCircuitBreaker.TestCircuitBreaker(), false);
            try {
                Assert.assertEquals((Object)false, commandDisabled.execute());
                Assert.fail((String)"expect exception thrown");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((Object)"we failed with a simulated issue", (Object)commandDisabled.getFailedExecutionException().getMessage());
            Assert.assertTrue((boolean)commandDisabled.isFailedExecution());
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            Assert.assertEquals((long)1L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
            Assert.assertEquals((long)1L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            Assert.assertEquals((long)0L, (long)commandDisabled.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
            Assert.assertEquals((long)100L, (long)commandDisabled.builder.metrics.getHealthCounts().getErrorPercentage());
            Assert.assertEquals((long)2L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
        }

        @Test
        public void testExecutionTimeoutValue() {
            Setter properties = Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestKey")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(50));
            HystrixCommand<String> command = new HystrixCommand<String>(properties){

                @Override
                protected String run() throws Exception {
                    Thread.sleep(3000L);
                    return "hello";
                }

                @Override
                protected String getFallback() {
                    if (this.isResponseTimedOut()) {
                        return "timed-out";
                    }
                    return "abc";
                }
            };
            String value = (String)command.execute();
            Assert.assertTrue((boolean)command.isResponseTimedOut());
            Assert.assertEquals((String)"expected fallback value", (Object)"timed-out", (Object)value);
        }

        @Test
        public void testObservableTimeoutNoFallbackThreadContext() {
            final AtomicReference onErrorThread = new AtomicReference();
            final AtomicBoolean isRequestContextInitialized = new AtomicBoolean();
            TestCommandWithTimeout command = new TestCommandWithTimeout(50L, 1);
            try {
                command.toObservable().doOnError((Action1)new Action1<Throwable>(){

                    public void call(Throwable t1) {
                        System.out.println("onError: " + t1);
                        System.out.println("onError Thread: " + Thread.currentThread());
                        System.out.println("ThreadContext in onError: " + HystrixRequestContext.isCurrentThreadInitialized());
                        onErrorThread.set(Thread.currentThread());
                        isRequestContextInitialized.set(HystrixRequestContext.isCurrentThreadInitialized());
                    }
                }).toBlocking().single();
                throw new RuntimeException("expected error to be thrown");
            }
            catch (Throwable e) {
                Assert.assertTrue((boolean)isRequestContextInitialized.get());
                Assert.assertTrue((boolean)((Thread)onErrorThread.get()).getName().startsWith("RxComputationThreadPool"));
                if (e instanceof HystrixRuntimeException) {
                    HystrixRuntimeException de = (HystrixRuntimeException)e;
                    Assert.assertNotNull((Object)de.getFallbackException());
                    Assert.assertTrue((boolean)(de.getFallbackException() instanceof UnsupportedOperationException));
                    Assert.assertNotNull(de.getImplementingClass());
                    Assert.assertNotNull((Object)de.getCause());
                    Assert.assertTrue((boolean)(de.getCause() instanceof TimeoutException));
                } else {
                    Assert.fail((String)"the exception should be ExecutionException with cause as HystrixRuntimeException");
                }
                Assert.assertTrue((command.getExecutionTimeInMilliseconds() > -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)command.isResponseTimedOut());
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                Assert.assertEquals((long)1L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                Assert.assertEquals((long)0L, (long)command.builder.metrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                Assert.assertEquals((long)100L, (long)command.builder.metrics.getHealthCounts().getErrorPercentage());
                Assert.assertEquals((long)1L, (long)HystrixRequestLog.getCurrentRequest().getExecutedCommands().size());
                return;
            }
        }

        @Test(timeout=1000L)
        public void testResponseFlatMappable() {
            Observable result = new SuccessfulTestCommand().toObservable().flatMap((Func1)new Func1<Boolean, Observable<Boolean>>(){

                public Observable<Boolean> call(Boolean t1) {
                    return new SuccessfulTestCommand().toObservable();
                }
            });
            System.out.println("result (toObservable) = " + result.toBlocking().single());
        }

        private static class TestExecutionHook
        extends HystrixCommandExecutionHook {
            StringBuilder executionSequence = new StringBuilder();
            AtomicInteger startExecute = new AtomicInteger();
            Object endExecuteSuccessResponse = null;
            Exception endExecuteFailureException = null;
            HystrixRuntimeException.FailureType endExecuteFailureType = null;
            AtomicInteger startRun = new AtomicInteger();
            Object runSuccessResponse = null;
            Exception runFailureException = null;
            AtomicInteger startFallback = new AtomicInteger();
            Object fallbackSuccessResponse = null;
            Exception fallbackFailureException = null;
            AtomicInteger threadStart = new AtomicInteger();
            AtomicInteger threadComplete = new AtomicInteger();

            private TestExecutionHook() {
            }

            @Override
            public <T> void onStart(HystrixCommand<T> commandInstance) {
                super.onStart(commandInstance);
                UnitTest.recordHookCall(this.executionSequence, "onStart");
                this.startExecute.incrementAndGet();
            }

            @Override
            public <T> T onComplete(HystrixCommand<T> commandInstance, T response) {
                this.endExecuteSuccessResponse = response;
                UnitTest.recordHookCall(this.executionSequence, "onComplete");
                return super.onComplete(commandInstance, response);
            }

            @Override
            public <T> Exception onError(HystrixCommand<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
                this.endExecuteFailureException = e;
                this.endExecuteFailureType = failureType;
                UnitTest.recordHookCall(this.executionSequence, "onError");
                return super.onError(commandInstance, failureType, e);
            }

            @Override
            public <T> void onRunStart(HystrixCommand<T> commandInstance) {
                super.onRunStart(commandInstance);
                UnitTest.recordHookCall(this.executionSequence, "onRunStart");
                this.startRun.incrementAndGet();
            }

            @Override
            public <T> T onRunSuccess(HystrixCommand<T> commandInstance, T response) {
                this.runSuccessResponse = response;
                UnitTest.recordHookCall(this.executionSequence, "onRunSuccess");
                return super.onRunSuccess(commandInstance, response);
            }

            @Override
            public <T> Exception onRunError(HystrixCommand<T> commandInstance, Exception e) {
                this.runFailureException = e;
                UnitTest.recordHookCall(this.executionSequence, "onRunError");
                return super.onRunError(commandInstance, e);
            }

            @Override
            public <T> void onFallbackStart(HystrixCommand<T> commandInstance) {
                super.onFallbackStart(commandInstance);
                UnitTest.recordHookCall(this.executionSequence, "onFallbackStart");
                this.startFallback.incrementAndGet();
            }

            @Override
            public <T> T onFallbackSuccess(HystrixCommand<T> commandInstance, T response) {
                this.fallbackSuccessResponse = response;
                UnitTest.recordHookCall(this.executionSequence, "onFallbackSuccess");
                return super.onFallbackSuccess(commandInstance, response);
            }

            @Override
            public <T> Exception onFallbackError(HystrixCommand<T> commandInstance, Exception e) {
                this.fallbackFailureException = e;
                UnitTest.recordHookCall(this.executionSequence, "onFallbackError");
                return super.onFallbackError(commandInstance, e);
            }

            @Override
            public <T> void onThreadStart(HystrixCommand<T> commandInstance) {
                super.onThreadStart(commandInstance);
                UnitTest.recordHookCall(this.executionSequence, "onThreadStart");
                this.threadStart.incrementAndGet();
            }

            @Override
            public <T> void onThreadComplete(HystrixCommand<T> commandInstance) {
                super.onThreadComplete(commandInstance);
                UnitTest.recordHookCall(this.executionSequence, "onThreadComplete");
                this.threadComplete.incrementAndGet();
            }
        }

        private static class TestPropertiesFactory
        extends HystrixPropertiesStrategy {
            private TestPropertiesFactory() {
            }

            @Override
            public HystrixCommandProperties getCommandProperties(HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
                if (builder == null) {
                    builder = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                }
                return HystrixCommandProperties.Setter.asMock(builder);
            }

            @Override
            public HystrixThreadPoolProperties getThreadPoolProperties(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter builder) {
                if (builder == null) {
                    builder = HystrixThreadPoolProperties.Setter.getUnitTestPropertiesBuilder();
                }
                return HystrixThreadPoolProperties.Setter.asMock(builder);
            }

            @Override
            public HystrixCollapserProperties getCollapserProperties(HystrixCollapserKey collapserKey, HystrixCollapserProperties.Setter builder) {
                throw new IllegalStateException("not expecting collapser properties");
            }

            @Override
            public String getCommandPropertiesCacheKey(HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
                return null;
            }

            @Override
            public String getThreadPoolPropertiesCacheKey(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter builder) {
                return null;
            }

            @Override
            public String getCollapserPropertiesCacheKey(HystrixCollapserKey collapserKey, HystrixCollapserProperties.Setter builder) {
                return null;
            }
        }

        static enum ThreadPoolKeyForUnitTest implements HystrixThreadPoolKey
        {
            THREAD_POOL_ONE,
            THREAD_POOL_TWO;

        }

        static enum CommandGroupForUnitTest implements HystrixCommandGroupKey
        {
            OWNER_ONE,
            OWNER_TWO;

        }

        static enum CommandKeyForUnitTest implements HystrixCommandKey
        {
            KEY_ONE,
            KEY_TWO;

        }

        private static class CommandWithCheckedException
        extends TestHystrixCommand<Boolean> {
            public CommandWithCheckedException(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(CommandWithCheckedException.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            @Override
            protected Boolean run() throws Exception {
                throw new IOException("simulated checked exception message");
            }
        }

        private static class CommandWithErrorThrown
        extends TestHystrixCommand<Boolean> {
            public CommandWithErrorThrown(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(CommandWithErrorThrown.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            @Override
            protected Boolean run() throws Exception {
                throw new Error("simulated java.lang.Error message");
            }
        }

        private static class BadRequestCommand
        extends TestHystrixCommand<Boolean> {
            public BadRequestCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, HystrixCommandProperties.ExecutionIsolationStrategy isolationType) {
                super(BadRequestCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(isolationType)));
            }

            @Override
            protected Boolean run() {
                throw new HystrixBadRequestException("Message to developer that they passed in bad data or something like that.");
            }

            @Override
            protected Boolean getFallback() {
                return false;
            }

            @Override
            protected String getCacheKey() {
                return "one";
            }
        }

        private static class RequestCacheThreadRejectionWithoutFallback
        extends TestHystrixCommand<Boolean> {
            final CountDownLatch completionLatch;

            public RequestCacheThreadRejectionWithoutFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, CountDownLatch completionLatch) {
                super(RequestCacheThreadRejectionWithoutFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setThreadPool(new HystrixThreadPool(){

                    @Override
                    public ThreadPoolExecutor getExecutor() {
                        return null;
                    }

                    @Override
                    public void markThreadExecution() {
                    }

                    @Override
                    public void markThreadCompletion() {
                    }

                    @Override
                    public boolean isQueueSpaceAvailable() {
                        return false;
                    }
                }));
                this.completionLatch = completionLatch;
            }

            @Override
            protected Boolean run() {
                try {
                    if (this.completionLatch.await(1000L, TimeUnit.MILLISECONDS)) {
                        throw new RuntimeException("timed out waiting on completionLatch");
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }

            @Override
            public String getCacheKey() {
                return "A";
            }
        }

        private static class RequestCacheTimeoutWithoutFallback
        extends TestHystrixCommand<Boolean> {
            public RequestCacheTimeoutWithoutFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(RequestCacheTimeoutWithoutFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(200)));
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    System.out.println(">>>> Sleep Interrupted: " + e.getMessage());
                }
                return true;
            }

            @Override
            public String getCacheKey() {
                return "A";
            }
        }

        private static class RequestCacheNullPointerExceptionCase
        extends TestHystrixCommand<Boolean> {
            public RequestCacheNullPointerExceptionCase(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(RequestCacheNullPointerExceptionCase.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(200)));
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected Boolean getFallback() {
                return false;
            }

            @Override
            public String getCacheKey() {
                return "A";
            }
        }

        private static class LatchedSemaphoreCommand
        extends TestHystrixCommand<Boolean> {
            private final CountDownLatch startLatch;
            private final CountDownLatch waitLatch;

            private LatchedSemaphoreCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, TryableSemaphore semaphore, CountDownLatch startLatch, CountDownLatch waitLatch) {
                super(LatchedSemaphoreCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)).setExecutionSemaphore(semaphore));
                this.startLatch = startLatch;
                this.waitLatch = waitLatch;
            }

            @Override
            protected Boolean run() {
                this.startLatch.countDown();
                try {
                    this.waitLatch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        }

        private static class TestSemaphoreCommand
        extends TestHystrixCommand<Boolean> {
            private final long executionSleep;
            private static final int RESULT_SUCCESS = 1;
            private static final int RESULT_FAILURE = 2;
            private static final int RESULT_BAD_REQUEST_EXCEPTION = 3;
            private final int resultBehavior;
            private static final int FALLBACK_SUCCESS = 10;
            private static final int FALLBACK_NOT_IMPLEMENTED = 11;
            private static final int FALLBACK_FAILURE = 12;
            private final int fallbackBehavior;

            private TestSemaphoreCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, int executionSemaphoreCount, long executionSleep, int resultBehavior, int fallbackBehavior) {
                super(TestSemaphoreCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(executionSemaphoreCount)));
                this.executionSleep = executionSleep;
                this.resultBehavior = resultBehavior;
                this.fallbackBehavior = fallbackBehavior;
            }

            private TestSemaphoreCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, TryableSemaphore semaphore, long executionSleep, int resultBehavior, int fallbackBehavior) {
                super(TestSemaphoreCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)).setExecutionSemaphore(semaphore));
                this.executionSleep = executionSleep;
                this.resultBehavior = resultBehavior;
                this.fallbackBehavior = fallbackBehavior;
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(this.executionSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.resultBehavior == 1) {
                    return true;
                }
                if (this.resultBehavior == 2) {
                    throw new RuntimeException("TestSemaphoreCommand failure");
                }
                if (this.resultBehavior == 3) {
                    throw new HystrixBadRequestException("TestSemaphoreCommand BadRequestException");
                }
                throw new IllegalStateException("Didn't use a proper enum for result behavior");
            }

            @Override
            protected Boolean getFallback() {
                if (this.fallbackBehavior == 10) {
                    return false;
                }
                if (this.fallbackBehavior == 12) {
                    throw new RuntimeException("fallback failure");
                }
                return (Boolean)super.getFallback();
            }
        }

        private static class NoRequestCacheTimeoutWithoutFallback
        extends TestHystrixCommand<Boolean> {
            public NoRequestCacheTimeoutWithoutFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(NoRequestCacheTimeoutWithoutFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(200)));
            }

            @Override
            protected Boolean run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    System.out.println(">>>> Sleep Interrupted: " + e.getMessage());
                }
                return true;
            }

            @Override
            public String getCacheKey() {
                return null;
            }
        }

        private static class TestSemaphoreCommandWithSlowFallback
        extends TestHystrixCommand<Boolean> {
            private final long fallbackSleep;

            private TestSemaphoreCommandWithSlowFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, int fallbackSemaphoreExecutionCount, long fallbackSleep) {
                super(TestSemaphoreCommandWithSlowFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withFallbackIsolationSemaphoreMaxConcurrentRequests(fallbackSemaphoreExecutionCount)));
                this.fallbackSleep = fallbackSleep;
            }

            @Override
            protected Boolean run() {
                throw new RuntimeException("run fails");
            }

            @Override
            protected Boolean getFallback() {
                try {
                    Thread.sleep(this.fallbackSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }

        private static class CommandWithCustomThreadPool
        extends TestHystrixCommand<Boolean> {
            public boolean didExecute = false;
            private final int sleepTime;

            private CommandWithCustomThreadPool(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, int sleepTime, HystrixCommandProperties.Setter properties) {
                super(CommandWithCustomThreadPool.testPropsBuilder().setThreadPool(threadPool).setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(properties));
                this.sleepTime = sleepTime;
            }

            @Override
            protected Boolean run() {
                System.out.println("**** Executing CommandWithCustomThreadPool. Execution => " + this.sleepTime);
                this.didExecute = true;
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }

        private static class TestCommandRejection
        extends TestHystrixCommand<Boolean> {
            private static final int FALLBACK_NOT_IMPLEMENTED = 1;
            private static final int FALLBACK_SUCCESS = 2;
            private static final int FALLBACK_FAILURE = 3;
            private final int fallbackBehavior;
            private final int sleepTime;

            private TestCommandRejection(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, int sleepTime, int timeout, int fallbackBehavior) {
                super(TestCommandRejection.testPropsBuilder().setThreadPool(threadPool).setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds(timeout)));
                this.fallbackBehavior = fallbackBehavior;
                this.sleepTime = sleepTime;
            }

            @Override
            protected Boolean run() {
                System.out.println(">>> TestCommandRejection running");
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected Boolean getFallback() {
                if (this.fallbackBehavior == 2) {
                    return false;
                }
                if (this.fallbackBehavior == 3) {
                    throw new RuntimeException("failed on fallback");
                }
                return (Boolean)super.getFallback();
            }
        }

        private static class SingleThreadedPoolWithNoQueue
        implements HystrixThreadPool {
            final SynchronousQueue<Runnable> queue = new SynchronousQueue();
            final ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, this.queue);

            @Override
            public ThreadPoolExecutor getExecutor() {
                return this.pool;
            }

            @Override
            public void markThreadExecution() {
            }

            @Override
            public void markThreadCompletion() {
            }

            @Override
            public boolean isQueueSpaceAvailable() {
                return true;
            }
        }

        private static class SingleThreadedPoolWithQueue
        implements HystrixThreadPool {
            final LinkedBlockingQueue<Runnable> queue;
            final ThreadPoolExecutor pool;
            private final int rejectionQueueSizeThreshold;

            public SingleThreadedPoolWithQueue(int queueSize) {
                this(queueSize, 100);
            }

            public SingleThreadedPoolWithQueue(int queueSize, int rejectionQueueSizeThreshold) {
                this.queue = new LinkedBlockingQueue(queueSize);
                this.pool = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, this.queue);
                this.rejectionQueueSizeThreshold = rejectionQueueSizeThreshold;
            }

            @Override
            public ThreadPoolExecutor getExecutor() {
                return this.pool;
            }

            @Override
            public void markThreadExecution() {
            }

            @Override
            public void markThreadCompletion() {
            }

            @Override
            public boolean isQueueSpaceAvailable() {
                return this.queue.size() < this.rejectionQueueSizeThreshold;
            }
        }

        private static class TestCommandWithTimeout
        extends TestHystrixCommand<Boolean> {
            private final long timeout;
            private static final int FALLBACK_NOT_IMPLEMENTED = 1;
            private static final int FALLBACK_SUCCESS = 2;
            private static final int FALLBACK_FAILURE = 3;
            private final int fallbackBehavior;
            private static final int RESULT_SUCCESS = 10;
            private static final int RESULT_EXCEPTION = 11;
            private final int result;

            private TestCommandWithTimeout(long timeout, int fallbackBehavior) {
                super(TestCommandWithTimeout.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds((int)timeout)));
                this.timeout = timeout;
                this.fallbackBehavior = fallbackBehavior;
                this.result = 10;
            }

            private TestCommandWithTimeout(long timeout, int fallbackBehavior, int result) {
                super(TestCommandWithTimeout.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationThreadTimeoutInMilliseconds((int)timeout)));
                this.timeout = timeout;
                this.fallbackBehavior = fallbackBehavior;
                this.result = result;
            }

            @Override
            protected Boolean run() {
                System.out.println("***** running");
                try {
                    Thread.sleep(this.timeout * 3L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    try {
                        Thread.sleep(this.timeout * 2L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println("after interruption with extra sleep");
                }
                if (this.result == 10) {
                    return true;
                }
                if (this.result == 11) {
                    throw new RuntimeException("Failure at end of TestCommandWithTimeout");
                }
                throw new RuntimeException("You passed in a bad result enum : " + this.result);
            }

            @Override
            protected Boolean getFallback() {
                if (this.fallbackBehavior == 2) {
                    return false;
                }
                if (this.fallbackBehavior == 3) {
                    throw new RuntimeException("failed on fallback");
                }
                return (Boolean)super.getFallback();
            }
        }

        private static class TestCommandWithoutCircuitBreaker
        extends TestHystrixCommand<Boolean> {
            private TestCommandWithoutCircuitBreaker() {
                super(TestCommandWithoutCircuitBreaker.testPropsBuilder().setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withCircuitBreakerEnabled(false)));
            }

            @Override
            protected Boolean run() {
                System.out.println("successfully executed");
                return true;
            }
        }

        private static class SlowCacheableCommand
        extends TestHystrixCommand<String> {
            private final String value;
            private final int duration;
            private volatile boolean executed = false;

            public SlowCacheableCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, String value, int duration) {
                super(SlowCacheableCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
                this.value = value;
                this.duration = duration;
            }

            @Override
            protected String run() {
                this.executed = true;
                try {
                    Thread.sleep(this.duration);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("successfully executed");
                return this.value;
            }

            @Override
            public String getCacheKey() {
                return this.value;
            }
        }

        private static class SuccessfulCacheableCommandViaSemaphore
        extends TestHystrixCommand<String> {
            private final boolean cacheEnabled;
            private volatile boolean executed = false;
            private final String value;

            public SuccessfulCacheableCommandViaSemaphore(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, boolean cacheEnabled, String value) {
                super(SuccessfulCacheableCommandViaSemaphore.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)));
                this.value = value;
                this.cacheEnabled = cacheEnabled;
            }

            @Override
            protected String run() {
                this.executed = true;
                System.out.println("successfully executed");
                return this.value;
            }

            public boolean isCommandRunningInThread() {
                return super.getProperties().executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
            }

            @Override
            public String getCacheKey() {
                if (this.cacheEnabled) {
                    return this.value;
                }
                return null;
            }
        }

        private static class SuccessfulCacheableCommand
        extends TestHystrixCommand<String> {
            private final boolean cacheEnabled;
            private volatile boolean executed = false;
            private final String value;

            public SuccessfulCacheableCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, boolean cacheEnabled, String value) {
                super(SuccessfulCacheableCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
                this.value = value;
                this.cacheEnabled = cacheEnabled;
            }

            @Override
            protected String run() {
                this.executed = true;
                System.out.println("successfully executed");
                return this.value;
            }

            public boolean isCommandRunningInThread() {
                return super.getProperties().executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
            }

            @Override
            public String getCacheKey() {
                if (this.cacheEnabled) {
                    return this.value;
                }
                return null;
            }
        }

        private static class KnownFailureTestCommandWithFallbackFailure
        extends TestHystrixCommand<Boolean> {
            private KnownFailureTestCommandWithFallbackFailure() {
                super(KnownFailureTestCommandWithFallbackFailure.testPropsBuilder());
            }

            private KnownFailureTestCommandWithFallbackFailure(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(KnownFailureTestCommandWithFallbackFailure.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with a simulated issue");
            }

            @Override
            protected Boolean getFallback() {
                throw new RuntimeException("failed while getting fallback");
            }
        }

        private static class KnownFailureTestCommandWithFallback
        extends TestHystrixCommand<Boolean> {
            public KnownFailureTestCommandWithFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(KnownFailureTestCommandWithFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            public KnownFailureTestCommandWithFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker, boolean fallbackEnabled) {
                super(KnownFailureTestCommandWithFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics).setCommandPropertiesDefaults(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter().withFallbackEnabled(fallbackEnabled)));
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with a simulated issue");
            }

            @Override
            protected Boolean getFallback() {
                return false;
            }
        }

        private static class KnownHystrixBadRequestFailureTestCommand
        extends TestHystrixCommand<Boolean> {
            public KnownHystrixBadRequestFailureTestCommand(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(KnownHystrixBadRequestFailureTestCommand.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed with HystrixBadRequestException  ***");
                throw new HystrixBadRequestException("we failed with a simulated issue");
            }
        }

        private static class KnownFailureTestCommandWithoutFallback
        extends TestHystrixCommand<Boolean> {
            private KnownFailureTestCommandWithoutFallback(HystrixCircuitBreaker.TestCircuitBreaker circuitBreaker) {
                super(KnownFailureTestCommandWithoutFallback.testPropsBuilder().setCircuitBreaker(circuitBreaker).setMetrics(circuitBreaker.metrics));
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with a simulated issue");
            }
        }

        private static class UnknownFailureTestCommandWithoutFallback
        extends TestHystrixCommand<Boolean> {
            private UnknownFailureTestCommandWithoutFallback() {
                super(UnknownFailureTestCommandWithoutFallback.testPropsBuilder());
            }

            @Override
            protected Boolean run() {
                System.out.println("*** simulated failed execution ***");
                throw new RuntimeException("we failed with an unknown issue");
            }
        }

        private static class DynamicOwnerAndKeyTestCommand
        extends TestHystrixCommand<Boolean> {
            public DynamicOwnerAndKeyTestCommand(HystrixCommandGroupKey owner, HystrixCommandKey key) {
                super(DynamicOwnerAndKeyTestCommand.testPropsBuilder().setOwner(owner).setCommandKey(key).setCircuitBreaker(null).setMetrics(null));
            }

            @Override
            protected Boolean run() {
                System.out.println("successfully executed");
                return true;
            }
        }

        private static class DynamicOwnerTestCommand
        extends TestHystrixCommand<Boolean> {
            public DynamicOwnerTestCommand(HystrixCommandGroupKey owner) {
                super(DynamicOwnerTestCommand.testPropsBuilder().setOwner(owner));
            }

            @Override
            protected Boolean run() {
                System.out.println("successfully executed");
                return true;
            }
        }

        private static class SuccessfulTestCommand
        extends TestHystrixCommand<Boolean> {
            public SuccessfulTestCommand() {
                this(HystrixCommandProperties.Setter.getUnitTestPropertiesSetter());
            }

            public SuccessfulTestCommand(HystrixCommandProperties.Setter properties) {
                super(SuccessfulTestCommand.testPropsBuilder().setCommandPropertiesDefaults(properties));
            }

            @Override
            protected Boolean run() {
                return true;
            }
        }

        static abstract class TestHystrixCommand<K>
        extends HystrixCommand<K> {
            final TestCommandBuilder builder;

            TestHystrixCommand(TestCommandBuilder builder) {
                super(builder.owner, builder.dependencyKey, builder.threadPoolKey, builder.circuitBreaker, builder.threadPool, builder.commandPropertiesDefaults, builder.threadPoolPropertiesDefaults, builder.metrics, builder.fallbackSemaphore, builder.executionSemaphore, TEST_PROPERTIES_FACTORY, builder.executionHook);
                this.builder = builder;
            }

            static TestCommandBuilder testPropsBuilder() {
                return new TestCommandBuilder();
            }

            static class TestCommandBuilder {
                HystrixCircuitBreaker.TestCircuitBreaker _cb = new HystrixCircuitBreaker.TestCircuitBreaker();
                HystrixCommandGroupKey owner = CommandGroupForUnitTest.OWNER_ONE;
                HystrixCommandKey dependencyKey = null;
                HystrixThreadPoolKey threadPoolKey = null;
                HystrixCircuitBreaker circuitBreaker = this._cb;
                HystrixThreadPool threadPool = null;
                HystrixCommandProperties.Setter commandPropertiesDefaults = HystrixCommandProperties.Setter.getUnitTestPropertiesSetter();
                HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults = HystrixThreadPoolProperties.Setter.getUnitTestPropertiesBuilder();
                HystrixCommandMetrics metrics;
                TryableSemaphore fallbackSemaphore;
                TryableSemaphore executionSemaphore;
                TestExecutionHook executionHook;

                TestCommandBuilder() {
                    this.metrics = this._cb.metrics;
                    this.fallbackSemaphore = null;
                    this.executionSemaphore = null;
                    this.executionHook = new TestExecutionHook();
                }

                TestCommandBuilder setOwner(HystrixCommandGroupKey owner) {
                    this.owner = owner;
                    return this;
                }

                TestCommandBuilder setCommandKey(HystrixCommandKey dependencyKey) {
                    this.dependencyKey = dependencyKey;
                    return this;
                }

                TestCommandBuilder setThreadPoolKey(HystrixThreadPoolKey threadPoolKey) {
                    this.threadPoolKey = threadPoolKey;
                    return this;
                }

                TestCommandBuilder setCircuitBreaker(HystrixCircuitBreaker circuitBreaker) {
                    this.circuitBreaker = circuitBreaker;
                    return this;
                }

                TestCommandBuilder setThreadPool(HystrixThreadPool threadPool) {
                    this.threadPool = threadPool;
                    return this;
                }

                TestCommandBuilder setCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
                    this.commandPropertiesDefaults = commandPropertiesDefaults;
                    return this;
                }

                TestCommandBuilder setThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
                    this.threadPoolPropertiesDefaults = threadPoolPropertiesDefaults;
                    return this;
                }

                TestCommandBuilder setMetrics(HystrixCommandMetrics metrics) {
                    this.metrics = metrics;
                    return this;
                }

                TestCommandBuilder setFallbackSemaphore(TryableSemaphore fallbackSemaphore) {
                    this.fallbackSemaphore = fallbackSemaphore;
                    return this;
                }

                TestCommandBuilder setExecutionSemaphore(TryableSemaphore executionSemaphore) {
                    this.executionSemaphore = executionSemaphore;
                    return this;
                }
            }
        }
    }

    @NotThreadSafe
    public static class Setter {
        private final HystrixCommandGroupKey groupKey;
        private HystrixCommandKey commandKey;
        private HystrixThreadPoolKey threadPoolKey;
        private HystrixCommandProperties.Setter commandPropertiesDefaults;
        private HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults;

        private Setter(HystrixCommandGroupKey groupKey) {
            this.groupKey = groupKey;
        }

        public static Setter withGroupKey(HystrixCommandGroupKey groupKey) {
            return new Setter(groupKey);
        }

        public Setter andCommandKey(HystrixCommandKey commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        public Setter andThreadPoolKey(HystrixThreadPoolKey threadPoolKey) {
            this.threadPoolKey = threadPoolKey;
            return this;
        }

        public Setter andCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
            this.commandPropertiesDefaults = commandPropertiesDefaults;
            return this;
        }

        public Setter andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
            this.threadPoolPropertiesDefaults = threadPoolPropertiesDefaults;
            return this;
        }
    }

    private static class TryableSemaphore {
        private final HystrixProperty<Integer> numberOfPermits;
        private final AtomicInteger count = new AtomicInteger(0);

        public TryableSemaphore(HystrixProperty<Integer> numberOfPermits) {
            this.numberOfPermits = numberOfPermits;
        }

        public boolean tryAcquire() {
            int currentCount = this.count.incrementAndGet();
            if (currentCount > this.numberOfPermits.get()) {
                this.count.decrementAndGet();
                return false;
            }
            return true;
        }

        public void release() {
            this.count.decrementAndGet();
        }

        public int getNumberOfPermitsUsed() {
            return this.count.get();
        }
    }

    private static class ExecutionResult {
        private final List<HystrixEventType> events;
        private final int executionTime;
        private final Exception exception;
        private static ExecutionResult EMPTY = new ExecutionResult(new HystrixEventType[0]);

        private ExecutionResult(HystrixEventType ... events) {
            this(Arrays.asList(events), -1, null);
        }

        public ExecutionResult setExecutionTime(int executionTime) {
            return new ExecutionResult(this.events, executionTime, this.exception);
        }

        public ExecutionResult setException(Exception e) {
            return new ExecutionResult(this.events, this.executionTime, e);
        }

        private ExecutionResult(List<HystrixEventType> events, int executionTime, Exception e) {
            this.events = events;
            this.executionTime = executionTime;
            this.exception = e;
        }

        public ExecutionResult addEvents(HystrixEventType ... events) {
            ArrayList<HystrixEventType> newEvents = new ArrayList<HystrixEventType>();
            newEvents.addAll(this.events);
            for (HystrixEventType e : events) {
                newEvents.add(e);
            }
            return new ExecutionResult(Collections.unmodifiableList(newEvents), this.executionTime, this.exception);
        }

        static /* synthetic */ ExecutionResult access$000() {
            return EMPTY;
        }
    }

    private static class TimeoutObservable<R>
    extends Observable<R> {
        public TimeoutObservable(final Observable<R> o, HystrixCommand<R> originalCommand, final boolean isNonBlocking) {
            super(new Observable.OnSubscribe<R>(){

                public void call(final Subscriber<? super R> observer) {
                    final HystrixContextRunnable timeoutRunnable = new HystrixContextRunnable(HystrixCommand.this.concurrencyStrategy, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                observer.onNext(HystrixCommand.this.getFallbackOrThrowException(HystrixEventType.TIMEOUT, HystrixRuntimeException.FailureType.TIMEOUT, "timed-out", new TimeoutException()));
                                observer.onCompleted();
                            }
                            catch (HystrixRuntimeException re) {
                                observer.onError((Throwable)re);
                            }
                        }
                    });
                    HystrixTimer.TimerListener listener = new HystrixTimer.TimerListener(){

                        @Override
                        public void tick() {
                            if (HystrixCommand.this.isCommandTimedOut.compareAndSet(TimedOutStatus.NOT_EXECUTED, TimedOutStatus.TIMED_OUT)) {
                                HystrixCommand.this.metrics.markTimeout(System.currentTimeMillis() - HystrixCommand.this.invocationStartTime);
                                HystrixCommand.this.recordTotalExecutionTime(HystrixCommand.this.invocationStartTime);
                                timeoutRunnable.run();
                            }
                            observer.unsubscribe();
                        }

                        @Override
                        public int getIntervalTimeInMilliseconds() {
                            return HystrixCommand.this.properties.executionIsolationThreadTimeoutInMilliseconds().get();
                        }
                    };
                    Reference<HystrixTimer.TimerListener> _tl = null;
                    _tl = isNonBlocking ? HystrixTimer.getInstance().addTimerListener(listener) : new SoftReference<2>(listener);
                    final Reference<HystrixTimer.TimerListener> tl = _tl;
                    HystrixCommand.this.timeoutTimer.set(tl);
                    o.unsafeSubscribe(new Subscriber<R>(observer){

                        public void onCompleted() {
                            tl.clear();
                            observer.onCompleted();
                        }

                        public void onError(Throwable e) {
                            tl.clear();
                            observer.onError(e);
                        }

                        public void onNext(R v) {
                            observer.onNext(v);
                        }
                    });
                }
            });
        }
    }

    private static class CachedObservableResponse<R>
    extends ObservableCommand<R> {
        final CachedObservableOriginal<R> originalObservable;

        CachedObservableResponse(final CachedObservableOriginal<R> originalObservable, final HystrixCommand<R> commandOfDuplicateCall) {
            super(new Observable.OnSubscribe<R>(){

                public void call(final Subscriber<? super R> observer) {
                    originalObservable.subscribe(new Subscriber<R>(observer){

                        public void onCompleted() {
                            this.completeCommand();
                            observer.onCompleted();
                        }

                        public void onError(Throwable e) {
                            this.completeCommand();
                            observer.onError(e);
                        }

                        public void onNext(R v) {
                            observer.onNext(v);
                        }

                        private void completeCommand() {
                            commandOfDuplicateCall.executionResult = originalObservable.originalCommand.executionResult;
                            commandOfDuplicateCall.executionResult = commandOfDuplicateCall.executionResult.addEvents(HystrixEventType.RESPONSE_FROM_CACHE);
                            commandOfDuplicateCall.executionResult = commandOfDuplicateCall.executionResult.setExecutionTime(-1);
                            commandOfDuplicateCall.recordExecutedCommand();
                        }
                    });
                }
            }, commandOfDuplicateCall);
            this.originalObservable = originalObservable;
        }

        @Override
        public HystrixCommand<R> getCommand() {
            return this.originalObservable.originalCommand;
        }
    }

    private static class ObservableCommand<R>
    extends Observable<R> {
        private final HystrixCommand<R> command;

        ObservableCommand(Observable.OnSubscribe<R> func, HystrixCommand<R> command) {
            super(func);
            this.command = command;
        }

        public HystrixCommand<R> getCommand() {
            return this.command;
        }

        ObservableCommand(final Observable<R> originalObservable, HystrixCommand<R> command) {
            super(new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> observer) {
                    originalObservable.unsafeSubscribe(observer);
                }
            });
            this.command = command;
        }
    }

    private static class CachedObservableOriginal<R>
    extends ObservableCommand<R> {
        final HystrixCommand<R> originalCommand;

        CachedObservableOriginal(final Observable<R> actual, HystrixCommand<R> command) {
            super(new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> observer) {
                    actual.subscribe(observer);
                }
            }, command);
            this.originalCommand = command;
        }
    }

    private static enum TimedOutStatus {
        NOT_EXECUTED,
        COMPLETED,
        TIMED_OUT;

    }
}

