/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPool;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hystrix {
    private static final Logger logger = LoggerFactory.getLogger(Hystrix.class);
    private static ThreadLocal<LinkedList<HystrixCommandKey>> currentCommand = new ThreadLocal<LinkedList<HystrixCommandKey>>(){

        @Override
        protected LinkedList<HystrixCommandKey> initialValue() {
            return new LinkedList<HystrixCommandKey>();
        }
    };

    public static void reset() {
        HystrixThreadPool.Factory.shutdown();
        Hystrix._reset();
    }

    public static void reset(long time, TimeUnit unit) {
        HystrixThreadPool.Factory.shutdown(time, unit);
        Hystrix._reset();
    }

    private static void _reset() {
        HystrixCommandMetrics.reset();
        HystrixCollapser.reset();
        HystrixCircuitBreaker.Factory.reset();
    }

    public static HystrixCommandKey getCurrentThreadExecutingCommand() {
        if (currentCommand == null) {
            return null;
        }
        return currentCommand.get().peek();
    }

    static void startCurrentThreadExecutingCommand(HystrixCommandKey key) {
        try {
            currentCommand.get().push(key);
        }
        catch (Exception e) {
            logger.warn("Unable to record command starting", (Throwable)e);
        }
    }

    static void endCurrentThreadExecutingCommand() {
        try {
            if (!currentCommand.get().isEmpty()) {
                currentCommand.get().pop();
            }
        }
        catch (NoSuchElementException e) {
            logger.debug("No command found to end.", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Unable to end command.", (Throwable)e);
        }
    }

    public static class UnitTest {
        @Test
        public void testNotInThread() {
            Assert.assertNull((Object)Hystrix.getCurrentThreadExecutingCommand());
        }

        @Test
        public void testInsideHystrixThread() {
            Assert.assertNull((Object)Hystrix.getCurrentThreadExecutingCommand());
            HystrixCommand<Boolean> command = new HystrixCommand<Boolean>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestUtil")).andCommandKey(HystrixCommandKey.Factory.asKey("CommandName"))){

                @Override
                protected Boolean run() {
                    Assert.assertEquals((Object)"CommandName", (Object)Hystrix.getCurrentThreadExecutingCommand().name());
                    return Hystrix.getCurrentThreadExecutingCommand() != null;
                }
            };
            Assert.assertTrue((boolean)((Boolean)command.execute()));
            Assert.assertNull((Object)Hystrix.getCurrentThreadExecutingCommand());
        }

        @Test
        public void testInsideNestedHystrixThread() {
            HystrixCommand<Boolean> command = new HystrixCommand<Boolean>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestUtil")).andCommandKey(HystrixCommandKey.Factory.asKey("OuterCommand"))){

                @Override
                protected Boolean run() {
                    Assert.assertEquals((Object)"OuterCommand", (Object)Hystrix.getCurrentThreadExecutingCommand().name());
                    if (Hystrix.getCurrentThreadExecutingCommand() == null) {
                        throw new RuntimeException("BEFORE expected it to run inside a thread");
                    }
                    HystrixCommand<Boolean> command2 = new HystrixCommand<Boolean>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestUtil")).andCommandKey(HystrixCommandKey.Factory.asKey("InnerCommand"))){

                        @Override
                        protected Boolean run() {
                            Assert.assertEquals((Object)"InnerCommand", (Object)Hystrix.getCurrentThreadExecutingCommand().name());
                            return Hystrix.getCurrentThreadExecutingCommand() != null;
                        }
                    };
                    if (Hystrix.getCurrentThreadExecutingCommand() == null) {
                        throw new RuntimeException("AFTER expected it to run inside a thread");
                    }
                    return (Boolean)command2.execute();
                }
            };
            Assert.assertTrue((boolean)((Boolean)command.execute()));
            Assert.assertNull((Object)Hystrix.getCurrentThreadExecutingCommand());
        }

        @Test
        public void testInsideHystrixSemaphoreExecute() {
            HystrixCommand<Boolean> command = new HystrixCommand<Boolean>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestUtil")).andCommandKey(HystrixCommandKey.Factory.asKey("SemaphoreIsolatedCommandName")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE))){

                @Override
                protected Boolean run() {
                    Assert.assertEquals((Object)"SemaphoreIsolatedCommandName", (Object)Hystrix.getCurrentThreadExecutingCommand().name());
                    return Hystrix.getCurrentThreadExecutingCommand() != null;
                }
            };
            Assert.assertTrue((boolean)((Boolean)command.execute()));
            Assert.assertNull((Object)Hystrix.getCurrentThreadExecutingCommand());
        }

        @Test
        public void testInsideHystrixSemaphoreQueue() throws Exception {
            HystrixCommand<Boolean> command = new HystrixCommand<Boolean>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestUtil")).andCommandKey(HystrixCommandKey.Factory.asKey("SemaphoreIsolatedCommandName")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE))){

                @Override
                protected Boolean run() {
                    Assert.assertEquals((Object)"SemaphoreIsolatedCommandName", (Object)Hystrix.getCurrentThreadExecutingCommand().name());
                    return Hystrix.getCurrentThreadExecutingCommand() != null;
                }
            };
            Assert.assertTrue((boolean)((Boolean)command.queue().get()));
            Assert.assertNull((Object)Hystrix.getCurrentThreadExecutingCommand());
        }

        @Test
        public void testThreadNestedInsideHystrixSemaphore() {
            HystrixCommand<Boolean> command = new HystrixCommand<Boolean>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestUtil")).andCommandKey(HystrixCommandKey.Factory.asKey("OuterSemaphoreCommand")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE))){

                @Override
                protected Boolean run() {
                    Assert.assertEquals((Object)"OuterSemaphoreCommand", (Object)Hystrix.getCurrentThreadExecutingCommand().name());
                    if (Hystrix.getCurrentThreadExecutingCommand() == null) {
                        throw new RuntimeException("BEFORE expected it to run inside a semaphore");
                    }
                    HystrixCommand<Boolean> command2 = new HystrixCommand<Boolean>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("TestUtil")).andCommandKey(HystrixCommandKey.Factory.asKey("InnerCommand"))){

                        @Override
                        protected Boolean run() {
                            Assert.assertEquals((Object)"InnerCommand", (Object)Hystrix.getCurrentThreadExecutingCommand().name());
                            return Hystrix.getCurrentThreadExecutingCommand() != null;
                        }
                    };
                    if (Hystrix.getCurrentThreadExecutingCommand() == null) {
                        throw new RuntimeException("AFTER expected it to run inside a semaphore");
                    }
                    return (Boolean)command2.execute();
                }
            };
            Assert.assertTrue((boolean)((Boolean)command.execute()));
            Assert.assertNull((Object)Hystrix.getCurrentThreadExecutingCommand());
        }
    }
}

