/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextScheduler;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;

public interface HystrixThreadPool {
    public ThreadPoolExecutor getExecutor();

    public Scheduler getScheduler();

    public void markThreadExecution();

    public void markThreadCompletion();

    public boolean isQueueSpaceAvailable();

    public static class HystrixThreadPoolDefault
    implements HystrixThreadPool {
        private final HystrixThreadPoolProperties properties;
        private final BlockingQueue<Runnable> queue;
        private final ThreadPoolExecutor threadPool;
        private final HystrixThreadPoolMetrics metrics;
        private final Scheduler scheduler;

        public HystrixThreadPoolDefault(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesDefaults) {
            this.properties = HystrixPropertiesFactory.getThreadPoolProperties(threadPoolKey, propertiesDefaults);
            HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
            this.queue = concurrencyStrategy.getBlockingQueue(this.properties.maxQueueSize().get());
            this.threadPool = concurrencyStrategy.getThreadPool(threadPoolKey, this.properties.coreSize(), this.properties.coreSize(), this.properties.keepAliveTimeMinutes(), TimeUnit.MINUTES, this.queue);
            this.metrics = HystrixThreadPoolMetrics.getInstance(threadPoolKey, this.threadPool, this.properties);
            this.scheduler = new HystrixContextScheduler(concurrencyStrategy, this);
            HystrixMetricsPublisherFactory.createOrRetrievePublisherForThreadPool(threadPoolKey, this.metrics, this.properties);
        }

        @Override
        public ThreadPoolExecutor getExecutor() {
            this.touchConfig();
            return this.threadPool;
        }

        @Override
        public Scheduler getScheduler() {
            this.touchConfig();
            return this.scheduler;
        }

        private void touchConfig() {
            this.threadPool.setCorePoolSize(this.properties.coreSize().get());
            this.threadPool.setMaximumPoolSize(this.properties.coreSize().get());
            this.threadPool.setKeepAliveTime(this.properties.keepAliveTimeMinutes().get().intValue(), TimeUnit.MINUTES);
        }

        @Override
        public void markThreadExecution() {
            this.metrics.markThreadExecution();
        }

        @Override
        public void markThreadCompletion() {
            this.metrics.markThreadCompletion();
        }

        @Override
        public boolean isQueueSpaceAvailable() {
            if (this.properties.maxQueueSize().get() < 0) {
                return true;
            }
            return this.threadPool.getQueue().size() < this.properties.queueSizeRejectionThreshold().get();
        }
    }

    public static class Factory {
        static final ConcurrentHashMap<String, HystrixThreadPool> threadPools = new ConcurrentHashMap();

        static HystrixThreadPool getInstance(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesBuilder) {
            String key = threadPoolKey.name();
            HystrixThreadPool previouslyCached = threadPools.get(key);
            if (previouslyCached != null) {
                return previouslyCached;
            }
            HystrixThreadPool poolForKey = threadPools.putIfAbsent(key, new HystrixThreadPoolDefault(threadPoolKey, propertiesBuilder));
            if (poolForKey == null) {
                HystrixThreadPool threadPoolJustCreated = threadPools.get(key);
                return threadPoolJustCreated;
            }
            return poolForKey;
        }

        static synchronized void shutdown() {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            threadPools.clear();
        }

        static synchronized void shutdown(long timeout, TimeUnit unit) {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            for (HystrixThreadPool pool : threadPools.values()) {
                try {
                    pool.getExecutor().awaitTermination(timeout, unit);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for thread-pools to terminate. Pools may not be correctly shutdown or cleared.", e);
                }
            }
            threadPools.clear();
        }
    }
}

