/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixCounters;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.HystrixObservable;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subjects.ReplaySubject;
import rx.subscriptions.CompositeSubscription;

abstract class AbstractCommand<R>
implements HystrixInvokableInfo<R>,
HystrixObservable<R> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCommand.class);
    protected final HystrixCircuitBreaker circuitBreaker;
    protected final HystrixThreadPool threadPool;
    protected final HystrixThreadPoolKey threadPoolKey;
    protected final HystrixCommandProperties properties;
    protected final HystrixCommandMetrics metrics;
    protected final HystrixCommandKey commandKey;
    protected final HystrixCommandGroupKey commandGroup;
    protected final HystrixEventNotifier eventNotifier;
    protected final HystrixConcurrencyStrategy concurrencyStrategy;
    protected final HystrixCommandExecutionHook executionHook;
    protected final TryableSemaphore fallbackSemaphoreOverride;
    protected static final ConcurrentHashMap<String, TryableSemaphore> fallbackSemaphorePerCircuit = new ConcurrentHashMap();
    protected final TryableSemaphore executionSemaphoreOverride;
    protected static final ConcurrentHashMap<String, TryableSemaphore> executionSemaphorePerCircuit = new ConcurrentHashMap();
    protected final AtomicReference<Reference<HystrixTimer.TimerListener>> timeoutTimer = new AtomicReference();
    protected AtomicBoolean started = new AtomicBoolean();
    protected volatile long invocationStartTime = -1L;
    protected volatile ExecutionResult executionResult = ExecutionResult.access$000();
    protected final AtomicReference<TimedOutStatus> isCommandTimedOut = new AtomicReference<TimedOutStatus>(TimedOutStatus.NOT_EXECUTED);
    protected final AtomicBoolean isExecutionComplete = new AtomicBoolean(false);
    protected final AtomicBoolean isExecutedInThread = new AtomicBoolean(false);
    protected final AtomicReference<Action0> endCurrentThreadExecutingCommand = new AtomicReference();
    protected final HystrixRequestCache requestCache;
    protected final HystrixRequestLog currentRequestLog;
    private static ConcurrentHashMap<Class<?>, String> defaultNameCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<HystrixCommandKey, Boolean> commandContainsFallback = new ConcurrentHashMap();

    static String getDefaultNameFromClass(Class<?> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    protected AbstractCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, TryableSemaphore fallbackSemaphore, TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        if (group == null) {
            throw new IllegalStateException("HystrixCommandGroup can not be NULL");
        }
        this.commandGroup = group;
        if (key == null || key.name().trim().equals("")) {
            String keyName = AbstractCommand.getDefaultNameFromClass(this.getClass());
            this.commandKey = HystrixCommandKey.Factory.asKey(keyName);
        } else {
            this.commandKey = key;
        }
        this.properties = propertiesStrategy == null ? HystrixPropertiesFactory.getCommandProperties(this.commandKey, commandPropertiesDefaults) : propertiesStrategy.getCommandProperties(this.commandKey, commandPropertiesDefaults);
        this.threadPoolKey = this.properties.executionIsolationThreadPoolKeyOverride().get() == null ? (threadPoolKey == null ? HystrixThreadPoolKey.Factory.asKey(this.commandGroup.name()) : threadPoolKey) : HystrixThreadPoolKey.Factory.asKey(this.properties.executionIsolationThreadPoolKeyOverride().get());
        this.eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        this.metrics = metrics == null ? HystrixCommandMetrics.getInstance(this.commandKey, this.commandGroup, this.threadPoolKey, this.properties) : metrics;
        this.circuitBreaker = this.properties.circuitBreakerEnabled().get().booleanValue() ? (circuitBreaker == null ? HystrixCircuitBreaker.Factory.getInstance(this.commandKey, this.commandGroup, this.properties, this.metrics) : circuitBreaker) : new HystrixCircuitBreaker.NoOpCircuitBreaker();
        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCommand(this.commandKey, this.commandGroup, this.metrics, this.circuitBreaker, this.properties);
        this.executionHook = executionHook == null ? new ExecutionHookDeprecationWrapper(HystrixPlugins.getInstance().getCommandExecutionHook()) : (executionHook instanceof ExecutionHookDeprecationWrapper ? executionHook : new ExecutionHookDeprecationWrapper(executionHook));
        this.threadPool = threadPool == null ? HystrixThreadPool.Factory.getInstance(this.threadPoolKey, threadPoolPropertiesDefaults) : threadPool;
        this.fallbackSemaphoreOverride = fallbackSemaphore;
        this.executionSemaphoreOverride = executionSemaphore;
        this.requestCache = HystrixRequestCache.getInstance(this.commandKey, this.concurrencyStrategy);
        this.currentRequestLog = this.properties.requestLogEnabled().get().booleanValue() ? (this.concurrencyStrategy instanceof HystrixConcurrencyStrategyDefault ? (HystrixRequestContext.isCurrentThreadInitialized() ? HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) : null) : (HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) != null ? HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) : null)) : null;
    }

    void markAsCollapsedCommand(int sizeOfBatch) {
        this.getMetrics().markCollapsed(sizeOfBatch);
        this.executionResult = this.executionResult.addEvents(HystrixEventType.COLLAPSED);
    }

    @Override
    public Observable<R> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.toObservable().subscribe((Observer)subject);
        return subject;
    }

    protected abstract Observable<R> getExecutionObservable();

    protected abstract Observable<R> getFallbackObservable();

    @Override
    public Observable<R> toObservable() {
        Observable fromCache;
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("This instance can only be executed once. Please instantiate a new instance.");
        }
        boolean requestCacheEnabled = this.isRequestCachingEnabled();
        if (requestCacheEnabled && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
            this.metrics.markResponseFromCache();
            this.isExecutionComplete.set(true);
            try {
                this.executionHook.onCacheHit(this);
            }
            catch (Throwable hookEx) {
                logger.warn("Error calling HystrixCommandExecutionHook.onCacheHit", hookEx);
            }
            return new CachedObservableResponse((CachedObservableOriginal)fromCache, this);
        }
        final AbstractCommand _this = this;
        ObservableCommand o = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

            public void call(Subscriber<? super R> observer) {
                AbstractCommand.this.recordExecutedCommand();
                AbstractCommand.this.metrics.incrementConcurrentExecutionCount();
                AbstractCommand.this.executionHook.onStart(_this);
                if (AbstractCommand.this.circuitBreaker.allowRequest()) {
                    final TryableSemaphore executionSemaphore = AbstractCommand.this.getExecutionSemaphore();
                    if (executionSemaphore.tryAcquire()) {
                        try {
                            AbstractCommand.this.invocationStartTime = System.currentTimeMillis();
                            AbstractCommand.this.getRunObservableDecoratedForMetricsAndErrorHandling().doOnTerminate(new Action0(){

                                public void call() {
                                    executionSemaphore.release();
                                }
                            }).unsafeSubscribe(observer);
                        }
                        catch (RuntimeException e) {
                            observer.onError((Throwable)e);
                        }
                    } else {
                        AbstractCommand.this.metrics.markSemaphoreRejection();
                        logger.debug("HystrixCommand Execution Rejection by Semaphore.");
                        AbstractCommand.this.getFallbackOrThrowException(HystrixEventType.SEMAPHORE_REJECTED, HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION, "could not acquire a semaphore for execution", new RuntimeException("could not acquire a semaphore for execution")).lift((Observable.Operator)new DeprecatedOnCompleteWithValueHookApplication(_this)).unsafeSubscribe(observer);
                    }
                } else {
                    AbstractCommand.this.metrics.markShortCircuited();
                    try {
                        AbstractCommand.this.getFallbackOrThrowException(HystrixEventType.SHORT_CIRCUITED, HystrixRuntimeException.FailureType.SHORTCIRCUIT, "short-circuited", new RuntimeException("Hystrix circuit short-circuited and is OPEN")).lift((Observable.Operator)new DeprecatedOnCompleteWithValueHookApplication(_this)).unsafeSubscribe(observer);
                    }
                    catch (Exception e) {
                        observer.onError((Throwable)e);
                    }
                }
            }
        });
        o = o.lift(new CommandHookApplication(this));
        o = o.onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

            public Observable<R> call(Throwable t) {
                AbstractCommand.this.metrics.markExceptionThrown();
                return Observable.error((Throwable)t);
            }
        });
        o = o.doOnTerminate(new Action0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                Reference<HystrixTimer.TimerListener> tl = AbstractCommand.this.timeoutTimer.get();
                if (tl != null) {
                    tl.clear();
                }
                try {
                    if (AbstractCommand.this.invocationStartTime > 0L && !AbstractCommand.this.isResponseRejected()) {
                        AbstractCommand.this.recordTotalExecutionTime(AbstractCommand.this.invocationStartTime);
                    }
                }
                finally {
                    AbstractCommand.this.metrics.decrementConcurrentExecutionCount();
                    AbstractCommand.this.isExecutionComplete.set(true);
                }
            }
        });
        if (requestCacheEnabled) {
            o = new CachedObservableOriginal(o.cache(), this);
            Observable fromCache2 = this.requestCache.putIfAbsent(this.getCacheKey(), o);
            if (fromCache2 != null) {
                o = new CachedObservableResponse((CachedObservableOriginal)fromCache2, this);
            }
            return o;
        }
        return new ObservableCommand(o, this);
    }

    private Observable<R> getRunObservableDecoratedForMetricsAndErrorHandling() {
        Observable run;
        final AbstractCommand _self = this;
        final HystrixRequestContext currentRequestContext = HystrixRequestContext.getContextForCurrentThread();
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
            run = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> s) {
                    if (AbstractCommand.this.isCommandTimedOut.get() == TimedOutStatus.TIMED_OUT) {
                        s.onError((Throwable)new RuntimeException("timed out before executing run()"));
                    } else {
                        HystrixCounters.incrementGlobalConcurrentThreads();
                        AbstractCommand.this.threadPool.markThreadExecution();
                        AbstractCommand.this.endCurrentThreadExecutingCommand.set(Hystrix.startCurrentThreadExecutingCommand(AbstractCommand.this.getCommandKey()));
                        AbstractCommand.this.isExecutedInThread.set(true);
                        try {
                            AbstractCommand.this.executionHook.onThreadStart(_self);
                            AbstractCommand.this.executionHook.onRunStart(_self);
                            AbstractCommand.this.executionHook.onExecutionStart(_self);
                        }
                        catch (Throwable ex) {
                            s.onError(ex);
                        }
                        AbstractCommand.this.getExecutionObservableWithLifecycle().unsafeSubscribe(s);
                    }
                }
            }).subscribeOn(this.threadPool.getScheduler(new Func0<Boolean>(){

                public Boolean call() {
                    return AbstractCommand.this.properties.executionIsolationThreadInterruptOnTimeout().get() != false && _self.isCommandTimedOut.get().equals((Object)TimedOutStatus.TIMED_OUT);
                }
            }));
        } else {
            this.endCurrentThreadExecutingCommand.set(Hystrix.startCurrentThreadExecutingCommand(this.getCommandKey()));
            try {
                this.executionHook.onRunStart(_self);
                this.executionHook.onExecutionStart(_self);
                run = this.getExecutionObservableWithLifecycle();
            }
            catch (Throwable ex) {
                run = Observable.error((Throwable)ex);
            }
        }
        run = run.doOnEach(new Action1<Notification<? super R>>(){

            public void call(Notification<? super R> n) {
                AbstractCommand.setRequestContextIfNeeded(currentRequestContext);
            }
        });
        if (this.properties.executionTimeoutEnabled().get().booleanValue()) {
            run = run.lift(new HystrixObservableTimeoutOperator(_self));
        }
        run = run.doOnNext(new Action1<R>(){

            public void call(R r) {
                if (AbstractCommand.this.shouldOutputOnNextEvents()) {
                    AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEmission(HystrixEventType.EMIT);
                    AbstractCommand.this.metrics.markEmit();
                }
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                long duration = System.currentTimeMillis() - AbstractCommand.this.invocationStartTime;
                AbstractCommand.this.metrics.addCommandExecutionTime(duration);
                AbstractCommand.this.metrics.markSuccess(duration);
                AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvents(HystrixEventType.SUCCESS);
                AbstractCommand.this.circuitBreaker.markSuccess();
                AbstractCommand.this.eventNotifier.markCommandExecution(AbstractCommand.this.getCommandKey(), AbstractCommand.this.properties.executionIsolationStrategy().get(), (int)duration, AbstractCommand.this.executionResult.events);
            }
        }).onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

            public Observable<R> call(Throwable t) {
                Exception e = AbstractCommand.this.getExceptionFromThrowable(t);
                if (e instanceof RejectedExecutionException) {
                    AbstractCommand.this.metrics.markThreadPoolRejection();
                    AbstractCommand.this.threadPool.markThreadRejection();
                    return AbstractCommand.this.getFallbackOrThrowException(HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "could not be queued for execution", e);
                }
                if (t instanceof HystrixObservableTimeoutOperator.HystrixTimeoutException) {
                    return AbstractCommand.this.getFallbackOrThrowException(HystrixEventType.TIMEOUT, HystrixRuntimeException.FailureType.TIMEOUT, "timed-out", new TimeoutException());
                }
                if (t instanceof HystrixBadRequestException) {
                    try {
                        AbstractCommand.this.metrics.markBadRequest(System.currentTimeMillis() - AbstractCommand.this.invocationStartTime);
                        AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvents(HystrixEventType.BAD_REQUEST);
                        Exception decorated = AbstractCommand.this.executionHook.onError(_self, HystrixRuntimeException.FailureType.BAD_REQUEST_EXCEPTION, (Exception)t);
                        if (decorated instanceof HystrixBadRequestException) {
                            t = decorated;
                        } else {
                            logger.warn("ExecutionHook.onError returned an exception that was not an instance of HystrixBadRequestException so will be ignored.", (Throwable)decorated);
                        }
                    }
                    catch (Exception hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onError", (Throwable)hookEx);
                    }
                    return Observable.error((Throwable)t);
                }
                if (e instanceof HystrixBadRequestException) {
                    AbstractCommand.this.metrics.markBadRequest(System.currentTimeMillis() - AbstractCommand.this.invocationStartTime);
                    return Observable.error((Throwable)e);
                }
                logger.debug("Error executing HystrixCommand.run(). Proceeding to fallback logic ...", (Throwable)e);
                AbstractCommand.this.metrics.markFailure(System.currentTimeMillis() - AbstractCommand.this.invocationStartTime);
                AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.setException(e);
                return AbstractCommand.this.getFallbackOrThrowException(HystrixEventType.FAILURE, HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, "failed", e);
            }
        }).doOnEach(new Action1<Notification<? super R>>(){

            public void call(Notification<? super R> n) {
                AbstractCommand.setRequestContextIfNeeded(currentRequestContext);
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                if (!AbstractCommand.this.isCommandTimedOut.get().equals((Object)TimedOutStatus.TIMED_OUT)) {
                    AbstractCommand.this.handleThreadEnd();
                }
            }
        }).lift((Observable.Operator)new DeprecatedOnCompleteWithValueHookApplication(_self));
        return run;
    }

    private Observable<R> getExecutionObservableWithLifecycle() {
        Observable userObservable;
        AbstractCommand _self = this;
        try {
            userObservable = this.getExecutionObservable();
        }
        catch (Throwable ex) {
            userObservable = Observable.error((Throwable)ex);
        }
        return userObservable.lift((Observable.Operator)new ExecutionHookApplication(_self)).lift((Observable.Operator)new DeprecatedOnRunHookApplication(_self)).doOnTerminate(new Action0(){

            public void call() {
                if (AbstractCommand.this.isCommandTimedOut.get().equals((Object)TimedOutStatus.TIMED_OUT)) {
                    AbstractCommand.this.handleThreadEnd();
                }
            }
        });
    }

    private Observable<R> getFallbackOrThrowException(HystrixEventType eventType, final HystrixRuntimeException.FailureType failureType, final String message, final Exception originalException) {
        Observable fallbackLogicApplied;
        final HystrixRequestContext currentRequestContext = HystrixRequestContext.getContextForCurrentThread();
        if (this.isUnrecoverable(originalException)) {
            Exception e = originalException;
            logger.error("Unrecoverable Error for HystrixCommand so will throw HystrixRuntimeException and not apply fallback. ", (Throwable)e);
            this.executionResult = this.executionResult.addEvents(eventType);
            e = this.wrapWithOnErrorHook(failureType, e);
            fallbackLogicApplied = Observable.error((Throwable)new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and encountered unrecoverable error.", e, null));
        } else {
            if (this.isRecoverableError(originalException)) {
                logger.warn("Recovered from java.lang.Error by serving Hystrix fallback", (Throwable)originalException);
            }
            if (this.properties.fallbackEnabled().get().booleanValue()) {
                Observable fallbackExecutionChain;
                this.executionResult = this.executionResult.addEvents(eventType);
                final AbstractCommand _cmd = this;
                final TryableSemaphore fallbackSemaphore = this.getFallbackSemaphore();
                if (fallbackSemaphore.tryAcquire()) {
                    try {
                        if (AbstractCommand.isFallbackUserSupplied(this)) {
                            this.executionHook.onFallbackStart(this);
                            fallbackExecutionChain = this.getFallbackObservable();
                        } else {
                            fallbackExecutionChain = this.getFallbackObservable();
                        }
                    }
                    catch (Throwable ex) {
                        fallbackExecutionChain = Observable.error((Throwable)ex);
                    }
                } else {
                    this.metrics.markFallbackRejection();
                    this.executionResult = this.executionResult.addEvents(HystrixEventType.FALLBACK_REJECTION);
                    logger.debug("HystrixCommand Fallback Rejection.");
                    return Observable.error((Throwable)new HystrixRuntimeException(HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_FALLBACK, this.getClass(), this.getLogMessagePrefix() + " fallback execution rejected.", null, null));
                }
                fallbackExecutionChain = fallbackExecutionChain.lift((Observable.Operator)new FallbackHookApplication(_cmd)).lift((Observable.Operator)new DeprecatedOnFallbackHookApplication(_cmd)).doOnTerminate(new Action0(){

                    public void call() {
                        fallbackSemaphore.release();
                    }
                });
                fallbackLogicApplied = fallbackExecutionChain.doOnNext(new Action1<R>(){

                    public void call(R r) {
                        if (AbstractCommand.this.shouldOutputOnNextEvents()) {
                            AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEmission(HystrixEventType.FALLBACK_EMIT);
                            AbstractCommand.this.metrics.markFallbackEmit();
                        }
                    }
                }).doOnCompleted(new Action0(){

                    public void call() {
                        AbstractCommand.this.metrics.markFallbackSuccess();
                        AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvents(HystrixEventType.FALLBACK_SUCCESS);
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

                    public Observable<R> call(Throwable t) {
                        Exception e = originalException;
                        Exception fe = AbstractCommand.this.getExceptionFromThrowable(t);
                        if (fe instanceof UnsupportedOperationException) {
                            logger.debug("No fallback for HystrixCommand. ", (Throwable)fe);
                            e = AbstractCommand.this.wrapWithOnErrorHook(failureType, e);
                            return Observable.error((Throwable)new HystrixRuntimeException(failureType, _cmd.getClass(), AbstractCommand.this.getLogMessagePrefix() + " " + message + " and no fallback available.", e, (Throwable)fe));
                        }
                        logger.debug("HystrixCommand execution " + failureType.name() + " and fallback failed.", (Throwable)fe);
                        AbstractCommand.this.metrics.markFallbackFailure();
                        AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvents(HystrixEventType.FALLBACK_FAILURE);
                        e = AbstractCommand.this.wrapWithOnErrorHook(failureType, e);
                        return Observable.error((Throwable)new HystrixRuntimeException(failureType, _cmd.getClass(), AbstractCommand.this.getLogMessagePrefix() + " " + message + " and fallback failed.", e, (Throwable)fe));
                    }
                }).doOnTerminate(new Action0(){

                    public void call() {
                        AbstractCommand.this.isExecutionComplete.set(true);
                    }
                }).doOnEach(new Action1<Notification<? super R>>(){

                    public void call(Notification<? super R> n) {
                        AbstractCommand.setRequestContextIfNeeded(currentRequestContext);
                    }
                });
            } else {
                Exception e = originalException;
                logger.debug("Fallback disabled for HystrixCommand so will throw HystrixRuntimeException. ", (Throwable)e);
                this.executionResult = this.executionResult.addEvents(eventType);
                e = this.wrapWithOnErrorHook(failureType, e);
                fallbackLogicApplied = Observable.error((Throwable)new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and fallback disabled.", e, null));
            }
        }
        return fallbackLogicApplied.doOnTerminate(new Action0(){

            public void call() {
                AbstractCommand.this.isExecutionComplete.set(true);
            }
        }).doOnEach(new Action1<Notification<? super R>>(){

            public void call(Notification<? super R> n) {
                AbstractCommand.setRequestContextIfNeeded(currentRequestContext);
            }
        });
    }

    private boolean isUnrecoverable(Throwable t) {
        if (t != null && t.getCause() != null) {
            Throwable cause = t.getCause();
            if (cause instanceof StackOverflowError) {
                return true;
            }
            if (cause instanceof VirtualMachineError) {
                return true;
            }
            if (cause instanceof ThreadDeath) {
                return true;
            }
            if (cause instanceof LinkageError) {
                return true;
            }
        }
        return false;
    }

    private boolean isRecoverableError(Throwable t) {
        Throwable cause;
        if (t != null && t.getCause() != null && (cause = t.getCause()) instanceof Error) {
            return !this.isUnrecoverable(t);
        }
        return false;
    }

    protected void handleThreadEnd() {
        if (this.endCurrentThreadExecutingCommand.get() != null) {
            this.endCurrentThreadExecutingCommand.get().call();
        }
        if (this.isExecutedInThread.get()) {
            HystrixCounters.decrementGlobalConcurrentThreads();
            this.threadPool.markThreadCompletion();
            try {
                this.executionHook.onThreadComplete(this);
            }
            catch (Throwable hookEx) {
                logger.warn("Error calling HystrixCommandExecutionHook.onThreadComplete", hookEx);
            }
        }
    }

    protected boolean shouldOutputOnNextEvents() {
        return false;
    }

    private static void setRequestContextIfNeeded(HystrixRequestContext currentRequestContext) {
        if (!HystrixRequestContext.isCurrentThreadInitialized()) {
            HystrixRequestContext.setContextOnCurrentThread(currentRequestContext);
        }
    }

    protected TryableSemaphore getFallbackSemaphore() {
        if (this.fallbackSemaphoreOverride == null) {
            TryableSemaphore _s = fallbackSemaphorePerCircuit.get(this.commandKey.name());
            if (_s == null) {
                fallbackSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphoreActual(this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests()));
                return fallbackSemaphorePerCircuit.get(this.commandKey.name());
            }
            return _s;
        }
        return this.fallbackSemaphoreOverride;
    }

    protected TryableSemaphore getExecutionSemaphore() {
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)) {
            if (this.executionSemaphoreOverride == null) {
                TryableSemaphore _s = executionSemaphorePerCircuit.get(this.commandKey.name());
                if (_s == null) {
                    executionSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphoreActual(this.properties.executionIsolationSemaphoreMaxConcurrentRequests()));
                    return executionSemaphorePerCircuit.get(this.commandKey.name());
                }
                return _s;
            }
            return this.executionSemaphoreOverride;
        }
        return TryableSemaphoreNoOp.DEFAULT;
    }

    protected abstract String getFallbackMethodName();

    static boolean isFallbackUserSupplied(AbstractCommand<?> cmd) {
        Boolean toInsertIntoMap;
        HystrixCommandKey commandKey = cmd.commandKey;
        Boolean containsFromMap = commandContainsFallback.get(commandKey);
        if (containsFromMap != null) {
            return containsFromMap;
        }
        try {
            cmd.getClass().getDeclaredMethod(cmd.getFallbackMethodName(), new Class[0]);
            toInsertIntoMap = true;
        }
        catch (NoSuchMethodException nsme) {
            toInsertIntoMap = false;
        }
        commandContainsFallback.put(commandKey, toInsertIntoMap);
        return toInsertIntoMap;
    }

    @Override
    public HystrixCommandGroupKey getCommandGroup() {
        return this.commandGroup;
    }

    @Override
    public HystrixCommandKey getCommandKey() {
        return this.commandKey;
    }

    @Override
    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    HystrixCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public HystrixCommandMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HystrixCommandProperties getProperties() {
        return this.properties;
    }

    protected void recordTotalExecutionTime(long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        this.metrics.addUserThreadExecutionTime(duration);
        this.executionResult = this.executionResult.setExecutionTime((int)duration);
    }

    protected void recordExecutedCommand() {
        if (this.properties.requestLogEnabled().get().booleanValue() && this.currentRequestLog != null) {
            this.currentRequestLog.addExecutedCommand(this);
        }
    }

    private Exception wrapWithOnExecutionErrorHook(Throwable t) {
        Exception e = this.getExceptionFromThrowable(t);
        try {
            return this.executionHook.onExecutionError(this, e);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onExecutionError", hookEx);
            return e;
        }
    }

    private Exception wrapWithOnFallbackErrorHook(Throwable t) {
        Exception e = this.getExceptionFromThrowable(t);
        try {
            if (AbstractCommand.isFallbackUserSupplied(this)) {
                return this.executionHook.onFallbackError(this, e);
            }
            return e;
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onFallbackError", hookEx);
            return e;
        }
    }

    private Exception wrapWithOnErrorHook(HystrixRuntimeException.FailureType failureType, Throwable t) {
        Exception e = this.getExceptionFromThrowable(t);
        try {
            return this.executionHook.onError(this, failureType, e);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onError", hookEx);
            return e;
        }
    }

    private R wrapWithOnExecutionEmitHook(R r) {
        try {
            return this.executionHook.onExecutionEmit(this, r);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onExecutionEmit", hookEx);
            return r;
        }
    }

    private R wrapWithOnFallbackEmitHook(R r) {
        try {
            return this.executionHook.onFallbackEmit(this, r);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onFallbackEmit", hookEx);
            return r;
        }
    }

    private R wrapWithOnEmitHook(R r) {
        try {
            return this.executionHook.onEmit(this, r);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onEmit", hookEx);
            return r;
        }
    }

    protected RuntimeException decomposeException(Exception e) {
        if (e instanceof IllegalStateException) {
            return (IllegalStateException)e;
        }
        if (e instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e;
        }
        if (e.getCause() instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e.getCause();
        }
        if (e instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e;
        }
        if (e.getCause() instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e.getCause();
        }
        String message = this.getLogMessagePrefix() + " failed while executing.";
        logger.debug(message, (Throwable)e);
        return new HystrixRuntimeException(HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, this.getClass(), message, e, null);
    }

    protected String getCacheKey() {
        return null;
    }

    protected boolean isRequestCachingEnabled() {
        return this.properties.requestCacheEnabled().get() != false && this.getCacheKey() != null;
    }

    protected String getLogMessagePrefix() {
        return this.getCommandKey().name();
    }

    @Override
    public boolean isCircuitBreakerOpen() {
        return this.properties.circuitBreakerForceOpen().get() != false || this.properties.circuitBreakerForceClosed().get() == false && this.circuitBreaker.isOpen();
    }

    @Override
    public boolean isExecutionComplete() {
        return this.isExecutionComplete.get();
    }

    @Override
    public boolean isExecutedInThread() {
        return this.isExecutedInThread.get();
    }

    @Override
    public boolean isSuccessfulExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.SUCCESS);
    }

    @Override
    public boolean isFailedExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.FAILURE);
    }

    @Override
    public Throwable getFailedExecutionException() {
        return this.executionResult.getException();
    }

    @Override
    public boolean isResponseFromFallback() {
        return this.executionResult.events.contains((Object)HystrixEventType.FALLBACK_SUCCESS);
    }

    @Override
    public boolean isResponseTimedOut() {
        return this.executionResult.events.contains((Object)HystrixEventType.TIMEOUT);
    }

    @Override
    public boolean isResponseShortCircuited() {
        return this.executionResult.events.contains((Object)HystrixEventType.SHORT_CIRCUITED);
    }

    @Override
    public boolean isResponseFromCache() {
        return this.executionResult.events.contains((Object)HystrixEventType.RESPONSE_FROM_CACHE);
    }

    @Override
    public boolean isResponseRejected() {
        return this.executionResult.events.contains((Object)HystrixEventType.THREAD_POOL_REJECTED) || this.executionResult.events.contains((Object)HystrixEventType.SEMAPHORE_REJECTED);
    }

    @Override
    public List<HystrixEventType> getExecutionEvents() {
        return this.executionResult.events;
    }

    @Override
    public int getNumberEmissions() {
        return this.executionResult.numEmissions;
    }

    @Override
    public int getNumberFallbackEmissions() {
        return this.executionResult.numFallbackEmissions;
    }

    @Override
    public int getExecutionTimeInMilliseconds() {
        return this.executionResult.getExecutionTime();
    }

    @Override
    public long getCommandRunStartTimeInNanos() {
        return this.executionResult.getCommandRunStartTimeInNanos();
    }

    protected Exception getExceptionFromThrowable(Throwable t) {
        Exception e = t instanceof Exception ? (Exception)t : new Exception("Throwable caught while executing.", t);
        return e;
    }

    private static class ExecutionHookDeprecationWrapper
    extends HystrixCommandExecutionHook {
        private final HystrixCommandExecutionHook actual;

        ExecutionHookDeprecationWrapper(HystrixCommandExecutionHook actual) {
            this.actual = actual;
        }

        @Override
        public <T> T onEmit(HystrixInvokable<T> commandInstance, T value) {
            return this.actual.onEmit(commandInstance, value);
        }

        @Override
        public <T> void onSuccess(HystrixInvokable<T> commandInstance) {
            this.actual.onSuccess(commandInstance);
        }

        @Override
        public <T> void onExecutionStart(HystrixInvokable<T> commandInstance) {
            this.actual.onExecutionStart(commandInstance);
        }

        @Override
        public <T> T onExecutionEmit(HystrixInvokable<T> commandInstance, T value) {
            return this.actual.onExecutionEmit(commandInstance, value);
        }

        @Override
        public <T> Exception onExecutionError(HystrixInvokable<T> commandInstance, Exception e) {
            return this.actual.onExecutionError(commandInstance, e);
        }

        @Override
        public <T> void onExecutionSuccess(HystrixInvokable<T> commandInstance) {
            this.actual.onExecutionSuccess(commandInstance);
        }

        @Override
        public <T> T onFallbackEmit(HystrixInvokable<T> commandInstance, T value) {
            return this.actual.onFallbackEmit(commandInstance, value);
        }

        @Override
        public <T> void onFallbackSuccess(HystrixInvokable<T> commandInstance) {
            this.actual.onFallbackSuccess(commandInstance);
        }

        @Override
        @Deprecated
        public <T> void onRunStart(HystrixCommand<T> commandInstance) {
            this.actual.onRunStart(commandInstance);
        }

        @Override
        public <T> void onRunStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onRunStart(c);
            }
            this.actual.onRunStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onRunSuccess(HystrixCommand<T> commandInstance, T response) {
            return this.actual.onRunSuccess(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> T onRunSuccess(HystrixInvokable<T> commandInstance, T response) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                response = this.onRunSuccess(c, response);
            }
            return this.actual.onRunSuccess(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> Exception onRunError(HystrixCommand<T> commandInstance, Exception e) {
            return this.actual.onRunError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> Exception onRunError(HystrixInvokable<T> commandInstance, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onRunError(c, e);
            }
            return this.actual.onRunError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> void onFallbackStart(HystrixCommand<T> commandInstance) {
            this.actual.onFallbackStart(commandInstance);
        }

        @Override
        public <T> void onFallbackStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onFallbackStart(c);
            }
            this.actual.onFallbackStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onFallbackSuccess(HystrixCommand<T> commandInstance, T fallbackResponse) {
            return this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
        }

        @Override
        @Deprecated
        public <T> T onFallbackSuccess(HystrixInvokable<T> commandInstance, T fallbackResponse) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                fallbackResponse = this.onFallbackSuccess(c, fallbackResponse);
            }
            return this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
        }

        @Override
        @Deprecated
        public <T> Exception onFallbackError(HystrixCommand<T> commandInstance, Exception e) {
            return this.actual.onFallbackError(commandInstance, e);
        }

        @Override
        public <T> Exception onFallbackError(HystrixInvokable<T> commandInstance, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onFallbackError(c, e);
            }
            return this.actual.onFallbackError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> void onStart(HystrixCommand<T> commandInstance) {
            this.actual.onStart(commandInstance);
        }

        @Override
        public <T> void onStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onStart(c);
            }
            this.actual.onStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onComplete(HystrixCommand<T> commandInstance, T response) {
            return this.actual.onComplete(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> T onComplete(HystrixInvokable<T> commandInstance, T response) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                response = this.onComplete(c, response);
            }
            return this.actual.onComplete(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> Exception onError(HystrixCommand<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
            return this.actual.onError(commandInstance, failureType, e);
        }

        @Override
        public <T> Exception onError(HystrixInvokable<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onError(c, failureType, e);
            }
            return this.actual.onError(commandInstance, failureType, e);
        }

        @Override
        @Deprecated
        public <T> void onThreadStart(HystrixCommand<T> commandInstance) {
            this.actual.onThreadStart(commandInstance);
        }

        @Override
        public <T> void onThreadStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onThreadStart(c);
            }
            this.actual.onThreadStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> void onThreadComplete(HystrixCommand<T> commandInstance) {
            this.actual.onThreadComplete(commandInstance);
        }

        @Override
        public <T> void onThreadComplete(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onThreadComplete(c);
            }
            this.actual.onThreadComplete(commandInstance);
        }

        @Override
        public <T> void onCacheHit(HystrixInvokable<T> commandInstance) {
            this.actual.onCacheHit(commandInstance);
        }

        private <T> HystrixCommand<T> getHystrixCommandFromAbstractIfApplicable(HystrixInvokable<T> commandInstance) {
            if (commandInstance instanceof HystrixCommand) {
                return (HystrixCommand)commandInstance;
            }
            return null;
        }
    }

    protected static class ExecutionResult {
        protected final List<HystrixEventType> events;
        private final int executionTime;
        private final Exception exception;
        private final long commandRunStartTimeInNanos;
        private final int numEmissions;
        private final int numFallbackEmissions;
        private static ExecutionResult EMPTY = new ExecutionResult(new HystrixEventType[0]);

        private ExecutionResult(HystrixEventType ... events) {
            this(Arrays.asList(events), -1, null, 0, 0);
        }

        public ExecutionResult setExecutionTime(int executionTime) {
            return new ExecutionResult(this.events, executionTime, this.exception, this.numEmissions, this.numFallbackEmissions);
        }

        public ExecutionResult setException(Exception e) {
            return new ExecutionResult(this.events, this.executionTime, e, this.numEmissions, this.numFallbackEmissions);
        }

        private ExecutionResult(List<HystrixEventType> events, int executionTime, Exception e, int numEmissions, int numFallbackEmissions) {
            this.events = events;
            this.executionTime = executionTime;
            this.commandRunStartTimeInNanos = executionTime >= 0 ? System.nanoTime() - (long)(this.executionTime * 1000 * 1000) : -1L;
            this.exception = e;
            this.numEmissions = numEmissions;
            this.numFallbackEmissions = numFallbackEmissions;
        }

        public ExecutionResult addEvents(HystrixEventType ... events) {
            return new ExecutionResult(ExecutionResult.getUpdatedList(this.events, events), this.executionTime, this.exception, this.numEmissions, this.numFallbackEmissions);
        }

        private static List<HystrixEventType> getUpdatedList(List<HystrixEventType> currentList, HystrixEventType ... newEvents) {
            ArrayList<HystrixEventType> updatedEvents = new ArrayList<HystrixEventType>();
            updatedEvents.addAll(currentList);
            Collections.addAll(updatedEvents, newEvents);
            return Collections.unmodifiableList(updatedEvents);
        }

        public int getExecutionTime() {
            return this.executionTime;
        }

        public long getCommandRunStartTimeInNanos() {
            return this.commandRunStartTimeInNanos;
        }

        public Exception getException() {
            return this.exception;
        }

        public ExecutionResult addEmission(HystrixEventType eventType) {
            switch (eventType) {
                case EMIT: {
                    if (this.events.contains((Object)HystrixEventType.EMIT)) {
                        return new ExecutionResult(this.events, this.executionTime, this.exception, this.numEmissions + 1, this.numFallbackEmissions);
                    }
                    return new ExecutionResult(ExecutionResult.getUpdatedList(this.events, HystrixEventType.EMIT), this.executionTime, this.exception, this.numEmissions + 1, this.numFallbackEmissions);
                }
                case FALLBACK_EMIT: {
                    if (this.events.contains((Object)HystrixEventType.FALLBACK_EMIT)) {
                        return new ExecutionResult(this.events, this.executionTime, this.exception, this.numEmissions, this.numFallbackEmissions + 1);
                    }
                    return new ExecutionResult(ExecutionResult.getUpdatedList(this.events, HystrixEventType.FALLBACK_EMIT), this.executionTime, this.exception, this.numEmissions, this.numFallbackEmissions + 1);
                }
            }
            return this;
        }

        static /* synthetic */ ExecutionResult access$000() {
            return EMPTY;
        }
    }

    static interface TryableSemaphore {
        public boolean tryAcquire();

        public void release();

        public int getNumberOfPermitsUsed();
    }

    static class TryableSemaphoreNoOp
    implements TryableSemaphore {
        public static final TryableSemaphore DEFAULT = new TryableSemaphoreNoOp();

        TryableSemaphoreNoOp() {
        }

        @Override
        public boolean tryAcquire() {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public int getNumberOfPermitsUsed() {
            return 0;
        }
    }

    static class TryableSemaphoreActual
    implements TryableSemaphore {
        protected final HystrixProperty<Integer> numberOfPermits;
        private final AtomicInteger count = new AtomicInteger(0);

        public TryableSemaphoreActual(HystrixProperty<Integer> numberOfPermits) {
            this.numberOfPermits = numberOfPermits;
        }

        @Override
        public boolean tryAcquire() {
            int currentCount = this.count.incrementAndGet();
            if (currentCount > this.numberOfPermits.get()) {
                this.count.decrementAndGet();
                return false;
            }
            return true;
        }

        @Override
        public void release() {
            this.count.decrementAndGet();
        }

        @Override
        public int getNumberOfPermitsUsed() {
            return this.count.get();
        }
    }

    @Deprecated
    private class DeprecatedOnFallbackHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        DeprecatedOnFallbackHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    subscriber.onCompleted();
                }

                public void onError(Throwable t) {
                    subscriber.onError(t);
                }

                public void onNext(R r) {
                    try {
                        Object wrappedValue = AbstractCommand.this.executionHook.onFallbackSuccess(DeprecatedOnFallbackHookApplication.this.cmd, r);
                        subscriber.onNext(wrappedValue);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onFallbackSuccess", hookEx);
                        subscriber.onNext(r);
                    }
                }
            };
        }
    }

    @Deprecated
    private class DeprecatedOnRunHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        DeprecatedOnRunHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    subscriber.onCompleted();
                }

                public void onError(Throwable t) {
                    Exception e = AbstractCommand.this.getExceptionFromThrowable(t);
                    try {
                        Exception wrappedEx = AbstractCommand.this.executionHook.onRunError(DeprecatedOnRunHookApplication.this.cmd, e);
                        subscriber.onError((Throwable)wrappedEx);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onRunError", hookEx);
                        subscriber.onError((Throwable)e);
                    }
                }

                public void onNext(R r) {
                    try {
                        Object wrappedValue = AbstractCommand.this.executionHook.onRunSuccess(DeprecatedOnRunHookApplication.this.cmd, r);
                        subscriber.onNext(wrappedValue);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onRunSuccess", hookEx);
                        subscriber.onNext(r);
                    }
                }
            };
        }
    }

    @Deprecated
    private class DeprecatedOnCompleteWithValueHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        DeprecatedOnCompleteWithValueHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    subscriber.onCompleted();
                }

                public void onError(Throwable e) {
                    subscriber.onError(e);
                }

                public void onNext(R r) {
                    try {
                        Object wrappedValue = AbstractCommand.this.executionHook.onComplete(DeprecatedOnCompleteWithValueHookApplication.this.cmd, r);
                        subscriber.onNext(wrappedValue);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onComplete", hookEx);
                        subscriber.onNext(r);
                    }
                }
            };
        }
    }

    private class FallbackHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        FallbackHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    try {
                        AbstractCommand.this.executionHook.onFallbackSuccess(FallbackHookApplication.this.cmd);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onFallbackSuccess", hookEx);
                    }
                    subscriber.onCompleted();
                }

                public void onError(Throwable e) {
                    Exception wrappedEx = AbstractCommand.this.wrapWithOnFallbackErrorHook(e);
                    subscriber.onError((Throwable)wrappedEx);
                }

                public void onNext(R r) {
                    Object wrappedValue = AbstractCommand.this.wrapWithOnFallbackEmitHook(r);
                    subscriber.onNext(wrappedValue);
                }
            };
        }
    }

    private class ExecutionHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        ExecutionHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    try {
                        AbstractCommand.this.executionHook.onExecutionSuccess(ExecutionHookApplication.this.cmd);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onExecutionSuccess", hookEx);
                    }
                    subscriber.onCompleted();
                }

                public void onError(Throwable e) {
                    Exception wrappedEx = AbstractCommand.this.wrapWithOnExecutionErrorHook(e);
                    subscriber.onError((Throwable)wrappedEx);
                }

                public void onNext(R r) {
                    Object wrappedValue = AbstractCommand.this.wrapWithOnExecutionEmitHook(r);
                    subscriber.onNext(wrappedValue);
                }
            };
        }
    }

    private class CommandHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        CommandHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    try {
                        AbstractCommand.this.executionHook.onSuccess(CommandHookApplication.this.cmd);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onSuccess", hookEx);
                    }
                    subscriber.onCompleted();
                }

                public void onError(Throwable e) {
                    subscriber.onError(e);
                }

                public void onNext(R r) {
                    Object wrappedValue = AbstractCommand.this.wrapWithOnEmitHook(r);
                    subscriber.onNext(wrappedValue);
                }
            };
        }
    }

    protected static class CachedObservableResponse<R>
    extends ObservableCommand<R> {
        final CachedObservableOriginal<R> originalObservable;

        CachedObservableResponse(final CachedObservableOriginal<R> originalObservable, final AbstractCommand<R> commandOfDuplicateCall) {
            super(new Observable.OnSubscribe<R>(){

                public void call(final Subscriber<? super R> observer) {
                    originalObservable.subscribe(new Subscriber<R>(){

                        public void onCompleted() {
                            this.completeCommand();
                            observer.onCompleted();
                        }

                        public void onError(Throwable e) {
                            this.completeCommand();
                            observer.onError(e);
                        }

                        public void onNext(R v) {
                            observer.onNext(v);
                        }

                        private void completeCommand() {
                            commandOfDuplicateCall.executionResult = originalObservable.originalCommand.executionResult;
                            commandOfDuplicateCall.executionResult = commandOfDuplicateCall.executionResult.addEvents(HystrixEventType.RESPONSE_FROM_CACHE);
                            commandOfDuplicateCall.executionResult = commandOfDuplicateCall.executionResult.setExecutionTime(-1);
                            commandOfDuplicateCall.recordExecutedCommand();
                        }
                    });
                }
            }, commandOfDuplicateCall);
            this.originalObservable = originalObservable;
        }

        @Override
        public AbstractCommand<R> getCommand() {
            return this.originalObservable.originalCommand;
        }
    }

    protected static class CachedObservableOriginal<R>
    extends ObservableCommand<R> {
        final AbstractCommand<R> originalCommand;

        CachedObservableOriginal(final Observable<R> actual, AbstractCommand<R> command) {
            super(new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> observer) {
                    actual.unsafeSubscribe(observer);
                }
            }, command);
            this.originalCommand = command;
        }
    }

    protected static class ObservableCommand<R>
    extends Observable<R> {
        private final AbstractCommand<R> command;

        ObservableCommand(Observable.OnSubscribe<R> func, AbstractCommand<R> command) {
            super(func);
            this.command = command;
        }

        public AbstractCommand<R> getCommand() {
            return this.command;
        }

        ObservableCommand(final Observable<R> originalObservable, AbstractCommand<R> command) {
            super(new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> observer) {
                    originalObservable.unsafeSubscribe(observer);
                }
            });
            this.command = command;
        }
    }

    private static class HystrixObservableTimeoutOperator<R>
    implements Observable.Operator<R, R> {
        final AbstractCommand<R> originalCommand;

        public HystrixObservableTimeoutOperator(AbstractCommand<R> originalCommand) {
            this.originalCommand = originalCommand;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> child) {
            final CompositeSubscription s = new CompositeSubscription();
            child.add((Subscription)s);
            final HystrixContextRunnable timeoutRunnable = new HystrixContextRunnable(this.originalCommand.concurrencyStrategy, new Runnable(){

                @Override
                public void run() {
                    child.onError((Throwable)new HystrixTimeoutException());
                }
            });
            HystrixTimer.TimerListener listener = new HystrixTimer.TimerListener(){

                @Override
                public void tick() {
                    if (HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.compareAndSet(TimedOutStatus.NOT_EXECUTED, TimedOutStatus.TIMED_OUT)) {
                        HystrixObservableTimeoutOperator.this.originalCommand.metrics.markTimeout(System.currentTimeMillis() - HystrixObservableTimeoutOperator.this.originalCommand.invocationStartTime);
                        HystrixObservableTimeoutOperator.this.originalCommand.recordTotalExecutionTime(HystrixObservableTimeoutOperator.this.originalCommand.invocationStartTime);
                        s.unsubscribe();
                        timeoutRunnable.run();
                    }
                }

                @Override
                public int getIntervalTimeInMilliseconds() {
                    return HystrixObservableTimeoutOperator.this.originalCommand.properties.executionTimeoutInMilliseconds().get();
                }
            };
            final Reference<HystrixTimer.TimerListener> tl = HystrixTimer.getInstance().addTimerListener(listener);
            this.originalCommand.timeoutTimer.set(tl);
            Subscriber parent = new Subscriber<R>(){

                public void onCompleted() {
                    if (this.isNotTimedOut()) {
                        tl.clear();
                        child.onCompleted();
                    }
                }

                public void onError(Throwable e) {
                    if (this.isNotTimedOut()) {
                        tl.clear();
                        child.onError(e);
                    }
                }

                public void onNext(R v) {
                    if (this.isNotTimedOut()) {
                        child.onNext(v);
                    }
                }

                private boolean isNotTimedOut() {
                    return HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.get() == TimedOutStatus.COMPLETED || HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.compareAndSet(TimedOutStatus.NOT_EXECUTED, TimedOutStatus.COMPLETED);
                }
            };
            s.add((Subscription)parent);
            return parent;
        }

        public static class HystrixTimeoutException
        extends Exception {
            private static final long serialVersionUID = 7460860948388895401L;
        }
    }

    protected static enum TimedOutStatus {
        NOT_EXECUTED,
        COMPLETED,
        TIMED_OUT;

    }
}

