/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public interface HystrixCircuitBreaker {
    public boolean allowRequest();

    public boolean isOpen();

    public void markSuccess();

    public static class NoOpCircuitBreaker
    implements HystrixCircuitBreaker {
        @Override
        public boolean allowRequest() {
            return true;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void markSuccess() {
        }
    }

    public static class HystrixCircuitBreakerImpl
    implements HystrixCircuitBreaker {
        private final HystrixCommandProperties properties;
        private final HystrixCommandMetrics metrics;
        private AtomicBoolean circuitOpen = new AtomicBoolean(false);
        private AtomicLong circuitOpenedOrLastTestedTime = new AtomicLong();

        protected HystrixCircuitBreakerImpl(HystrixCommandKey key, HystrixCommandGroupKey commandGroup, HystrixCommandProperties properties, HystrixCommandMetrics metrics) {
            this.properties = properties;
            this.metrics = metrics;
        }

        @Override
        public void markSuccess() {
            if (this.circuitOpen.get()) {
                this.metrics.resetCounter();
                this.circuitOpen.set(false);
            }
        }

        @Override
        public boolean allowRequest() {
            if (this.properties.circuitBreakerForceOpen().get().booleanValue()) {
                return false;
            }
            if (this.properties.circuitBreakerForceClosed().get().booleanValue()) {
                this.isOpen();
                return true;
            }
            return !this.isOpen() || this.allowSingleTest();
        }

        public boolean allowSingleTest() {
            long timeCircuitOpenedOrWasLastTested = this.circuitOpenedOrLastTestedTime.get();
            return this.circuitOpen.get() && System.currentTimeMillis() > timeCircuitOpenedOrWasLastTested + (long)this.properties.circuitBreakerSleepWindowInMilliseconds().get().intValue() && this.circuitOpenedOrLastTestedTime.compareAndSet(timeCircuitOpenedOrWasLastTested, System.currentTimeMillis());
        }

        @Override
        public boolean isOpen() {
            if (this.circuitOpen.get()) {
                return true;
            }
            HystrixCommandMetrics.HealthCounts health = this.metrics.getHealthCounts();
            if (health.getTotalRequests() < (long)this.properties.circuitBreakerRequestVolumeThreshold().get().intValue()) {
                return false;
            }
            if (health.getErrorPercentage() < this.properties.circuitBreakerErrorThresholdPercentage().get()) {
                return false;
            }
            if (this.circuitOpen.compareAndSet(false, true)) {
                this.circuitOpenedOrLastTestedTime.set(System.currentTimeMillis());
                return true;
            }
            return true;
        }
    }

    public static class Factory {
        private static ConcurrentHashMap<String, HystrixCircuitBreaker> circuitBreakersByCommand = new ConcurrentHashMap();

        public static HystrixCircuitBreaker getInstance(HystrixCommandKey key, HystrixCommandGroupKey group, HystrixCommandProperties properties, HystrixCommandMetrics metrics) {
            HystrixCircuitBreaker previouslyCached = circuitBreakersByCommand.get(key.name());
            if (previouslyCached != null) {
                return previouslyCached;
            }
            HystrixCircuitBreaker cbForCommand = circuitBreakersByCommand.putIfAbsent(key.name(), new HystrixCircuitBreakerImpl(key, group, properties, metrics));
            if (cbForCommand == null) {
                return circuitBreakersByCommand.get(key.name());
            }
            return cbForCommand;
        }

        public static HystrixCircuitBreaker getInstance(HystrixCommandKey key) {
            return circuitBreakersByCommand.get(key.name());
        }

        static void reset() {
            circuitBreakersByCommand.clear();
        }
    }
}

