/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.metrics;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCollapser;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import java.util.concurrent.ConcurrentHashMap;

public class HystrixMetricsPublisherFactory {
    private static HystrixMetricsPublisherFactory SINGLETON = new HystrixMetricsPublisherFactory();
    private final ConcurrentHashMap<String, HystrixMetricsPublisherCommand> commandPublishers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, HystrixMetricsPublisherThreadPool> threadPoolPublishers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, HystrixMetricsPublisherCollapser> collapserPublishers = new ConcurrentHashMap();

    public static HystrixMetricsPublisherThreadPool createOrRetrievePublisherForThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
        return SINGLETON.getPublisherForThreadPool(threadPoolKey, metrics, properties);
    }

    public static HystrixMetricsPublisherCommand createOrRetrievePublisherForCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandOwner, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        return SINGLETON.getPublisherForCommand(commandKey, commandOwner, metrics, circuitBreaker, properties);
    }

    public static void reset() {
        SINGLETON = new HystrixMetricsPublisherFactory();
        HystrixMetricsPublisherFactory.SINGLETON.commandPublishers.clear();
        HystrixMetricsPublisherFactory.SINGLETON.threadPoolPublishers.clear();
        HystrixMetricsPublisherFactory.SINGLETON.collapserPublishers.clear();
    }

    HystrixMetricsPublisherFactory() {
    }

    HystrixMetricsPublisherCommand getPublisherForCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandOwner, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        HystrixMetricsPublisherCommand publisher = this.commandPublishers.get(commandKey.name());
        if (publisher != null) {
            return publisher;
        }
        publisher = HystrixPlugins.getInstance().getMetricsPublisher().getMetricsPublisherForCommand(commandKey, commandOwner, metrics, circuitBreaker, properties);
        HystrixMetricsPublisherCommand existing = this.commandPublishers.putIfAbsent(commandKey.name(), publisher);
        if (existing == null) {
            publisher.initialize();
            return publisher;
        }
        return existing;
    }

    HystrixMetricsPublisherThreadPool getPublisherForThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
        HystrixMetricsPublisherThreadPool publisher = this.threadPoolPublishers.get(threadPoolKey.name());
        if (publisher != null) {
            return publisher;
        }
        publisher = HystrixPlugins.getInstance().getMetricsPublisher().getMetricsPublisherForThreadPool(threadPoolKey, metrics, properties);
        HystrixMetricsPublisherThreadPool existing = this.threadPoolPublishers.putIfAbsent(threadPoolKey.name(), publisher);
        if (existing == null) {
            publisher.initialize();
            return publisher;
        }
        return existing;
    }

    public static HystrixMetricsPublisherCollapser createOrRetrievePublisherForCollapser(HystrixCollapserKey collapserKey, HystrixCollapserMetrics metrics, HystrixCollapserProperties properties) {
        return SINGLETON.getPublisherForCollapser(collapserKey, metrics, properties);
    }

    HystrixMetricsPublisherCollapser getPublisherForCollapser(HystrixCollapserKey collapserKey, HystrixCollapserMetrics metrics, HystrixCollapserProperties properties) {
        HystrixMetricsPublisherCollapser publisher = this.collapserPublishers.get(collapserKey.name());
        if (publisher != null) {
            return publisher;
        }
        publisher = HystrixPlugins.getInstance().getMetricsPublisher().getMetricsPublisherForCollapser(collapserKey, metrics, properties);
        HystrixMetricsPublisherCollapser existing = this.collapserPublishers.putIfAbsent(collapserKey.name(), publisher);
        if (existing == null) {
            publisher.initialize();
            return publisher;
        }
        return existing;
    }
}

