/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.collapser;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.collapser.CollapserTimer;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import com.netflix.hystrix.collapser.RequestBatch;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextCallable;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> {
    static final Logger logger = LoggerFactory.getLogger(HystrixCollapser.class);
    private final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser;
    private final AtomicReference<RequestBatch<BatchReturnType, ResponseType, RequestArgumentType>> batch = new AtomicReference();
    private final AtomicReference<Reference<HystrixTimer.TimerListener>> timerListenerReference = new AtomicReference();
    private final AtomicBoolean timerListenerRegistered = new AtomicBoolean();
    private final CollapserTimer timer;
    private final HystrixCollapserProperties properties;
    private final HystrixConcurrencyStrategy concurrencyStrategy;

    RequestCollapser(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser, HystrixCollapserProperties properties, CollapserTimer timer, HystrixConcurrencyStrategy concurrencyStrategy) {
        this.commandCollapser = commandCollapser;
        this.concurrencyStrategy = concurrencyStrategy;
        this.properties = properties;
        this.timer = timer;
        this.batch.set(new RequestBatch<BatchReturnType, ResponseType, RequestArgumentType>(properties, commandCollapser, properties.maxRequestsInBatch().get()));
    }

    public Observable<ResponseType> submitRequest(RequestArgumentType arg) {
        if (!this.timerListenerRegistered.get() && this.timerListenerRegistered.compareAndSet(false, true)) {
            this.timerListenerReference.set(this.timer.addListener(new CollapsedTask()));
        }
        while (true) {
            RequestBatch<BatchReturnType, ResponseType, RequestArgumentType> b;
            if ((b = this.batch.get()) == null) {
                throw new IllegalStateException("Submitting requests after collapser is shutdown");
            }
            Observable<ResponseType> f = b.offer(arg);
            if (f != null) {
                return f;
            }
            this.createNewBatchAndExecutePreviousIfNeeded(b);
        }
    }

    private void createNewBatchAndExecutePreviousIfNeeded(RequestBatch<BatchReturnType, ResponseType, RequestArgumentType> previousBatch) {
        if (previousBatch == null) {
            throw new IllegalStateException("Trying to start null batch which means it was shutdown already.");
        }
        if (this.batch.compareAndSet(previousBatch, new RequestBatch<BatchReturnType, ResponseType, RequestArgumentType>(this.properties, this.commandCollapser, this.properties.maxRequestsInBatch().get()))) {
            previousBatch.executeBatchIfNotAlreadyStarted();
        }
    }

    public void shutdown() {
        RequestBatch currentBatch = this.batch.getAndSet(null);
        if (currentBatch != null) {
            currentBatch.shutdown();
        }
        if (this.timerListenerReference.get() != null) {
            this.timerListenerReference.get().clear();
        }
    }

    private class CollapsedTask
    implements HystrixTimer.TimerListener {
        final Callable<Void> callableWithContextOfParent;

        CollapsedTask() {
            this.callableWithContextOfParent = new HystrixContextCallable<Void>(RequestCollapser.this.concurrencyStrategy, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        RequestBatch currentBatch = (RequestBatch)RequestCollapser.this.batch.get();
                        if (currentBatch != null && currentBatch.requests.size() > 0) {
                            RequestCollapser.this.createNewBatchAndExecutePreviousIfNeeded(currentBatch);
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Error occurred trying to executeRequestsFromQueue.", t);
                    }
                    return null;
                }
            });
        }

        @Override
        public void tick() {
            try {
                this.callableWithContextOfParent.call();
            }
            catch (Exception e) {
                logger.error("Error occurred trying to execute callable inside CollapsedTask from Timer.", (Throwable)e);
                e.printStackTrace();
            }
        }

        @Override
        public int getIntervalTimeInMilliseconds() {
            return RequestCollapser.this.properties.timerDelayInMilliseconds().get();
        }
    }
}

