/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class HystrixRequestCache {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestCache.class);
    private static final ConcurrentHashMap<RequestCacheKey, HystrixRequestCache> caches = new ConcurrentHashMap();
    private final RequestCacheKey rcKey;
    private final HystrixConcurrencyStrategy concurrencyStrategy;
    private static final HystrixRequestVariableHolder<ConcurrentHashMap<ValueCacheKey, Observable<?>>> requestVariableForCache = new HystrixRequestVariableHolder(new HystrixRequestVariableLifecycle<ConcurrentHashMap<ValueCacheKey, Observable<?>>>(){

        @Override
        public ConcurrentHashMap<ValueCacheKey, Observable<?>> initialValue() {
            return new ConcurrentHashMap();
        }

        @Override
        public void shutdown(ConcurrentHashMap<ValueCacheKey, Observable<?>> value) {
        }
    });

    private HystrixRequestCache(RequestCacheKey rcKey, HystrixConcurrencyStrategy concurrencyStrategy) {
        this.rcKey = rcKey;
        this.concurrencyStrategy = concurrencyStrategy;
    }

    public static HystrixRequestCache getInstance(HystrixCommandKey key, HystrixConcurrencyStrategy concurrencyStrategy) {
        return HystrixRequestCache.getInstance(new RequestCacheKey(key, concurrencyStrategy), concurrencyStrategy);
    }

    public static HystrixRequestCache getInstance(HystrixCollapserKey key, HystrixConcurrencyStrategy concurrencyStrategy) {
        return HystrixRequestCache.getInstance(new RequestCacheKey(key, concurrencyStrategy), concurrencyStrategy);
    }

    private static HystrixRequestCache getInstance(RequestCacheKey rcKey, HystrixConcurrencyStrategy concurrencyStrategy) {
        HystrixRequestCache c = caches.get(rcKey);
        if (c == null) {
            HystrixRequestCache newRequestCache = new HystrixRequestCache(rcKey, concurrencyStrategy);
            HystrixRequestCache existing = caches.putIfAbsent(rcKey, newRequestCache);
            c = existing == null ? newRequestCache : existing;
        }
        return c;
    }

    <T> Observable<T> get(String cacheKey) {
        ValueCacheKey key = this.getRequestCacheKey(cacheKey);
        if (key != null) {
            ConcurrentHashMap<ValueCacheKey, Observable<?>> cacheInstance = requestVariableForCache.get(this.concurrencyStrategy);
            if (cacheInstance == null) {
                throw new IllegalStateException("Request caching is not available. Maybe you need to initialize the HystrixRequestContext?");
            }
            return cacheInstance.get(key);
        }
        return null;
    }

    <T> Observable<T> putIfAbsent(String cacheKey, Observable<T> f) {
        ValueCacheKey key = this.getRequestCacheKey(cacheKey);
        if (key != null) {
            ConcurrentHashMap<ValueCacheKey, Observable<?>> cacheInstance = requestVariableForCache.get(this.concurrencyStrategy);
            if (cacheInstance == null) {
                throw new IllegalStateException("Request caching is not available.  Maybe you need to initialize the HystrixRequestContext?");
            }
            Observable<T> alreadySet = cacheInstance.putIfAbsent(key, f);
            if (alreadySet != null) {
                return alreadySet;
            }
        }
        return null;
    }

    public void clear(String cacheKey) {
        ValueCacheKey key = this.getRequestCacheKey(cacheKey);
        if (key != null) {
            requestVariableForCache.get(this.concurrencyStrategy).remove(key);
        }
    }

    private ValueCacheKey getRequestCacheKey(String cacheKey) {
        if (cacheKey != null) {
            return new ValueCacheKey(this.rcKey, cacheKey);
        }
        return null;
    }

    private static class RequestCacheKey {
        private final short type;
        private final String key;
        private final HystrixConcurrencyStrategy concurrencyStrategy;

        private RequestCacheKey(HystrixCommandKey commandKey, HystrixConcurrencyStrategy concurrencyStrategy) {
            this.type = 1;
            this.key = commandKey == null ? null : commandKey.name();
            this.concurrencyStrategy = concurrencyStrategy;
        }

        private RequestCacheKey(HystrixCollapserKey collapserKey, HystrixConcurrencyStrategy concurrencyStrategy) {
            this.type = (short)2;
            this.key = collapserKey == null ? null : collapserKey.name();
            this.concurrencyStrategy = concurrencyStrategy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.concurrencyStrategy == null ? 0 : this.concurrencyStrategy.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequestCacheKey other = (RequestCacheKey)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.concurrencyStrategy == null ? other.concurrencyStrategy != null : !this.concurrencyStrategy.equals(other.concurrencyStrategy));
        }
    }

    private static class ValueCacheKey {
        private final RequestCacheKey rvKey;
        private final String valueCacheKey;

        private ValueCacheKey(RequestCacheKey rvKey, String valueCacheKey) {
            this.rvKey = rvKey;
            this.valueCacheKey = valueCacheKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rvKey == null ? 0 : this.rvKey.hashCode());
            result = 31 * result + (this.valueCacheKey == null ? 0 : this.valueCacheKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueCacheKey other = (ValueCacheKey)obj;
            if (this.rvKey == null ? other.rvKey != null : !this.rvKey.equals(other.rvKey)) {
                return false;
            }
            return !(this.valueCacheKey == null ? other.valueCacheKey != null : !this.valueCacheKey.equals(other.valueCacheKey));
        }
    }
}

