/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.collect.Lists;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.CommandSetterBuilder;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BatchHystrixCommand
extends AbstractHystrixCommand<List<Object>> {
    private boolean fallbackEnabled;

    protected BatchHystrixCommand(CommandSetterBuilder setterBuilder, CommandActions commandActions, Map<String, Object> commandProperties, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests, Class<? extends Throwable>[] ignoreExceptions, ExecutionType executionType) {
        super(setterBuilder, commandActions, commandProperties, collapsedRequests, ignoreExceptions, executionType);
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    public void setFallbackEnabled(boolean fallbackEnabled) {
        this.fallbackEnabled = fallbackEnabled;
    }

    @Override
    protected List<Object> run() throws Exception {
        ArrayList response = Lists.newArrayList();
        for (HystrixCollapser.CollapsedRequest<Object, Object> request : this.getCollapsedRequests()) {
            Object[] args = (Object[])request.getArgument();
            try {
                response.add(this.fallbackEnabled ? this.processWithFallback(args) : this.process(args));
            }
            catch (RuntimeException ex) {
                request.setException((Exception)ex);
                response.add(null);
            }
        }
        return response;
    }

    private Object process(final Object[] args) {
        return this.process(new AbstractHystrixCommand.Action(){

            @Override
            Object execute() {
                return BatchHystrixCommand.this.getCommandAction().executeWithArgs(BatchHystrixCommand.this.getExecutionType(), args);
            }
        });
    }

    private Object processWithFallback(Object[] args) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.process(args);
            }
            catch (RuntimeException ex) {
                if (ex instanceof HystrixBadRequestException || this.getFallbackAction() == null) {
                    throw ex;
                }
                if (this.getFallbackAction() == null) break block3;
                result = this.processFallback(args);
            }
        }
        return result;
    }

    private Object processFallback(final Object[] args) {
        return this.process(new AbstractHystrixCommand.Action(){

            @Override
            Object execute() {
                return BatchHystrixCommand.this.getFallbackAction().executeWithArgs(ExecutionType.SYNCHRONOUS, args);
            }
        });
    }
}

