/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContextFactory;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.CommandSetterBuilder;
import com.netflix.hystrix.contrib.javanica.command.GenericHystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.LazyCommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.command.MethodExecutionAction;
import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class AbstractHystrixCommandFactory<T extends AbstractHystrixCommand>
implements HystrixCommandFactory<T> {
    @Override
    public T create(MetaHolder metaHolder, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        Validate.notNull((Object)metaHolder.getHystrixCommand(), (String)"hystrixCommand cannot be null", (Object[])new Object[0]);
        String groupKey = StringUtils.isNotEmpty((CharSequence)metaHolder.getHystrixCommand().groupKey()) ? metaHolder.getHystrixCommand().groupKey() : metaHolder.getDefaultGroupKey();
        String commandKey = StringUtils.isNotEmpty((CharSequence)metaHolder.getHystrixCommand().commandKey()) ? metaHolder.getHystrixCommand().commandKey() : metaHolder.getDefaultCommandKey();
        HystrixPropertiesManager.initializeThreadPoolProperties(metaHolder.getHystrixCommand());
        CommandSetterBuilder setterBuilder = new CommandSetterBuilder();
        setterBuilder.commandKey(commandKey);
        setterBuilder.groupKey(groupKey);
        setterBuilder.threadPoolKey(metaHolder.getHystrixCommand().threadPoolKey());
        Map<String, Object> commandProperties = this.getCommandProperties(metaHolder.getHystrixCommand());
        MethodExecutionAction commandAction = new MethodExecutionAction(metaHolder.getObj(), metaHolder.getMethod(), metaHolder.getArgs());
        CommandAction fallbackAction = this.createFallbackAction(metaHolder, collapsedRequests);
        CommandActions commandActions = CommandActions.builder().commandAction(commandAction).fallbackAction(fallbackAction).build();
        HystrixCommandBuilder hystrixCommandBuilder = new HystrixCommandBuilder().setterBuilder(setterBuilder).commandActions(commandActions).commandProperties(commandProperties).collapsedRequests(collapsedRequests).cacheResultInvocationContext(CacheInvocationContextFactory.createCacheResultInvocationContext(metaHolder)).cacheRemoveInvocationContext(CacheInvocationContextFactory.createCacheRemoveInvocationContext(metaHolder)).ignoreExceptions(metaHolder.getHystrixCommand().ignoreExceptions()).executionType(metaHolder.getExecutionType());
        return this.create(hystrixCommandBuilder);
    }

    CommandAction createFallbackAction(MetaHolder metaHolder, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        String fallbackMethodName = metaHolder.getHystrixCommand().fallbackMethod();
        CommandAction fallbackAction = null;
        if (StringUtils.isNotEmpty((CharSequence)fallbackMethodName)) {
            try {
                Method fallbackMethod = metaHolder.getObj().getClass().getDeclaredMethod(fallbackMethodName, metaHolder.getParameterTypes());
                if (fallbackMethod.isAnnotationPresent(HystrixCommand.class)) {
                    fallbackMethod.setAccessible(true);
                    MetaHolder fmMetaHolder = MetaHolder.builder().obj(metaHolder.getObj()).method(fallbackMethod).args(metaHolder.getArgs()).defaultCollapserKey(metaHolder.getDefaultCollapserKey()).defaultCommandKey(fallbackMethod.getName()).defaultGroupKey(metaHolder.getDefaultGroupKey()).hystrixCollapser(metaHolder.getHystrixCollapser()).hystrixCommand(fallbackMethod.getAnnotation(HystrixCommand.class)).build();
                    fallbackAction = new LazyCommandExecutionAction(GenericHystrixCommandFactory.getInstance(), fmMetaHolder, collapsedRequests);
                } else {
                    fallbackAction = new MethodExecutionAction(metaHolder.getObj(), fallbackMethod, metaHolder.getArgs());
                }
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return fallbackAction;
    }

    abstract T create(HystrixCommandBuilder var1);

    private CommandAction createCacheKeyAction(MetaHolder metaHolder) {
        MethodExecutionAction cacheKeyAction = null;
        if (metaHolder.getCacheKeyMethod() != null) {
            cacheKeyAction = new MethodExecutionAction(metaHolder.getObj(), metaHolder.getCacheKeyMethod(), metaHolder.getArgs());
        }
        return cacheKeyAction;
    }

    private Map<String, Object> getCommandProperties(HystrixCommand hystrixCommand) {
        if (hystrixCommand.commandProperties() == null || hystrixCommand.commandProperties().length == 0) {
            return Collections.emptyMap();
        }
        HashMap commandProperties = Maps.newHashMap();
        for (HystrixProperty commandProperty : hystrixCommand.commandProperties()) {
            commandProperties.put(commandProperty.name(), commandProperty.value());
        }
        return commandProperties;
    }
}

