/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.cache;

import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContext;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheRemove;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheResult;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.command.MethodExecutionAction;
import com.netflix.hystrix.contrib.javanica.exception.HystrixCachingException;
import com.netflix.hystrix.contrib.javanica.utils.AopUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class CacheInvocationContextFactory {
    public static CacheInvocationContext<CacheResult> createCacheResultInvocationContext(MetaHolder metaHolder) {
        if (metaHolder.getMethod().isAnnotationPresent(CacheResult.class)) {
            Method method = metaHolder.getMethod();
            CacheResult cacheResult = method.getAnnotation(CacheResult.class);
            MethodExecutionAction cacheKeyMethod = CacheInvocationContextFactory.createCacheKeyAction(cacheResult.cacheKeyMethod(), metaHolder);
            return new CacheInvocationContext<CacheResult>(cacheResult, cacheKeyMethod, metaHolder.getObj(), method, metaHolder.getArgs());
        }
        return null;
    }

    public static CacheInvocationContext<CacheRemove> createCacheRemoveInvocationContext(MetaHolder metaHolder) {
        if (metaHolder.getMethod().isAnnotationPresent(CacheRemove.class)) {
            Method method = metaHolder.getMethod();
            CacheRemove cacheRemove = method.getAnnotation(CacheRemove.class);
            MethodExecutionAction cacheKeyMethod = CacheInvocationContextFactory.createCacheKeyAction(cacheRemove.cacheKeyMethod(), metaHolder);
            return new CacheInvocationContext<CacheRemove>(cacheRemove, cacheKeyMethod, metaHolder.getObj(), method, metaHolder.getArgs());
        }
        return null;
    }

    private static MethodExecutionAction createCacheKeyAction(String method, MetaHolder metaHolder) {
        MethodExecutionAction cacheKeyAction = null;
        if (StringUtils.isNotBlank((CharSequence)method)) {
            Method cacheKeyMethod = AopUtils.getDeclaredMethod(metaHolder.getObj().getClass(), method, metaHolder.getMethod().getParameterTypes());
            if (cacheKeyMethod == null) {
                throw new HystrixCachingException("method with name '" + method + "' doesn't exist in class '" + metaHolder.getObj().getClass() + "'");
            }
            if (!cacheKeyMethod.getReturnType().equals(String.class)) {
                throw new HystrixCachingException("return type of cacheKey method must be String. Method: '" + method + "', Class: '" + metaHolder.getObj().getClass() + "'");
            }
            cacheKeyAction = new MethodExecutionAction(metaHolder.getObj(), cacheKeyMethod, metaHolder.getArgs());
        }
        return cacheKeyAction;
    }
}

