/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.conf;

import com.google.common.collect.Maps;
import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public final class HystrixPropertiesManager {
    private static final String COMMAND_PROPERTY_TEMPLATE = "hystrix.command.{0}.{1}";
    private static final String COLLAPSER_PROPERTY_TEMPLATE = "hystrix.collapser.{0}.{1}";

    private HystrixPropertiesManager() {
    }

    public static void setCommandProperties(Map<String, Object> commandProperties, String commandKey) {
        HystrixPropertiesManager.setProperties(commandProperties, COMMAND_PROPERTY_TEMPLATE, commandKey);
    }

    public static void setCollapserProperties(Map<String, Object> collapserProperties, String collapserKey) {
        HystrixPropertiesManager.setProperties(collapserProperties, COLLAPSER_PROPERTY_TEMPLATE, collapserKey);
    }

    public static void setCollapserProperties(HystrixProperty[] collapserProperties, String collapserKey) {
        HystrixPropertiesManager.setCollapserProperties(HystrixPropertiesManager.toMap(collapserProperties), collapserKey);
    }

    public static Map<String, Object> getPropertiesAsMap(HystrixCommand hystrixCommand) {
        return HystrixPropertiesManager.toMap(hystrixCommand.commandProperties());
    }

    public static Map<String, Object> getPropertiesAsMap(HystrixCollapser hystrixCollapser) {
        return HystrixPropertiesManager.toMap(hystrixCollapser.collapserProperties());
    }

    public static Map<String, Object> toMap(HystrixProperty[] properties) {
        HashMap propertiesMap = Maps.newHashMap();
        for (HystrixProperty hystrixProperty : properties) {
            HystrixPropertiesManager.validate(hystrixProperty);
            propertiesMap.put(hystrixProperty.name(), hystrixProperty.value());
        }
        return propertiesMap;
    }

    private static void setProperties(Map<String, Object> properties, String propTemplate, String commandKey) {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String propName = MessageFormat.format(propTemplate, commandKey, property.getKey());
                ConfigurationManager.getConfigInstance().setProperty(propName, property.getValue());
            }
        }
    }

    private static void validate(HystrixProperty hystrixProperty) throws IllegalArgumentException {
        Validate.notBlank((CharSequence)hystrixProperty.name(), (String)"hystrix property name cannot be null", (Object[])new Object[0]);
    }

    public static void initializeThreadPoolProperties(HystrixCommand hystrixCommand) {
        HystrixProperty[] properties;
        if (hystrixCommand.threadPoolProperties() == null || hystrixCommand.threadPoolProperties().length == 0) {
            return;
        }
        HystrixThreadPoolProperties.Setter setter = HystrixThreadPoolProperties.Setter();
        String threadPoolKey = hystrixCommand.threadPoolKey();
        if (threadPoolKey == null || "".equals(threadPoolKey)) {
            threadPoolKey = "default";
        }
        for (HystrixProperty property : properties = hystrixCommand.threadPoolProperties()) {
            String name = String.format("hystrix.threadpool.%s.%s", threadPoolKey, property.name());
            ConfigurationManager.getConfigInstance().setProperty(name, (Object)property.value());
        }
    }
}

