/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutor;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;

public class CommandExecutionAction
extends CommandAction {
    private AbstractHystrixCommand hystrixCommand;
    private MetaHolder metaHolder;

    public CommandExecutionAction(AbstractHystrixCommand hystrixCommand, MetaHolder metaHolder) {
        this.hystrixCommand = hystrixCommand;
        this.metaHolder = metaHolder;
    }

    public AbstractHystrixCommand getHystrixCommand() {
        return this.hystrixCommand;
    }

    @Override
    public MetaHolder getMetaHolder() {
        return this.metaHolder;
    }

    @Override
    public Object execute(ExecutionType executionType) throws CommandActionExecutionException {
        return CommandExecutor.execute((HystrixExecutable)this.hystrixCommand, executionType, this.metaHolder);
    }

    @Override
    public Object executeWithArgs(ExecutionType executionType, Object[] args) throws CommandActionExecutionException {
        return CommandExecutor.execute((HystrixExecutable)this.hystrixCommand, executionType, this.metaHolder);
    }

    @Override
    public String getActionName() {
        if (this.hystrixCommand != null) {
            return this.hystrixCommand.getCommandKey().name();
        }
        return "";
    }
}

