/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.utils.FutureDecorator;
import org.apache.commons.lang3.Validate;

public class CommandExecutor {
    public static Object execute(HystrixExecutable executable, ExecutionType executionType, MetaHolder metaHolder) throws RuntimeException {
        Validate.notNull((Object)executable);
        Validate.notNull((Object)metaHolder);
        switch (executionType) {
            case SYNCHRONOUS: {
                return executable.execute();
            }
            case ASYNCHRONOUS: {
                if (metaHolder.hasFallbackMethodCommand() && ExecutionType.ASYNCHRONOUS == metaHolder.getFallbackExecutionType()) {
                    return new FutureDecorator(executable.queue());
                }
                return executable.queue();
            }
            case OBSERVABLE: {
                return executable.observe();
            }
        }
        throw new RuntimeException("unsupported execution type: " + (Object)((Object)executionType));
    }
}

