/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class LazyCommandExecutionAction
extends CommandAction {
    private MetaHolder metaHolder;
    private Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests;
    private HystrixCommandFactory<?> commandFactory;

    public LazyCommandExecutionAction(HystrixCommandFactory<?> commandFactory, MetaHolder metaHolder, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        this.commandFactory = commandFactory;
        this.metaHolder = metaHolder;
        this.collapsedRequests = collapsedRequests;
    }

    @Override
    public MetaHolder getMetaHolder() {
        return this.metaHolder;
    }

    @Override
    public Object execute(ExecutionType executionType) throws CommandActionExecutionException {
        Object abstractHystrixCommand = this.commandFactory.create(this.createHolder(executionType), this.collapsedRequests);
        return new CommandExecutionAction((AbstractHystrixCommand)((Object)abstractHystrixCommand), this.metaHolder).execute(executionType);
    }

    @Override
    public Object executeWithArgs(ExecutionType executionType, Object[] args) throws CommandActionExecutionException {
        Object abstractHystrixCommand = this.commandFactory.create(this.createHolder(executionType, args), this.collapsedRequests);
        return new CommandExecutionAction((AbstractHystrixCommand)((Object)abstractHystrixCommand), this.metaHolder).execute(executionType);
    }

    @Override
    public String getActionName() {
        return StringUtils.isNotEmpty((CharSequence)this.metaHolder.getHystrixCommand().commandKey()) ? this.metaHolder.getHystrixCommand().commandKey() : this.metaHolder.getDefaultCommandKey();
    }

    private MetaHolder createHolder(ExecutionType executionType) {
        return MetaHolder.builder().obj(this.metaHolder.getObj()).method(this.metaHolder.getMethod()).ajcMethod(this.metaHolder.getAjcMethod()).fallbackExecutionType(this.metaHolder.getFallbackExecutionType()).extendedFallback(this.metaHolder.isExtendedFallback()).extendedParentFallback(this.metaHolder.isExtendedParentFallback()).executionType(executionType).args(this.metaHolder.getArgs()).defaultCollapserKey(this.metaHolder.getDefaultCollapserKey()).defaultCommandKey(this.metaHolder.getDefaultCommandKey()).defaultGroupKey(this.metaHolder.getDefaultGroupKey()).hystrixCollapser(this.metaHolder.getHystrixCollapser()).hystrixCommand(this.metaHolder.getHystrixCommand()).build();
    }

    private MetaHolder createHolder(ExecutionType executionType, Object[] args) {
        return MetaHolder.builder().obj(this.metaHolder.getObj()).method(this.metaHolder.getMethod()).executionType(executionType).ajcMethod(this.metaHolder.getAjcMethod()).fallbackExecutionType(this.metaHolder.getFallbackExecutionType()).extendedParentFallback(this.metaHolder.isExtendedParentFallback()).extendedFallback(this.metaHolder.isExtendedFallback()).args(args).defaultCollapserKey(this.metaHolder.getDefaultCollapserKey()).defaultCommandKey(this.metaHolder.getDefaultCommandKey()).defaultGroupKey(this.metaHolder.getDefaultGroupKey()).hystrixCollapser(this.metaHolder.getHystrixCollapser()).hystrixCommand(this.metaHolder.getHystrixCommand()).build();
    }
}

