/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.cache;

import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContext;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationParameter;
import com.netflix.hystrix.contrib.javanica.cache.DefaultHystrixGeneratedCacheKey;
import com.netflix.hystrix.contrib.javanica.cache.HystrixGeneratedCacheKey;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheKey;
import com.netflix.hystrix.contrib.javanica.command.MethodExecutionAction;
import com.netflix.hystrix.contrib.javanica.exception.HystrixCacheKeyGenerationException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HystrixCacheKeyGenerator {
    private static final HystrixCacheKeyGenerator INSTANCE = new HystrixCacheKeyGenerator();

    public static HystrixCacheKeyGenerator getInstance() {
        return INSTANCE;
    }

    public HystrixGeneratedCacheKey generateCacheKey(CacheInvocationContext<? extends Annotation> cacheInvocationContext) throws HystrixCacheKeyGenerationException {
        MethodExecutionAction cacheKeyMethod = cacheInvocationContext.getCacheKeyMethod();
        if (cacheKeyMethod != null) {
            try {
                DefaultHystrixGeneratedCacheKey cacheKey = new DefaultHystrixGeneratedCacheKey((String)cacheKeyMethod.execute(cacheInvocationContext.getExecutionType()));
                return cacheKey;
            }
            catch (Throwable throwable) {
                throw new HystrixCacheKeyGenerationException(throwable);
            }
        }
        if (cacheInvocationContext.hasKeyParameters()) {
            StringBuilder cacheKeyBuilder = new StringBuilder();
            for (CacheInvocationParameter parameter : cacheInvocationContext.getKeyParameters()) {
                CacheKey cacheKey = parameter.getCacheKeyAnnotation();
                if (cacheKey != null && StringUtils.isNotBlank((CharSequence)cacheKey.value())) {
                    this.appendPropertyValue(cacheKeyBuilder, Arrays.asList(StringUtils.split((String)cacheKey.value(), (String)".")), parameter.getValue());
                    continue;
                }
                cacheKeyBuilder.append(parameter.getValue());
            }
            return new DefaultHystrixGeneratedCacheKey(cacheKeyBuilder.toString());
        }
        return DefaultHystrixGeneratedCacheKey.EMPTY;
    }

    private Object appendPropertyValue(StringBuilder cacheKeyBuilder, List<String> names, Object obj) throws HystrixCacheKeyGenerationException {
        for (String name : names) {
            if (obj == null) continue;
            obj = this.getPropertyValue(name, obj);
        }
        if (obj != null) {
            cacheKeyBuilder.append(obj);
        }
        return obj;
    }

    private Object getPropertyValue(String name, Object obj) throws HystrixCacheKeyGenerationException {
        try {
            return new PropertyDescriptor(name, obj.getClass()).getReadMethod().invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new HystrixCacheKeyGenerationException(e);
        }
        catch (IntrospectionException e) {
            throw new HystrixCacheKeyGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new HystrixCacheKeyGenerationException(e);
        }
    }
}

