/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.collapser;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.netflix.hystrix.contrib.javanica.command.BatchHystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.MessageFormatter;

public class CommandCollapser
extends HystrixCollapser<List<Object>, Object, Object> {
    private MetaHolder metaHolder;
    private static final String ERROR_MSG = "Failed to map all collapsed requests to response. The expected contract has not been respected. ";
    private static final String ERROR_MSF_TEMPLATE = "Collapser key: '{}', requests size: '{}', response size: '{}'";

    public CommandCollapser(MetaHolder metaHolder) {
        super(new CollapserSetterBuilder().collapserKey(metaHolder.getHystrixCollapser().collapserKey(), metaHolder.getDefaultCollapserKey()).scope(metaHolder.getHystrixCollapser().scope()).properties(metaHolder.getHystrixCollapser().collapserProperties()).build());
        this.metaHolder = metaHolder;
    }

    public Object getRequestArgument() {
        return this.metaHolder.getArgs();
    }

    protected HystrixCommand<List<Object>> createCommand(Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        return BatchHystrixCommandFactory.getInstance().create(this.metaHolder, collapsedRequests);
    }

    protected void mapResponseToRequests(List<Object> batchResponse, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        if (batchResponse.size() < collapsedRequests.size()) {
            throw new RuntimeException(this.createMessage(collapsedRequests, batchResponse));
        }
        int count = 0;
        for (HystrixCollapser.CollapsedRequest<Object, Object> request : collapsedRequests) {
            request.setResponse(batchResponse.get(count++));
        }
    }

    private String createMessage(Collection<HystrixCollapser.CollapsedRequest<Object, Object>> requests, List<Object> response) {
        return ERROR_MSG + MessageFormatter.arrayFormat((String)ERROR_MSF_TEMPLATE, (Object[])new Object[]{this.getCollapserKey().name(), requests.size(), response.size()}).getMessage();
    }

    private static final class CollapserSetterBuilder {
        private String collapserKey;
        private HystrixCollapser.Scope scope;
        private HystrixProperty[] properties;

        private CollapserSetterBuilder() {
        }

        private CollapserSetterBuilder collapserKey(String pCollapserKey, String def) {
            this.collapserKey = StringUtils.isNotEmpty((CharSequence)pCollapserKey) ? pCollapserKey : def;
            return this;
        }

        private CollapserSetterBuilder scope(HystrixCollapser.Scope pScope) {
            this.scope = pScope;
            return this;
        }

        private CollapserSetterBuilder properties(HystrixProperty[] properties) {
            this.properties = properties;
            return this;
        }

        public HystrixCollapser.Setter build() {
            HystrixCollapserProperties.Setter propSetter = HystrixPropertiesManager.initializeCollapserProperties(this.properties);
            return HystrixCollapser.Setter.withCollapserKey((HystrixCollapserKey)HystrixCollapserKey.Factory.asKey((String)this.collapserKey)).andScope(this.scope).andCollapserPropertiesDefaults(propSetter);
        }
    }
}

