/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.google.common.base.Throwables;
import com.netflix.hystrix.contrib.javanica.utils.MethodProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public final class AopUtils {
    private AopUtils() {
        throw new UnsupportedOperationException("It's prohibited to create instances of the class.");
    }

    public static Method getMethodFromTarget(JoinPoint joinPoint) {
        Method method = null;
        if (joinPoint.getSignature() instanceof MethodSignature) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            method = AopUtils.getDeclaredMethod(joinPoint.getTarget().getClass(), signature.getName(), AopUtils.getParameterTypes(joinPoint));
        }
        return method;
    }

    public static Method getMethodFromTarget(JoinPoint joinPoint, String methodName) {
        return AopUtils.getDeclaredMethod(joinPoint.getTarget().getClass(), methodName, AopUtils.getParameterTypes(joinPoint));
    }

    public static Class[] getParameterTypes(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        return method.getParameterTypes();
    }

    public static Method getDeclaredMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = type.getDeclaredMethod(methodName, parameterTypes);
            if (method.isBridge()) {
                method = MethodProvider.getInstance().unbride(method, type);
            }
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = type.getSuperclass();
            if (superclass != null) {
                method = AopUtils.getDeclaredMethod(superclass, methodName, parameterTypes);
            }
        }
        catch (ClassNotFoundException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return method;
    }
}

