/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.collect.ImmutableList;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.netflix.hystrix.contrib.javanica.annotation.ObservableExecutionMode;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.closure.Closure;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.aspectj.lang.JoinPoint;

@Immutable
public class MetaHolder {
    private final HystrixCollapser hystrixCollapser;
    private final HystrixCommand hystrixCommand;
    private final Method method;
    private final Method cacheKeyMethod;
    private final Method ajcMethod;
    private final Method fallbackMethod;
    private final Object obj;
    private final Object proxyObj;
    private final Object[] args;
    private final Closure closure;
    private final String defaultGroupKey;
    private final String defaultCommandKey;
    private final String defaultCollapserKey;
    private final ExecutionType executionType;
    private final boolean extendedFallback;
    private final ExecutionType collapserExecutionType;
    private final ExecutionType fallbackExecutionType;
    private final boolean fallback;
    private boolean extendedParentFallback;
    private final JoinPoint joinPoint;
    private final boolean observable;
    private final ObservableExecutionMode observableExecutionMode;

    private MetaHolder(Builder builder) {
        this.hystrixCommand = builder.hystrixCommand;
        this.method = builder.method;
        this.cacheKeyMethod = builder.cacheKeyMethod;
        this.fallbackMethod = builder.fallbackMethod;
        this.ajcMethod = builder.ajcMethod;
        this.obj = builder.obj;
        this.proxyObj = builder.proxyObj;
        this.args = builder.args;
        this.closure = builder.closure;
        this.defaultGroupKey = builder.defaultGroupKey;
        this.defaultCommandKey = builder.defaultCommandKey;
        this.defaultCollapserKey = builder.defaultCollapserKey;
        this.hystrixCollapser = builder.hystrixCollapser;
        this.executionType = builder.executionType;
        this.collapserExecutionType = builder.collapserExecutionType;
        this.fallbackExecutionType = builder.fallbackExecutionType;
        this.joinPoint = builder.joinPoint;
        this.extendedFallback = builder.extendedFallback;
        this.fallback = builder.fallback;
        this.extendedParentFallback = builder.extendedParentFallback;
        this.observable = builder.observable;
        this.observableExecutionMode = builder.observableExecutionMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HystrixCollapser getHystrixCollapser() {
        return this.hystrixCollapser;
    }

    public HystrixCommand getHystrixCommand() {
        return this.hystrixCommand;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method getCacheKeyMethod() {
        return this.cacheKeyMethod;
    }

    public Method getAjcMethod() {
        return this.ajcMethod;
    }

    public Object getObj() {
        return this.obj;
    }

    public Object getProxyObj() {
        return this.proxyObj;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public ExecutionType getCollapserExecutionType() {
        return this.collapserExecutionType;
    }

    public Object[] getArgs() {
        return this.args != null ? Arrays.copyOf(this.args, this.args.length) : new Object[]{};
    }

    public String getDefaultGroupKey() {
        return this.defaultGroupKey;
    }

    public String getDefaultCommandKey() {
        return this.defaultCommandKey;
    }

    public String getDefaultCollapserKey() {
        return this.defaultCollapserKey;
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public boolean isCollapserAnnotationPresent() {
        return this.hystrixCollapser != null;
    }

    public boolean isCommandAnnotationPresent() {
        return this.hystrixCommand != null;
    }

    public JoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public Method getFallbackMethod() {
        return this.fallbackMethod;
    }

    public boolean hasFallbackMethod() {
        return this.fallbackMethod != null;
    }

    public boolean isExtendedParentFallback() {
        return this.extendedParentFallback;
    }

    public boolean hasFallbackMethodCommand() {
        return this.fallbackMethod != null && this.fallbackMethod.isAnnotationPresent(HystrixCommand.class);
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public boolean isExtendedFallback() {
        return this.extendedFallback;
    }

    public ExecutionType getFallbackExecutionType() {
        return this.fallbackExecutionType;
    }

    public List<HystrixProperty> getCommandProperties() {
        return this.isCommandAnnotationPresent() ? ImmutableList.copyOf((Object[])this.hystrixCommand.commandProperties()) : Collections.emptyList();
    }

    public List<HystrixProperty> getCollapserProperties() {
        return this.isCollapserAnnotationPresent() ? ImmutableList.copyOf((Object[])this.hystrixCollapser.collapserProperties()) : Collections.emptyList();
    }

    public List<HystrixProperty> getThreadPoolProperties() {
        return this.isCommandAnnotationPresent() ? ImmutableList.copyOf((Object[])this.hystrixCommand.threadPoolProperties()) : Collections.emptyList();
    }

    public boolean isObservable() {
        return this.observable;
    }

    public ObservableExecutionMode getObservableExecutionMode() {
        return this.observableExecutionMode;
    }

    public static final class Builder {
        private HystrixCollapser hystrixCollapser;
        private HystrixCommand hystrixCommand;
        private Method method;
        private Method cacheKeyMethod;
        private Method fallbackMethod;
        private Method ajcMethod;
        private Object obj;
        private Object proxyObj;
        private Closure closure;
        private Object[] args;
        private String defaultGroupKey;
        private String defaultCommandKey;
        private String defaultCollapserKey;
        private ExecutionType executionType;
        private ExecutionType collapserExecutionType;
        private ExecutionType fallbackExecutionType;
        private boolean extendedFallback;
        private boolean fallback;
        private boolean extendedParentFallback;
        private boolean observable;
        private JoinPoint joinPoint;
        private ObservableExecutionMode observableExecutionMode;

        public Builder hystrixCollapser(HystrixCollapser hystrixCollapser) {
            this.hystrixCollapser = hystrixCollapser;
            return this;
        }

        public Builder hystrixCommand(HystrixCommand hystrixCommand) {
            this.hystrixCommand = hystrixCommand;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder cacheKeyMethod(Method cacheKeyMethod) {
            this.cacheKeyMethod = cacheKeyMethod;
            return this;
        }

        public Builder fallbackMethod(Method fallbackMethod) {
            this.fallbackMethod = fallbackMethod;
            return this;
        }

        public Builder fallbackExecutionType(ExecutionType fallbackExecutionType) {
            this.fallbackExecutionType = fallbackExecutionType;
            return this;
        }

        public Builder fallback(boolean fallback) {
            this.fallback = fallback;
            return this;
        }

        public Builder extendedParentFallback(boolean extendedParentFallback) {
            this.extendedParentFallback = extendedParentFallback;
            return this;
        }

        public Builder ajcMethod(Method ajcMethod) {
            this.ajcMethod = ajcMethod;
            return this;
        }

        public Builder obj(Object obj) {
            this.obj = obj;
            return this;
        }

        public Builder proxyObj(Object proxy) {
            this.proxyObj = proxy;
            return this;
        }

        public Builder args(Object[] args) {
            this.args = args;
            return this;
        }

        public Builder closure(Closure closure) {
            this.closure = closure;
            return this;
        }

        public Builder executionType(ExecutionType executionType) {
            this.executionType = executionType;
            return this;
        }

        public Builder collapserExecutionType(ExecutionType collapserExecutionType) {
            this.collapserExecutionType = collapserExecutionType;
            return this;
        }

        public Builder defaultGroupKey(String defGroupKey) {
            this.defaultGroupKey = defGroupKey;
            return this;
        }

        public Builder defaultCommandKey(String defCommandKey) {
            this.defaultCommandKey = defCommandKey;
            return this;
        }

        public Builder defaultCollapserKey(String defCollapserKey) {
            this.defaultCollapserKey = defCollapserKey;
            return this;
        }

        public Builder joinPoint(JoinPoint joinPoint) {
            this.joinPoint = joinPoint;
            return this;
        }

        public Builder extendedFallback(boolean extendedFallback) {
            this.extendedFallback = extendedFallback;
            return this;
        }

        public Builder observable(boolean observable) {
            this.observable = observable;
            return this;
        }

        public Builder observableExecutionMode(ObservableExecutionMode observableExecutionMode) {
            this.observableExecutionMode = observableExecutionMode;
            return this;
        }

        public MetaHolder build() {
            return new MetaHolder(this);
        }
    }
}

